/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.util;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.util.Utils;
import com.fr.web.core.WebUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;

public class TemplateUtils {
    public static Pattern ParameterPattern = Pattern.compile("\\$\\{((\\\"[^(\\$\\{)]*\\}[^(\\$\\{)]*\\\")|(\\\"[^(\\$\\{)]*[^\\$]?\\{[^(\\$\\{)]*\\\")|[^\\{\\}])*+\\}");

    private TemplateUtils() {
    }

    public static String readTemplate2String(String string, String string2) {
        StringWriter stringWriter = new StringWriter();
        InputStream inputStream = BaseUtils.readResource(string);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            Utils.copyCharTo(inputStreamReader, stringWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().log(Level.WARNING, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
        }
        return stringWriter.getBuffer().toString();
    }

    public static String render(String string, String string2, Object object) {
        return TemplateUtils.render(string, new String[]{string2}, new Object[]{object});
    }

    public static String render(String string, String[] stringArray, Object[] objectArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], objectArray[i]);
        }
        try {
            return TemplateUtils.render(string, hashMap);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return string;
        }
    }

    public static String render(String string, Map map) throws IOException, Exception {
        Calculator calculator = Calculator.createCalculator();
        calculator.pushNameSpace(ParameterMapNameSpace.create(map));
        return calculator.renderTpl(string);
    }

    public static String render(StringReader stringReader, Map map) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        StringBuffer stringBuffer = new StringBuffer();
        while (bufferedReader.readLine() != null) {
            stringBuffer.append(bufferedReader.readLine());
        }
        String string = "";
        try {
            string = TemplateUtils.render(stringBuffer.toString(), map);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return string;
    }

    public static String renderTemplate(String string, Map map) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        TemplateUtils.dealWithTemplate(string, printWriter, map);
        return stringWriter.toString();
    }

    public static void dealWithTemplate(String string, HttpServletResponse httpServletResponse, Map map) throws IOException {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        TemplateUtils.dealWithTemplate(string, printWriter, map);
        printWriter.flush();
        printWriter.close();
    }

    public static void dealWithTemplate(String string, PrintWriter printWriter, Map map) throws IOException {
        InputStream inputStream = BaseUtils.readResource(string);
        if (inputStream == null) {
            throw new IOException("Not found template: " + string);
        }
        TemplateUtils.dealWithTemplate(inputStream, "GBK", printWriter, map);
        inputStream.close();
    }

    public static void dealWithTemplate(InputStream inputStream, String string, PrintWriter printWriter, Map map) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        TemplateUtils.dealWithTemplate(bufferedReader, printWriter, map);
        bufferedReader.close();
    }

    public static void dealWithTemplate(Reader reader, PrintWriter printWriter, Map map) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(string);
        }
        String string2 = "";
        try {
            string2 = TemplateUtils.render(stringBuffer.toString(), map);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        printWriter.write(string2);
    }
}

