/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.dav;

import com.fr.base.dav.FileNode;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLFileReader;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DatabaseConnection;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.parameter.Parameter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class DavXMLUtils {
    private DavXMLUtils() {
    }

    public static void writeXMLFileNodes(FileNode[] fileNodeArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new FileNodeArrayWriter(fileNodeArray));
    }

    public static FileNode[] readXMLFileNodes(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new FileNodeArrayReader());
        return object instanceof FileNode[] ? (FileNode[])object : new FileNode[]{};
    }

    public static void writeXMLFileDatabaseConnection(DatabaseConnection databaseConnection, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new DatabaseConnectionWriter(databaseConnection));
    }

    public static DatabaseConnection readXMLDatabaseConnection(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new DatabaseConnectionReader());
        return object instanceof DatabaseConnection ? (DatabaseConnection)object : null;
    }

    public static DatabaseConnection readXMLDatabaseMapConnection(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new DatabaseMapConnectionReader());
        return object instanceof DatabaseConnection ? (DatabaseConnection)object : null;
    }

    public static void writeXMLFileTableData(TableData tableData, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new TableDataWriter(tableData));
    }

    public static TableData readXMLTableData(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new TableDataReader());
        return object instanceof TableData ? (TableData)object : null;
    }

    public static void writeXMLFileParameters(Parameter[] parameterArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new ParameterArrayWriter(parameterArray));
    }

    public static Parameter[] readXMLParameters(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new ParameterArrayReader());
        return object instanceof Parameter[] ? (Parameter[])object : new Parameter[]{};
    }

    public static void writeXMLFileSchema(String[] stringArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new SchemaWriter(stringArray));
    }

    public static String[] readXMLFileSchema(InputStream inputStream) {
        Object object = null;
        try {
            object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new SchemaReader());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object instanceof String[] ? (String[])object : new String[1];
    }

    public static void writeXMLFileSQLTable(TableProcedure[] tableProcedureArray, OutputStream outputStream) {
        BaseXMLUtils.writeXMLFile(outputStream, new SQLTableArrayWriter(tableProcedureArray));
    }

    public static TableProcedure[] readXMLSQLTables(InputStream inputStream) throws Exception {
        Object object = BaseXMLUtils.readXMLFile(inputStream, (XMLFileReader)new SQLTableArrayReader());
        return object instanceof TableProcedure[] ? (TableProcedure[])object : new TableProcedure[]{};
    }

    private static class SQLTableArrayReader
    implements XMLFileReader {
        private SQLTableArrayReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            ArrayList arrayList = new ArrayList();
            if ("SQLTables".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(this, arrayList){
                    private final /* synthetic */ List val$nodes;
                    private final /* synthetic */ SQLTableArrayReader this$0;
                    {
                        this.this$0 = sQLTableArrayReader;
                        this.val$nodes = list;
                    }

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && "TableProcedure".equals(string = xMLableReader.getTagName())) {
                            TableProcedure tableProcedure = new TableProcedure();
                            xMLableReader.readXMLObject(tableProcedure);
                            this.val$nodes.add(tableProcedure);
                        }
                    }
                });
            }
            return arrayList.toArray(new TableProcedure[arrayList.size()]);
        }

        public Object errorHandler() {
            return new TableProcedure[0];
        }
    }

    private static class SQLTableArrayWriter
    implements XMLWriter {
        private TableProcedure[] sqlTables;

        SQLTableArrayWriter(TableProcedure[] tableProcedureArray) {
            this.sqlTables = tableProcedureArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            int n;
            xMLPrintWriter.startTAG("SQLTables");
            int n2 = n = this.sqlTables == null ? 0 : this.sqlTables.length;
            for (int i = 0; i < n; ++i) {
                this.sqlTables[i].writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
    }

    private static class SchemaReader
    implements XMLFileReader {
        private SchemaReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            ArrayList arrayList = new ArrayList();
            if (string.equals("SchemaName")) {
                xMLableReader.readXMLObject(new XMLReadable(this, arrayList){
                    private final /* synthetic */ List val$schemaList;
                    private final /* synthetic */ SchemaReader this$0;
                    {
                        this.this$0 = schemaReader;
                        this.val$schemaList = list;
                    }

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Schema")) {
                            String string = xMLableReader.getElementValue();
                            this.val$schemaList.add(string);
                        }
                    }
                });
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            return stringArray;
        }

        public Object errorHandler() {
            return new String[0];
        }
    }

    private static class SchemaWriter
    implements XMLWriter {
        private String[] schema;

        public SchemaWriter(String[] stringArray) {
            this.schema = stringArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("SchemaName");
            for (int i = 0; i < (this.schema == null ? 0 : this.schema.length); ++i) {
                xMLPrintWriter.startTAG("Schema").textNode(this.schema[i]).end();
            }
            xMLPrintWriter.end();
        }
    }

    private static class ParameterArrayReader
    implements XMLFileReader {
        private ParameterArrayReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("Parameters".equals(string)) {
                return ReportXMLUtils.readParameters(xMLableReader);
            }
            return null;
        }

        public Object errorHandler() {
            return new Parameter[0];
        }
    }

    private static class ParameterArrayWriter
    implements XMLWriter {
        private Parameter[] parameters;

        ParameterArrayWriter(Parameter[] parameterArray) {
            this.parameters = parameterArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            ReportXMLUtils.writeParameters(xMLPrintWriter, this.parameters);
        }
    }

    private static class TableDataReader
    implements XMLFileReader {
        private TableDataReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            if ("TableData".equals(string)) {
                return DataXMLUtils.readXMLTableData(xMLableReader);
            }
            return null;
        }

        public Object errorHandler() {
            return null;
        }
    }

    private static class TableDataWriter
    implements XMLWriter {
        private TableData data;

        TableDataWriter(TableData tableData) {
            this.data = tableData;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            DataXMLUtils.writeXMLTableData(xMLPrintWriter, this.data);
        }
    }

    private static class DatabaseMapConnectionReader
    implements XMLFileReader {
        private DatabaseMapConnectionReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            Connection connection;
            String string = xMLableReader.getTagName();
            if ("ConnectionMap".equals(string) && (connection = DataXMLUtils.readXMLConnectionMap(xMLableReader)) instanceof DatabaseConnection) {
                return connection;
            }
            return null;
        }

        public Object errorHandler() {
            return null;
        }
    }

    private static class DatabaseConnectionReader
    implements XMLFileReader {
        private DatabaseConnectionReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            Connection connection;
            String string = xMLableReader.getTagName();
            if ("Connection".equals(string) && (connection = DataXMLUtils.readXMLConnection(xMLableReader)) instanceof DatabaseConnection) {
                return connection;
            }
            return null;
        }

        public Object errorHandler() {
            return null;
        }
    }

    private static class DatabaseConnectionWriter
    implements XMLWriter {
        private DatabaseConnection database;

        DatabaseConnectionWriter(DatabaseConnection databaseConnection) {
            this.database = databaseConnection;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            DataXMLUtils.writeXMLConnection(xMLPrintWriter, this.database);
        }
    }

    private static class FileNodeArrayReader
    implements XMLFileReader {
        private FileNodeArrayReader() {
        }

        public Object readFileContent(XMLableReader xMLableReader) {
            String string = xMLableReader.getTagName();
            final ArrayList arrayList = new ArrayList();
            if ("NODES".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "Node".equals(xMLableReader.getTagName())) {
                            FileNode fileNode = new FileNode();
                            xMLableReader.readXMLObject(fileNode);
                            arrayList.add(fileNode);
                        }
                    }
                });
            }
            return arrayList.toArray(new FileNode[arrayList.size()]);
        }

        public Object errorHandler() {
            return new FileNode[0];
        }
    }

    private static class FileNodeArrayWriter
    implements XMLWriter {
        private FileNode[] fileNodes;

        FileNodeArrayWriter(FileNode[] fileNodeArray) {
            this.fileNodes = fileNodeArray;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            int n;
            xMLPrintWriter.startTAG("NODES");
            int n2 = n = this.fileNodes == null ? 0 : this.fileNodes.length;
            for (int i = 0; i < n; ++i) {
                this.fileNodes[i].writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
    }
}

