/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.dav;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.XMLFileManager;
import com.fr.base.XMLTools;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.dav.Env;
import com.fr.base.dav.EnvException;
import com.fr.base.dav.FileNode;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.report.RWorkBook;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateWorkBook;
import com.fr.report.WorkBook;
import com.fr.report.io.TemplateExporter;
import com.fr.report.io.TemplateImporter;
import com.fr.report.parameter.Parameter;
import com.fr.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class LocalEnv
implements Env {
    private String path;
    private Map tableDataMap = new HashMap();

    public LocalEnv() {
    }

    public LocalEnv(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void checkValid() throws EnvException {
        File file = new File(this.path);
        if (!file.isDirectory()) {
            throw new EnvException(this.path + " is not a valid directory.");
        }
        if (!ComparatorUtils.equals(file.getName(), "WEB-INF")) {
            throw new EnvException(Inter.getLocText("Env-Des1"));
        }
    }

    public InputStream readResource(String string) throws Exception {
        return new FileInputStream(BaseCoreUtils.pathJoin(new String[]{this.path, "resources", string}));
    }

    public boolean writeResource(XMLFileManager xMLFileManager) throws Exception {
        File file = new File(BaseCoreUtils.pathJoin(new String[]{this.path, "resources", xMLFileManager.fileName()}));
        Utils.mkfile(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        XMLTools.writeOutputStreamXML(xMLFileManager, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        return true;
    }

    public boolean isTemplateExist(String string) throws Exception {
        if (string == null) {
            return false;
        }
        return new File(BaseCoreUtils.pathJoin(new String[]{this.path, "reportlets", string})).exists();
    }

    public TemplateWorkBook readTemplate(String string) throws Exception {
        WorkBook workBook = null;
        File file = new File(BaseCoreUtils.pathJoin(new String[]{this.path, "reportlets", string}));
        if (!file.exists()) {
            throw new FileNotFoundException(Inter.getLocText("Cannot_Found_Template_File") + ":" + string);
        }
        TemplateImporter templateImporter = new TemplateImporter();
        workBook = templateImporter.generateTemplate(file);
        return workBook;
    }

    public boolean writeTemplate(TemplateWorkBook templateWorkBook, String string) throws Exception {
        File file = new File(BaseCoreUtils.pathJoin(new String[]{this.path, "reportlets", string}));
        if (!file.exists()) {
            Utils.mkfile(file);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        new TemplateExporter().export((OutputStream)fileOutputStream, templateWorkBook);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        return true;
    }

    public boolean createFolder(String string) {
        File file = new File(BaseCoreUtils.pathJoin(new String[]{this.path, string}));
        if (file.exists()) {
            return true;
        }
        return Utils.mkdirs(file);
    }

    public boolean createFile(String string) throws Exception {
        File file = new File(BaseCoreUtils.pathJoin(new String[]{this.path, string}));
        if (file.exists()) {
            return true;
        }
        return Utils.mkfile(file);
    }

    public boolean fileExists(String string) {
        return new File(BaseCoreUtils.pathJoin(new String[]{this.path, string})).exists();
    }

    public InputStream fileInputStream(String string) throws Exception {
        return new FileInputStream(BaseCoreUtils.pathJoin(new String[]{this.path, string}));
    }

    public FileNode[] listFile(String string) {
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        File file = new File(BaseCoreUtils.pathJoin(new String[]{this.path, string}));
        if (file.isFile()) {
            arrayList.add(new FileNode(string, file.isDirectory()));
        } else {
            int n;
            File[] fileArray = file.listFiles();
            int n2 = n = fileArray == null ? 0 : fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray[i];
                arrayList.add(new FileNode(BaseCoreUtils.pathJoin(new String[]{string, file2.getName()}), file2.isDirectory()));
            }
        }
        return arrayList.toArray(new FileNode[arrayList.size()]);
    }

    public boolean testConnection(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            return false;
        }
        try {
            databaseConnection.testConnection();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public List getTableColumnNames(TableData tableData) throws Exception {
        List list = (List)this.tableDataMap.get(tableData);
        return list;
    }

    public void setTableColumnNames(TableData tableData) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableData tableData2 = null;
        try {
            tableData2 = FRContext.getCurrentEnv().previewTableData(tableData, Collections.EMPTY_MAP, 0);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        if (tableData2 != null) {
            try {
                int n = tableData2.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    String string = tableData2.getColumnName(i);
                    arrayList.add(string);
                }
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
            try {
                tableData2.release();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        Collections.sort(arrayList);
        this.tableDataMap.put(tableData, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTableSchema(DatabaseConnection databaseConnection) throws Exception {
        if (databaseConnection == null) {
            return null;
        }
        Connection connection = databaseConnection.createConnection();
        if (connection == null) {
            throw new Exception("Cannot connect to database!");
        }
        Dialect dialect = DialectFactory.generateDialect(connection);
        try {
            String[] stringArray = dialect.getSchemas(connection);
            return stringArray;
        }
        finally {
            if (connection != null) {
                DBUtils.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableProcedure[] getSQLTablesProcedure(DatabaseConnection databaseConnection, String string) throws Exception {
        List<TableProcedure> list = new ArrayList();
        ResultSet resultSet = null;
        String string2 = null;
        Connection connection = databaseConnection.createConnection();
        if (connection == null) {
            throw new Exception("Cannot connect to database!");
        }
        if (string != null) {
            string2 = connection.getCatalog();
        }
        Dialect dialect = DialectFactory.generateDialect(connection);
        list = dialect.getTableProcedure(connection, string, false);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String[] stringArray = new String[]{"VIEW"};
        try {
            resultSet = databaseMetaData.getTables(string2, string, "%", stringArray);
        }
        catch (SQLException sQLException) {
            resultSet = databaseMetaData.getTables(string2, string, "%", stringArray);
        }
        while (resultSet.next()) {
            list.add(new TableProcedure(resultSet.getString(2), resultSet.getString(3), resultSet.getString(4)));
        }
        resultSet.close();
        try {
            resultSet = databaseMetaData.getProcedures(string2, string, "%");
            while (resultSet.next()) {
                String string3 = resultSet.getString(3);
                int n = string3.lastIndexOf(";");
                if (n > 0) {
                    string3 = string3.substring(0, n);
                }
                list.add(new TableProcedure(resultSet.getString(2), string3, "PROCEDURE"));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return list.toArray(new TableProcedure[list.size()]);
    }

    public TableProcedure[] getTableProcedure(DatabaseConnection databaseConnection, String string, String string2) throws Exception {
        TableProcedure[] tableProcedureArray = null;
        ResultSet resultSet = null;
        String string3 = null;
        Connection connection = databaseConnection.createConnection();
        if (connection == null) {
            throw new Exception("Cannot connect to database!");
        }
        if (string2 != null) {
            string3 = connection.getCatalog();
        }
        if (string.equals("TABLE")) {
            List list = new ArrayList();
            Dialect dialect = DialectFactory.generateDialect(connection);
            list = dialect.getTableProcedure(connection, string2, false);
            tableProcedureArray = list.toArray(new TableProcedure[list.size()]);
        } else if (string.equals("VIEW")) {
            ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray = new String[]{"VIEW"};
            try {
                resultSet = databaseMetaData.getTables(string3, string2, "%", stringArray);
            }
            catch (SQLException sQLException) {
                resultSet = databaseMetaData.getTables(string3, string2, "%", stringArray);
            }
            while (resultSet.next()) {
                arrayList.add(new TableProcedure(resultSet.getString(2), resultSet.getString(3), resultSet.getString(4)));
            }
            resultSet.close();
            tableProcedureArray = arrayList.toArray(new TableProcedure[arrayList.size()]);
        } else if (string.equals("PROCEDURE")) {
            ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                resultSet = databaseMetaData.getProcedures(string3, string2, "%");
                while (resultSet.next()) {
                    String string4 = resultSet.getString(3);
                    int n = string4.lastIndexOf(";");
                    if (n > 0) {
                        string4 = string4.substring(0, n);
                    }
                    arrayList.add(new TableProcedure(resultSet.getString(2), string4, "PROCEDURE"));
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                FRContext.getLogger().log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
            tableProcedureArray = arrayList.toArray(new TableProcedure[arrayList.size()]);
        } else if (string.equals("ALLTABLE")) {
            List list = new ArrayList();
            Dialect dialect = DialectFactory.generateDialect(connection);
            list = dialect.getTableProcedure(connection, string2, true);
            tableProcedureArray = list.toArray(new TableProcedure[list.size()]);
        }
        if (connection != null) {
            connection.close();
        }
        return tableProcedureArray;
    }

    public Parameter[] getTableDataParameters(TableData tableData) {
        Parameter[] parameterArray = null;
        if (tableData != null) {
            parameterArray = tableData.getParameters();
        }
        return parameterArray == null ? new Parameter[]{} : parameterArray;
    }

    /*
     * Loose catch block
     */
    public TableData previewTableData(TableData tableData, Map map, int n) throws TableDataException {
        EmbeddedTableData embeddedTableData;
        block10: {
            int n2;
            TableData tableData2 = null;
            embeddedTableData = null;
            try {
                tableData2 = (TableData)tableData.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
            Parameter[] parameterArray = tableData2.getParameters();
            int n3 = n2 = parameterArray == null ? 0 : parameterArray.length;
            for (int i = 0; i < n2; ++i) {
                Object v = map.get(parameterArray[i].getName());
                if (v == null) continue;
                parameterArray[i].setValue(v);
            }
            embeddedTableData = EmbeddedTableData.embedify(tableData2, n);
            Object var11_12 = null;
            try {
                tableData2.release();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
            break block10;
            {
                catch (TableDataException tableDataException) {
                    throw new TableDataException(tableDataException.getMessage(), tableDataException);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    tableData2.release();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
                throw throwable;
            }
        }
        return embeddedTableData == null ? new EmbeddedTableData() : embeddedTableData;
    }

    public Parameter[] getTemplateParameters(TemplateWorkBook templateWorkBook) throws Exception {
        if (templateWorkBook == null) {
            return new Parameter[0];
        }
        Parameter[] parameterArray = templateWorkBook.getParameters();
        return parameterArray == null ? new Parameter[]{} : parameterArray;
    }

    public ResultWorkBook executeTemplate(TemplateWorkBook templateWorkBook, Map map) {
        return templateWorkBook.execute(map);
    }

    public void openContainerFolder(FileNode fileNode) {
        if (fileNode == null) {
            return;
        }
        Utils.openWindowsFolder(BaseCoreUtils.pathJoin(new String[]{this.path, fileNode.getEnvPath()}));
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "DIR".equals(xMLableReader.getTagName())) {
            this.path = xMLableReader.getElementValue();
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DIR").textNode(this.path).end();
    }

    public boolean writeResult(ResultWorkBook resultWorkBook, String string) throws Exception {
        File file = new File(BaseCoreUtils.pathJoin(new String[]{this.path, "resultlets", string}));
        if (!file.exists()) {
            Utils.mkfile(file);
        }
        file.getAbsolutePath();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        new TemplateExporter().export((OutputStream)fileOutputStream, resultWorkBook);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        return true;
    }

    public ResultWorkBook readResult(String string) throws Exception {
        if (string == null) {
            return null;
        }
        RWorkBook rWorkBook = null;
        File file = new File(BaseCoreUtils.pathJoin(new String[]{this.path, "resultlets", string}));
        if (!file.exists()) {
            throw new FileNotFoundException(Inter.getLocText("Cannot_Found_Result_File") + ":" + string);
        }
        TemplateImporter templateImporter = new TemplateImporter();
        rWorkBook = templateImporter.generateResult(file);
        return rWorkBook;
    }
}

