/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.file;

import com.fr.base.FRContext;
import com.fr.base.XMLFileManager;
import com.fr.base.cache.CacheEventAdapter;
import com.fr.base.cache.CacheException;
import com.fr.base.cache.FRCache;
import com.fr.base.cache.Unity;
import com.fr.base.cache.config.CacheConfiguration;
import com.fr.base.cache.store.MemoryStore;
import com.fr.base.cache.store.Status;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.TableDataAdapter;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.util.Consts;
import com.fr.util.Utils;
import java.io.File;
import java.util.logging.Level;

public class CacheManager
extends XMLFileManager {
    private File cacheDirectory = null;
    private int maxMemSize = 0x400000;
    private CacheConfiguration dbConfig = new CacheConfiguration();
    private CacheConfiguration cptConfig = new CacheConfiguration();
    private Thread shutdownHook;
    private Status status = Status.STATUS_ALIVE;
    private FRCache db_cache;
    private FRCache cpt_cache;
    private boolean alwaysReloadTpl = true;
    static /* synthetic */ Class class$com$fr$base$file$CacheManager;

    public CacheManager() {
        this.addShutdownHookIfRequired();
        this.db_cache = this.createDBCache();
        this.cpt_cache = this.createCptCache();
    }

    public String fileName() {
        return "cache.xml";
    }

    public synchronized TableDataAdapter get(DatabaseConnection databaseConnection, String string, long l) {
        TableDataAdapter tableDataAdapter = (TableDataAdapter)this.db_cache.getObject(new DBKey(databaseConnection, string));
        if (tableDataAdapter == null) {
            tableDataAdapter = DBTableData.createCacheableAdapter(databaseConnection, string, 0, l);
            this.db_cache.put(new DBKey(databaseConnection, string), tableDataAdapter);
        }
        return tableDataAdapter;
    }

    public File getCacheDirectory() {
        if (this.cacheDirectory == null) {
            this.cacheDirectory = new File(Consts.getEnvHome(), "cache");
            Utils.mkdirs(this.cacheDirectory);
            this.cacheDirectory.deleteOnExit();
        }
        return this.cacheDirectory;
    }

    public int getMaxMemSize() {
        return this.maxMemSize;
    }

    public void setMaxMemSize(int n) {
        this.maxMemSize = n;
    }

    public CacheConfiguration getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(CacheConfiguration cacheConfiguration) {
        this.dbConfig = cacheConfiguration;
    }

    public CacheConfiguration getCptConfig() {
        return this.cptConfig;
    }

    public void setCptConfig(CacheConfiguration cacheConfiguration) {
        this.cptConfig = cacheConfiguration;
    }

    public void setAlwaysReloadTpl(boolean bl) {
        this.alwaysReloadTpl = bl;
    }

    public boolean isAlwaysReloadTpl() {
        return this.alwaysReloadTpl;
    }

    public FRCache createDBCache() {
        final FRCache fRCache = new FRCache(this.dbConfig);
        fRCache.getCacheEventNotificationService().registerListener(new CacheEventAdapter(){

            public void notifyElementRemoved(FRCache fRCache2, Unity unity) throws CacheException {
                TableDataAdapter tableDataAdapter = (TableDataAdapter)unity.getObjectValue();
                try {
                    tableDataAdapter.tryDestroy();
                }
                catch (Exception exception) {
                    throw new CacheException(exception.getMessage(), exception);
                }
            }

            public void notifyElementExpired(FRCache fRCache2, Unity unity) {
                TableDataAdapter tableDataAdapter = (TableDataAdapter)unity.getObjectValue();
                try {
                    tableDataAdapter.tryDestroy();
                }
                catch (Exception exception) {
                    throw new CacheException(exception.getMessage(), exception);
                }
            }

            public void dispose() {
                MemoryStore memoryStore = fRCache.getStore();
                Object[] objectArray = memoryStore.getKeyArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Unity unity = memoryStore.get(objectArray[i]);
                    TableDataAdapter tableDataAdapter = (TableDataAdapter)unity.getObjectValue();
                    try {
                        tableDataAdapter.tryDestroy();
                        continue;
                    }
                    catch (Exception exception) {
                        throw new CacheException(exception.getMessage(), exception);
                    }
                }
            }
        });
        return fRCache;
    }

    public FRCache createCptCache() {
        this.cptConfig.setMemoryStoreEvictionPolicy("DISK_CPT");
        this.cptConfig.setMaxElementsOnDisk(100);
        FRCache fRCache = new FRCache(this.cptConfig);
        fRCache.getCacheEventNotificationService().registerListener(new CacheEventAdapter(){

            public void dispose() {
                if (CacheManager.this.cacheDirectory != null) {
                    Utils.deleteFile(CacheManager.this.cacheDirectory);
                }
            }
        });
        return fRCache;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("XMLVersion")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                    synchronizedVersion.setXmlVersionByString(string2);
                }
            } else if ("Basic".equals(string)) {
                String string3 = xMLableReader.getAttr("maxMemSize");
                if (string3 != null) {
                    this.setMaxMemSize(Integer.parseInt(string3));
                }
            } else if ("DBConfig".equals(string)) {
                if (this.dbConfig == null) {
                    CacheConfiguration cacheConfiguration = new CacheConfiguration();
                    xMLableReader.readXMLObject(cacheConfiguration);
                    this.setDbConfig(cacheConfiguration);
                } else {
                    xMLableReader.readXMLObject(this.getDbConfig());
                }
            } else if ("AlwaysReloadTpl".equals(string)) {
                this.setAlwaysReloadTpl(Boolean.valueOf(xMLableReader.getElementValue()));
            } else if ("CPTConfig".equals(string)) {
                if (this.getCptConfig() == null) {
                    CacheConfiguration cacheConfiguration = new CacheConfiguration();
                    xMLableReader.readXMLObject(cacheConfiguration);
                    this.setDbConfig(cacheConfiguration);
                } else {
                    xMLableReader.readXMLObject(this.getCptConfig());
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CacheParameters");
        xMLPrintWriter.startTAG("Basic").attr("maxMemSize", this.getMaxMemSize()).end();
        if (this.dbConfig != null) {
            xMLPrintWriter.startTAG("DBConfig");
            this.dbConfig.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.cptConfig != null) {
            xMLPrintWriter.startTAG("CPTConfig");
            this.cptConfig.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("AlwaysReloadTpl").textNode(String.valueOf(this.isAlwaysReloadTpl())).end();
        xMLPrintWriter.end();
    }

    private void addShutdownHookIfRequired() {
        boolean bl = true;
        if (!bl) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    if (CacheManager.this.status.equals(Status.STATUS_ALIVE)) {
                        CacheManager.this.shutdownHook = null;
                        CacheManager.this.shutdown();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
        this.shutdownHook = thread;
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                FRContext.getLogger().log(Level.WARNING, "IllegalStateException due to attempt to remove a shutdownhook while the VM is actually shutting down.", illegalStateException);
            }
            this.shutdownHook = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class clazz = class$com$fr$base$file$CacheManager == null ? (class$com$fr$base$file$CacheManager = CacheManager.class$("com.fr.base.file.CacheManager")) : class$com$fr$base$file$CacheManager;
        synchronized (clazz) {
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                return;
            }
            if (this.db_cache != null) {
                this.db_cache.dispose();
            }
            Utils.deleteFile(this.cacheDirectory);
            this.status = Status.STATUS_SHUTDOWN;
            this.removeShutdownHook();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static interface PoolKey {
    }

    private static class DBKey
    implements PoolKey {
        private DatabaseConnection database;
        private String query;

        public DBKey(DatabaseConnection databaseConnection, String string) {
            this.database = databaseConnection;
            this.query = string;
        }

        public int hashCode() {
            return this.database.hashCode() + this.query.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof DBKey)) {
                return false;
            }
            DBKey dBKey = (DBKey)object;
            return this.database.equals(dBKey.database) && this.query.equals(dBKey.query);
        }
    }
}

