/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.file;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.XMLFileManager;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.web.cluster.ClusterService;
import com.fr.web.core.service.ClusterUtilService;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ClusterConfigManager
extends XMLFileManager {
    private boolean isInit = false;
    private String localIp = null;
    private String localPort = null;
    private boolean useCluster = false;
    private List serviceList = new ArrayList();
    private ClusterService selfService = null;

    public String fileName() {
        return "cluster.xml";
    }

    public void initClusterServiceConfig(HttpServletRequest httpServletRequest) {
        if (!this.isInit) {
            for (int i = 0; i < this.serviceList.size(); ++i) {
                if (!((ClusterService)this.serviceList.get(i)).isSelf()) continue;
                this.selfService = (ClusterService)this.serviceList.get(i);
            }
            if (this.selfService == null) {
                try {
                    this.localIp = ClusterUtilService.getLocalIP().trim();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
                this.localPort = String.valueOf(httpServletRequest.getLocalPort()).trim();
                if (StringUtils.isNotEmpty(this.localIp) && StringUtils.isNotEmpty(this.localPort)) {
                    for (int i = 0; i < this.serviceList.size(); ++i) {
                        ClusterService clusterService = (ClusterService)this.serviceList.get(i);
                        if (!this.localIp.equals(clusterService.getIp()) || !this.localPort.equals(clusterService.getPort())) continue;
                        this.selfService = clusterService;
                    }
                }
            }
            this.isInit = true;
        }
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public String getLocalPort() {
        return this.localPort;
    }

    public ClusterService getSelfService() {
        return this.selfService;
    }

    public List getOtherServices() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.serviceList.size(); ++i) {
            if (this.selfService != null && this.selfService.equals(this.serviceList.get(i))) continue;
            arrayList.add(this.serviceList.get(i));
        }
        return arrayList;
    }

    public ClusterService getService(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.serviceList.size(); ++i) {
            if (!string.equals(((ClusterService)this.serviceList.get(i)).getServiceName())) continue;
            return (ClusterService)this.serviceList.get(i);
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr()) {
            if (this.serviceList == null) {
                this.serviceList = new ArrayList();
            } else {
                this.serviceList.clear();
            }
            string = xMLableReader.getAttr("useCluster");
            if (string != null) {
                this.setUseCluster(Boolean.valueOf(string));
            }
        }
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if (string2.equals("XMLVersion")) {
                string = xMLableReader.getElementValue();
                if (string != null) {
                    SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                    synchronizedVersion.setXmlVersionByString(string);
                }
            } else if ("ClusterService".equals(string2)) {
                ClusterService clusterService = new ClusterService();
                xMLableReader.readXMLObject(clusterService);
                this.serviceList.add(clusterService);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ClusterConfig").attr("useCluster", this.useCluster);
        for (int i = 0; i < this.serviceList.size(); ++i) {
            ((ClusterService)this.serviceList.get(i)).writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean isUseCluster() {
        return this.useCluster;
    }

    public void setUseCluster(boolean bl) {
        this.useCluster = bl;
    }
}

