/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.file;

import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.base.XMLFileManager;
import com.fr.base.core.util.ListMap;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.ReportWebAttr;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.report.parameter.Parameter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class ConfigManager
extends XMLFileManager {
    private String serverCharset = null;
    private Level serverLogLevel = Level.WARNING;
    private int concurrency = 100;
    private int concurrencyOnce = 10;
    private ReportWebAttr reportWebAttr = new ReportWebAttr();
    private Parameter[] globeParameters = new Parameter[0];
    private Map styleMap = new ListMap();
    private boolean popupFlashPrintSetting = true;
    private boolean popupPdfPrintSetting = true;
    private String ServletMapping = "ReportServer";
    private boolean supportGzip = false;
    private int serverLanguage = 0;
    private String resultSaverClassName = null;

    public String fileName() {
        return "config.xml";
    }

    public String getServerCharset() {
        if (this.serverCharset == null) {
            this.serverCharset = this.getDefaultBrowserCharset();
        }
        return this.serverCharset;
    }

    public void setServerCharset(String string) {
        this.serverCharset = string;
    }

    private String getDefaultBrowserCharset() {
        if (Locale.SIMPLIFIED_CHINESE.equals(FRContext.getLocale())) {
            return "GBK";
        }
        if (Locale.TRADITIONAL_CHINESE.equals(FRContext.getLocale())) {
            return "BIG5";
        }
        if (Locale.JAPANESE.equals(FRContext.getLocale())) {
            return "EUC_JP";
        }
        if (Locale.KOREAN.equals(FRContext.getLocale())) {
            return "EUC_KR";
        }
        return "UTF-8";
    }

    public Level getServerLogLevel() {
        return this.serverLogLevel;
    }

    public void setServerLogLevel(Level level) {
        this.serverLogLevel = level;
        FRContext.getLogger().setLevel(level);
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int n) {
        this.concurrency = Math.max(n, 0);
    }

    public int getConcurrencyOnce() {
        return this.concurrencyOnce;
    }

    public void setConcurrencyOnce(int n) {
        this.concurrencyOnce = Math.max(n, 1);
    }

    public boolean isPopupFlashPrintSetting() {
        return this.popupFlashPrintSetting;
    }

    public boolean isPopupPdfPrintSetting() {
        return this.popupPdfPrintSetting;
    }

    public void setPopupFlashPrintSetting(boolean bl) {
        this.popupFlashPrintSetting = bl;
    }

    public void setPopupPdfPrintSetting(boolean bl) {
        this.popupPdfPrintSetting = bl;
    }

    public void setSupportGzip(boolean bl) {
        this.supportGzip = bl;
    }

    public boolean isSupportGzip() {
        return this.supportGzip;
    }

    public void setServerLanguage(int n) {
        this.serverLanguage = n;
    }

    public int getServerLanguage() {
        return this.serverLanguage;
    }

    public boolean hasStyle() {
        return this.styleMap.isEmpty();
    }

    public Iterator getStyleNameIterator() {
        return this.styleMap.keySet().iterator();
    }

    public Style getStyle(String string) {
        return (Style)this.styleMap.get(string);
    }

    public void putStyle(String string, Style style) {
        if (style == null) {
            this.styleMap.remove(string);
        }
        this.styleMap.put(string, style);
    }

    public void removeStyle(String string) {
        this.styleMap.remove(string);
    }

    public void clearAllStyle() {
        this.styleMap.clear();
    }

    public String getResultSaverClassName() {
        return this.resultSaverClassName;
    }

    public void setResultSaverClassName(String string) {
        this.resultSaverClassName = string;
    }

    public String[] getImportedCss() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.reportWebAttr != null) {
            int n = this.reportWebAttr.getCSSImportCount();
            for (int i = 0; i < n; ++i) {
                hashSet.add(this.reportWebAttr.getCSSImport(i));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] getWriteImportedCss() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.reportWebAttr != null) {
            int n = this.reportWebAttr.getWriteCSSImportCount();
            for (int i = 0; i < n; ++i) {
                hashSet.add(this.reportWebAttr.getWriteCSSImport(i));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] getWidgetImportedCss() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.reportWebAttr != null) {
            int n = this.reportWebAttr.getWidgetCSSImportCount();
            for (int i = 0; i < n; ++i) {
                hashSet.add(this.reportWebAttr.getWidgetCSSImport(i));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] getImportedJs() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.reportWebAttr != null) {
            int n = this.reportWebAttr.getJSImportCount();
            for (int i = 0; i < n; ++i) {
                hashSet.add(this.reportWebAttr.getJSImport(i));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode()) {
            String string2;
            String string3 = xMLableReader.getTagName();
            if (string3.equals("XMLVersion")) {
                String string4 = xMLableReader.getElementValue();
                if (string4 != null) {
                    SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                    synchronizedVersion.setXmlVersionByString(string4);
                }
            } else if ("Write".equals(string3)) {
                String string5 = xMLableReader.getAttr("serverCharacterEncoding");
                if (string5 != null) {
                    this.setServerCharset(string5);
                }
            } else if ("SM".equals(string3)) {
                String string6 = xMLableReader.getAttr("concurrency");
                if (string6 != null) {
                    this.setConcurrency(Integer.parseInt(string6));
                }
                if ((string6 = xMLableReader.getAttr("concurrencyOnce")) != null) {
                    this.setConcurrencyOnce(Integer.parseInt(string6));
                }
            } else if ("GZip".equals(string3)) {
                String string7 = xMLableReader.getAttr("run");
                if (string7 != null) {
                    this.setSupportGzip(Boolean.valueOf(string7));
                }
            } else if ("ServletMapping".equals(string3)) {
                String string8 = xMLableReader.getAttr("pattern");
                if (string8 != null) {
                    this.setServletMapping(string8);
                }
            } else if ("Parameters".equals(string3) || "Global_Parameters".equals(string3)) {
                this.globeParameters = ReportXMLUtils.readParameters(xMLableReader);
            } else if (string3.equals("ReportWebAttr")) {
                xMLableReader.readXMLObject(this.reportWebAttr);
            } else if ("ServerLogLevel".equals(string3) || "SetServerLogLevel".equals(string3)) {
                String string9 = xMLableReader.getElementValue();
                if (string9 != null) {
                    try {
                        Level level = Level.parse(string9);
                        this.setServerLogLevel(level);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else if (string3.equals("Styles")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isAttr()) {
                            ConfigManager.this.styleMap.clear();
                        }
                        if (xMLableReader.isChildNode() && "SAttr".equals(string = xMLableReader.getTagName())) {
                            String string2 = "";
                            String string3 = xMLableReader.getAttr("name");
                            if (string3 != null) {
                                string2 = string3;
                            }
                            xMLableReader.readXMLObject(new XMLObject(this, string2){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void readXML(XMLableReader xMLableReader) {
                                    if (xMLableReader.isChildNode() && "Style".equals(xMLableReader.getTagName())) {
                                        Style style = ReportXMLUtils.readFullStyle(xMLableReader);
                                        1.access$100(this.this$1).putStyle((String)this.getObject(), style);
                                    }
                                }
                            });
                        }
                    }

                    static /* synthetic */ ConfigManager access$100(1 var0) {
                        return var0.ConfigManager.this;
                    }
                });
            } else if (string3.equals("FlashPrint")) {
                String string10 = xMLableReader.getAttr("popupFlashPrintSetting");
                if (string10 != null) {
                    this.setPopupFlashPrintSetting(Boolean.valueOf(string10));
                }
            } else if (string3.equals("PdfPrint") && (string2 = xMLableReader.getAttr("popupPdfPrintSetting")) != null) {
                this.setPopupPdfPrintSetting(Boolean.valueOf(string2));
            }
        } else if (xMLableReader.isAttr() && (string = xMLableReader.getAttr("language")) != null) {
            this.setServerLanguage(Integer.parseInt(string));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ReportServerParameter").attr("language", this.getServerLanguage());
        if (this.serverLogLevel != null) {
            xMLPrintWriter.startTAG("ServerLogLevel");
            xMLPrintWriter.textNode(String.valueOf(this.getServerLogLevel()));
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("Write").attr("serverCharacterEncoding", this.getServerCharset());
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("GZip").attr("run", this.isSupportGzip()).end();
        xMLPrintWriter.startTAG("ServletMapping").attr("pattern", this.getServletMapping()).end();
        xMLPrintWriter.startTAG("SM").attr("concurrency", this.concurrency).attr("concurrencyOnce", this.concurrencyOnce).end();
        xMLPrintWriter.startTAG("ReportWebAttr");
        this.reportWebAttr.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
        ReportXMLUtils.writeParameters(xMLPrintWriter, this.globeParameters);
        xMLPrintWriter.startTAG("Styles");
        Iterator iterator = this.getStyleNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Style style = this.getStyle(string);
            if (style == null) continue;
            xMLPrintWriter.startTAG("SAttr").attr("name", string);
            ReportXMLUtils.writeStyle(xMLPrintWriter, style);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("FlashPrint").attr("popupFlashPrintSetting", this.isPopupFlashPrintSetting()).end();
        xMLPrintWriter.startTAG("PdfPrint").attr("popupPdfPrintSetting", this.isPopupPdfPrintSetting()).end();
        xMLPrintWriter.end();
    }

    public ReportWebAttr getReportWebAttr() {
        return this.reportWebAttr;
    }

    public void setReportWebAttr(ReportWebAttr reportWebAttr) {
        this.reportWebAttr = reportWebAttr;
    }

    public Parameter[] getGlobal_Parameters() {
        return this.globeParameters;
    }

    public void setGlobal_Parameters(Parameter[] parameterArray) {
        this.globeParameters = parameterArray;
    }

    public String getServletMapping() {
        return this.ServletMapping;
    }

    public void setServletMapping(String string) {
        this.ServletMapping = string;
    }
}

