/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.file;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.XMLFileManager;
import com.fr.base.core.util.ListMap;
import com.fr.base.file.DeprecatedDictionaryManager;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.TableData;
import com.fr.data.condition.FalseCondition;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.Connection;
import com.fr.dialog.NameObject;
import com.fr.report.io.xml.ReportDeprecatedXMLUtils;
import com.fr.report.io.xml.SynchronizedVersion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class DatasourceManager
extends XMLFileManager {
    private ListMap nameConnectionMap = new ListMap();
    private ListMap nameTableDataMap = new ListMap();
    private ListMap nameADHOCMap = new ListMap();
    private List nameCondition = null;
    private DeprecatedDictionaryManager deprecatedDicManager = new DeprecatedDictionaryManager();
    private String scheduleDatasource = null;

    public String fileName() {
        return "datasource.xml";
    }

    public List getNameCondition() {
        return this.nameCondition;
    }

    public void setNameCondition(FalseCondition falseCondition) {
        if (this.nameCondition == null) {
            this.nameCondition = new ArrayList();
        }
        this.nameCondition.add(falseCondition);
    }

    public Iterator getConnectionNameIterator() {
        return this.nameConnectionMap.keySet().iterator();
    }

    public Object[] getConnectionNameArray() {
        return this.nameConnectionMap.keySet().toArray();
    }

    public Connection getConnection(String string) {
        return (Connection)this.nameConnectionMap.get(string);
    }

    public void putConnection(String string, Connection connection) {
        if (connection == null) {
            this.nameConnectionMap.remove(string);
        }
        this.nameConnectionMap.put(string, connection);
    }

    public void removeConnection(String string) {
        this.nameConnectionMap.remove(string);
    }

    public void clearAllConnection() {
        this.nameConnectionMap.clear();
    }

    public Iterator getTableDataNameIterator() {
        return this.nameTableDataMap.keySet().iterator();
    }

    private TableData getStoredTableData(String string) {
        return (TableData)this.nameTableDataMap.get(string);
    }

    public TableData getTableData(String string) {
        TableData tableData = this.getStoredTableData(string);
        try {
            return tableData == null ? null : (TableData)tableData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    public void putTableData(String string, TableData tableData) {
        if (tableData == null) {
            this.nameTableDataMap.remove(string);
        }
        this.nameTableDataMap.put(string, tableData);
    }

    public boolean renameTableData(String string, String string2) {
        if (!this.nameTableDataMap.containsKey(string) || this.nameTableDataMap.containsKey(string2)) {
            return false;
        }
        int n = this.nameTableDataMap.indexOf(string);
        this.nameTableDataMap.put(n, string2, this.nameTableDataMap.get(string));
        return true;
    }

    public void removeTableData(String string) {
        this.nameTableDataMap.remove(string);
    }

    public void clearAllTableData() {
        this.nameTableDataMap.clear();
    }

    public Iterator getADHOCNameIterator() {
        return this.nameADHOCMap.keySet().iterator();
    }

    private TableData getStoredADHOC(String string) {
        return (TableData)this.nameADHOCMap.get(string);
    }

    public TableData getADHOC(String string) {
        TableData tableData = this.getStoredADHOC(string);
        try {
            return tableData == null ? null : (TableData)tableData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    public void putADHOC(String string, TableData tableData) {
        if (tableData == null) {
            this.nameADHOCMap.remove(string);
        }
        this.nameADHOCMap.put(string, tableData);
    }

    public boolean renameADHOC(String string, String string2) {
        if (!this.nameADHOCMap.containsKey(string) || this.nameADHOCMap.containsKey(string2)) {
            return false;
        }
        int n = this.nameADHOCMap.indexOf(string);
        this.nameADHOCMap.put(n, string2, this.nameADHOCMap.get(string));
        return true;
    }

    public void removeADHOC(String string) {
        this.nameADHOCMap.remove(string);
    }

    public void clearAllADHOC() {
        this.nameADHOCMap.clear();
    }

    public DeprecatedDictionaryManager getDeprecatedDictionaryManager() {
        return this.deprecatedDicManager;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearAllConnection();
            this.clearAllTableData();
            this.deprecatedDicManager.clearAllDictionary();
        }
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("ConnectionMap".equals(string2) || "DatasourceMap".equals(string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && ("Connection".equals(string = xMLableReader.getTagName()) || "Datasource".equals(string))) {
                            String string2 = null;
                            String string3 = xMLableReader.getAttr("name");
                            if (string3 != null) {
                                string2 = string3;
                            }
                            if (string2 == null) {
                                return;
                            }
                            Connection connection = DataXMLUtils.readXMLConnection(xMLableReader);
                            if (connection != null) {
                                DatasourceManager.this.putConnection(string2, connection);
                            }
                        }
                    }
                });
            } else if ("TableDataMap".equals(string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("TableData")) {
                            String string = null;
                            String string2 = null;
                            string2 = xMLableReader.getAttr("name");
                            if (string2 != null) {
                                string = string2;
                            }
                            if (string == null) {
                                return;
                            }
                            TableData tableData = DataXMLUtils.readXMLTableData(xMLableReader);
                            if (tableData != null) {
                                DatasourceManager.this.putTableData(string, tableData);
                            }
                        }
                    }
                });
            } else if ("ADHOCMap".equals(string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("TableData")) {
                            String string = null;
                            String string2 = null;
                            string2 = xMLableReader.getAttr("name");
                            if (string2 != null) {
                                string = string2;
                            }
                            if (string == null) {
                                return;
                            }
                            TableData tableData = DataXMLUtils.readXMLTableData(xMLableReader);
                            if (tableData != null) {
                                DatasourceManager.this.putADHOC(string, tableData);
                            }
                        }
                    }
                });
            } else if ("DictMap".equals(string2) || "MapMap".equals(string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && ((string = xMLableReader.getTagName()).equals("Dictionary") || string.equals("Dict") || string.equals("Map"))) {
                            String string2 = null;
                            String string3 = null;
                            string3 = xMLableReader.getAttr("name");
                            if (string3 != null) {
                                string2 = string3;
                            }
                            if (string2 == null) {
                                return;
                            }
                            Dictionary dictionary = DataXMLUtils.readXMLDictionary(xMLableReader);
                            if (dictionary != null) {
                                DatasourceManager.this.deprecatedDicManager.putDictionary(string2, dictionary);
                            }
                        }
                    }
                });
            } else if ("Relations".equals(string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "Relation".equals(xMLableReader.getTagName())) {
                            String string = "";
                            String string2 = "";
                            String string3 = "";
                            String string4 = "";
                            String string5 = xMLableReader.getAttr("selfData");
                            if (string5 != null) {
                                string = string5;
                            }
                            if ((string5 = xMLableReader.getAttr("selfField")) != null) {
                                string2 = string5;
                            }
                            if ((string5 = xMLableReader.getAttr("fatherData")) != null) {
                                string3 = string5;
                            }
                            if ((string5 = xMLableReader.getAttr("fatherField")) != null) {
                                string4 = string5;
                            }
                            FalseCondition falseCondition = new FalseCondition(string, string2, string3, string4);
                            DatasourceManager.this.nameCondition.add(falseCondition);
                        }
                    }
                });
            } else if ("ScheduleDatasource".equals(string2)) {
                this.setScheduleDatasource(xMLableReader.getElementValue());
            } else if ("Databases".equals(string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Database")) {
                            String string = null;
                            XMLObject xMLObject = new XMLObject(this, null){
                                private final /* synthetic */ 6 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void readXML(XMLableReader xMLableReader) {
                                    String string;
                                    if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("DatabaseAttr") && (string = xMLableReader.getAttr("name")) != null) {
                                        this.obj = string;
                                    }
                                }
                            };
                            xMLableReader.readXMLObject(xMLObject);
                            string = (String)xMLObject.getObject();
                            if (string != null) {
                                Connection connection = DataXMLUtils.readXMLConnection(xMLableReader);
                                DatasourceManager.this.putConnection(string, connection);
                            }
                        }
                    }
                });
            } else if (string2.equals("NamedDatasource")) {
                NameObject nameObject = ReportDeprecatedXMLUtils.readNamedDatasource_2006_02(xMLableReader);
                if (nameObject != null) {
                    this.nameTableDataMap.put(nameObject.getName(), nameObject.getObject());
                }
            } else if (string2.equals("XMLVersion") && (string = xMLableReader.getElementValue()) != null) {
                SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                synchronizedVersion.setXmlVersionByString(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        xMLPrintWriter.startTAG("DatasourceManager");
        Iterator iterator = this.getConnectionNameIterator();
        if (iterator.hasNext()) {
            xMLPrintWriter.startTAG("ConnectionMap");
            while (iterator.hasNext()) {
                object4 = (String)iterator.next();
                object3 = this.getConnection((String)object4);
                if (object3 == null) continue;
                DataXMLUtils.writeXMLConnection(xMLPrintWriter, (Connection)object3, (String)object4);
            }
            xMLPrintWriter.end();
        }
        if ((object4 = this.getTableDataNameIterator()).hasNext()) {
            xMLPrintWriter.startTAG("TableDataMap");
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object2 = this.getStoredTableData((String)object3);
                if (object2 == null) continue;
                DataXMLUtils.writeXMLTableData(xMLPrintWriter, (TableData)object2, (String)object3);
            }
            xMLPrintWriter.end();
        }
        if ((object3 = this.getADHOCNameIterator()).hasNext()) {
            xMLPrintWriter.startTAG("ADHOCMap");
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = this.getStoredADHOC((String)object2);
                if (object == null) continue;
                DataXMLUtils.writeXMLTableData(xMLPrintWriter, (TableData)object, (String)object2);
            }
            xMLPrintWriter.end();
        }
        if (this.nameCondition != null && this.nameCondition.size() > 0) {
            xMLPrintWriter.startTAG("Relations");
            for (int i = 0; i < this.nameCondition.size(); ++i) {
                object = (FalseCondition)this.nameCondition.get(i);
                xMLPrintWriter.startTAG("Relation").attr("selfData", ((FalseCondition)object).getSelfData()).attr("selfField", ((FalseCondition)object).getSelfField()).attr("fatherData", ((FalseCondition)object).getFatherData()).attr("fatherField", ((FalseCondition)object).getFatherField()).end();
            }
            xMLPrintWriter.end();
        }
        if (StringUtils.isNotEmpty(this.scheduleDatasource)) {
            xMLPrintWriter.startTAG("ScheduleDatasource").textNode(this.scheduleDatasource).end();
        }
        xMLPrintWriter.end();
    }

    public String getScheduleDatasource() {
        return this.scheduleDatasource;
    }

    public void setScheduleDatasource(String string) {
        this.scheduleDatasource = string;
    }
}

