/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.file;

import com.fr.base.XMLFileManager;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.web.face.FaceNode;
import com.fr.web.face.NodeDef;

public class FaceManager
extends XMLFileManager {
    private FaceNode rootFaceNode = new FaceNode();
    private int dayOfMonth = 7;
    private boolean outlookView = true;
    private boolean showHomePage = true;
    private boolean homeTabClosable = false;
    private String homeTitle = "FineReport Demo";
    private String homeURLPath = null;

    public String fileName() {
        return "face.xml";
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(int n) {
        this.dayOfMonth = n;
    }

    public FaceNode getRootFaceNode() {
        return this.rootFaceNode;
    }

    public void setRootFaceNode(FaceNode faceNode) {
        this.rootFaceNode = faceNode;
    }

    public boolean isOutlookView() {
        return this.outlookView;
    }

    public void setOutlookView(boolean bl) {
        this.outlookView = bl;
    }

    public boolean isShowHomePage() {
        return this.showHomePage;
    }

    public void setShowHomePage(boolean bl) {
        this.showHomePage = bl;
    }

    public boolean isHomeTabClosable() {
        return this.homeTabClosable;
    }

    public void setHomeTabClosable(boolean bl) {
        this.homeTabClosable = bl;
    }

    public String getHomeTitle() {
        return this.homeTitle;
    }

    public void setHomeTitle(String string) {
        this.homeTitle = string;
    }

    public String getHomeURLPath() {
        return this.homeURLPath;
    }

    public void setHomeURLPath(String string) {
        this.homeURLPath = string;
    }

    public NodeDef searchNodeDef(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            return null;
        }
        FaceNode faceNode = this.getRootFaceNode();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            int n = faceNode.getChildCount();
            for (int j = 0; j < n; ++j) {
                FaceNode faceNode2 = faceNode.getChild(j);
                NodeDef nodeDef = faceNode2.getNodeDef();
                if (!ComparatorUtils.equals(nodeDef.getName(), stringArray[i])) continue;
                faceNode = faceNode2;
                continue block0;
            }
        }
        if (faceNode != null && faceNode != this.getRootFaceNode()) {
            return faceNode.getNodeDef();
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("XMLVersion")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                    synchronizedVersion.setXmlVersionByString(string2);
                }
            } else if ("Attributes".equals(string)) {
                String string3 = xMLableReader.getAttr("dayOfMonth");
                if (string3 != null) {
                    this.setDayOfMonth(Integer.parseInt(string3));
                }
                if ((string3 = xMLableReader.getAttr("outlookView")) != null) {
                    this.setOutlookView(Boolean.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("showHomePage")) != null) {
                    this.setShowHomePage(Boolean.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("homeTabClosable")) != null) {
                    this.setHomeTabClosable(Boolean.valueOf(string3));
                }
                if ((string3 = xMLableReader.getAttr("homeTabTitle")) != null) {
                    this.setHomeTitle(string3);
                }
                if ((string3 = xMLableReader.getAttr("homeURLPath")) != null) {
                    this.setHomeURLPath(string3);
                }
            } else if ("FaceNode".equals(string)) {
                FaceNode faceNode = new FaceNode();
                this.setRootFaceNode(faceNode);
                xMLableReader.readXMLObject(faceNode);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("FaceManager");
        xMLPrintWriter.startTAG("Attributes").attr("dayOfMonth", this.getDayOfMonth());
        if (!this.isOutlookView()) {
            xMLPrintWriter.attr("outlookView", this.isOutlookView());
        }
        if (!this.isShowHomePage()) {
            xMLPrintWriter.attr("showHomePage", this.isShowHomePage());
        }
        if (this.isHomeTabClosable()) {
            xMLPrintWriter.attr("homeTabClosable", this.isHomeTabClosable());
        }
        if (this.getHomeTitle() != null) {
            xMLPrintWriter.attr("homeTabTitle", this.getHomeTitle());
        }
        if (this.getHomeURLPath() != null) {
            xMLPrintWriter.attr("homeURLPath", this.getHomeURLPath());
        }
        xMLPrintWriter.end();
        FaceNode faceNode = this.getRootFaceNode();
        if (faceNode != null) {
            faceNode.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }
}

