/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.html;

import com.fr.base.CodeUtils;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.html.Tag;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HTMLPrintWriter {
    public static final String NEW_LINE = "\n";
    private LinkedList tagChain = new LinkedList();
    private List classes;
    private List styles;
    private PrintWriter writer;
    private boolean debug = false;
    private boolean isLastTagOpened = false;

    public HTMLPrintWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public static HTMLPrintWriter create(OutputStream outputStream) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        }
        return HTMLPrintWriter.create(printWriter);
    }

    public static HTMLPrintWriter create(Writer writer) {
        return HTMLPrintWriter.create(new PrintWriter(writer));
    }

    public static HTMLPrintWriter create(PrintWriter printWriter) {
        return new HTMLPrintWriter(printWriter);
    }

    public HTMLPrintWriter startTAG(String string) {
        this.closeLastTagOfChain();
        this.export("<" + string);
        this.tagChain.add(string);
        this.isLastTagOpened = true;
        return this;
    }

    public HTMLPrintWriter subHtml(String string) {
        this.closeLastTagOfChain();
        this.export(string);
        return this;
    }

    public HTMLPrintWriter subTag(Tag tag) {
        return this.subHtml(tag.toHtml());
    }

    public HTMLPrintWriter cls(String string) {
        if (this.classes == null) {
            this.classes = new ArrayList();
        }
        this.classes.add(string);
        return this;
    }

    public HTMLPrintWriter css(String string, String string2) {
        if (this.styles == null) {
            this.styles = new ArrayList();
        }
        this.styles.add(string + ":" + string2);
        return this;
    }

    private void exportClasses() {
        if (this.classes != null && this.classes.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" class=\"").append(CodeUtils.htmlEncode(BaseCoreUtils.join(this.classes, " "))).append("\"");
            this.export(stringBuffer.toString());
            this.classes.clear();
        }
    }

    private void exportStyles() {
        if (this.styles != null && this.styles.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" style=\"").append(CodeUtils.htmlEncode(BaseCoreUtils.join(this.styles, ";"))).append("\"");
            this.export(stringBuffer.toString());
            this.styles.clear();
        }
    }

    public HTMLPrintWriter attr(String string, String string2) {
        this.export(BaseCoreUtils.join(new String[]{" ", string, "=\"", CodeUtils.htmlEncode(string2), "\""}));
        return this;
    }

    private void export(String string) {
        this.writer.print(string);
        if (this.debug) {
            System.out.print(string);
        }
    }

    private void closeLastTagOfChain() {
        if (this.isLastTagOpened) {
            this.exportClasses();
            this.exportStyles();
            this.export(">\n");
            this.isLastTagOpened = false;
        }
    }

    public HTMLPrintWriter end() {
        String string = (String)this.tagChain.removeLast();
        if (this.isLastTagOpened) {
            if ("script".equalsIgnoreCase(string)) {
                this.exportClasses();
                this.exportStyles();
                this.export("></" + string + ">" + NEW_LINE);
            } else {
                this.exportClasses();
                this.exportStyles();
                this.export("/>\n");
            }
        } else {
            this.export("</" + string + ">" + NEW_LINE);
        }
        this.isLastTagOpened = false;
        return this;
    }

    public HTMLPrintWriter end(int n) {
        while (n-- > 0) {
            this.end();
        }
        return this;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        if (this.tagChain.size() > 0) {
            Object[] objectArray = this.tagChain.toArray(new String[this.tagChain.size()]);
            throw new RuntimeException(BaseCoreUtils.join(new String[]{BaseCoreUtils.join(objectArray, ","), objectArray.length > 1 ? "are" : "is", "not closed."}, " "));
        }
        this.writer.close();
    }
}

