/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.print;

import com.fr.report.PageSet;
import com.fr.report.ReportPage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class PrintUtils {
    private PrintUtils() {
    }

    public static void print(PageSet pageSet, boolean bl) throws PrinterException {
        PrintUtils.print(pageSet, bl, null);
    }

    public static void print(PageSet pageSet) throws PrinterException {
        ReportPage reportPage;
        int n;
        PrintService printService = null;
        if (printService == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        try {
            printerJob.setPrintService(printService);
        }
        catch (PrinterException printerException) {
            System.out.println(printerException);
        }
        Book book = new Book();
        PageFormat pageFormat = printerJob.defaultPage();
        PageFormat pageFormat2 = null;
        for (n = 0; n < pageSet.size() && (reportPage = pageSet.getPage(n)) != null; ++n) {
            pageFormat2 = reportPage.getPageFormat(pageFormat);
            book.append(reportPage, pageFormat2);
        }
        printerJob.setPageable(book);
        n = printerJob.printDialog() ? 1 : 0;
        if (n == 0) {
            return;
        }
        try {
            printerJob.print();
        }
        catch (PrinterException printerException) {
            System.out.println(printerException);
        }
    }

    public static void print(PageSet pageSet, boolean bl, String string) throws PrinterException {
        PrintUtils.print(pageSet, bl, string, 0);
    }

    public static void print(PageSet pageSet, boolean bl, String string, int n) throws PrinterException {
        ReportPage reportPage;
        int n2;
        Object object;
        Object object2 = null;
        if (string != null) {
            object = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null);
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (!string.equals(object[i].getName())) continue;
                object2 = object[i];
                break;
            }
        }
        if (object2 == null) {
            object2 = PrintServiceLookup.lookupDefaultPrintService();
        }
        object = PrinterJob.getPrinterJob();
        if (object2 != null) {
            ((PrinterJob)object).setPrintService((PrintService)object2);
        }
        PageFormat pageFormat = ((PrinterJob)object).defaultPage();
        PageFormat pageFormat2 = null;
        Book book = new Book();
        int n3 = 0;
        for (n2 = 0; n2 < pageSet.size() && (reportPage = pageSet.getPage(n2)) != null; ++n2) {
            if (n3 < n) {
                ++n3;
                continue;
            }
            pageFormat2 = reportPage.getPageFormat(pageFormat);
            pageFormat2 = ((PrinterJob)object).validatePage(pageFormat2);
            book.append(reportPage, pageFormat2);
        }
        ((PrinterJob)object).setPageable(book);
        if ((bl || string == null) && (n2 = (int)(((PrinterJob)object).printDialog() ? 1 : 0)) == 0) {
            return;
        }
        ((PrinterJob)object).print();
    }

    public static String[] getSystemPrinterNameArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, new HashPrintRequestAttributeSet());
        for (int i = 0; i < printServiceArray.length; ++i) {
            arrayList.add(printServiceArray[i].getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

