/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.xml;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.Inter;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.GradientBackground;
import com.fr.base.background.ImageBackground;
import com.fr.base.background.IntervalColorBackground;
import com.fr.base.background.PatternBackground;
import com.fr.base.background.TextureBackground;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.GraphHelper;
import com.fr.base.xml.XMLEncodeUtils;
import com.fr.base.xml.XMLFileReader;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.marker.AllEqualMarker;
import com.fr.chart.marker.AntiClockLineMarker;
import com.fr.chart.marker.CircleFilledMarker;
import com.fr.chart.marker.CircleMarker;
import com.fr.chart.marker.ClockLineMarker;
import com.fr.chart.marker.CrossMarker;
import com.fr.chart.marker.DiamondFilledMarker;
import com.fr.chart.marker.DiamondMarker;
import com.fr.chart.marker.DowJonesMarker;
import com.fr.chart.marker.Marker;
import com.fr.chart.marker.MinusSignMarker;
import com.fr.chart.marker.NullMarker;
import com.fr.chart.marker.PlusSignMarker;
import com.fr.chart.marker.PointMarker;
import com.fr.chart.marker.RoundFilledMarker;
import com.fr.chart.marker.RoundMarker;
import com.fr.chart.marker.SquareFilledMarker;
import com.fr.chart.marker.SquareMarker;
import com.fr.chart.marker.StarMarker;
import com.fr.chart.marker.TriangleFilledMarker;
import com.fr.chart.marker.TriangleMarker;
import com.fr.chart.marker.XMarker;
import com.fr.util.Utils;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;

public class BaseXMLUtils {
    private static final String[][] decodeArray = new String[][]{{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"}, {"&", "<", ">", "'", "\""}};

    private BaseXMLUtils() {
    }

    public static Object readXMLFile(Reader reader, XMLFileReader xMLFileReader) throws Exception {
        XMLableReader xMLableReader = XMLableReader.createXMLableReader(reader);
        if (xMLableReader != null) {
            String string = xMLableReader.getTagName();
            if (string == null) {
                throw new Exception("Error template file.");
            }
            return xMLFileReader.readFileContent(xMLableReader);
        }
        return null;
    }

    public static Object readXMLFile(InputStream inputStream, XMLFileReader xMLFileReader) throws Exception {
        return BaseXMLUtils.readXMLFile(new InputStreamReader(inputStream, "UTF-8"), xMLFileReader);
    }

    public static void writeXMLFile(OutputStream outputStream, XMLWriter xMLWriter) {
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(outputStream);
        xMLWriter.writeXML(xMLPrintWriter);
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
    }

    public static Background readBackground(XMLableReader xMLableReader) {
        Background background = null;
        String string = xMLableReader.getAttr("name");
        if (string != null) {
            if (string.equals("NullBackground")) {
                return null;
            }
            if (string.equals("ColorBackground")) {
                background = ColorBackground.getInstance();
            } else if (string.equals("GradientBackground")) {
                background = new GradientBackground();
            } else if (string.equals("TextureBackground")) {
                background = new TextureBackground();
            } else if (string.equals("PatternBackground")) {
                background = new PatternBackground();
            } else if (string.equals("ImageBackground")) {
                background = new ImageBackground();
            } else if (string.equals("BGBackground")) {
                background = new IntervalColorBackground();
            }
        }
        if (background == null && (string = xMLableReader.getAttr("class")) != null) {
            if (string.equals("null")) {
                return null;
            }
            string = Utils.replaceAllString(string, "com.fr.report.background", "com.fr.base.background");
            try {
                background = (Background)FRCoreContext.classForName(string).newInstance();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.SEVERE, "Load class with name: " + string, exception);
            }
        }
        if (background == null) {
            return background;
        }
        if (background instanceof ColorBackground) {
            ColorBackground colorBackground = null;
            string = xMLableReader.getAttr("color");
            if (string != null) {
                colorBackground = ColorBackground.getInstance(new Color(Integer.parseInt(string), true));
            }
            background = colorBackground;
        } else if (background instanceof GradientBackground) {
            string = xMLableReader.getAttr("color1");
            if (string != null) {
                ((GradientBackground)background).setColor1(new Color(Integer.parseInt(string), true));
            }
            if ((string = xMLableReader.getAttr("color2")) != null) {
                ((GradientBackground)background).setColor2(new Color(Integer.parseInt(string), true));
            }
            if ((string = xMLableReader.getAttr("direction")) != null) {
                ((GradientBackground)background).setDirection(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("useCell")) != null) {
                ((GradientBackground)background).setUseCell(Boolean.valueOf(string));
                if (Boolean.valueOf(string).booleanValue()) {
                    return background;
                }
            }
            if ((string = xMLableReader.getAttr("begin")) != null) {
                ((GradientBackground)background).setBeginPlace(Float.parseFloat(string));
            }
            if ((string = xMLableReader.getAttr("finish")) != null) {
                ((GradientBackground)background).setFinishPlace(Float.parseFloat(string));
            }
            if ((string = xMLableReader.getAttr("cyclic")) != null) {
                ((GradientBackground)background).setCyclic(Boolean.valueOf(string));
            }
        } else if (background instanceof TextureBackground) {
            final TextureBackground textureBackground = (TextureBackground)background;
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("TexturePaint")) {
                        textureBackground.setTexturePaint(BaseXMLUtils.readTexturePaint(xMLableReader));
                    }
                }
            });
        } else if (background instanceof PatternBackground) {
            PatternBackground patternBackground = (PatternBackground)background;
            string = xMLableReader.getAttr("patternIndex");
            if (string != null) {
                patternBackground.setPatternIndex(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("foreground")) != null) {
                patternBackground.setForeground(new Color(Integer.parseInt(string), true));
            }
            if ((string = xMLableReader.getAttr("background")) != null) {
                patternBackground.setBackground(new Color(Integer.parseInt(string), true));
            }
        } else if (background instanceof ImageBackground) {
            final ImageBackground imageBackground = (ImageBackground)background;
            string = xMLableReader.getAttr("specifiedImageWidth");
            if (string != null) {
                imageBackground.setSpecifiedImageWidth(Double.parseDouble(string));
            }
            if ((string = xMLableReader.getAttr("specifiedImageHeight")) != null) {
                imageBackground.setSpecifiedImageHeight(Double.parseDouble(string));
            }
            if ((string = xMLableReader.getAttr("layout")) != null) {
                imageBackground.setLayout(Integer.parseInt(string));
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Image")) {
                        imageBackground.setImage(BaseXMLUtils.readImage(xMLableReader));
                    }
                }
            });
        }
        return background;
    }

    public static String writeXMLableAsString(XMLWriter xMLWriter) {
        StringWriter stringWriter = new StringWriter();
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(stringWriter, false);
        xMLPrintWriter.startTAG("R");
        if (xMLWriter != null) {
            xMLWriter.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
        return stringWriter.getBuffer().toString();
    }

    public static XMLReadable readStringAsXMLable(String string, XMLReadable xMLReadable) {
        try {
            XMLableReader xMLableReader = XMLableReader.createXMLableReader(string);
            xMLableReader.readXMLObject(xMLReadable);
        }
        catch (XMLStreamException xMLStreamException) {
            FRContext.getLogger().log(Level.WARNING, xMLStreamException.getMessage(), xMLStreamException);
        }
        return xMLReadable;
    }

    public static void writeColumnRow(XMLPrintWriter xMLPrintWriter, ColumnRow columnRow) {
        xMLPrintWriter.startTAG("ColumnRow").attr("column", columnRow.getColumn()).attr("row", columnRow.getRow()).end();
    }

    public static void writeBackground(XMLPrintWriter xMLPrintWriter, Background background) {
        xMLPrintWriter.startTAG("Background");
        if (background == null) {
            xMLPrintWriter.attr("name", "NullBackground").end();
            return;
        }
        if (background instanceof ColorBackground) {
            xMLPrintWriter.attr("name", "ColorBackground");
            ColorBackground colorBackground = (ColorBackground)background;
            if (colorBackground.getColor() != null) {
                xMLPrintWriter.attr("color", colorBackground.getColor().getRGB());
            }
        } else if (background instanceof GradientBackground) {
            xMLPrintWriter.attr("name", "GradientBackground");
            GradientBackground gradientBackground = (GradientBackground)background;
            if (gradientBackground.getColor1() != null) {
                xMLPrintWriter.attr("color1", gradientBackground.getColor1().getRGB());
            }
            if (gradientBackground.getColor2() != null) {
                xMLPrintWriter.attr("color2", gradientBackground.getColor2().getRGB());
            }
            xMLPrintWriter.attr("direction", gradientBackground.getDirection()).attr("useCell", gradientBackground.isUseCell()).attr("begin", gradientBackground.getBeginPlace()).attr("finish", gradientBackground.getFinishPlace()).attr("cyclic", gradientBackground.isCyclic());
        } else if (background instanceof TextureBackground) {
            xMLPrintWriter.attr("name", "TextureBackground");
            TextureBackground textureBackground = (TextureBackground)background;
            if (textureBackground.getTexturePaint() != null) {
                BaseXMLUtils.writeTexturePaint(xMLPrintWriter, textureBackground.getTexturePaint());
            }
        } else if (background instanceof PatternBackground) {
            xMLPrintWriter.attr("name", "PatternBackground");
            PatternBackground patternBackground = (PatternBackground)background;
            xMLPrintWriter.attr("patternIndex", patternBackground.getPatternIndex());
            if (patternBackground.getForeground() != null) {
                xMLPrintWriter.attr("foreground", patternBackground.getForeground().getRGB());
            }
            if (patternBackground.getBackground() != null) {
                xMLPrintWriter.attr("background", patternBackground.getBackground().getRGB());
            }
        } else if (background instanceof ImageBackground) {
            xMLPrintWriter.attr("name", "ImageBackground");
            ImageBackground imageBackground = (ImageBackground)background;
            xMLPrintWriter.attr("specifiedImageWidth", imageBackground.getSpecifiedImageWidth()).attr("specifiedImageHeight", imageBackground.getSpecifiedImageHeight()).attr("layout", imageBackground.getLayout());
            if (imageBackground.getImage() != null) {
                BaseXMLUtils.writeImage(xMLPrintWriter, imageBackground.getImage());
            }
        } else {
            xMLPrintWriter.attr("class", background.getClass().getName());
        }
        xMLPrintWriter.end();
    }

    public static void writeMarker(XMLPrintWriter xMLPrintWriter, Marker marker) {
        xMLPrintWriter.startTAG("Marker");
        if (marker == null) {
            xMLPrintWriter.attr("class", "null");
        } else {
            xMLPrintWriter.attr("class", marker.getClass().getName());
        }
        xMLPrintWriter.attr("size", marker.getSize());
        if (marker.getColor() != null) {
            xMLPrintWriter.attr("color", marker.getColor().getRGB());
        }
        xMLPrintWriter.end();
    }

    public static Marker readMarker(XMLableReader xMLableReader) {
        Marker marker = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.equals("null")) {
                return null;
            }
            if (string.endsWith(".AllEqualMarker")) {
                marker = new AllEqualMarker();
            } else if (string.endsWith(".AntiClockLineMarkerAnti")) {
                marker = new AntiClockLineMarker();
            } else if (string.endsWith(".CircleMarker")) {
                marker = new CircleMarker();
            } else if (string.endsWith(".CircleFilledMarker")) {
                marker = new CircleFilledMarker();
            } else if (string.endsWith(".ClockLineMarker")) {
                marker = new ClockLineMarker();
            } else if (string.endsWith(".CrossMarker")) {
                marker = new CrossMarker();
            } else if (string.endsWith(".DiamondFilledMarker")) {
                marker = new DiamondFilledMarker();
            } else if (string.endsWith(".DiamondMarker")) {
                marker = new DiamondMarker();
            } else if (string.endsWith(".DowJonesMarker")) {
                marker = new DowJonesMarker();
            } else if (string.endsWith(".MinusSignMarker")) {
                marker = new MinusSignMarker();
            } else if (string.endsWith(".NullMarker")) {
                marker = new NullMarker();
            } else if (string.endsWith(".PlusSignMarker")) {
                marker = new PlusSignMarker();
            } else if (string.endsWith(".PointMarker")) {
                marker = new PointMarker();
            } else if (string.endsWith(".RoundFilledMarker")) {
                marker = new RoundFilledMarker();
            } else if (string.endsWith(".RoundMarker")) {
                marker = new RoundMarker();
            } else if (string.endsWith(".SquareFilledMarker")) {
                marker = new SquareFilledMarker();
            } else if (string.endsWith(".SquareMarker")) {
                marker = new SquareMarker();
            } else if (string.endsWith(".StarMarker")) {
                marker = new StarMarker();
            } else if (string.endsWith(".TriangleFilledMarker")) {
                marker = new TriangleFilledMarker();
            } else if (string.endsWith(".TriangleMarker")) {
                marker = new TriangleMarker();
            } else if (string.endsWith(".XMarker")) {
                marker = new XMarker();
            }
        }
        if (marker != null) {
            string = xMLableReader.getAttr("size");
            if (string != null) {
                marker.setSize(Double.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("color")) != null) {
                marker.setColor(new Color(Integer.parseInt(string), true));
            }
        }
        return marker;
    }

    public static FRFont readFRFont(XMLableReader xMLableReader) {
        String string = "";
        int n = 0;
        int n2 = 0;
        String string2 = xMLableReader.getAttr("name");
        if (string2 != null) {
            string = string2;
        }
        if ((string2 = xMLableReader.getAttr("style")) != null) {
            n = Integer.parseInt(string2);
        }
        if ((string2 = xMLableReader.getAttr("size")) != null) {
            n2 = Integer.parseInt(string2);
        }
        FRFont fRFont = FRFont.getInstance(string, n, n2);
        string2 = xMLableReader.getAttr("foreground");
        if (string2 != null) {
            fRFont = fRFont.applyForeground(new Color(Integer.parseInt(string2), true));
        }
        if ((string2 = xMLableReader.getAttr("underline")) != null) {
            fRFont = fRFont.applyUnderline(Integer.parseInt(string2));
        }
        if ((string2 = xMLableReader.getAttr("isStrikethrough")) != null) {
            fRFont = fRFont.applyStrikethrough(Boolean.valueOf(string2));
        }
        if ((string2 = xMLableReader.getAttr("isShadow")) != null) {
            fRFont = fRFont.applyShadow(Boolean.valueOf(string2));
        }
        if ((string2 = xMLableReader.getAttr("isSuperscript")) != null) {
            fRFont = fRFont.applySuperscript(Boolean.valueOf(string2));
        }
        if ((string2 = xMLableReader.getAttr("isSubscript")) != null) {
            fRFont = fRFont.applySubscript(Boolean.valueOf(string2));
        }
        return fRFont;
    }

    public static void writeFRFont(XMLPrintWriter xMLPrintWriter, FRFont fRFont) {
        xMLPrintWriter.startTAG("FRFont").attr("name", fRFont.getName()).attr("style", fRFont.getStyle()).attr("size", fRFont.getSize());
        if (fRFont.getForeground() != null && !fRFont.getForeground().equals(Color.black)) {
            xMLPrintWriter.attr("foreground", fRFont.getForeground().getRGB());
        }
        if (fRFont.getUnderline() != 0) {
            xMLPrintWriter.attr("underline", fRFont.getUnderline());
        }
        if (fRFont.isStrikethrough()) {
            xMLPrintWriter.attr("isStrikethrough", fRFont.isStrikethrough());
        }
        if (fRFont.isShadow()) {
            xMLPrintWriter.attr("isShadow", fRFont.isShadow());
        }
        if (fRFont.isSuperscript()) {
            xMLPrintWriter.attr("isSuperscript", fRFont.isSuperscript());
        }
        if (fRFont.isSubscript()) {
            xMLPrintWriter.attr("isSubscript", fRFont.isSubscript());
        }
        xMLPrintWriter.end();
    }

    public static boolean isFRFontTagName(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("CellFont") || string.equals("ReportFont") || string.equals("FRFont");
    }

    public static void writeTexturePaint(XMLPrintWriter xMLPrintWriter, TexturePaint texturePaint) {
        xMLPrintWriter.startTAG("TexturePaint");
        Rectangle2D rectangle2D = texturePaint.getAnchorRect();
        xMLPrintWriter.startTAG("Rectangle2D").attr("x", rectangle2D.getX()).attr("y", rectangle2D.getY()).attr("width", rectangle2D.getWidth()).attr("height", rectangle2D.getHeight()).end();
        BaseXMLUtils.writeImage(xMLPrintWriter, texturePaint.getImage());
        xMLPrintWriter.end();
    }

    public static TexturePaint readTexturePaint(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(new Object[2]){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("Rectangle2D")) {
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        String string2 = xMLableReader.getAttr("x");
                        if (string2 != null) {
                            d = Double.parseDouble(string2);
                        }
                        if ((string2 = xMLableReader.getAttr("y")) != null) {
                            d2 = Double.parseDouble(string2);
                        }
                        if ((string2 = xMLableReader.getAttr("width")) != null) {
                            d3 = Double.parseDouble(string2);
                        }
                        if ((string2 = xMLableReader.getAttr("height")) != null) {
                            d4 = Double.parseDouble(string2);
                        }
                        ((Object[])this.obj)[0] = new Rectangle2D.Double(d, d2, d3, d4);
                    } else if (string.equals("Image")) {
                        ((Object[])this.obj)[1] = GraphHelper.createBufferedImageFromImage(BaseXMLUtils.readImage(xMLableReader));
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return new TexturePaint((BufferedImage)((Object[])xMLObject.getObject())[1], (Rectangle2D)((Object[])xMLObject.getObject())[0]);
    }

    public static Rectangle readRectangle(String string) {
        Rectangle rectangle = new Rectangle();
        String[] stringArray = Utils.splitString(string, ",");
        if (stringArray != null && stringArray.length == 4) {
            rectangle.x = Integer.parseInt(stringArray[0]);
            rectangle.y = Integer.parseInt(stringArray[1]);
            rectangle.width = Integer.parseInt(stringArray[2]);
            rectangle.height = Integer.parseInt(stringArray[3]);
        }
        return rectangle;
    }

    public static String getRectangleText(Rectangle rectangle) {
        return rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
    }

    public static String xmlAttrEncode(String string) {
        return BaseCoreUtils.encodeString(string, decodeArray);
    }

    public static String generateTextKey(String string) {
        try {
            int n;
            int n2;
            byte[] byArray = string.getBytes("UTF-8");
            StringBuffer stringBuffer = new StringBuffer();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            for (n2 = 2; n2 <= 5; ++n2) {
                n = byArray2[n2] & 0xFF;
                stringBuffer.append((char)(n % 25 + 65));
            }
            stringBuffer.append("-");
            for (n2 = 7; n2 <= 11; ++n2) {
                n = byArray2[n2] & 0xFF;
                if (n2 == 9) {
                    stringBuffer.append(Integer.toHexString(n % 16));
                    continue;
                }
                stringBuffer.append(n % 10);
            }
            stringBuffer.append("-");
            n = byArray2[15] & 0xFF;
            stringBuffer.append((char)(n % 25 + 65));
            for (n2 = 14; n2 >= 12; --n2) {
                n = byArray2[n2] & 0xFF;
                stringBuffer.append(n % 10);
            }
            for (n2 = 6; n2 >= 3; --n2) {
                n = byArray2[n2] & 0xFF;
                stringBuffer.append(Integer.toHexString(n % 16));
            }
            stringBuffer.append("-");
            for (n2 = 4; n2 >= 1; --n2) {
                n = byArray2[n2] & 0xFF;
                stringBuffer.append(n % 10);
            }
            return stringBuffer.toString().toUpperCase();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static void writeImage(XMLPrintWriter xMLPrintWriter, Image image) {
        if (image == null) {
            return;
        }
        GraphHelper.waitForImage(image);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        xMLPrintWriter.startTAG("Image").attr("width", n).attr("height", n2);
        BaseXMLUtils.writeByteArray(xMLPrintWriter, BaseXMLUtils.image2Bytes(image));
        xMLPrintWriter.end();
    }

    public static byte[] image2Bytes(Image image) {
        int[] nArray = Utils.grabImagePixelsArray(image, image.getWidth(null), image.getHeight(null));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            byteArrayOutputStream.write((byte)((n & 0xFF0000) >> 16));
            byteArrayOutputStream.write((byte)((n & 0xFF00) >> 8));
            byteArrayOutputStream.write((byte)(n & 0xFF));
            byteArrayOutputStream.write((byte)((n & 0xFF000000) >> 24));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Image readImage(XMLableReader xMLableReader) {
        byte[] byArray;
        int n = 0;
        int n2 = 0;
        String string = xMLableReader.getAttr("width");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        if ((string = xMLableReader.getAttr("height")) != null) {
            n2 = Integer.parseInt(string);
        }
        if (n * n2 * 4 != (byArray = BaseXMLUtils.readByteArray(xMLableReader)).length) {
            throw new RuntimeException(BaseCoreUtils.join(new String[]{Inter.getLocText("EX-Image_stored_is_broken"), ":", String.valueOf(n), "*", String.valueOf(n2), "*4=", String.valueOf(n * n2 * 4), "!=", String.valueOf(byArray.length)}));
        }
        int[] nArray = new int[n * n2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = byArray[n3++] & 0xFF;
                int n6 = byArray[n3++] & 0xFF;
                int n7 = byArray[n3++] & 0xFF;
                int n8 = byArray[n3++] & 0xFF;
                nArray[n4++] = n8 << 24 | n5 << 16 | n6 << 8 | n7;
            }
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    public static byte[] encodeImage(Image image) {
        GraphHelper.waitForImage(image);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = Utils.grabImagePixelsArray(image, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            byteArrayOutputStream.write((byte)((n3 & 0xFF0000) >> 16));
            byteArrayOutputStream.write((byte)((n3 & 0xFF00) >> 8));
            byteArrayOutputStream.write((byte)(n3 & 0xFF));
            byteArrayOutputStream.write((byte)((n3 & 0xFF000000) >> 24));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Image decodeImage(int n, int n2, byte[] byArray) {
        int[] nArray = new int[n * n2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = byArray[n3++] & 0xFF;
                int n6 = byArray[n3++] & 0xFF;
                int n7 = byArray[n3++] & 0xFF;
                int n8 = byArray[n3++] & 0xFF;
                nArray[n4++] = n8 << 24 | n5 << 16 | n6 << 8 | n7;
            }
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    public static void writeByteArray(XMLPrintWriter xMLPrintWriter, byte[] byArray) {
        xMLPrintWriter.textNode(XMLEncodeUtils.encodeBytesAsString(byArray));
    }

    public static byte[] readByteArray(XMLableReader xMLableReader) {
        return XMLEncodeUtils.decodeStringAsBytes(xMLableReader.getElementValue());
    }
}

