/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.xml;

import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLEncodeUtils;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedList;

public class XMLPrintWriter {
    public static final String XML_ENCODER = "UTF-8";
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String NEW_LINE = "\n";
    private boolean rootPrinted;
    private LinkedList tagChain = new LinkedList();
    private boolean isLastTagOpened = false;
    private PrintWriter writer;
    private boolean debug = false;
    private boolean wellFormatted = true;

    public static XMLPrintWriter create(OutputStream outputStream) {
        return XMLPrintWriter.create(outputStream, true);
    }

    public static XMLPrintWriter create(OutputStream outputStream, boolean bl) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, XML_ENCODER));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        }
        return XMLPrintWriter.create(printWriter, bl);
    }

    public static XMLPrintWriter create(Writer writer) {
        return XMLPrintWriter.create(writer, true);
    }

    public static XMLPrintWriter create(Writer writer, boolean bl) {
        return XMLPrintWriter.create(new PrintWriter(writer), bl);
    }

    public static XMLPrintWriter create(PrintWriter printWriter) {
        return XMLPrintWriter.create(printWriter, true);
    }

    public static XMLPrintWriter create(PrintWriter printWriter, boolean bl) {
        return new XMLPrintWriter(printWriter, bl);
    }

    private XMLPrintWriter(PrintWriter printWriter, boolean bl) {
        this.writer = printWriter;
        this.wellFormatted = bl;
    }

    private void export(String string) {
        this.writer.print(string);
        if (this.debug) {
            FRContext.getLogger().info(string);
        }
    }

    public XMLPrintWriter startTAG(String string) {
        if (!this.rootPrinted) {
            return this.startRoot(string);
        }
        this.closeLastTagOfChain();
        this.export("<" + string);
        this.tagChain.add(string);
        this.isLastTagOpened = true;
        return this;
    }

    private XMLPrintWriter startRoot(String string) {
        this.export(XML_HEADER);
        if (this.wellFormatted) {
            this.export(NEW_LINE);
        }
        this.rootPrinted = true;
        this.startTAG(string).attr("xmlVersion", 20100901L);
        return this;
    }

    public XMLPrintWriter textNode(String string) {
        this.closeLastTagOfChain();
        this.export(BaseCoreUtils.join(new String[]{"<![CDATA[", XMLEncodeUtils.cdataEncode(string), "]]>"}));
        return this;
    }

    private void closeLastTagOfChain() {
        if (this.isLastTagOpened) {
            this.export(">");
            if (this.wellFormatted) {
                this.export(NEW_LINE);
            }
            this.isLastTagOpened = false;
        }
    }

    public XMLPrintWriter attr(String string, long l) {
        return this.attr(string, String.valueOf(l));
    }

    public XMLPrintWriter attr(String string, boolean bl) {
        return this.attr(string, String.valueOf(bl));
    }

    public XMLPrintWriter attr(String string, int n) {
        return this.attr(string, String.valueOf(n));
    }

    public XMLPrintWriter attr(String string, double d) {
        return this.attr(string, String.valueOf(d));
    }

    public XMLPrintWriter attr(String string, String string2) {
        if (string2 == null) {
            return this;
        }
        this.export(BaseCoreUtils.join(new String[]{" ", string, "=\"", BaseXMLUtils.xmlAttrEncode(string2), "\""}));
        return this;
    }

    public XMLPrintWriter end() {
        String string = (String)this.tagChain.removeLast();
        if (this.isLastTagOpened) {
            this.export("/>");
            if (this.wellFormatted) {
                this.export(NEW_LINE);
            }
        } else {
            this.export("</" + string + ">");
            if (this.wellFormatted) {
                this.export(NEW_LINE);
            }
        }
        this.isLastTagOpened = false;
        return this;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        if (this.tagChain.size() > 0) {
            Object[] objectArray = this.tagChain.toArray(new String[this.tagChain.size()]);
            throw new RuntimeException(BaseCoreUtils.join(new String[]{BaseCoreUtils.join(objectArray, ","), objectArray.length > 1 ? "are" : "is", "not closed."}, " "));
        }
        this.writer.close();
    }
}

