/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.xml;

import com.fr.base.xml.BaseXMLUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class XMLWriterHelper {
    public static XmlStartTag startTag(String string) {
        return new XmlStartTag(string);
    }

    public static XmlStartTag completeTagWithNoChildNode(String string) {
        return new XmlStartTag(string, true);
    }

    public static void startTagWithNoAttribute(PrintWriter printWriter, String string) {
        printWriter.print("<" + string + ">");
    }

    public static void endTag(PrintWriter printWriter, String string) {
        printWriter.print("</" + string + ">");
    }

    public static class XmlStartTag {
        private String tagName;
        private Map attributes;
        private boolean withNoChildNode = false;

        private XmlStartTag(String string) {
            this.tagName = string;
        }

        private XmlStartTag(String string, boolean bl) {
            this(string);
            this.withNoChildNode = bl;
        }

        public XmlStartTag attr(String string, String string2) {
            if (string2 == null) {
                return this;
            }
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(string, string2);
            return this;
        }

        public XmlStartTag attr(String string, String string2, String string3) {
            if (string2 == null || string2.equals(string3)) {
                return this;
            }
            return this.attr(string, string2);
        }

        public XmlStartTag attr(String string, boolean bl) {
            return this.attr(string, Boolean.toString(bl));
        }

        public XmlStartTag attr(String string, boolean bl, boolean bl2) {
            if (bl == bl2) {
                return this;
            }
            return this.attr(string, bl);
        }

        public XmlStartTag attr(String string, byte by) {
            return this.attr(string, Byte.toString(by));
        }

        public XmlStartTag attr(String string, byte by, byte by2) {
            if (by == by2) {
                return this;
            }
            return this.attr(string, by);
        }

        public XmlStartTag attr(String string, int n) {
            return this.attr(string, Integer.toString(n));
        }

        public XmlStartTag attr(String string, int n, int n2) {
            if (n == n2) {
                return this;
            }
            return this.attr(string, n);
        }

        public XmlStartTag attr(String string, double d) {
            return this.attr(string, Double.toString(d));
        }

        public XmlStartTag attr(String string, double d, double d2) {
            if (d == d2) {
                return this;
            }
            return this.attr(string, d);
        }

        public void write(PrintWriter printWriter) {
            printWriter.write("<" + this.tagName);
            printWriter.write(this.attributeBuffer().toString());
            if (this.withNoChildNode) {
                printWriter.write("/>");
            } else {
                printWriter.write(">");
            }
        }

        private StringBuffer attributeBuffer() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.attributes != null) {
                Iterator iterator = this.attributes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    stringBuffer.append(" ").append(entry.getKey()).append("=\"").append(BaseXMLUtils.xmlAttrEncode(entry.getValue().toString())).append("\"");
                }
            }
            return stringBuffer;
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            this.write(new PrintWriter(stringWriter));
            return stringWriter.getBuffer().toString();
        }
    }
}

