/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.xml;

import com.fr.base.xml.XMLEncodeUtils;
import com.fr.base.xml.XMLReadable;
import com.fr.report.io.xml.SynchronizedVersion;
import com.sun.xml.stream.ZephyrParserFactory;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLableReader {
    private static final int NULL_STATE = -1;
    private static final int ATTRIBUTE = 0;
    private static final int CHILD_NODE = 1;
    private static final int CHARACTERS = 2;
    private XMLEventReader xmlEventReader;
    private StartElement startElement;
    private XMLEvent currentEvent;
    private int deep = 0;
    private int state = -1;

    public static XMLableReader createXMLableReader(String string) throws XMLStreamException {
        return XMLableReader.createXMLableReader(new StringReader(string));
    }

    public static XMLableReader createXMLableReader(Reader reader) throws XMLStreamException {
        ZephyrParserFactory zephyrParserFactory = new ZephyrParserFactory();
        if (zephyrParserFactory.isPropertySupported("report-cdata-event")) {
            zephyrParserFactory.setProperty("report-cdata-event", Boolean.TRUE);
        } else if (zephyrParserFactory.isPropertySupported("http://java.sun.com/xml/stream/properties/report-cdata-event")) {
            zephyrParserFactory.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", Boolean.TRUE);
        }
        XMLEventReader xMLEventReader = zephyrParserFactory.createXMLEventReader(reader);
        XMLableReader xMLableReader = new XMLableReader(xMLEventReader);
        if (xMLableReader.initRootElement() == null) {
            return null;
        }
        String string = xMLableReader.getAttr("xmlVersion");
        if (string != null) {
            SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
            synchronizedVersion.setXmlVersionByString(string);
        }
        return xMLableReader;
    }

    private XMLableReader(XMLEventReader xMLEventReader) {
        this.xmlEventReader = xMLEventReader;
    }

    private StartElement initRootElement() {
        block3: {
            try {
                while (this.xmlEventReader.hasNext()) {
                    this.currentEvent = this.xmlEventReader.nextEvent();
                    if (!this.currentEvent.isStartElement()) continue;
                    ++this.deep;
                    this.startElement = this.currentEvent.asStartElement();
                    break;
                }
            }
            catch (XMLStreamException xMLStreamException) {
                if (this.startElement == null) break block3;
                xMLStreamException.printStackTrace();
            }
        }
        return this.startElement;
    }

    public XMLableReader(XMLEventReader xMLEventReader, StartElement startElement) {
        this.xmlEventReader = xMLEventReader;
        this.startElement = startElement;
        this.currentEvent = this.startElement;
    }

    public void setXMLEventReader(XMLEventReader xMLEventReader) {
        this.xmlEventReader = xMLEventReader;
    }

    public XMLEventReader getXMLEventReader() {
        return this.xmlEventReader;
    }

    public String getTagName() {
        if (this.startElement == null) {
            return null;
        }
        return this.startElement.getName().toString();
    }

    protected static String cdataDecode(String string) {
        if (SynchronizedVersion.isAfterCPT_XML_Version()) {
            return XMLEncodeUtils.cdataDecode(string);
        }
        return XMLEncodeUtils.deprecatedCDATADecode(string);
    }

    public String getElementValue() {
        if (!this.currentEvent.isStartElement()) {
            throw new IllegalStateException("current state must be StartElement");
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.currentEvent = this.xmlEventReader.nextEvent();
            int n = this.currentEvent.getEventType();
            while (n != 2) {
                if (this.currentEvent.isCharacters() && this.currentEvent.asCharacters().isCData()) {
                    stringBuffer.append(XMLableReader.cdataDecode(this.currentEvent.asCharacters().getData()));
                } else if (n == 12 || n == 4 || n == 6 || n == 9) {
                    String string = this.currentEvent.asCharacters().getData();
                    if (!string.matches("\\s+")) {
                        stringBuffer.append(string.trim());
                    }
                } else if (n != 3 && n != 5) {
                    if (n == 8) {
                        throw new XMLStreamException("unexpected end of document when reading element text content");
                    }
                    if (n == 1) {
                        throw new XMLStreamException("elementGetText() function expects text only elment but START_ELEMENT was encountered.", this.currentEvent.getLocation());
                    }
                    throw new XMLStreamException("Unexpected event type " + n, this.currentEvent.getLocation());
                }
                this.currentEvent = this.xmlEventReader.nextEvent();
                n = this.currentEvent.getEventType();
            }
            --this.deep;
            if (stringBuffer.length() == 0) {
                return null;
            }
            return stringBuffer.toString();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            return null;
        }
    }

    public boolean isAttr() {
        return this.state == 0;
    }

    public boolean isCharacters() {
        return this.state == 2;
    }

    public boolean isChildNode() {
        return this.state == 1;
    }

    public String getAttr(String string) {
        if (this.startElement == null) {
            throw new IllegalStateException("StartElement should not be null...");
        }
        Attribute attribute = this.startElement.getAttributeByName(QName.valueOf(string));
        return attribute == null ? null : attribute.getValue();
    }

    public String getContent() {
        if (this.state != 2) {
            throw new IllegalStateException("Current State should be Characters...");
        }
        return this.currentEvent.asCharacters().getData();
    }

    public Object readXMLObject(XMLReadable xMLReadable) {
        if (xMLReadable == null) {
            throw new NullPointerException();
        }
        int n = this.deep;
        this.state = 0;
        xMLReadable.readXML(this);
        this.state = -1;
        if (this.deep < n) {
            return xMLReadable;
        }
        try {
            while (this.xmlEventReader.hasNext()) {
                this.currentEvent = this.xmlEventReader.nextEvent();
                if (this.currentEvent.isStartElement()) {
                    ++this.deep;
                    this.startElement = this.currentEvent.asStartElement();
                    this.state = 1;
                    xMLReadable.readXML(this);
                    this.state = -1;
                    continue;
                }
                if (this.currentEvent.isEndElement()) {
                    if (this.deep <= n) {
                        --this.deep;
                        break;
                    }
                    --this.deep;
                    continue;
                }
                if (!this.currentEvent.isCharacters() || !this.currentEvent.asCharacters().isCData() && this.currentEvent.asCharacters().getData().equals("\n")) continue;
                this.state = 2;
                xMLReadable.readXML(this);
                this.state = -1;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException);
        }
        return xMLReadable;
    }

    public void close() throws XMLStreamException {
        this.xmlEventReader.close();
    }
}

