/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.cell.BaseGridComponent;
import com.fr.cell.GridKeyAction;
import com.fr.cell.GridKeyListener;
import com.fr.cell.GridMouseAdapter;
import com.fr.cell.GridSelection;
import com.fr.cell.GridUI;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GridUtils;
import com.fr.cell.editor.CellEditor;
import com.fr.cell.editor.FloatEditor;
import com.fr.cell.editor.GeneralCellEditor;
import com.fr.cell.editor.GeneralFloatEditor;
import com.fr.cell.event.CellEditorEvent;
import com.fr.cell.event.CellEditorListener;
import com.fr.cell.event.FloatEditorEvent;
import com.fr.cell.event.FloatEditorListener;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.FloatElement;
import com.fr.report.Report;
import com.fr.report.ReportSettings;
import com.fr.report.TemplateReport;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.CellImage;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Grid
extends BaseGridComponent {
    private boolean showGridLine = true;
    private Color gridLineColor = Color.lightGray;
    private boolean isShowPaginateLine = true;
    private Color paginationLineColor = Color.RED;
    private boolean isShowVerticalFrozenLine = true;
    private Color verticalFrozenLineColor = Color.black;
    private boolean isShowHorizontalFrozenLine = true;
    private Color horizontalFrozenLineColor = Color.black;
    private Color selectedBackground = new Color(150, 150, 255);
    private Color selectedBorderLineColor = Color.black;
    private boolean editable = true;
    private boolean cellSelectable = true;
    private boolean supportCellEditorDef = false;
    private boolean cellDragable = true;
    private boolean isDragPermited = false;
    private boolean isDataChanged = false;
    private FloatElement drawingFloatElement = null;
    private int dragType = GridUtils.DRAG_NONE;
    private Rectangle dragRectangle = null;
    private Point tooltipLocation = new Point();
    private int tabMoveDirection = 0;
    private int enterMoveDirection = 0;
    protected transient Component editorComponent;
    protected transient Point2D editorComponentLoc;
    protected transient CellElement editingCellElement;
    protected transient CellEditor cellEditor;
    protected transient FloatEditor floatEditor;
    protected transient int editingColumn;
    protected transient int editingRow;
    protected transient Hashtable defaultCellEditorsByClass;
    protected transient Hashtable defaultFloatEditorsByClass;
    private int verticalValue = 0;
    private int verticalExtent = 30;
    private int horizontalValue = 0;
    private int horizontalExtent = 20;
    private int verticalBeginValue = 0;
    private int horizontalBeginValue = 0;
    private CellEditorListener innerCellEditorListener = new CellEditorListener(){

        public void editingStopped(CellEditorEvent cellEditorEvent) {
            Grid.this.stopCellEditingInner(false);
        }

        public void editingCanceled(CellEditorEvent cellEditorEvent) {
            Grid.this.cancelEditing();
        }
    };
    private FloatEditorListener innerFloatEditorListener = new FloatEditorListener(){

        public void editingStopped(FloatEditorEvent floatEditorEvent) {
            Grid.this.stopFloatEditingInner(false);
        }

        public void editingCanceled(FloatEditorEvent floatEditorEvent) {
            Grid.this.cancelEditing();
        }
    };
    static /* synthetic */ Class class$java$lang$Object;

    public Grid() {
        this.enableEvents(56L);
        GridKeyAction.initGridInputActionMap(this);
        GridMouseAdapter gridMouseAdapter = new GridMouseAdapter(this);
        this.addMouseListener(gridMouseAdapter);
        this.addMouseMotionListener(gridMouseAdapter);
        this.addMouseWheelListener(gridMouseAdapter);
        this.addKeyListener(new GridKeyListener(this));
        this.setFocusTraversalKeysEnabled(false);
        this.setOpaque(false);
        this.setUI(new GridUI());
    }

    public boolean isShowGridLine() {
        return this.showGridLine;
    }

    public void setShowGridLine(boolean bl) {
        boolean bl2 = this.showGridLine;
        this.showGridLine = bl;
        this.firePropertyChange("showGridLine", bl2, this.isShowGridLine());
        this.getReportPane().repaint();
    }

    public Color getGridLineColor() {
        return this.gridLineColor;
    }

    public void setGridLineColor(Color color) {
        Color color2 = this.gridLineColor;
        this.gridLineColor = color;
        this.firePropertyChange("girdLineColor", color2, this.gridLineColor);
        this.getReportPane().repaint();
    }

    public boolean isShowPaginateLine() {
        return this.isShowPaginateLine;
    }

    public void setShowPaginateLine(boolean bl) {
        boolean bl2 = this.isShowPaginateLine;
        this.isShowPaginateLine = bl;
        this.firePropertyChange("isShowPaginateLine", bl2, this.isShowPaginateLine);
        this.getReportPane().repaint();
    }

    public Color getPaginationLineColor() {
        return this.paginationLineColor;
    }

    public void setPaginationLineColor(Color color) {
        Color color2 = this.paginationLineColor;
        this.paginationLineColor = color;
        this.firePropertyChange("paginationLineColor", color2, this.paginationLineColor);
        this.getReportPane().repaint();
    }

    public boolean isShowVerticalFrozenLine() {
        return this.isShowVerticalFrozenLine;
    }

    public void setShowVerticalFrozenLine(boolean bl) {
        boolean bl2 = this.isShowVerticalFrozenLine;
        this.isShowVerticalFrozenLine = bl;
        this.firePropertyChange("isShowVerticalFrozenLine", bl2, this.isShowVerticalFrozenLine);
        this.getReportPane().repaint();
    }

    public Color getVerticalFrozenLineColor() {
        return this.verticalFrozenLineColor;
    }

    public void setVerticalFrozenLineColor(Color color) {
        Color color2 = this.verticalFrozenLineColor;
        this.verticalFrozenLineColor = color;
        this.firePropertyChange("verticalFrozenLineColor", color2, this.verticalFrozenLineColor);
        this.getReportPane().repaint();
    }

    public boolean isShowHorizontalFrozenLine() {
        return this.isShowHorizontalFrozenLine;
    }

    public void setShowHorizontalFrozenLine(boolean bl) {
        boolean bl2 = this.isShowHorizontalFrozenLine;
        this.isShowHorizontalFrozenLine = bl;
        this.firePropertyChange("isShowHorizontalFrozenLine", bl2, this.isShowHorizontalFrozenLine);
        this.getReportPane().repaint();
    }

    public Color getHorizontalFrozenLineColor() {
        return this.horizontalFrozenLineColor;
    }

    public void setHorizontalFrozenLineColor(Color color) {
        Color color2 = this.horizontalFrozenLineColor;
        this.horizontalFrozenLineColor = color;
        this.firePropertyChange("horizontalFrozenLineColor", color2, this.horizontalFrozenLineColor);
        this.getReportPane().repaint();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        Color color2 = this.selectedBackground;
        this.selectedBackground = color;
        this.firePropertyChange("selectedBackground", color2, this.selectedBackground);
        this.getReportPane().repaint();
    }

    public Color getSelectedBorderLineColor() {
        return this.selectedBorderLineColor;
    }

    public void setSelectedBorderLineColor(Color color) {
        Color color2 = this.selectedBorderLineColor;
        this.selectedBorderLineColor = color;
        this.firePropertyChange("selectedBorderLineColor", color2, this.selectedBorderLineColor);
        this.getReportPane().repaint();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isSupportCellEditorDef() {
        return this.supportCellEditorDef;
    }

    public void setSupportCellEditorDef(boolean bl) {
        this.supportCellEditorDef = bl;
    }

    public boolean isCellDragable() {
        return this.cellDragable;
    }

    public void setCellDragable(boolean bl) {
        this.cellDragable = bl;
    }

    public FloatElement getDrawingFloatElement() {
        return this.drawingFloatElement;
    }

    public void setDrawingFloatElement(FloatElement floatElement) {
        this.drawingFloatElement = floatElement;
    }

    public int getVerticalValue() {
        return this.verticalValue;
    }

    public void setVerticalValue(int n) {
        this.verticalValue = n;
    }

    public int getVerticalExtent() {
        return this.verticalExtent;
    }

    public void setVerticalExtent(int n) {
        this.verticalExtent = n;
    }

    public int getVerticalBeginValue() {
        return this.verticalBeginValue;
    }

    public void setVerticalBeinValue(int n) {
        this.verticalBeginValue = n;
    }

    public boolean isDragPermited() {
        return this.isDragPermited;
    }

    public void setDragPermited(boolean bl) {
        this.isDragPermited = bl;
    }

    public int getHorizontalExtent() {
        return this.horizontalExtent;
    }

    public void setHorizontalExtent(int n) {
        this.horizontalExtent = n;
    }

    public int getHorizontalValue() {
        return this.horizontalValue;
    }

    public void setHorizontalValue(int n) {
        this.horizontalValue = n;
    }

    public int getHorizontalBeginValue() {
        return this.horizontalBeginValue;
    }

    public void setHorizontalBeginValue(int n) {
        this.horizontalBeginValue = n;
    }

    public boolean isEditing() {
        return this.editorComponent != null;
    }

    public boolean isCellEditing() {
        return this.isEditing() && this.cellEditor != null;
    }

    public boolean isFloatEditing() {
        return this.isEditing() && this.floatEditor != null;
    }

    public CellEditor getCellEditor(int n, int n2) {
        Class clazz;
        ReportPane reportPane = this.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        CellElement cellElement = templateReport.getCellElement(n, n2);
        Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = Grid.class$("java.lang.Object")) : class$java$lang$Object;
        if (cellElement != null && cellElement.getValue() != null) {
            clazz = cellElement.getValue().getClass();
        }
        return this.getDefaultCellEditor(clazz);
    }

    public Component getEditorComponent() {
        return this.editorComponent;
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void setEditingColumn(int n) {
        this.editingColumn = n;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void setEditingRow(int n) {
        this.editingRow = n;
    }

    public CellEditor getCellEditor() {
        return this.cellEditor;
    }

    public FloatEditor getFloatEditor() {
        return this.floatEditor;
    }

    public void setCellEditor(CellEditor cellEditor) {
        CellEditor cellEditor2 = this.cellEditor;
        this.cellEditor = cellEditor;
        this.firePropertyChange("CellEditor", cellEditor2, this.cellEditor);
    }

    public void setFloatEditor(FloatEditor floatEditor) {
        FloatEditor floatEditor2 = this.floatEditor;
        this.floatEditor = floatEditor;
        this.firePropertyChange("FloatEditor", floatEditor2, this.floatEditor);
    }

    public CellEditor getDefaultCellEditor() {
        return this.getDefaultCellEditor(class$java$lang$Object == null ? (class$java$lang$Object = Grid.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public FloatEditor getDefaultFloatEditor() {
        return this.getDefaultFloatEditor(class$java$lang$Object == null ? (class$java$lang$Object = Grid.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public void setDefaultCellEditor(CellEditor cellEditor) {
        this.setDefaultCellEditor(class$java$lang$Object == null ? (class$java$lang$Object = Grid.class$("java.lang.Object")) : class$java$lang$Object, cellEditor);
    }

    public void setDefaultFloatEditor(FloatEditor floatEditor) {
        this.setDefaultFloatEditor(class$java$lang$Object == null ? (class$java$lang$Object = Grid.class$("java.lang.Object")) : class$java$lang$Object, floatEditor);
    }

    public CellEditor getDefaultCellEditor(Class clazz) {
        Object v;
        if (clazz == null) {
            Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = Grid.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if ((v = this.prepareDefaultCellEditorsByClass().get(clazz)) != null) {
            return (CellEditor)v;
        }
        return this.getDefaultCellEditor(clazz.getSuperclass());
    }

    public FloatEditor getDefaultFloatEditor(Class clazz) {
        Object v;
        if (clazz == null) {
            Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = Grid.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if ((v = this.prepareDefaultFloatEditorsByClass().get(clazz)) != null) {
            return (FloatEditor)v;
        }
        return this.getDefaultFloatEditor(clazz.getSuperclass());
    }

    public void setDefaultCellEditor(Class clazz, CellEditor cellEditor) {
        if (cellEditor != null) {
            this.prepareDefaultCellEditorsByClass().put(clazz, cellEditor);
        } else {
            this.prepareDefaultCellEditorsByClass().remove(clazz);
        }
    }

    public void setDefaultFloatEditor(Class clazz, FloatEditor floatEditor) {
        if (floatEditor != null) {
            this.prepareDefaultFloatEditorsByClass().put(clazz, floatEditor);
        } else {
            this.prepareDefaultFloatEditorsByClass().remove(clazz);
        }
    }

    public void startEditing() {
        this.startEditing(null);
    }

    protected void startEditing(KeyEvent keyEvent) {
        ReportPane reportPane = this.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            FloatElement floatElement = templateReport.getFloatElement(gridSelection.getFloatName(0));
            this.stopEditing();
            Object object = floatElement.getValue();
            this.floatEditor = null;
            if (this.floatEditor == null) {
                this.floatEditor = object == null ? this.getDefaultFloatEditor() : this.getDefaultFloatEditor(object.getClass());
            }
            if (this.floatEditor == null) {
                this.editorComponent = null;
                return;
            }
            this.editorComponent = this.floatEditor.getFloatEditorComponent(this, floatElement);
            if (this.editorComponent == null) {
                this.removeEditor();
                return;
            }
            this.floatEditor.addFloatEditorListener(this.innerFloatEditorListener);
            this.setFloatEditor(this.floatEditor);
            if (this.editorComponent instanceof Window) {
                this.editorComponent.setVisible(true);
            } else {
                this.ajustEditorComponentBounds(this.getReportPane());
                this.add(this.editorComponent);
                this.validate();
                this.editorComponent.requestFocus();
                this.repaint(10L);
            }
        } else if (this.isCellSelectable()) {
            Rectangle rectangle = gridSelection.getEditRectangle();
            this.startCellEditingAt(rectangle.x, rectangle.y, keyEvent);
        }
    }

    public boolean startCellEditingAt(int n, int n2) {
        return this.startCellEditingAt_DEC(n, n2, null, null);
    }

    public boolean startCellEditingAt(int n, int n2, KeyEvent keyEvent) {
        return this.startCellEditingAt_DEC(n, n2, null, keyEvent);
    }

    public boolean startCellEditingAt_DEC(int n, int n2, Class clazz, KeyEvent keyEvent) {
        if (this.isEditing()) {
            this.stopEditing();
        }
        if (!this.isEditable()) {
            return false;
        }
        if (n2 < 0 || n < 0) {
            return false;
        }
        ReportPane reportPane = this.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        this.editingCellElement = templateReport.getCellElement(n, n2);
        this.cellEditor = clazz == null ? this.getCellEditor(n, n2) : this.getDefaultCellEditor(clazz);
        if (this.cellEditor == null) {
            this.editorComponent = null;
            return false;
        }
        if (this.editingCellElement == null) {
            this.editingCellElement = new DefaultCellElement(n, n2);
            templateReport.addCellElement(this.editingCellElement);
        }
        this.editorComponent = this.cellEditor.getCellEditorComponent(this, this.editingCellElement);
        if (this.editorComponent == null) {
            this.removeEditor();
            return false;
        }
        this.editorComponentLoc = this.cellEditor.getLocationOnCellElement();
        this.cellEditor.addCellEditorListener(this.innerCellEditorListener);
        this.setCellEditor(this.cellEditor);
        this.setEditingColumn(n);
        this.setEditingRow(n2);
        if (this.editorComponent instanceof Window) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (Grid.this.editorComponent != null) {
                        Grid.this.editorComponent.setVisible(true);
                    }
                }
            });
        } else {
            if (keyEvent != null && this.editorComponent instanceof JTextField) {
                ((JTextField)this.editorComponent).setText("");
            }
            this.editingRow = this.editingCellElement.getRow();
            this.editingColumn = this.editingCellElement.getColumn();
            this.ajustEditorComponentBounds(this.getReportPane());
            this.add(this.editorComponent);
            reportPane.ensureColumnRowVisible(n, n2);
            this.validate();
            this.repaint(10L);
            this.editorComponent.requestFocus();
        }
        return true;
    }

    public void stopEditing() {
        if (this.isCellEditing()) {
            this.stopCellEditingInner(true);
        }
        if (this.isFloatEditing()) {
            this.stopFloatEditingInner(true);
        }
    }

    private void stopFloatEditingInner(boolean bl) {
        GridSelection gridSelection;
        if (!this.isFloatEditing()) {
            return;
        }
        FloatEditor floatEditor = this.floatEditor;
        if (floatEditor == null) {
            if (this.editorComponent != null) {
                this.remove(this.editorComponent);
            }
            return;
        }
        Object object = null;
        try {
            object = floatEditor.getFloatEditorValue();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (object == null) {
            this.removeEditor();
            return;
        }
        ReportPane reportPane = this.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        FloatElement floatElement = templateReport.getFloatElement((gridSelection = reportPane.getGridSelection()).getFloatName(0));
        Object object2 = floatElement.getValue();
        if (!ComparatorUtils.equals_exactly(object2, object)) {
            floatElement.setValue(object);
            this.setDataChanged(true);
        }
        if (this.isDataChanged()) {
            this.setDataChanged(false);
            reportPane.fireReportDataChanged();
            reportPane.undoRecord();
        }
        this.removeEditor();
        if (bl && !this.hasFocus()) {
            this.requestFocus();
        }
    }

    private void stopCellEditingInner(boolean bl) {
        Object object;
        Object object2;
        if (!this.isCellEditing()) {
            return;
        }
        CellEditor cellEditor = this.cellEditor;
        if (cellEditor == null) {
            if (this.editorComponent != null) {
                this.remove(this.editorComponent);
            }
            return;
        }
        ReportPane reportPane = this.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        Object object3 = null;
        try {
            object3 = cellEditor.getCellEditorValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object3 == null) {
            this.removeEditor();
            return;
        }
        this.editingCellElement = templateReport.getCellElement(this.editingColumn, this.editingRow);
        if (this.editingCellElement == null) {
            if (object3 instanceof String) {
                if (((String)object3).length() > 0) {
                    this.editingCellElement = new DefaultCellElement(this.editingColumn, this.editingRow, object3);
                }
            } else if (object3 instanceof CellElement) {
                object2 = (CellElement)object3;
                this.editingCellElement = new DefaultCellElement(this.editingColumn, this.editingRow, object2.getValue());
                this.editingCellElement.setCellExpandAttr(object2.getCellExpandAttr());
            } else if (object3 instanceof CellImage) {
                object2 = (CellImage)object3;
                object3 = ((CellImage)object2).getImage();
                this.editingCellElement = new DefaultCellElement(this.editingColumn, this.editingRow, object3);
                if (((CellImage)object2).getStyle() != null) {
                    this.editingCellElement.setStyle(((CellImage)object2).getStyle());
                }
            } else {
                this.editingCellElement = new DefaultCellElement(this.editingColumn, this.editingRow, object3);
            }
            if (this.editingCellElement != null) {
                templateReport.addCellElement(this.editingCellElement);
                this.setDataChanged(true);
            }
        } else if (object3 instanceof CellElement) {
            object2 = (CellElement)object3;
            this.editingCellElement.setValue(object2.getValue());
            this.editingCellElement.setCellExpandAttr(object2.getCellExpandAttr());
            this.setDataChanged(true);
        } else if (object3 instanceof CellImage) {
            object2 = (CellImage)object3;
            object3 = ((CellImage)object2).getImage();
            object = this.editingCellElement.getValue();
            if (!ComparatorUtils.equals_exactly(object, object3)) {
                this.editingCellElement.setValue(object3);
                this.setDataChanged(true);
            }
            if (((CellImage)object2).getStyle() != null) {
                this.editingCellElement.setStyle(((CellImage)object2).getStyle());
            }
        } else {
            object2 = this.editingCellElement.getValue();
            if (!ComparatorUtils.equals_exactly(object2, object3)) {
                this.editingCellElement.setValue(object3);
                this.setDataChanged(true);
            }
        }
        if (this.isDataChanged()) {
            this.setDataChanged(false);
            if (this.editingCellElement != null && (object2 = this.editingCellElement.getValue()) != null && (object2 instanceof String || object2 instanceof Number)) {
                CellGUIAttr cellGUIAttr;
                object = ReportHelper.getColumnWidthList(templateReport);
                DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(templateReport);
                int n = this.editingCellElement.getColumn();
                ReportSettings reportSettings = templateReport.getReportSettings();
                if (reportSettings == null) {
                    reportSettings = new ReportSettings();
                }
                if ((cellGUIAttr = this.editingCellElement.getCellGUIAttr()) == null) {
                    cellGUIAttr = new CellGUIAttr();
                }
                if (cellGUIAttr.getAdjustMode() == 1 || cellGUIAttr.getAdjustMode() == 3 && reportSettings.getShrinkToFitMode() == 1) {
                    double d = PaintUtils.analyzeCellElementPreferredHeight(this.editingCellElement, ((DynamicValueList)object).getRangeValue(n, n + this.editingCellElement.getColumnSpan()));
                    if (this.editingCellElement.getRowSpan() == 1) {
                        dynamicValueList.set(this.editingCellElement.getRow(), (int)Math.max(d, (double)dynamicValueList.get(this.editingCellElement.getRow())));
                    } else {
                        int n2 = this.editingCellElement.getRow() + this.editingCellElement.getRowSpan() - 1;
                        double d2 = d - (double)dynamicValueList.getRangeValue(this.editingCellElement.getRow(), n2 + 1);
                        if (d2 > 0.0) {
                            for (int i = this.editingCellElement.getRow(); i <= n2; ++i) {
                                dynamicValueList.set(i, (int)((double)dynamicValueList.get(i) + d2 / (double)this.editingCellElement.getRowSpan()));
                            }
                        }
                    }
                } else if (cellGUIAttr.getAdjustMode() == 2 || cellGUIAttr.getAdjustMode() == 3 && reportSettings.getShrinkToFitMode() == 2) {
                    double d = PaintUtils.getPreferredWidth(this.editingCellElement, dynamicValueList.getRangeValue(this.editingCellElement.getRow(), this.editingCellElement.getRow() + this.editingCellElement.getRowSpan()));
                    if (this.editingCellElement.getColumnSpan() == 1) {
                        ((DynamicValueList)object).set(this.editingCellElement.getColumn(), (int)Math.max(d, (double)((DynamicValueList)object).get(this.editingCellElement.getColumn())));
                    } else {
                        int n3 = this.editingCellElement.getColumn() + this.editingCellElement.getColumnSpan() - 1;
                        double d3 = d - (double)((DynamicValueList)object).getRangeValue(this.editingCellElement.getColumn(), n3 + 1);
                        if (d3 > 0.0) {
                            for (int i = this.editingCellElement.getColumn(); i <= n3; ++i) {
                                ((DynamicValueList)object).set(i, (int)((double)((DynamicValueList)object).get(i) + d3 / (double)this.editingCellElement.getColumnSpan()) + 1);
                            }
                        }
                    }
                }
            }
            reportPane.fireReportDataChanged();
            reportPane.undoRecord();
        }
        this.removeEditor();
        if (bl && !this.hasFocus()) {
            this.requestFocus();
        }
    }

    public void cancelEditing() {
        if (this.isEditing()) {
            this.removeEditor();
            this.requestFocus();
        }
    }

    public void removeEditor() {
        if (this.isCellEditing()) {
            this.removeCellEditor();
        } else {
            FloatEditor floatEditor = this.getFloatEditor();
            if (floatEditor != null) {
                if (this.editorComponent != null) {
                    if (this.editorComponent instanceof Window) {
                        this.editorComponent.setVisible(false);
                        ((Window)this.editorComponent).dispose();
                    } else {
                        this.remove(this.editorComponent);
                        this.validate();
                    }
                }
                floatEditor.removeFloatEditorListener(this.innerFloatEditorListener);
            }
            this.setFloatEditor(null);
            this.editorComponent = null;
            this.getReportPane().repaint();
        }
    }

    public void removeCellEditor() {
        CellEditor cellEditor = this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        if (this.editorComponent != null) {
            if (this.editorComponent instanceof Window) {
                this.editorComponent.setVisible(false);
                ((Window)this.editorComponent).dispose();
            } else {
                this.remove(this.editorComponent);
                this.validate();
            }
        }
        cellEditor.removeCellEditorListener(this.innerCellEditorListener);
        this.setCellEditor(null);
        this.setEditingColumn(-1);
        this.setEditingRow(-1);
        this.editorComponent = null;
        this.editingCellElement = null;
        this.getReportPane().repaint();
    }

    private Hashtable prepareDefaultCellEditorsByClass() {
        if (this.defaultCellEditorsByClass == null) {
            this.defaultCellEditorsByClass = new Hashtable();
            this.defaultCellEditorsByClass.put(class$java$lang$Object == null ? (class$java$lang$Object = Grid.class$("java.lang.Object")) : class$java$lang$Object, new GeneralCellEditor());
        }
        return this.defaultCellEditorsByClass;
    }

    private Hashtable prepareDefaultFloatEditorsByClass() {
        if (this.defaultFloatEditorsByClass == null) {
            this.defaultFloatEditorsByClass = new Hashtable();
            this.defaultFloatEditorsByClass.put(class$java$lang$Object == null ? (class$java$lang$Object = Grid.class$("java.lang.Object")) : class$java$lang$Object, new GeneralFloatEditor());
        }
        return this.defaultFloatEditorsByClass;
    }

    public void doMousePress(double d, double d2) {
        this.dispatchEvent(new MouseEvent(this, 501, System.currentTimeMillis(), 0, (int)d, (int)d2, 1, false));
    }

    public Rectangle caculateIntersectsUnion(Report report, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        Iterator iterator = report.intersect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            Rectangle rectangle3 = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            if (!rectangle2.intersects(rectangle3) || rectangle2.contains(rectangle3)) continue;
            rectangle2 = rectangle2.union(rectangle3);
        }
        if (!rectangle2.equals(rectangle)) {
            return this.caculateIntersectsUnion(report, rectangle2);
        }
        return rectangle2;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (StringUtils.isEmpty(this.getToolTipText())) {
            return null;
        }
        return this.tooltipLocation;
    }

    public void ajustEditorComponentBounds(ReportPane reportPane) {
        double d;
        double d2;
        double d3;
        double d4;
        Cloneable cloneable;
        if (this.editorComponent == null) {
            return;
        }
        if (this.editorComponent instanceof Window) {
            return;
        }
        DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(reportPane.getEditingReport());
        DynamicValueList dynamicValueList2 = ReportHelper.getColumnWidthList(reportPane.getEditingReport());
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            cloneable = templateReport.getFloatElement(gridSelection.getFloatName(0));
            int n2 = ((FloatElement)cloneable).getColumn();
            int n3 = ((FloatElement)cloneable).getRow();
            d4 = dynamicValueList2.getRangeValue(this.horizontalBeginValue, n2);
            d4 += (double)((FloatElement)cloneable).getLeftDistance();
            d3 = dynamicValueList.getRangeValue(this.verticalBeginValue, n3);
            d3 += (double)((FloatElement)cloneable).getTopDistance();
            d2 = ((FloatElement)cloneable).getSize().getWidth();
            d = ((FloatElement)cloneable).getSize().getHeight();
        } else {
            d4 = dynamicValueList2.getRangeValue(this.horizontalBeginValue, this.editingColumn);
            d3 = dynamicValueList.getRangeValue(this.verticalBeginValue, this.editingRow);
            int n4 = 1;
            int n5 = 1;
            if (this.editingCellElement != null) {
                n4 = this.editingCellElement.getColumnSpan();
                n5 = this.editingCellElement.getRowSpan();
            }
            d2 = dynamicValueList2.getRangeValue(this.editingColumn, this.editingColumn + n4) - 1;
            d = dynamicValueList.getRangeValue(this.editingRow, this.editingRow + n5) - 1;
        }
        if (this.editorComponentLoc == null) {
            this.editorComponent.setLocation((int)(d4 + 1.0), (int)(d3 + 1.0));
        } else {
            this.editorComponent.setLocation((int)(d4 + this.editorComponentLoc.getX()), (int)(d3 + this.editorComponentLoc.getY()));
        }
        if (this.editorComponent instanceof JTextField) {
            cloneable = this.editorComponent.getPreferredSize();
            if (this.editorComponentLoc == null) {
                this.editorComponent.setSize((int)Math.max(d2, ((Dimension)cloneable).getWidth() + 1.0), (int)d);
            } else {
                this.editorComponent.setSize((int)(Math.max(d2, ((Dimension)cloneable).getWidth() + 1.0) - this.editorComponentLoc.getX()), (int)(d - this.editorComponentLoc.getY()));
            }
        } else if (this.editorComponentLoc == null) {
            this.editorComponent.setSize((int)d2, (int)d);
        } else {
            this.editorComponent.setSize((int)(d2 - this.editorComponentLoc.getX()), (int)(d - this.editorComponentLoc.getY()));
        }
    }

    public int getEnterMoveDirection() {
        return this.enterMoveDirection;
    }

    public void setEnterMoveDirection(int n) {
        this.enterMoveDirection = n;
    }

    public int getTabMoveDirection() {
        return this.tabMoveDirection;
    }

    public void setTabMoveDirection(int n) {
        this.tabMoveDirection = n;
    }

    public boolean isCellSelectable() {
        return this.cellSelectable;
    }

    public void setCellSelectable(boolean bl) {
        boolean bl2 = this.cellSelectable;
        this.cellSelectable = bl;
        this.firePropertyChange("cellSelectable", bl2, this.cellSelectable);
        this.getReportPane().repaint();
        this.cellSelectable = bl;
    }

    public void setDragType(int n) {
        this.dragType = n;
    }

    public int getDragType() {
        return this.dragType;
    }

    public void setDragRectangle(Rectangle rectangle) {
        this.dragRectangle = rectangle;
    }

    public Rectangle getDragRectangle() {
        return this.dragRectangle;
    }

    public void setDataChanged(boolean bl) {
        this.isDataChanged = bl;
    }

    public boolean isDataChanged() {
        return this.isDataChanged;
    }

    public void setTooltipLocation(double d, double d2) {
        this.tooltipLocation.setLocation(d, d2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

