/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.core.GraphHelper;
import com.fr.cell.BaseGridComponent;
import com.fr.cell.DefaultGridColumnRenderer;
import com.fr.cell.GridCRRenderer;
import com.fr.cell.GridColumnUI;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GridColumnMouseHandler;
import java.awt.Color;
import java.awt.Dimension;

public class GridColumn
extends BaseGridComponent {
    public static final int COLUMN_HEIGHT_AJUST = 4;
    private Color separatorLineColor = new Color(172, 168, 153);
    private Color selectedForeground = Color.black;
    private Color selectedBackground = new Color(253, 216, 153);
    private GridCRRenderer gridCRRender;

    public GridColumn() {
        GridColumnMouseHandler gridColumnMouseHandler = new GridColumnMouseHandler(this);
        this.addMouseListener(gridColumnMouseHandler);
        this.addMouseMotionListener(gridColumnMouseHandler);
        this.gridCRRender = new DefaultGridColumnRenderer();
        this.getInputMap().clear();
        this.getActionMap().clear();
        this.setFocusable(false);
        this.setOpaque(true);
        this.setUI(new GridColumnUI());
    }

    public GridCRRenderer getGridCRRender() {
        return this.gridCRRender;
    }

    public void setGridCRRender(GridCRRenderer gridCRRenderer) {
        this.gridCRRender = gridCRRenderer;
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public Color getForeground() {
        return super.getForeground();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public Color getSeparatorLineColor() {
        return this.separatorLineColor;
    }

    public void setSeparatorLineColor(Color color) {
        Color color2 = this.separatorLineColor;
        this.separatorLineColor = color;
        this.firePropertyChange("separatorLineColor", color2, this.separatorLineColor);
        this.repaint();
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        Color color2 = this.selectedForeground;
        this.selectedForeground = color;
        this.firePropertyChange("selectedForeground", color2, this.selectedForeground);
        this.repaint();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        Color color2 = this.selectedBackground;
        this.selectedBackground = color;
        this.firePropertyChange("selectedBackground", color2, this.selectedBackground);
        this.repaint();
    }

    public Dimension getPreferredSize() {
        ReportPane reportPane = this.getReportPane();
        if (!reportPane.isColumnHeaderVisible()) {
            return new Dimension(0, 0);
        }
        return new Dimension(super.getPreferredSize().width, GraphHelper.getFontMetrics(this.getFont()).getHeight() + 4);
    }
}

