/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.core.GraphHelper;
import com.fr.base.core.list.IntList;
import com.fr.cell.GridColumn;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GridUtils;
import com.fr.report.Margin;
import com.fr.report.PaperSize;
import com.fr.report.ReportSettings;
import com.fr.report.TemplateReport;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class GridColumnUI
extends ComponentUI {
    private Color withoutDetailsBackground = Color.lightGray;

    public void paint(Graphics graphics, JComponent jComponent) {
        if (!(jComponent instanceof GridColumn)) {
            throw new IllegalArgumentException("The component c to paint must be a GridColumn!");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        GridColumn gridColumn = (GridColumn)jComponent;
        ReportPane reportPane = gridColumn.getReportPane();
        Dimension dimension = gridColumn.getSize();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
        graphics2D.setPaint(gridColumn.getBackground());
        GraphHelper.fill(graphics2D, double_);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = gridColumn.getFont().getLineMetrics("", fontRenderContext);
        float f = lineMetrics.getAscent();
        TemplateReport templateReport = reportPane.getEditingReport();
        DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
        int n = reportPane.getGrid().getHorizontalValue();
        int n2 = reportPane.getGrid().getHorizontalBeginValue();
        n2 = n;
        reportPane.getGrid().setHorizontalBeginValue(n2);
        int n3 = reportPane.getGrid().getHorizontalExtent();
        int n4 = templateReport.getColumnCount() - 1;
        int n5 = n + n3 + 1;
        double d = dimension.getWidth();
        if (!reportPane.isColumnEndless()) {
            n5 = Math.min(n5, n4);
            d = dynamicValueList.getRangeValue(n, Math.max(0, n4 + 1));
        }
        int n6 = templateReport.getColumnCount();
        double d2 = 0.0;
        if (n6 > n2) {
            d2 = dynamicValueList.getRangeValue(n2, n6);
        }
        d2 = Math.min(d, d2);
        if (gridColumn.getBackground() != null) {
            graphics2D.setPaint(this.withoutDetailsBackground);
            GraphHelper.fill(graphics2D, new Rectangle2D.Double(0.0, 0.0, d2, dimension.getHeight()));
            graphics2D.setPaint(gridColumn.getBackground());
            GraphHelper.fill(graphics2D, new Rectangle2D.Double(d2, 0.0, dimension.getWidth() - d2, dimension.getHeight()));
        }
        graphics2D.setPaint(gridColumn.getSeparatorLineColor());
        GraphHelper.drawLine(graphics2D, 0.0, 0.0, 0.0, dimension.getHeight());
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i <= n5; ++i) {
            int n7;
            boolean bl;
            if (i == 0) {
                i = n2;
            }
            d4 = (d5 = (double)dynamicValueList.get(i)) <= 0.0 ? d3 + 1.0 : (d3 += d5) + d5;
            GridSelection gridSelection = reportPane.getGridSelection();
            IntList intList = GridUtils.getGridSelectionColumnIndex(gridSelection);
            int n8 = gridSelection.getType();
            if (n8 == 0 && intList.contain(i)) {
                graphics2D.setColor(gridColumn.getSelectedBackground());
                GraphHelper.fill(graphics2D, new Rectangle2D.Double(d3 + 1.0, 0.0, d5 - 1.0, dimension.height));
                bl = true;
            } else {
                bl = false;
            }
            graphics2D.setColor(gridColumn.getSeparatorLineColor());
            GraphHelper.drawLine(graphics2D, d4, 0.0, d4, dimension.height);
            Object object = gridColumn.getGridCRRender().getDisplay(i);
            if (object == null) {
                return;
            }
            if (object instanceof String || object instanceof Number) {
                double d6;
                String string = object.toString();
                if (templateReport.getReportPageAttr() != null) {
                    if (i >= templateReport.getReportPageAttr().getRepeatHeaderColumnFrom() && i <= templateReport.getReportPageAttr().getRepeatHeaderColumnTo()) {
                        string = string + "(HR)";
                    }
                    if (i >= templateReport.getReportPageAttr().getRepeatFooterColumnFrom() && i <= templateReport.getReportPageAttr().getRepeatFooterColumnTo()) {
                        string = string + "(FR)";
                    }
                }
                if ((d6 = gridColumn.getFont().getStringBounds(string, fontRenderContext).getWidth()) > d5) {
                    Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                    graphics2D2.setClip(new Rectangle2D.Double(0.0, d3, dimension.width, d5));
                    if (bl) {
                        graphics2D2.setPaint(gridColumn.getSelectedForeground());
                    } else if (gridColumn.isEnabled()) {
                        graphics2D2.setPaint(gridColumn.getForeground());
                    } else {
                        graphics2D.setPaint(UIManager.getColor("controlShadow"));
                    }
                    GraphHelper.drawString(graphics2D2, string, d3 + (d5 - d6) / 2.0, f + 2.0f + 1.0f);
                    graphics2D2.dispose();
                } else {
                    if (bl) {
                        graphics2D.setPaint(gridColumn.getSelectedForeground());
                    } else if (gridColumn.isEnabled()) {
                        graphics2D.setPaint(gridColumn.getForeground());
                    } else {
                        graphics2D.setPaint(UIManager.getColor("controlShadow"));
                    }
                    GraphHelper.drawString(graphics2D, string, d3 + (d5 - d6) / 2.0, f + 2.0f + 1.0f);
                }
            } else if (object instanceof Image) {
                GraphHelper.paintImage(graphics2D, (int)d5, dimension.height, (Image)object, null, 3, -1, -1);
            }
            double d7 = dynamicValueList.getRangeValue(0, i);
            double d8 = dynamicValueList.getRangeValue(0, i + 1);
            ReportSettings reportSettings = ReportUtils.getReportSettings(templateReport);
            PaperSize paperSize = reportSettings.getPaperSize();
            if (paperSize == null) {
                paperSize = PaperSize.PAPERSIZE_A4;
            }
            Margin margin = reportSettings.getMargin();
            double d9 = 0.0;
            d9 = reportSettings.getOrientation() == 1 ? (paperSize.getHeight() - margin.getLeft() - margin.getRight()) * (double)reportSettings.getResolution() : (paperSize.getWidth() - margin.getLeft() - margin.getRight()) * (double)reportSettings.getResolution();
            int n9 = (int)(d8 / d9);
            if (n9 - (n7 = (int)(d7 / d9)) != 1 || n9 == 0) continue;
            graphics2D.setPaint(gridColumn.getSeparatorLineColor());
            double d10 = (double)n9 * d9 - d7;
            GeneralPath generalPath = new GeneralPath(0, 4);
            generalPath.moveTo((float)(d10 + d3 - 4.0), 0.0f);
            generalPath.lineTo((float)(d10 + d3 + 4.0), 0.0f);
            generalPath.lineTo((float)(d10 + d3), 10.0f);
            generalPath.closePath();
            graphics2D.fill(generalPath);
        }
        graphics2D.setColor(gridColumn.getSeparatorLineColor());
        GraphHelper.drawLine(graphics2D, 0.0, 0.0, d4, 0.0);
    }
}

