/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.core.GraphHelper;
import com.fr.cell.BaseGridComponent;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GridCornerMouseHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class GridCorner
extends BaseGridComponent {
    public GridCorner() {
        this.setOpaque(true);
        GridCornerMouseHandler gridCornerMouseHandler = new GridCornerMouseHandler(this);
        this.addMouseListener(gridCornerMouseHandler);
        this.addMouseMotionListener(gridCornerMouseHandler);
        this.getInputMap().clear();
        this.getActionMap().clear();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        ReportPane reportPane = this.getReportPane();
        Dimension dimension = this.getSize();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
        if (this.getBackground() != null) {
            graphics2D.setPaint(this.getBackground());
            GraphHelper.fill(graphics2D, double_);
        } else {
            graphics2D.setPaint(reportPane.getBackground());
            GraphHelper.fill(graphics2D, double_);
        }
        graphics2D.setColor(reportPane.getGridColumn().getSeparatorLineColor());
        GraphHelper.drawLine(graphics2D, 0.0, 0.0, 0.0, dimension.getHeight());
        graphics2D.setColor(reportPane.getGridRow().getSeparatorLineColor());
        GraphHelper.drawLine(graphics2D, 0.0, 0.0, dimension.getWidth(), 0.0);
    }

    public Dimension getPreferredSize() {
        ReportPane reportPane = this.getReportPane();
        if (!reportPane.isColumnHeaderVisible() || !reportPane.isRowHeaderVisible()) {
            return new Dimension(0, 0);
        }
        return new Dimension(reportPane.getGridRow().getPreferredSize().width, reportPane.getGridColumn().getPreferredSize().height);
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }
}

