/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.cell.Grid;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GridUtils;
import com.fr.report.TemplateReport;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class GridKeyAction
extends AbstractAction {
    private Grid grid;
    private String actionKey;
    private boolean isShift;

    public GridKeyAction(Grid grid, String string, boolean bl) {
        this.grid = grid;
        this.actionKey = string;
        this.isShift = bl;
    }

    protected static void initGridInputActionMap(Grid grid) {
        InputMap inputMap = grid.getInputMap();
        ActionMap actionMap = grid.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "left");
        actionMap.put("left", new GridKeyAction(grid, "left", false));
        inputMap.put(KeyStroke.getKeyStroke(37, 1), "left_shift");
        actionMap.put("left_shift", new GridKeyAction(grid, "left", true));
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "right");
        actionMap.put("right", new GridKeyAction(grid, "right", false));
        inputMap.put(KeyStroke.getKeyStroke(39, 1), "right_shift");
        actionMap.put("right_shift", new GridKeyAction(grid, "right", true));
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "up");
        actionMap.put("up", new GridKeyAction(grid, "up", false));
        inputMap.put(KeyStroke.getKeyStroke(38, 1), "up_shift");
        actionMap.put("up_shift", new GridKeyAction(grid, "up", true));
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "down");
        actionMap.put("down", new GridKeyAction(grid, "down", false));
        inputMap.put(KeyStroke.getKeyStroke(40, 1), "down_shift");
        actionMap.put("down_shift", new GridKeyAction(grid, "down", true));
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
        actionMap.put("enter", new GridKeyAction(grid, "enter", false));
        inputMap.put(KeyStroke.getKeyStroke(10, 1), "enter_shift");
        actionMap.put("enter_shift", new GridKeyAction(grid, "enter", true));
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "tab");
        actionMap.put("tab", new GridKeyAction(grid, "tab", false));
        inputMap.put(KeyStroke.getKeyStroke(9, 1), "tab_shift");
        actionMap.put("tab_shift", new GridKeyAction(grid, "tab", true));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("left".equals(this.actionKey)) {
            this.selectionMove(2, true);
        } else if ("right".equals(this.actionKey)) {
            this.selectionMove(4, true);
        } else if ("up".equals(this.actionKey)) {
            this.selectionMove(1, true);
        } else if ("down".equals(this.actionKey)) {
            this.selectionMove(3, true);
        } else if ("enter".equals(this.actionKey)) {
            this.enterKeyPressed();
        } else if ("tab".equals(this.actionKey)) {
            this.tabKeyPressed();
        }
    }

    public void enterKeyPressed() {
        int n;
        if (this.grid.isCellEditing()) {
            this.grid.stopEditing();
        }
        if ((n = this.grid.getEnterMoveDirection()) == 0) {
            n = 3;
        }
        this.selectionMove(n, false);
    }

    public void tabKeyPressed() {
        int n;
        if (this.grid.isCellEditing()) {
            this.grid.stopEditing();
        }
        if ((n = this.grid.getTabMoveDirection()) == 0) {
            n = 4;
        }
        this.selectionMove(n, false);
    }

    private void selectionMove(int n, boolean bl) {
        ReportPane reportPane = this.grid.getReportPane();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n2 = gridSelection.getType();
        if (n2 == 1) {
            return;
        }
        if (n == 3) {
            if (this.isShift) {
                if (bl) {
                    this.unionDown(reportPane, gridSelection);
                } else {
                    this.up(reportPane, gridSelection);
                }
            } else {
                this.down(reportPane, gridSelection);
            }
        } else if (n == 4) {
            if (this.isShift) {
                if (bl) {
                    this.unionRight(reportPane, gridSelection);
                } else {
                    this.left(reportPane, gridSelection);
                }
            } else {
                this.right(reportPane, gridSelection);
            }
        } else if (n == 1) {
            if (this.isShift) {
                if (bl) {
                    this.unionUp(reportPane, gridSelection);
                } else {
                    this.down(reportPane, gridSelection);
                }
            } else {
                this.up(reportPane, gridSelection);
            }
        } else if (n == 2) {
            if (this.isShift) {
                if (bl) {
                    this.unionLeft(reportPane, gridSelection);
                } else {
                    this.right(reportPane, gridSelection);
                }
            } else {
                this.left(reportPane, gridSelection);
            }
        }
        reportPane.repaint();
        reportPane.fireGridSelectionChanged();
    }

    private void left(ReportPane reportPane, GridSelection gridSelection) {
        Rectangle rectangle = gridSelection.getEditRectangle();
        if (rectangle.x > 0) {
            int n = rectangle.x - 1;
            GridUtils.doSelectCell(reportPane, n, rectangle.y);
            reportPane.ensureColumnRowVisible(n, rectangle.y);
        }
    }

    private void right(ReportPane reportPane, GridSelection gridSelection) {
        Rectangle rectangle = gridSelection.getEditRectangle();
        int n = rectangle.x + rectangle.width;
        GridUtils.doSelectCell(reportPane, n, rectangle.y);
        reportPane.ensureColumnRowVisible(n, rectangle.y);
    }

    private void up(ReportPane reportPane, GridSelection gridSelection) {
        Rectangle rectangle = gridSelection.getEditRectangle();
        if (rectangle.y > 0) {
            int n = rectangle.y - 1;
            GridUtils.doSelectCell(reportPane, rectangle.x, n);
            reportPane.ensureColumnRowVisible(rectangle.x, n);
        }
    }

    private void down(ReportPane reportPane, GridSelection gridSelection) {
        Rectangle rectangle = gridSelection.getEditRectangle();
        int n = rectangle.y + rectangle.height;
        GridUtils.doSelectCell(reportPane, rectangle.x, n);
        reportPane.ensureColumnRowVisible(rectangle.x, n);
    }

    protected void unionLeft(ReportPane reportPane, GridSelection gridSelection) {
        Rectangle rectangle = gridSelection.getEditRectangle();
        Rectangle rectangle2 = gridSelection.getLastCellRectangle();
        TemplateReport templateReport = reportPane.getEditingReport();
        int n = rectangle.x + rectangle.width - 1;
        int n2 = rectangle2.x + rectangle2.width - 1;
        Rectangle rectangle3 = this.grid.caculateIntersectsUnion(templateReport, new Rectangle(n2, rectangle2.y, 1, rectangle2.height));
        if (n2 <= n || rectangle3.contains(rectangle)) {
            if (rectangle.x <= 0) {
                return;
            }
            Rectangle rectangle4 = this.grid.caculateIntersectsUnion(templateReport, new Rectangle(rectangle2.x - 1, rectangle2.y, rectangle2.width + 1, rectangle2.height));
            rectangle2.setBounds(rectangle4.union(rectangle2));
            reportPane.ensureColumnRowVisible(rectangle2.x, rectangle2.y);
        } else {
            rectangle2.width = rectangle3.x - rectangle2.x;
            reportPane.ensureColumnRowVisible(rectangle2.x + rectangle2.width - 1, rectangle2.y);
        }
    }

    protected void unionRight(ReportPane reportPane, GridSelection gridSelection) {
        Rectangle rectangle = gridSelection.getEditRectangle();
        Rectangle rectangle2 = gridSelection.getLastCellRectangle();
        TemplateReport templateReport = reportPane.getEditingReport();
        Rectangle rectangle3 = this.grid.caculateIntersectsUnion(templateReport, new Rectangle(rectangle2.x, rectangle2.y, 1, rectangle2.height));
        if (rectangle2.x >= rectangle.x || rectangle3.contains(rectangle)) {
            if (!reportPane.isColumnEndless() && rectangle2.x + rectangle2.width > templateReport.getColumnCount() - 1) {
                return;
            }
            Rectangle rectangle4 = this.grid.caculateIntersectsUnion(templateReport, new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width + 1, rectangle2.height));
            rectangle2.setBounds(rectangle4.union(rectangle2));
            reportPane.ensureColumnRowVisible(rectangle2.x + rectangle2.width - 1, rectangle2.y);
        } else {
            rectangle2.width = rectangle2.x + rectangle2.width - (rectangle3.x + rectangle3.width);
            rectangle2.x = rectangle3.x + rectangle3.width;
            reportPane.ensureColumnRowVisible(rectangle2.x + 1, rectangle2.y);
        }
    }

    protected void unionUp(ReportPane reportPane, GridSelection gridSelection) {
        Rectangle rectangle = gridSelection.getEditRectangle();
        Rectangle rectangle2 = gridSelection.getLastCellRectangle();
        TemplateReport templateReport = reportPane.getEditingReport();
        int n = rectangle.y + rectangle.height - 1;
        int n2 = rectangle2.y + rectangle2.height - 1;
        Rectangle rectangle3 = this.grid.caculateIntersectsUnion(templateReport, new Rectangle(rectangle2.x, n2, rectangle2.width, 1));
        if (n2 <= n || rectangle3.contains(rectangle)) {
            if (rectangle2.y <= 0) {
                return;
            }
            Rectangle rectangle4 = this.grid.caculateIntersectsUnion(templateReport, new Rectangle(rectangle2.x, rectangle2.y - 1, rectangle2.width, rectangle2.height + 1));
            rectangle2.setBounds(rectangle4.union(rectangle2));
            reportPane.ensureColumnRowVisible(rectangle2.x, rectangle2.y);
        } else {
            rectangle2.height = rectangle3.y - rectangle2.y;
            reportPane.ensureColumnRowVisible(rectangle2.x, rectangle2.y + rectangle2.height - 1);
        }
    }

    protected void unionDown(ReportPane reportPane, GridSelection gridSelection) {
        Rectangle rectangle = gridSelection.getEditRectangle();
        Rectangle rectangle2 = gridSelection.getLastCellRectangle();
        TemplateReport templateReport = reportPane.getEditingReport();
        Rectangle rectangle3 = this.grid.caculateIntersectsUnion(templateReport, new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, 1));
        if (rectangle2.y >= rectangle.y || rectangle3.contains(rectangle)) {
            if (!reportPane.isRowEndless() && rectangle2.y + rectangle2.height > templateReport.getRowCount() - 1) {
                return;
            }
            Rectangle rectangle4 = this.grid.caculateIntersectsUnion(templateReport, new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height + 1));
            rectangle2.setBounds(rectangle4.union(rectangle2));
            reportPane.ensureColumnRowVisible(rectangle2.x, rectangle2.y + rectangle2.height - 1);
        } else {
            rectangle2.height = rectangle2.y + rectangle2.height - (rectangle3.y + rectangle3.height);
            rectangle2.y = rectangle3.y + rectangle3.height;
            reportPane.ensureColumnRowVisible(rectangle2.x, rectangle2.y + 1);
        }
    }
}

