/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.cell.Grid;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.report.FloatElement;
import com.fr.report.TemplateReport;
import com.fr.util.KeyEventWork;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class GridKeyListener
implements KeyListener {
    private Grid grid;
    private long keyPressedLastTime = 0L;
    private boolean isKeyPressedContentChanged = false;

    public GridKeyListener(Grid grid) {
        this.grid = grid;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.grid.isEnabled() || !this.grid.isCellSelectable()) {
            return;
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        KeyEvent keyEvent2 = KeyEventWork.processKeyEvent(keyEvent);
        if (keyEvent2 == null) {
            return;
        }
        long l = System.currentTimeMillis();
        int n = keyEvent.getKeyCode();
        boolean bl = false;
        ReportPane reportPane = this.grid.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        templateReport.getColumnCount();
        templateReport.getRowCount();
        GridSelection gridSelection = reportPane.getGridSelection();
        reportPane.getGridRow();
        int n2 = gridSelection.getType();
        if (n2 == 1) {
            if (l - this.keyPressedLastTime <= 2L) {
                return;
            }
            this.keyPressedLastTime = l;
            boolean bl2 = false;
            if (!this.isKeyPressedContentChanged) {
                this.isKeyPressedContentChanged = true;
            }
            FloatElement floatElement = templateReport.getFloatElement(gridSelection.getFloatName(0));
            switch (n) {
                case 37: {
                    if (floatElement.getLeftDistance() <= 0) {
                        floatElement.setColumn(floatElement.getColumn() - 1);
                        floatElement.setLeftDistance(templateReport.getColumnWidth(floatElement.getColumn()));
                    } else {
                        floatElement.setLeftDistance(floatElement.getLeftDistance() - 1);
                    }
                    bl2 = true;
                    break;
                }
                case 39: {
                    if (floatElement.getLeftDistance() >= templateReport.getColumnWidth(floatElement.getColumn())) {
                        floatElement.setColumn(floatElement.getColumn() + 1);
                        floatElement.setLeftDistance(0);
                    } else {
                        floatElement.setLeftDistance(floatElement.getLeftDistance() + 1);
                    }
                    bl2 = true;
                    break;
                }
                case 38: {
                    if (floatElement.getTopDistance() <= 0) {
                        floatElement.setRow(floatElement.getRow() - 1);
                        floatElement.setTopDistance(templateReport.getRowHeight(floatElement.getRow()));
                    } else {
                        floatElement.setTopDistance(floatElement.getTopDistance() - 1);
                    }
                    bl2 = true;
                    break;
                }
                case 40: {
                    if (floatElement.getTopDistance() >= templateReport.getRowHeight(floatElement.getRow())) {
                        floatElement.setRow(floatElement.getRow() + 1);
                        floatElement.setTopDistance(0);
                    } else {
                        floatElement.setTopDistance(floatElement.getTopDistance() + 1);
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                this.grid.getReportPane().repaint();
            }
        } else {
            if (l - this.keyPressedLastTime <= 32L) {
                return;
            }
            this.keyPressedLastTime = l;
            switch (n) {
                case 27: {
                    if (!this.grid.isCellEditing()) break;
                    this.grid.cancelEditing();
                    break;
                }
                case 113: {
                    if (this.grid.isCellEditing()) break;
                    this.grid.startEditing();
                }
            }
            if (n == 96 || n == 97 || n == 98 || n == 99 || n == 100 || n == 101 || n == 102 || n == 103 || n == 104 || n == 105 || n == 106 || n == 107 || n == 109 || n == 110 || n == 111) {
                this.keyTyped(keyEvent);
            }
        }
        switch (n) {
            case 33: {
                reportPane.getVerticalScrollBar().setValue(Math.max(0, this.grid.getVerticalValue() - this.grid.getVerticalExtent()));
                bl = true;
                break;
            }
            case 34: {
                reportPane.getVerticalScrollBar().setValue(this.grid.getVerticalValue() + this.grid.getVerticalExtent());
                bl = true;
                break;
            }
            case 65: {
                if (n == 65 && keyEvent.isControlDown()) {
                    gridSelection.clearAllCellRectangles();
                    gridSelection.addCellRectangle(new Rectangle(0, 0, templateReport.getColumnCount(), templateReport.getRowCount()));
                    bl = true;
                }
                bl = true;
            }
        }
        if (bl) {
            reportPane.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.grid.isEnabled() || !this.grid.isCellSelectable()) {
            return;
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        KeyEvent keyEvent2 = KeyEventWork.processKeyEvent(keyEvent);
        if (keyEvent2 == null) {
            return;
        }
        if (this.isKeyPressedContentChanged) {
            this.grid.getReportPane().fireReportDataChanged();
            this.grid.getReportPane().undoRecord();
            this.isKeyPressedContentChanged = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        GridSelection gridSelection;
        int n;
        if (!this.grid.isEnabled() || !this.grid.isCellSelectable()) {
            return;
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        KeyEvent keyEvent2 = KeyEventWork.processKeyEvent(keyEvent);
        if (keyEvent2 == null) {
            return;
        }
        if (keyEvent.isControlDown()) {
            return;
        }
        int n2 = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (c == '\t') {
            return;
        }
        if (Character.isDefined(c) && (n = (gridSelection = this.grid.getReportPane().getGridSelection()).getType()) == 0) {
            if (!this.grid.isCellEditing()) {
                this.grid.startEditing(keyEvent);
            }
            if (this.grid.getCellEditor() != null && this.grid.editorComponent != null) {
                if (n2 == 96 || n2 == 97 || n2 == 98 || n2 == 99 || n2 == 100 || n2 == 101 || n2 == 102 || n2 == 103 || n2 == 104 || n2 == 105 || n2 == 110 || n2 == 106 || n2 == 107 || n2 == 109 || n2 == 111 || n2 == 127) {
                    KeyEvent keyEvent3 = new KeyEvent(this.grid, 401, 0L, 0, n2 - 48, c);
                    this.grid.editorComponent.dispatchEvent(keyEvent3);
                    keyEvent3.consume();
                } else if (!keyEvent.isConsumed()) {
                    this.grid.editorComponent.dispatchEvent(keyEvent);
                }
            }
        }
    }
}

