/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.BaseUtils;
import com.fr.base.ColumnRow;
import com.fr.base.Inter;
import com.fr.cell.Grid;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GUIConstants;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.GridUtils;
import com.fr.cell.core.IntelliElements;
import com.fr.data.condition.ListCondition;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.TemplateReport;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import com.fr.report.painter.shape.LineShapePainter;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class GridMouseAdapter
implements MouseListener,
MouseWheelListener,
MouseMotionListener {
    private static int DRAG_REFRESH_TIME = 10;
    private Grid grid;
    int oldEvtX = 0;
    int oldEvtY = 0;
    int oldLocationX = 0;
    int oldLocationY = 0;
    private long lastMouseMoveTime = 0L;
    private Map floatNamePointMap = new HashMap();

    public GridMouseAdapter(Grid grid) {
        this.grid = grid;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.grid.isEnabled()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = mouseEvent.isShiftDown();
        boolean bl2 = mouseEvent.isControlDown();
        boolean bl3 = SwingUtilities.isRightMouseButton(mouseEvent);
        int n3 = mouseEvent.getClickCount();
        this.grid.stopEditing();
        if (!this.grid.hasFocus() && this.grid.isRequestFocusEnabled()) {
            this.grid.requestFocus();
        }
        ReportPane reportPane = this.grid.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        this.oldEvtX = n;
        this.oldEvtY = n2;
        this.grid.setDragPermited(true);
        ColumnRow columnRow = GridUtils.getEventColumnRow(reportPane, n, n2);
        if (!reportPane.isRowEndless() && columnRow.getRow() > templateReport.getRowCount() - 1) {
            this.grid.setDragPermited(false);
        }
        if (!reportPane.isColumnEndless() && columnRow.getColumn() > templateReport.getColumnCount() - 1) {
            this.grid.setDragPermited(false);
        }
        if (this.grid.getDrawingFloatElement() != null) {
            DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
            DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(templateReport);
            int n4 = this.grid.getHorizontalValue();
            int n5 = this.grid.getVerticalValue();
            int n6 = dynamicValueList.getValueIndex(n, n4);
            int n7 = dynamicValueList2.getValueIndex(n2, n5);
            int n8 = n - dynamicValueList.getRangeValue(n4, n6);
            int n9 = n2 - dynamicValueList2.getRangeValue(n5, n7);
            this.grid.getDrawingFloatElement().setColumn(n6);
            this.grid.getDrawingFloatElement().setLeftDistance(n8);
            this.grid.getDrawingFloatElement().setRow(n7);
            this.grid.getDrawingFloatElement().setTopDistance(n9);
            this.grid.setDataChanged(true);
            templateReport.addFloatElement(this.grid.getDrawingFloatElement());
            reportPane.repaint();
        } else if (bl3) {
            Serializable serializable;
            GridSelection gridSelection = reportPane.getGridSelection();
            int n10 = gridSelection.getType();
            Object[] objectArray = GridUtils.getAboveFloatElementCursor(reportPane, n, n2);
            if (objectArray != null) {
                serializable = (FloatElement)objectArray[0];
                if (n10 == 1) {
                    if (!gridSelection.containFloatName(((FloatElement)serializable).getName())) {
                        gridSelection.clearAllFloatName();
                        gridSelection.addFloatName(((FloatElement)serializable).getName());
                    }
                } else {
                    gridSelection.setType(1);
                    gridSelection.clearAllFloatName();
                    gridSelection.addFloatName(((FloatElement)serializable).getName());
                }
            } else {
                serializable = GridUtils.getAdjustEventColumnRow(reportPane, n, n2);
                if (n10 == 1) {
                    GridUtils.doSelectCell(reportPane, ((ColumnRow)serializable).getColumn(), ((ColumnRow)serializable).getRow());
                } else if (!gridSelection.containsCell(((ColumnRow)serializable).getColumn(), ((ColumnRow)serializable).getRow())) {
                    GridUtils.doSelectCell(reportPane, ((ColumnRow)serializable).getColumn(), ((ColumnRow)serializable).getRow());
                }
            }
            reportPane.repaint();
            serializable = reportPane.createPopupMenu(mouseEvent);
            if (serializable != null) {
                GUICoreUtils.showPopupMenu((JPopupMenu)serializable, this.grid, n - 1, n2 - 1);
            }
        } else {
            if (this.grid.isCellDragable() && this.grid.isCellSelectable()) {
                this.grid.setDragType(this.isMoveCellSelection(n, n2));
                if (this.grid.getDragType() != GridUtils.DRAG_NONE) {
                    GridSelection gridSelection = reportPane.getGridSelection();
                    Rectangle rectangle = gridSelection.getFirstCellRectangle();
                    if (this.grid.getDragRectangle() == null) {
                        this.grid.setDragRectangle(new Rectangle());
                    }
                    this.grid.getDragRectangle().setBounds(rectangle);
                    return;
                }
            } else {
                this.grid.setDragType(GridUtils.DRAG_NONE);
            }
            this.doOneClickSelection(reportPane, n, n2, bl, bl2);
            ColumnRow columnRow2 = GridUtils.getEventColumnRow(reportPane, n, n2);
            CellElement cellElement = templateReport.getCellElement(columnRow2.getColumn(), columnRow2.getRow());
            if (n3 >= 2) {
                this.grid.startEditing();
            }
            if (n3 == 1 && cellElement != null && cellElement.getWidget() != null) {
                DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
                DynamicValueList dynamicValueList3 = ReportHelper.getRowHeightList(templateReport);
                double d = n - dynamicValueList.getRangeValue(this.grid.getHorizontalValue(), cellElement.getColumn());
                double d2 = n2 - dynamicValueList3.getRangeValue(this.grid.getVerticalValue(), cellElement.getRow());
                int n11 = dynamicValueList.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan());
                int n12 = dynamicValueList3.getRangeValue(cellElement.getRow(), cellElement.getRow() + cellElement.getRowSpan());
                if ((double)n11 - d > 0.0 && (double)n12 - d2 > 0.0 && (double)n11 - d < 13.0 && (double)n12 - d2 < 13.0) {
                    reportPane.showWidgetWindow();
                }
            }
            reportPane.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.grid.isEnabled()) {
            return;
        }
        if (!this.grid.isEditable()) {
            return;
        }
        boolean bl = false;
        ReportPane reportPane = this.grid.getReportPane();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (this.grid.getDrawingFloatElement() != null) {
            if (this.grid.getDrawingFloatElement().getSize().getWidth() == 0.0 && this.grid.getDrawingFloatElement().getSize().getHeight() == 0.0) {
                this.grid.getDrawingFloatElement().setSize(new Dimension(100, 100));
            }
            this.grid.setDrawingFloatElement(null);
        } else if (n == 1) {
            this.grid.setCursor(Cursor.getDefaultCursor());
        }
        if (this.grid.getDragType() == GridUtils.DRAG_CELLSELECTION) {
            if (n == 0) {
                this.grid.getReportPane().cut();
                this.mousePressed(mouseEvent);
                this.grid.getReportPane().paste();
                this.grid.setDataChanged(true);
            } else {
                bl = true;
            }
        } else if (this.grid.getDragType() == GridUtils.Drag_CellSelection_BottomRight_Corner) {
            if (n == 0 && gridSelection.getCellRectangleCount() == 1) {
                int n2 = gridSelection.getEditRectangle().x;
                int n3 = gridSelection.getEditRectangle().y;
                int n4 = gridSelection.getEditRectangle().width;
                int n5 = gridSelection.getEditRectangle().height;
                IntelliElements.iterating(reportPane, gridSelection.getEditRectangle(), gridSelection.getFirstCellRectangle(), this.grid.getDragRectangle(), bl, this.grid.isDataChanged());
                if (this.grid.getDragRectangle() != null) {
                    gridSelection.setOnlyCellBounds(this.grid.getDragRectangle().x, this.grid.getDragRectangle().y, this.grid.getDragRectangle().width, this.grid.getDragRectangle().height);
                    gridSelection.setEditBounds(n2, n3, n4, n5);
                }
            } else {
                bl = true;
            }
        }
        this.grid.setDragType(GridUtils.DRAG_NONE);
        this.grid.setDragRectangle(null);
        if (this.grid.isDataChanged()) {
            this.grid.setDataChanged(false);
            reportPane.fireReportDataChanged();
            reportPane.undoRecord();
        } else if (bl) {
            reportPane.repaint();
        }
        if (this.grid.getReportPane().isFormatBrush()) {
            this.grid.getReportPane().brushFormat();
            this.grid.setDataChanged(true);
            if (this.grid.isDataChanged()) {
                this.grid.setDataChanged(false);
                this.grid.getReportPane().fireReportDataChanged();
                this.grid.getReportPane().undoRecord();
            }
        }
    }

    public void mouseMoved(final MouseEvent mouseEvent) {
        if (!this.grid.isEnabled()) {
            return;
        }
        if (!this.grid.isEditable()) {
            return;
        }
        if (this.grid.isEditing()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastMouseMoveTime <= 100L) {
            return;
        }
        this.lastMouseMoveTime = l;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GridMouseAdapter.this.mouseMoveOnGrid(mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.grid.isEnabled()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastMouseMoveTime <= (long)DRAG_REFRESH_TIME) {
            return;
        }
        this.lastMouseMoveTime = l;
        if (!this.grid.isDragPermited() || SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        ReportPane reportPane = this.grid.getReportPane();
        this.threadMouseDragged(reportPane, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isControlDown());
    }

    protected void threadMouseDragged(ReportPane reportPane, int n, int n2, boolean bl) {
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n3 = gridSelection.getType();
        boolean bl2 = false;
        if (this.grid.getDrawingFloatElement() != null) {
            int n4 = Math.min(this.oldEvtX, n);
            int n5 = Math.max(this.oldEvtX, n);
            int n6 = Math.min(this.oldEvtY, n2);
            int n7 = Math.max(this.oldEvtY, n2);
            Object object = this.grid.getDrawingFloatElement().getValue();
            if (object instanceof LineShapePainter) {
                if (n < this.oldEvtX && n2 < this.oldEvtY || n > this.oldEvtX && n2 > this.oldEvtY) {
                    ((LineShapePainter)object).setPositiveArrow(false);
                } else {
                    ((LineShapePainter)object).setPositiveArrow(true);
                }
            }
            DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
            DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(templateReport);
            int n8 = this.grid.getHorizontalValue();
            int n9 = this.grid.getVerticalValue();
            int n10 = dynamicValueList.getValueIndex(n4, n8);
            int n11 = n4 - dynamicValueList.getRangeValue(n8, n10);
            int n12 = dynamicValueList2.getValueIndex(n6, n9);
            int n13 = n6 - dynamicValueList2.getRangeValue(n9, n12);
            this.grid.getDrawingFloatElement().setColumn(n10);
            this.grid.getDrawingFloatElement().setLeftDistance(n11);
            this.grid.getDrawingFloatElement().setRow(n12);
            this.grid.getDrawingFloatElement().setTopDistance(n13);
            this.grid.getDrawingFloatElement().setSize(new Dimension(n5 - n4, n7 - n6));
            gridSelection.setType(1);
            gridSelection.clearAllFloatName();
            gridSelection.addFloatName(this.grid.getDrawingFloatElement().getName());
            this.grid.setDataChanged(true);
            bl2 = true;
        } else if (n3 == 1) {
            String string = gridSelection.getFloatName(0);
            FloatElement floatElement = templateReport.getFloatElement(string);
            int n14 = this.grid.getCursor().getType();
            if (n14 == 6 || n14 == 7 || n14 == 5 || n14 == 4) {
                int n15 = Math.min(this.oldEvtX, n);
                int n16 = Math.max(this.oldEvtX, n);
                int n17 = Math.min(this.oldEvtY, n2);
                int n18 = Math.max(this.oldEvtY, n2);
                DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
                DynamicValueList dynamicValueList3 = ReportHelper.getRowHeightList(templateReport);
                int n19 = this.grid.getHorizontalValue();
                int n20 = this.grid.getVerticalValue();
                int n21 = dynamicValueList.getValueIndex(n15, n19);
                int n22 = n15 - dynamicValueList.getRangeValue(n19, n21);
                int n23 = dynamicValueList3.getValueIndex(n17, n20);
                int n24 = n17 - dynamicValueList3.getRangeValue(n20, n23);
                floatElement.setColumn(n21);
                floatElement.setLeftDistance(n22);
                floatElement.setRow(n23);
                floatElement.setTopDistance(n24);
                floatElement.setSize(new Dimension(n16 - n15, n18 - n17));
            } else if (n14 == 9 || n14 == 8) {
                int n25 = Math.min(this.oldEvtY, n2);
                int n26 = Math.max(this.oldEvtY, n2);
                DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(templateReport);
                int n27 = this.grid.getVerticalValue();
                int n28 = dynamicValueList.getValueIndex(n25, n27);
                int n29 = n25 - dynamicValueList.getRangeValue(n27, n28);
                floatElement.setRow(n28);
                floatElement.setTopDistance(n29);
                floatElement.setSize(new Dimension((int)floatElement.getSize().getWidth(), n26 - n25));
            } else if (n14 == 10 || n14 == 11) {
                int n30 = Math.min(this.oldEvtX, n);
                int n31 = Math.max(this.oldEvtX, n);
                DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
                int n32 = this.grid.getHorizontalValue();
                int n33 = dynamicValueList.getValueIndex(n30, n32);
                int n34 = n30 - dynamicValueList.getRangeValue(n32, n33);
                floatElement.setColumn(n33);
                floatElement.setLeftDistance(n34);
                floatElement.setSize(new Dimension(n31 - n30, (int)floatElement.getSize().getHeight()));
            } else if (n14 == 13) {
                int n35;
                int n36 = this.oldLocationX + (n - this.oldEvtX);
                if (n36 < 0) {
                    n36 = 0;
                }
                if ((n35 = this.oldLocationY + (n2 - this.oldEvtY)) < 0) {
                    n35 = 0;
                }
                DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
                DynamicValueList dynamicValueList4 = ReportHelper.getRowHeightList(templateReport);
                int n37 = this.grid.getHorizontalValue();
                int n38 = this.grid.getVerticalValue();
                for (int i = 0; i < gridSelection.getFloatNameCount(); ++i) {
                    String string2 = gridSelection.getFloatName(i);
                    FloatElement floatElement2 = templateReport.getFloatElement(string2);
                    Point point = (Point)this.floatNamePointMap.get(string2);
                    int n39 = point.x + n36;
                    int n40 = point.y + n35;
                    int n41 = dynamicValueList.getValueIndex(n39, n37);
                    int n42 = n39 - dynamicValueList.getRangeValue(n37, n41);
                    int n43 = dynamicValueList4.getValueIndex(n40, n38);
                    int n44 = n40 - dynamicValueList4.getRangeValue(n38, n43);
                    floatElement2.setColumn(n41);
                    floatElement2.setLeftDistance(n42);
                    floatElement2.setRow(n43);
                    floatElement2.setTopDistance(n44);
                }
            }
            this.grid.setDataChanged(true);
            bl2 = true;
        } else if (this.grid.getDragType() == GridUtils.Drag_CellSelection_BottomRight_Corner) {
            ColumnRow columnRow;
            Rectangle rectangle = gridSelection.getFirstCellRectangle();
            if (rectangle.contains((columnRow = GridUtils.getAdjustEventColumnRow(reportPane, n, n2)).getColumn(), columnRow.getRow())) {
                this.grid.getDragRectangle().setBounds(rectangle);
            } else {
                int n45 = n - this.oldEvtX;
                int n46 = n2 - this.oldEvtY;
                if (Math.abs(n46) > Math.abs(n45)) {
                    this.grid.getDragRectangle().x = rectangle.x;
                    this.grid.getDragRectangle().width = rectangle.width;
                    if (n46 >= 0) {
                        this.grid.getDragRectangle().y = rectangle.y;
                        this.grid.getDragRectangle().height = columnRow.getRow() - rectangle.y + 1;
                    } else if (columnRow.getRow() >= rectangle.y && columnRow.getRow() < rectangle.y + rectangle.height) {
                        this.grid.getDragRectangle().y = rectangle.y;
                        this.grid.getDragRectangle().height = rectangle.height;
                    } else {
                        this.grid.getDragRectangle().y = rectangle.y;
                        this.grid.getDragRectangle().height = rectangle.y - columnRow.getRow() + rectangle.height;
                    }
                } else {
                    this.grid.getDragRectangle().y = rectangle.y;
                    this.grid.getDragRectangle().height = rectangle.height;
                    if (n45 >= 0) {
                        this.grid.getDragRectangle().x = rectangle.x;
                        this.grid.getDragRectangle().width = columnRow.getColumn() - rectangle.x + 1;
                    } else if (columnRow.getColumn() >= rectangle.x && columnRow.getColumn() < rectangle.x + rectangle.width) {
                        this.grid.getDragRectangle().x = rectangle.x;
                        this.grid.getDragRectangle().width = rectangle.width;
                    } else {
                        this.grid.getDragRectangle().x = columnRow.getColumn();
                        this.grid.getDragRectangle().width = rectangle.x - columnRow.getColumn() + rectangle.width;
                    }
                }
            }
            reportPane.ensureColumnRowVisible(columnRow.getColumn() + 1, columnRow.getRow() + 1);
            bl2 = true;
        } else if (this.grid.getDragType() == GridUtils.DRAG_CELLSELECTION) {
            ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, n, n2);
            if (columnRow.getColumn() != this.grid.getDragRectangle().x || columnRow.getRow() != this.grid.getDragRectangle().y) {
                this.grid.getDragRectangle().x = columnRow.getColumn();
                this.grid.getDragRectangle().y = columnRow.getRow();
                bl2 = true;
            }
        } else if (this.grid.isCellSelectable()) {
            Rectangle rectangle = null;
            rectangle = bl ? gridSelection.getLastCellRectangle() : gridSelection.getFirstCellRectangle();
            this.doShiftSelectCell(reportPane, n, n2, rectangle);
            bl2 = true;
        }
        if (bl2) {
            this.grid.getReportPane().repaint();
        }
    }

    protected void mouseMoveOnGrid(int n, int n2) {
        this.grid.setToolTipText(null);
        ReportPane reportPane = this.grid.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        ColumnRow columnRow = GridUtils.getEventColumnRow(reportPane, n, n2);
        if (!reportPane.isRowEndless() && columnRow.getRow() > templateReport.getRowCount() - 1 || !reportPane.isColumnEndless() && columnRow.getColumn() > templateReport.getColumnCount() - 1) {
            this.grid.setCursor(new Cursor(0));
            return;
        }
        if (reportPane.isFormatBrush()) {
            this.grid.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(BaseUtils.readImage("/com/fr/cell/images/cursor/formatpainter.gif"), new Point(16, 16), "formatpainter"));
        } else if (this.grid.getDrawingFloatElement() != null) {
            this.grid.setCursor(GUIConstants.DrawCursor);
        } else {
            Object[] objectArray = GridUtils.getAboveFloatElementCursor(reportPane, n, n2);
            if (objectArray != null) {
                this.grid.setCursor((Cursor)objectArray[1]);
            } else if (this.grid.isCellSelectable()) {
                int n3;
                this.grid.setCursor(GUIConstants.CellDefaultCursor);
                int n4 = columnRow.getColumn();
                int n5 = columnRow.getRow();
                CellElement cellElement = templateReport.getCellElement(n4, n5);
                DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
                DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(templateReport);
                double d = -1.0;
                double d2 = -1.0;
                if (cellElement != null) {
                    Object object;
                    CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
                    if (cellGUIAttr == null) {
                        cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
                    }
                    this.grid.setToolTipText(cellGUIAttr.getTooltipText());
                    d = dynamicValueList.getRangeValue(this.grid.getHorizontalValue(), cellElement.getColumn()) + 4;
                    d2 = dynamicValueList2.getRangeValue(this.grid.getVerticalValue(), cellElement.getRow() + cellElement.getRowSpan()) + 4;
                    double d3 = n - dynamicValueList.getRangeValue(this.grid.getHorizontalValue(), cellElement.getColumn());
                    double d4 = n2 - dynamicValueList2.getRangeValue(this.grid.getVerticalValue(), cellElement.getRow());
                    int n6 = 6;
                    int n7 = 0;
                    if (cellElement.getHighlightGroup() != null && cellElement.getHighlightGroup().size() > 0) {
                        if (d3 > 0.0 && d4 > 0.0 && d3 + d4 < (double)n6) {
                            this.grid.setCursor(new Cursor(12));
                            this.grid.setToolTipText(Inter.getLocText("Condition_Attributes"));
                            d = (double)n - d3 - 10.0;
                            d2 = (double)n2 - d4 - 20.0;
                        }
                        ++n7;
                    }
                    if (cellElement.getPresent() != null) {
                        if (d3 > (double)(n6 * n7) && d4 > 0.0 && d3 + d4 < (double)(n6 + n6 * n7)) {
                            this.grid.setCursor(new Cursor(12));
                            this.grid.setToolTipText(Inter.getLocText("Present"));
                            d = (double)n - d3 - 10.0;
                            d2 = (double)n2 - d4 - 20.0;
                        }
                        ++n7;
                    }
                    int n8 = dynamicValueList.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan());
                    if (cellElement.getCellPageAttr() != null && (cellElement.getCellPageAttr().isPageAfterColumn() || cellElement.getCellPageAttr().isPageBeforeColumn() || cellElement.getCellPageAttr().isPageAfterRow() || cellElement.getCellPageAttr().isPageBeforeRow()) && (double)n8 - d3 > 0.0 && d4 > 0.0 && (double)n8 - d3 + d4 < (double)n6) {
                        this.grid.setCursor(new Cursor(12));
                        this.grid.setToolTipText(Inter.getLocText("Pagination"));
                        d = (double)n - d3 + (double)n8 - 10.0;
                        d2 = (double)n2 - d4 - 20.0;
                    }
                    int n9 = dynamicValueList2.getRangeValue(cellElement.getRow(), cellElement.getRow() + cellElement.getRowSpan());
                    if (cellElement.getWidget() != null && (double)n8 - d3 > 0.0 && (double)n9 - d4 > 0.0 && (double)n8 - d3 < 13.0 && (double)n9 - d4 < 13.0) {
                        this.grid.setCursor(new Cursor(12));
                        this.grid.setToolTipText(Inter.getLocText("Widget"));
                        d = (double)n - d3 + (double)n8 + 10.0;
                        d2 = (double)n2 - d4 + (double)n9 + 20.0;
                    }
                    if ((object = cellElement.getValue()) instanceof DSColumn && ((DSColumn)object).getCondition() != null && (!(((DSColumn)object).getCondition() instanceof ListCondition) || ((ListCondition)((DSColumn)object).getCondition()).getJoinConditionCount() != 0) && d3 > 0.0 && (double)n9 - d4 > 0.0 && d3 + (double)n9 - d4 < (double)n6) {
                        this.grid.setCursor(new Cursor(12));
                        this.grid.setToolTipText(Inter.getLocText("Condition") + Inter.getLocText("Filter"));
                        d = (double)n - d3 - 10.0;
                        d2 = (double)n2 - d4 + (double)n9 + 20.0;
                    }
                }
                if ((n3 = this.isMoveCellSelection(n, n2)) == GridUtils.DRAG_CELLSELECTION) {
                    this.grid.setCursor(new Cursor(13));
                } else if (n3 == GridUtils.Drag_CellSelection_BottomRight_Corner) {
                    this.grid.setCursor(new Cursor(1));
                }
                if (this.grid.getToolTipText() != null && this.grid.getToolTipText().length() > 0) {
                    this.grid.getToolTipLocation(null).setLocation(d, d2);
                }
            } else {
                this.grid.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private int isMoveCellSelection(double d, double d2) {
        ReportPane reportPane = this.grid.getReportPane();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 0 && gridSelection.getCellRectangleCount() != 1) {
            return GridUtils.DRAG_NONE;
        }
        Rectangle rectangle = gridSelection.getFirstCellRectangle();
        TemplateReport templateReport = reportPane.getEditingReport();
        DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
        DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(templateReport);
        double d3 = dynamicValueList.getRangeValue(this.grid.getHorizontalValue(), rectangle.x);
        double d4 = dynamicValueList.getRangeValue(this.grid.getHorizontalValue(), rectangle.x + rectangle.width);
        double d5 = dynamicValueList2.getRangeValue(this.grid.getVerticalValue(), rectangle.y);
        double d6 = dynamicValueList2.getRangeValue(this.grid.getVerticalValue(), rectangle.y + rectangle.height);
        if (d >= d4 - 1.5 && d <= d4 + 2.5 && d2 >= d6 - 1.5 && d6 <= d6 + 2.5) {
            return GridUtils.Drag_CellSelection_BottomRight_Corner;
        }
        double d7 = 1.0;
        if (d >= d3 - d7 && d <= d3 + d7 || d >= d4 - d7 && d <= d4 + d7 ? d2 >= d5 - d7 && d2 <= d6 + d7 : (d2 >= d5 - d7 && d2 <= d5 + d7 || d2 >= d6 - d7 && d2 <= d6 + d7) && d >= d3 - d7 && d <= d4 + d7) {
            return GridUtils.DRAG_CELLSELECTION;
        }
        return GridUtils.DRAG_NONE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doOneClickSelection(ReportPane reportPane, int n, int n2, boolean bl, boolean bl2) {
        block15: {
            Object object;
            int n3;
            FloatElement floatElement;
            FloatElement floatElement2;
            int n4;
            int n5;
            int n6;
            String string;
            int n7;
            int n8;
            DynamicValueList dynamicValueList;
            DynamicValueList dynamicValueList2;
            GridSelection gridSelection;
            TemplateReport templateReport;
            block25: {
                block16: {
                    int n9;
                    block24: {
                        double[] dArray;
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block17: {
                                                    templateReport = reportPane.getEditingReport();
                                                    gridSelection = reportPane.getGridSelection();
                                                    dynamicValueList2 = ReportHelper.getColumnWidthList(templateReport);
                                                    dynamicValueList = ReportHelper.getRowHeightList(templateReport);
                                                    n8 = this.grid.getVerticalValue();
                                                    n7 = this.grid.getHorizontalValue();
                                                    Object[] objectArray = GridUtils.getAboveFloatElementCursor(reportPane, n, n2);
                                                    if (objectArray == null) break block16;
                                                    if (gridSelection.getType() != 1) {
                                                        gridSelection.setType(1);
                                                    }
                                                    FloatElement floatElement3 = (FloatElement)objectArray[0];
                                                    string = floatElement3.getName();
                                                    if (bl || bl2) {
                                                        if (gridSelection.containFloatName(string)) {
                                                            gridSelection.removeFloatName(string);
                                                        } else {
                                                            gridSelection.addFloatName(string);
                                                        }
                                                    } else if (!gridSelection.containFloatName(string)) {
                                                        gridSelection.clearAllFloatName();
                                                        gridSelection.addFloatName(string);
                                                    }
                                                    dArray = GridUtils.caculateFloatElementLocations(floatElement3, dynamicValueList2, dynamicValueList, n8, n7);
                                                    n9 = ((Cursor)objectArray[1]).getType();
                                                    if (n9 != 6) break block17;
                                                    this.oldEvtX = (int)dArray[2];
                                                    this.oldEvtY = (int)dArray[3];
                                                    break block15;
                                                }
                                                if (n9 != 7) break block18;
                                                this.oldEvtX = (int)dArray[0];
                                                this.oldEvtY = (int)dArray[3];
                                                break block15;
                                            }
                                            if (n9 != 5) break block19;
                                            this.oldEvtX = (int)dArray[0];
                                            this.oldEvtY = (int)dArray[1];
                                            break block15;
                                        }
                                        if (n9 != 4) break block20;
                                        this.oldEvtX = (int)dArray[2];
                                        this.oldEvtY = (int)dArray[1];
                                        break block15;
                                    }
                                    if (n9 != 8) break block21;
                                    this.oldEvtX = (int)dArray[0];
                                    this.oldEvtY = (int)dArray[3];
                                    break block15;
                                }
                                if (n9 != 9) break block22;
                                this.oldEvtX = (int)dArray[0];
                                this.oldEvtY = (int)dArray[1];
                                break block15;
                            }
                            if (n9 != 10) break block23;
                            this.oldEvtX = (int)dArray[2];
                            this.oldEvtY = (int)dArray[1];
                            break block15;
                        }
                        if (n9 != 11) break block24;
                        this.oldEvtX = (int)dArray[0];
                        this.oldEvtY = (int)dArray[1];
                        break block15;
                    }
                    if (n9 != 13) break block15;
                    this.oldEvtX = n;
                    this.oldEvtY = n2;
                    n6 = gridSelection.getFloatNameCount();
                    n5 = Integer.MAX_VALUE;
                    n4 = Integer.MAX_VALUE;
                    floatElement2 = null;
                    floatElement = null;
                    break block25;
                }
                if (this.grid.isCellSelectable()) {
                    gridSelection.setType(0);
                    if (bl) {
                        Rectangle rectangle = null;
                        rectangle = bl2 ? gridSelection.getLastCellRectangle() : gridSelection.getFirstCellRectangle();
                        this.doShiftSelectCell(reportPane, n, n2, rectangle);
                        break block15;
                    } else {
                        if (!bl2) {
                            ColumnRow columnRow = GridUtils.getEventColumnRow(reportPane, n, n2);
                            GridUtils.doSelectCell(reportPane, columnRow.getColumn(), columnRow.getRow());
                            return;
                        }
                        this.doControlSelectCell(reportPane, n, n2);
                    }
                    break block15;
                } else {
                    gridSelection.setType(0);
                    gridSelection.clearCellRectangles();
                    gridSelection.clearAllFloatName();
                }
                break block15;
            }
            for (n3 = 0; n3 < n6; ++n3) {
                string = gridSelection.getFloatName(n3);
                object = templateReport.getFloatElement(string);
                if (object == null) continue;
                if ((n5 = Math.min(n5, ((FloatElement)object).getColumn())) == ((FloatElement)object).getColumn()) {
                    floatElement = object;
                }
                if ((n4 = Math.min(((FloatElement)object).getRow(), n4)) != ((FloatElement)object).getRow()) continue;
                floatElement2 = object;
            }
            this.oldLocationX = dynamicValueList2.getRangeValue(n7, n5) + floatElement.getLeftDistance();
            this.oldLocationY = dynamicValueList.getRangeValue(n8, n4) + floatElement2.getTopDistance();
            this.floatNamePointMap.clear();
            for (n3 = 0; n3 < gridSelection.getFloatNameCount(); ++n3) {
                object = gridSelection.getFloatName(n3);
                FloatElement floatElement4 = templateReport.getFloatElement((String)object);
                int n10 = dynamicValueList2.getRangeValue(n7, floatElement4.getColumn()) + floatElement4.getLeftDistance() - this.oldLocationX;
                int n11 = dynamicValueList.getRangeValue(n8, floatElement4.getRow()) + floatElement4.getTopDistance() - this.oldLocationY;
                this.floatNamePointMap.put(object, new Point(n10, n11));
            }
        }
        reportPane.fireGridSelectionChanged();
    }

    private void doShiftSelectCell(ReportPane reportPane, double d, double d2, Rectangle rectangle) {
        ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, d, d2);
        int n = columnRow.getColumn();
        int n2 = columnRow.getRow();
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        Rectangle rectangle2 = gridSelection.getEditRectangle();
        int n3 = rectangle2.x;
        int n4 = rectangle2.y;
        if (columnRow.getColumn() >= rectangle2.x) {
            columnRow = ColumnRow.valueOf(columnRow.getColumn() + 1, columnRow.getRow());
        } else {
            ++n3;
        }
        if (columnRow.getRow() >= rectangle2.y) {
            columnRow = ColumnRow.valueOf(columnRow.getColumn(), columnRow.getRow() + 1);
        } else {
            ++n4;
        }
        Rectangle rectangle3 = new Rectangle(Math.min(n3, columnRow.getColumn()), Math.min(n4, columnRow.getRow()), Math.max(rectangle2.width, Math.abs(n3 - columnRow.getColumn())), Math.max(rectangle2.height, Math.abs(n4 - columnRow.getRow())));
        rectangle3 = this.grid.caculateIntersectsUnion(templateReport, rectangle3);
        rectangle.setBounds(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        reportPane.ensureColumnRowVisible(n, n2);
    }

    private void doControlSelectCell(ReportPane reportPane, double d, double d2) {
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        gridSelection.setType(0);
        ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, d, d2);
        CellElement cellElement = templateReport.getCellElement(columnRow.getColumn(), columnRow.getRow());
        if (cellElement == null) {
            gridSelection.setEditBounds(columnRow.getColumn(), columnRow.getRow(), 1, 1);
            gridSelection.addCellRectangle(new Rectangle(columnRow.getColumn(), columnRow.getRow(), 1, 1));
        } else {
            gridSelection.setEditBounds(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            gridSelection.addCellRectangle(new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan()));
        }
        reportPane.ensureColumnRowVisible(columnRow.getColumn(), columnRow.getRow());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        ReportPane reportPane = this.grid.getReportPane();
        int n = mouseWheelEvent.getWheelRotation();
        reportPane.getVerticalScrollBar().setValue(reportPane.getVerticalScrollBar().getValue() + n * 3);
    }
}

