/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.core.GraphHelper;
import com.fr.cell.BaseGridComponent;
import com.fr.cell.DefaultGirdRowRenderer;
import com.fr.cell.GridCRRenderer;
import com.fr.cell.GridRowUI;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GridRowMouseHandler;
import java.awt.Color;
import java.awt.Dimension;

public class GridRow
extends BaseGridComponent {
    public static final int ROW_WEIGHT_AJUST = 4;
    private Color separatorLineColor = new Color(172, 168, 153);
    private Color selectedForeground = Color.black;
    private Color selectedBackground = new Color(253, 216, 153);
    private GridCRRenderer gridCRRender;

    public GridRow() {
        GridRowMouseHandler gridRowMouseHandler = new GridRowMouseHandler(this);
        this.addMouseListener(gridRowMouseHandler);
        this.addMouseMotionListener(gridRowMouseHandler);
        this.gridCRRender = new DefaultGirdRowRenderer();
        this.getInputMap().clear();
        this.getActionMap().clear();
        this.setFocusable(false);
        this.setOpaque(true);
        this.setUI(new GridRowUI());
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public Color getForeground() {
        return super.getForeground();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public Color getSeparatorLineColor() {
        return this.separatorLineColor;
    }

    public void setSeparatorLineColor(Color color) {
        Color color2 = this.separatorLineColor;
        this.separatorLineColor = color;
        this.firePropertyChange("separatorLineColor", color2, this.separatorLineColor);
        this.repaint();
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        Color color2 = this.selectedForeground;
        this.selectedForeground = color;
        this.firePropertyChange("selectedForeground", color2, this.selectedForeground);
        this.repaint();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        Color color2 = this.selectedBackground;
        this.selectedBackground = color;
        this.firePropertyChange("selectedBackground", color2, this.selectedBackground);
        this.repaint();
    }

    public Dimension getPreferredSize() {
        ReportPane reportPane = this.getReportPane();
        if (!reportPane.isRowHeaderVisible()) {
            return new Dimension(0, 0);
        }
        int n = this.caculateMaxCharNumber(reportPane);
        return new Dimension(n * GraphHelper.getFontMetrics(this.getFont()).charWidth('M'), super.getPreferredSize().height);
    }

    private int caculateMaxCharNumber(ReportPane reportPane) {
        int n = 5;
        n = Math.max(n, ("" + (reportPane.getGrid().getVerticalValue() + reportPane.getGrid().getVerticalExtent())).length() + 1);
        return n;
    }

    public GridCRRenderer getGridCRRender() {
        return this.gridCRRender;
    }

    public void setGridCRRender(GridCRRenderer gridCRRenderer) {
        this.gridCRRender = gridCRRenderer;
    }
}

