/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.core.GraphHelper;
import com.fr.base.core.list.IntList;
import com.fr.cell.GridRow;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GridUtils;
import com.fr.report.TemplateReport;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class GridRowUI
extends ComponentUI {
    private Color detailsBackground = Color.lightGray;

    public void paint(Graphics graphics, JComponent jComponent) {
        if (!(jComponent instanceof GridRow)) {
            throw new IllegalArgumentException("The component c to paint must be a GridColumn!");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        GridRow gridRow = (GridRow)jComponent;
        ReportPane reportPane = gridRow.getReportPane();
        Dimension dimension = gridRow.getSize();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
        graphics2D.setPaint(gridRow.getBackground());
        GraphHelper.fill(graphics2D, double_);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(gridRow.getFont());
        TemplateReport templateReport = reportPane.getEditingReport();
        DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(templateReport);
        int n = reportPane.getGrid().getVerticalValue();
        int n2 = reportPane.getGrid().getVerticalBeginValue();
        n2 = n;
        reportPane.getGrid().setVerticalBeinValue(n2);
        int n3 = reportPane.getGrid().getVerticalExtent();
        int n4 = templateReport.getRowCount() - 1;
        int n5 = n + n3 + 1;
        double d = dimension.getHeight();
        if (!reportPane.isRowEndless()) {
            n5 = Math.min(n5, n4);
            d = dynamicValueList.getRangeValue(n, Math.max(0, n4 + 1));
        }
        int n6 = templateReport.getRowCount();
        double d2 = 0.0;
        dynamicValueList.getRangeValue(n2, n6);
        if (n6 > n2) {
            d2 = dynamicValueList.getRangeValue(n2, n6);
        }
        d2 = Math.min(d, d2);
        if (gridRow.getBackground() != null) {
            graphics2D.setPaint(this.detailsBackground);
            GraphHelper.fill(graphics2D, new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), d2));
            graphics2D.setPaint(gridRow.getBackground());
            GraphHelper.fill(graphics2D, new Rectangle2D.Double(0.0, d2, dimension.getHeight(), dimension.getHeight() - d2));
        }
        graphics2D.setPaint(gridRow.getSeparatorLineColor());
        GraphHelper.drawLine(graphics2D, 0.0, 0.0, dimension.getWidth(), 0.0);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i <= n5; ++i) {
            boolean bl;
            if (i == 0) {
                i = n2;
            }
            d4 = (d5 = (double)dynamicValueList.get(i)) == 0.0 ? d3 + 1.0 : (d3 += d5) + d5;
            GridSelection gridSelection = reportPane.getGridSelection();
            IntList intList = GridUtils.getGridSelectionRowIndex(gridSelection);
            int n7 = gridSelection.getType();
            if (n7 == 0 && intList.contain(i)) {
                graphics2D.setPaint(gridRow.getSelectedBackground());
                GraphHelper.fill(graphics2D, new Rectangle2D.Double(0.0, d3 + 1.0, dimension.width, d5 - 1.0));
                bl = true;
            } else {
                bl = false;
            }
            graphics2D.setColor(gridRow.getSeparatorLineColor());
            GraphHelper.drawLine(graphics2D, 0.0, d4, dimension.getWidth(), d4);
            Object object = gridRow.getGridCRRender().getDisplay(i);
            if (object == null) {
                return;
            }
            if (object instanceof String || object instanceof Number) {
                String string = object.toString();
                if (templateReport.getReportPageAttr() != null) {
                    if (i >= templateReport.getReportPageAttr().getRepeatHeaderRowFrom() && i <= templateReport.getReportPageAttr().getRepeatHeaderRowTo()) {
                        string = string + "(H)";
                    }
                    if (i >= templateReport.getReportPageAttr().getRepeatFooterRowFrom() && i <= templateReport.getReportPageAttr().getRepeatFooterRowTo()) {
                        string = string + "(F)";
                    }
                }
                float f = fontMetrics.getAscent();
                double d6 = gridRow.getFont().getStringBounds(string, fontRenderContext).getWidth();
                if (bl) {
                    graphics2D.setColor(gridRow.getSelectedForeground());
                } else if (gridRow.isEnabled()) {
                    graphics2D.setColor(gridRow.getForeground());
                } else {
                    graphics2D.setPaint(UIManager.getColor("controlShadow"));
                }
                GraphHelper.drawString(graphics2D, string, ((double)dimension.width - d6) / 2.0, d3 + 2.0 + (double)f);
                continue;
            }
            if (!(object instanceof Image)) continue;
            GraphHelper.paintImage(graphics2D, dimension.width, (int)d5, (Image)object, null, 3, -1, -1);
        }
        graphics2D.setColor(gridRow.getSeparatorLineColor());
        GraphHelper.drawLine(graphics2D, 0.0, 0.0, 0.0, d4);
    }
}

