/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.ColumnRow;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.ImageBackground;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.antlr.ANTLRException;
import com.fr.cell.CellElementPainter;
import com.fr.cell.Grid;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GridUtils;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.Margin;
import com.fr.report.PaperSize;
import com.fr.report.Report;
import com.fr.report.ReportSettings;
import com.fr.report.TemplateReport;
import com.fr.report.cellElement.CellExpandAttr;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.script.Calculator;
import com.fr.util.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class GridUI
extends ComponentUI {
    public static int INVALID_INTEGER = Integer.MIN_VALUE;
    private transient Dimension gridSize;
    private transient int verticalValue;
    private transient int horizontalValue;
    private transient double paperPaintWidth;
    private transient double paperPaintHeight;
    private transient DynamicValueList rowHeightList;
    private transient DynamicValueList columnWidthList;
    private transient int verticalEndValue;
    private transient int horizontalEndValue;
    private List paintCellElementList = new ArrayList();
    private List paintCellElementRectangleList = new ArrayList();
    private List paginateLineList = new ArrayList();
    private static Background WHITE_Backgorund = ColorBackground.getInstance(Color.WHITE);
    private static Background LIGHT_Backgorund = ColorBackground.getInstance(new Color(250, 250, 250));
    private CellElementPainter painter = new CellElementPainter();
    private Rectangle2D.Double left_col_row_rect = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Rectangle2D.Double top_col_row_rect = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Rectangle2D.Double back_or_selection_rect = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Rectangle2D.Double drag_cell_rect = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Rectangle2D.Double cell_back_rect = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Rectangle2D.Double tmpRectangle = new Rectangle2D.Double(INVALID_INTEGER, INVALID_INTEGER, INVALID_INTEGER, INVALID_INTEGER);

    private void paintBackground(Graphics graphics, Grid grid, Report report, ReportSettings reportSettings) {
        Cloneable cloneable;
        Cloneable cloneable2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.back_or_selection_rect.setRect(0.0, 0.0, this.gridSize.getWidth(), this.gridSize.getHeight());
        if (grid.isEnabled()) {
            graphics2D.setPaint(Color.WHITE);
        } else {
            graphics2D.setPaint(UIManager.getColor("control"));
        }
        GraphHelper.fill(graphics2D, this.back_or_selection_rect);
        this.paperPaintWidth = 0.0;
        this.paperPaintHeight = 0.0;
        if (grid.isShowPaginateLine()) {
            cloneable2 = reportSettings.getPaperSize();
            cloneable = reportSettings.getMargin();
            double d = ((PaperSize)cloneable2).getWidth();
            double d2 = ((PaperSize)cloneable2).getHeight();
            if (reportSettings.getOrientation() == 1) {
                d = ((PaperSize)cloneable2).getHeight();
                d2 = ((PaperSize)cloneable2).getWidth();
            }
            this.paperPaintWidth = (d - ((Margin)cloneable).getLeft() - ((Margin)cloneable).getRight()) * (double)reportSettings.getResolution();
            this.paperPaintHeight = (d2 - ((Margin)cloneable).getTop() - ((Margin)cloneable).getBottom() - reportSettings.getHeaderHeight() - reportSettings.getFooterHeight()) * (double)reportSettings.getResolution();
        }
        if ((cloneable2 = reportSettings.getBackground()) != null) {
            if (grid.isEnabled() && !(cloneable2 instanceof ImageBackground)) {
                cloneable2.paint(graphics2D, this.back_or_selection_rect);
            }
            if (grid.isEditable() && cloneable2 instanceof ImageBackground) {
                if (!grid.isShowPaginateLine()) {
                    cloneable = reportSettings.getPaperSize();
                    Margin margin = reportSettings.getMargin();
                    double d = ((PaperSize)cloneable).getWidth();
                    double d3 = ((PaperSize)cloneable).getHeight();
                    if (reportSettings.getOrientation() == 1 && ((PaperSize)cloneable).getWidth() < ((PaperSize)cloneable).getHeight()) {
                        d = Math.max(((PaperSize)cloneable).getWidth(), ((PaperSize)cloneable).getHeight());
                        d3 = Math.min(((PaperSize)cloneable).getWidth(), ((PaperSize)cloneable).getHeight());
                    } else if (reportSettings.getOrientation() == 0 && ((PaperSize)cloneable).getWidth() > ((PaperSize)cloneable).getHeight()) {
                        d = Math.min(((PaperSize)cloneable).getWidth(), ((PaperSize)cloneable).getHeight());
                        d3 = Math.max(((PaperSize)cloneable).getWidth(), ((PaperSize)cloneable).getHeight());
                    }
                    this.paperPaintWidth = (d - margin.getLeft() - margin.getRight()) * (double)reportSettings.getResolution();
                    this.paperPaintHeight = (d3 - margin.getTop() - margin.getBottom() - reportSettings.getHeaderHeight() - reportSettings.getFooterHeight()) * (double)reportSettings.getResolution();
                }
                cloneable = (ImageBackground)cloneable2;
                int n = this.columnWidthList.getRangeValue(0, this.horizontalValue);
                int n2 = this.rowHeightList.getRangeValue(0, this.verticalValue);
                int n3 = 0;
                while ((double)n3 * this.paperPaintWidth < this.gridSize.getWidth()) {
                    int n4 = 0;
                    while ((double)n4 * this.paperPaintHeight < this.gridSize.getHeight()) {
                        this.back_or_selection_rect.setRect((double)n3 * this.paperPaintWidth, (double)n4 * this.paperPaintHeight, this.paperPaintWidth, this.paperPaintHeight);
                        ((ImageBackground)cloneable).paint2(graphics2D, this.back_or_selection_rect, n, n2);
                        ++n4;
                    }
                    ++n3;
                }
                this.back_or_selection_rect.setRect(0.0, 0.0, this.gridSize.getWidth(), this.gridSize.getHeight());
            }
        }
    }

    private void paintGridLine(Graphics graphics, Grid grid, double d, double d2) {
        int n;
        double d3;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n3 = this.horizontalEndValue;
        int n4 = this.verticalEndValue;
        int n5 = grid.getHorizontalBeginValue();
        int n6 = grid.getVerticalBeginValue();
        Line2D.Double double_ = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        graphics2D.setPaint(grid.getGridLineColor());
        GraphHelper.setStroke(graphics2D, GraphHelper.getStroke(1));
        this.paginateLineList.clear();
        double d4 = 0.0;
        double d5 = 0.0;
        for (n2 = 0; n2 <= n3; ++n2) {
            if (n2 == 0) {
                n2 = n5;
                for (int i = 0; i < n5; ++i) {
                    d3 = this.columnWidthList.get(i);
                    if (!((d5 += d3) >= this.paperPaintWidth)) continue;
                    d5 = d3;
                }
            }
            d3 = this.columnWidthList.get(n2);
            d5 += d3;
            if (grid.isShowPaginateLine() && d5 >= this.paperPaintWidth) {
                this.paginateLineList.add(new Line2D.Double(d4, 0.0, d4, this.gridSize.height));
                d5 = d3;
            }
            d4 += d3;
        }
        d4 = 0.0;
        for (n2 = 0; n2 < this.horizontalEndValue; ++n2) {
            if (n2 == 0) {
                n2 = n5;
            }
            d3 = this.columnWidthList.get(n2);
            if (grid.isShowGridLine()) {
                ((Line2D)double_).setLine(d4, 0.0, d4, d2);
                graphics2D.draw(double_);
            }
            d4 += d3;
        }
        if (grid.isShowGridLine()) {
            graphics2D.setPaint(grid.getGridLineColor());
            GraphHelper.drawLine(graphics2D, d4, 0.0, d4, d2);
        }
        double d6 = 0.0;
        double d7 = 0.0;
        for (n = 0; n <= n4; ++n) {
            if (n == 0) {
                n = n6;
                for (int i = 0; i < n6; ++i) {
                    double d8 = this.rowHeightList.get(i);
                    if (!((d7 += d8) >= this.paperPaintHeight)) continue;
                    d7 = d8;
                }
            }
            double d9 = this.rowHeightList.get(n);
            d7 += d9;
            if (grid.isShowPaginateLine() && d7 >= this.paperPaintHeight) {
                this.paginateLineList.add(new Line2D.Double(0.0, d6, this.gridSize.width, d6));
                d7 = d9;
            }
            d6 += d9;
        }
        d6 = 0.0;
        for (n = 0; n < this.verticalEndValue; ++n) {
            if (n == 0) {
                n = n6;
            }
            double d10 = this.rowHeightList.get(n);
            if (grid.isShowGridLine()) {
                ((Line2D)double_).setLine(0.0, d6, d, d6);
                graphics2D.draw(double_);
            }
            d6 += d10;
        }
        if (grid.isShowGridLine()) {
            graphics2D.setPaint(grid.getGridLineColor());
            GraphHelper.drawLine(graphics2D, 0.0, d6, d, d6);
        }
    }

    private void paintCellElements(Graphics graphics, Grid grid, Report report) {
        GeneralPath generalPath;
        int n;
        Cloneable cloneable;
        Graphics2D graphics2D = (Graphics2D)graphics;
        CellElement cellElement = null;
        ReportPane reportPane = grid.getReportPane();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n2 = gridSelection.getType();
        if (n2 == 0) {
            Rectangle rectangle = gridSelection.getEditRectangle();
            cellElement = report.getCellElement(rectangle.x, rectangle.y);
        }
        int n3 = grid.getHorizontalBeginValue();
        int n4 = grid.getVerticalBeginValue();
        Shape shape = null;
        CellElement cellElement2 = null;
        Iterator iterator = report.intersect(n3, n4, this.horizontalEndValue - n3, this.verticalEndValue - n4);
        double d = this.columnWidthList.getRangeValue(0, this.horizontalValue);
        double d2 = this.rowHeightList.getRangeValue(0, this.verticalValue);
        this.left_col_row_rect.setRect(0.0, 0.0, 0.0, 0.0);
        this.top_col_row_rect.setRect(0.0, 0.0, 0.0, 0.0);
        while (iterator.hasNext()) {
            CellExpandAttr cellExpandAttr;
            cellElement2 = (CellElement)iterator.next();
            if (cellElement2 == null) continue;
            this.calculateForcedPagingOfCellElement(reportPane, cellElement2, d, d2);
            cloneable = cellElement2.getCellGUIAttr();
            if (cloneable == null) {
                cloneable = CellGUIAttr.DEFAULT_CELLGUIATTR;
            }
            if (cellElement == cellElement2 && (cellExpandAttr = cellElement2.getCellExpandAttr()) != null) {
                ColumnRow columnRow;
                ColumnRow columnRow2 = cellExpandAttr.getLeftParentColumnRow();
                if (ColumnRow.validate(columnRow2)) {
                    this.caculateScrollVisibleBounds(this.left_col_row_rect, columnRow2.getColumn(), columnRow2.getRow(), 1, 1);
                }
                if (ColumnRow.validate(columnRow = cellExpandAttr.getUpParentColumnRow())) {
                    this.caculateScrollVisibleBounds(this.top_col_row_rect, columnRow.getColumn(), columnRow.getRow(), 1, 1);
                }
            }
            this.caculateScrollVisibleBounds(this.tmpRectangle, cellElement2.getColumn(), cellElement2.getRow(), cellElement2.getColumnSpan(), cellElement2.getRowSpan());
            shape = graphics2D.getClip();
            graphics2D.clip(this.tmpRectangle);
            graphics2D.translate(this.tmpRectangle.getX() + 1.0, this.tmpRectangle.getY() + 1.0);
            this.cell_back_rect.setRect(0.0, 0.0, this.tmpRectangle.getWidth() - 1.0, this.tmpRectangle.getHeight() - 1.0);
            if (cellElement2.getColumnSpan() > 1 || cellElement2.getRowSpan() > 1) {
                WHITE_Backgorund.paint(graphics2D, this.cell_back_rect);
            }
            this.paintCellElementList.add(cellElement2);
            this.paintCellElementRectangleList.add(this.tmpRectangle.clone());
            n = (int)this.tmpRectangle.getWidth();
            int n5 = (int)this.tmpRectangle.getHeight();
            this.painter.paintBackground(graphics2D, report, cellElement2, n, n5);
            this.painter.paintContent(graphics2D, report, cellElement2, n, n5);
            graphics2D.translate(-this.tmpRectangle.getX() - 1.0, -this.tmpRectangle.getY() - 1.0);
            graphics2D.setClip(shape);
        }
        for (n = 0; n < this.paintCellElementList.size(); ++n) {
            cellElement2 = (CellElement)this.paintCellElementList.get(n);
            cloneable = (Rectangle2D.Double)this.paintCellElementRectangleList.get(n);
            CellGUIAttr cellGUIAttr = cellElement2.getCellGUIAttr();
            if (cellGUIAttr == null) {
                cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
            }
            graphics2D.translate(((Rectangle2D.Double)cloneable).getX(), ((Rectangle2D.Double)cloneable).getY());
            this.painter.paintBorder(graphics2D, report, cellElement2, (int)((Rectangle2D.Double)cloneable).getWidth(), (int)((Rectangle2D.Double)cloneable).getHeight());
            graphics2D.translate(-((Rectangle2D.Double)cloneable).getX(), -((Rectangle2D.Double)cloneable).getY());
        }
        if (GridUI.validate(this.left_col_row_rect) && this.left_col_row_rect.getHeight() > 5.0) {
            graphics2D.setPaint(Color.BLUE);
            double d3 = this.left_col_row_rect.getX() + 4.0;
            double d4 = this.left_col_row_rect.getY() + this.left_col_row_rect.getHeight() / 2.0;
            GraphHelper.drawLine(graphics2D, d3, d4 - 5.0, d3, d4 + 5.0);
            generalPath = new GeneralPath(0, 3);
            generalPath.moveTo((float)d3, (float)d4 + 5.0f);
            generalPath.lineTo((float)d3 + 3.0f, (float)d4 + 5.0f - 4.0f);
            generalPath.lineTo((float)d3 - 2.0f, (float)d4 + 5.0f - 4.0f);
            GraphHelper.fill(graphics2D, generalPath);
        }
        if (GridUI.validate(this.top_col_row_rect) && this.top_col_row_rect.getWidth() > 5.0) {
            graphics2D.setPaint(Color.BLUE);
            double d5 = this.top_col_row_rect.getX() + this.top_col_row_rect.getWidth() / 2.0;
            double d6 = this.top_col_row_rect.getY() + 4.0;
            GraphHelper.drawLine(graphics2D, d5 - 5.0, d6, d5 + 5.0, d6);
            generalPath = new GeneralPath(0, 3);
            generalPath.moveTo((float)d5 + 5.0f, (float)d6);
            generalPath.lineTo((float)d5 + 5.0f - 4.0f, (float)d6 + 3.0f);
            generalPath.lineTo((float)d5 + 5.0f - 4.0f, (float)d6 - 3.0f);
            GraphHelper.fill(graphics2D, generalPath);
        }
    }

    private void paintPaginateLines(Graphics graphics, Grid grid) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.paginateLineList.size() > 0) {
            int n;
            int n2;
            Line2D line2D = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
            for (n2 = 0; n2 < this.paginateLineList.size(); ++n2) {
                line2D = (Line2D)this.paginateLineList.get(n2);
                for (n = n2 + 1; n < this.paginateLineList.size(); ++n) {
                    Line2D line2D2 = (Line2D)this.paginateLineList.get(n);
                    if (line2D2.getX1() != line2D.getX1() || line2D2.getX2() != line2D.getX2() || line2D2.getY1() != line2D.getY1() || line2D2.getY2() != line2D.getY2()) continue;
                    this.paginateLineList.remove(n);
                }
            }
            graphics2D.setPaint(grid.getPaginationLineColor());
            graphics2D.setXORMode(Utils.getXORColor(grid.getPaginationLineColor()));
            GraphHelper.setStroke(graphics2D, GraphHelper.getStroke(9));
            n = this.paginateLineList.size();
            for (n2 = 0; n2 < n; ++n2) {
                graphics2D.draw((Shape)this.paginateLineList.get(n2));
            }
            graphics2D.setPaintMode();
        }
    }

    private void paintGridSelection(Graphics graphics, Grid grid, Report report) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        GridSelection gridSelection = grid.getReportPane().getGridSelection();
        int n = gridSelection.getType();
        if (n == 0 && grid.isCellSelectable()) {
            Object object;
            Rectangle rectangle = gridSelection.getEditRectangle();
            int n2 = gridSelection.getCellRectangleCount();
            Area area = new Area();
            Area area2 = new Area();
            this.caculateScrollVisibleBounds(this.tmpRectangle, rectangle);
            if (GridUI.validate(this.tmpRectangle)) {
                area2.add(new Area(this.tmpRectangle));
            }
            if (n2 == 1) {
                object = gridSelection.getFirstCellRectangle();
                this.caculateScrollVisibleBounds(this.tmpRectangle, (Rectangle)object);
                if (GridUI.validate(this.tmpRectangle)) {
                    Object object2;
                    double d = this.tmpRectangle.getX();
                    double d2 = this.tmpRectangle.getY();
                    double d3 = this.tmpRectangle.getWidth();
                    double d4 = this.tmpRectangle.getHeight();
                    area = new Area(this.tmpRectangle);
                    area.add(area2);
                    area.exclusiveOr(area2);
                    if (((Rectangle)object).x != rectangle.x || ((Rectangle)object).y != rectangle.y || ((Rectangle)object).width != rectangle.width || ((Rectangle)object).height != rectangle.height) {
                        object2 = graphics2D.getComposite();
                        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                        graphics2D.setPaint(grid.getSelectedBackground());
                        GraphHelper.fill(graphics2D, area);
                        graphics2D.setComposite((Composite)object2);
                    }
                    this.back_or_selection_rect.setRect(d - 1.0, d2 - 1.0, d3 + 3.0, d4 + 3.0);
                    object2 = new Area(this.back_or_selection_rect);
                    this.back_or_selection_rect.setRect(d + 2.0, d2 + 2.0, d3 - 3.0, d4 - 3.0);
                    ((Area)object2).exclusiveOr(new Area(this.back_or_selection_rect));
                    this.back_or_selection_rect.setRect(d + d3 - 1.0, d2 + d4 - 3.0, 3.0, 1.0);
                    ((Area)object2).exclusiveOr(new Area(this.back_or_selection_rect));
                    this.back_or_selection_rect.setRect(d + d3 - 3.0, d2 + d4 - 1.0, 1.0, 3.0);
                    ((Area)object2).exclusiveOr(new Area(this.back_or_selection_rect));
                    this.back_or_selection_rect.setRect(d + d3 - 2.0, d2 + d4 - 2.0, 5.0, 5.0);
                    ((Area)object2).add(new Area(this.back_or_selection_rect));
                    graphics2D.setXORMode(Utils.getXORColor(grid.getSelectedBorderLineColor()));
                    graphics2D.setPaint(grid.getSelectedBorderLineColor());
                    GraphHelper.fill(graphics2D, (Shape)object2);
                    graphics2D.setPaintMode();
                }
            } else {
                area = new Area();
                for (int i = 0; i < n2; ++i) {
                    Rectangle rectangle2 = gridSelection.getCellRectangle(i);
                    this.caculateScrollVisibleBounds(this.tmpRectangle, rectangle2);
                    if (!GridUI.validate(this.tmpRectangle)) continue;
                    area.add(new Area(this.tmpRectangle));
                }
                area.add(area2);
                area.exclusiveOr(area2);
                object = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                graphics2D.setPaint(grid.getSelectedBackground());
                GraphHelper.fill(graphics2D, area);
                graphics2D.setComposite((Composite)object);
                graphics2D.setPaint(Color.blue);
                if (area2 != null) {
                    GraphHelper.draw(graphics2D, area2);
                }
            }
            if (report.getCellValue(rectangle.x, rectangle.y) instanceof Formula) {
                object = (Formula)report.getCellValue(rectangle.x, rectangle.y);
                String string = ((Formula)object).getContent();
                ColumnRow[] columnRowArray = new ColumnRow[]{};
                try {
                    columnRowArray = Calculator.relatedColumnRowArray(string.substring(1));
                }
                catch (ANTLRException aNTLRException) {
                    // empty catch block
                }
                Area area3 = null;
                for (int i = 0; i < columnRowArray.length; ++i) {
                    ColumnRow columnRow = columnRowArray[i];
                    int n3 = 1;
                    int n4 = 1;
                    CellElement cellElement = report.getCellElement(columnRow.getColumn(), columnRow.getRow());
                    if (cellElement != null) {
                        n3 = cellElement.getColumnSpan();
                        n4 = cellElement.getRowSpan();
                        if (n3 > 1 || n4 > 1) {
                            columnRow = ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow());
                        }
                    }
                    this.caculateScrollVisibleBounds(this.tmpRectangle, columnRow.getColumn(), columnRow.getRow(), n3, n4);
                    if (!GridUI.validate(this.tmpRectangle)) continue;
                    area3 = new Area(new Rectangle2D.Double(this.tmpRectangle.getX(), this.tmpRectangle.getY(), this.tmpRectangle.getWidth(), this.tmpRectangle.getHeight()));
                    area3.exclusiveOr(new Area(new Rectangle2D.Double(this.tmpRectangle.getX() + 1.0, this.tmpRectangle.getY() + 1.0, this.tmpRectangle.getWidth() - 2.0, this.tmpRectangle.getHeight() - 2.0)));
                    area3.add(new Area(new Rectangle2D.Double(this.tmpRectangle.getX(), this.tmpRectangle.getY(), 3.0, 3.0)));
                    area3.add(new Area(new Rectangle2D.Double(this.tmpRectangle.getX() + this.tmpRectangle.getWidth() - 3.0, this.tmpRectangle.getY(), 3.0, 3.0)));
                    area3.add(new Area(new Rectangle2D.Double(this.tmpRectangle.getX(), this.tmpRectangle.getY() + this.tmpRectangle.getHeight() - 3.0, 3.0, 3.0)));
                    area3.add(new Area(new Rectangle2D.Double(this.tmpRectangle.getX() + this.tmpRectangle.getWidth() - 3.0, this.tmpRectangle.getY() + this.tmpRectangle.getHeight() - 3.0, 3.0, 3.0)));
                    graphics2D.setPaint(new Color((i + 2) * 50 % 256, (i + 1) * 50 % 256, i * 50 % 256));
                    if (area3 == null) continue;
                    GraphHelper.fill(graphics2D, area3);
                }
            }
        }
    }

    private void paintFloatElements(Graphics graphics, Grid grid, Report report) {
        int n;
        int n2;
        int n3;
        int n4;
        FloatElement floatElement;
        Graphics2D graphics2D = (Graphics2D)graphics;
        GridSelection gridSelection = grid.getReportPane().getGridSelection();
        int n5 = gridSelection.getType();
        Iterator iterator = report.floatIterator();
        while (iterator.hasNext()) {
            floatElement = (FloatElement)iterator.next();
            n4 = floatElement.getRow();
            n3 = floatElement.getColumn();
            n2 = this.rowHeightList.getValueIndex((int)((double)(this.rowHeightList.getRangeValueFromZero(n4) + floatElement.getTopDistance()) + floatElement.getSize().getHeight()));
            if (n4 < this.verticalValue && n4 > this.verticalEndValue && n2 < this.verticalValue && n2 > this.verticalValue) continue;
            n = this.columnWidthList.getRangeValue(this.horizontalValue, n3) + floatElement.getLeftDistance();
            int n6 = this.rowHeightList.getRangeValue(this.verticalValue, n4) + floatElement.getTopDistance();
            Dimension dimension = floatElement.getSize();
            graphics2D.translate(n, n6);
            PaintUtils.paintFloatElement(graphics2D, floatElement, (int)((Dimension2D)dimension).getWidth(), (int)((Dimension2D)dimension).getHeight());
            graphics2D.translate(-n, -n6);
        }
        if (n5 == 1) {
            iterator = report.floatIterator();
            while (iterator.hasNext()) {
                floatElement = (FloatElement)iterator.next();
                if (!gridSelection.containFloatName(floatElement.getName())) continue;
                n4 = this.columnWidthList.getRangeValue(this.horizontalValue, floatElement.getColumn()) + floatElement.getLeftDistance();
                n3 = this.rowHeightList.getRangeValue(this.verticalValue, floatElement.getRow()) + floatElement.getTopDistance();
                n2 = (int)((double)n4 + floatElement.getSize().getWidth());
                n = (int)((double)n3 + floatElement.getSize().getHeight());
                GraphHelper.setStroke(graphics2D, GraphHelper.getStroke(1));
                Rectangle2D[] rectangle2DArray = new Rectangle2D[]{new Rectangle2D.Double(n4 - 3, n3 - 3, 6.0, 6.0), new Rectangle2D.Double((n4 + n2) / 2 - 3, n3 - 3, 6.0, 6.0), new Rectangle2D.Double(n2 - 3, n3 - 3, 6.0, 6.0), new Rectangle2D.Double(n2 - 3, (n3 + n) / 2 - 3, 6.0, 6.0), new Rectangle2D.Double(n2 - 3, n - 3, 6.0, 6.0), new Rectangle2D.Double((n4 + n2) / 2 - 3, n - 3, 6.0, 6.0), new Rectangle2D.Double(n4 - 3, n - 3, 6.0, 6.0), new Rectangle2D.Double(n4 - 3, (n3 + n) / 2 - 3, 6.0, 6.0)};
                for (int i = 0; i < rectangle2DArray.length; ++i) {
                    graphics2D.setPaint(Utils.getXORColor(grid.getSelectedBorderLineColor()));
                    GraphHelper.fill(graphics2D, rectangle2DArray[i]);
                    graphics2D.setPaint(grid.getSelectedBorderLineColor());
                    GraphHelper.draw(graphics2D, rectangle2DArray[i]);
                }
            }
        }
    }

    private void paintDragCellBorder(Graphics graphics, Grid grid) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if ((grid.getDragType() == GridUtils.DRAG_CELLSELECTION || grid.getDragType() == GridUtils.Drag_CellSelection_BottomRight_Corner) && grid.getDragRectangle() != null) {
            this.caculateScrollVisibleBounds(this.drag_cell_rect, grid.getDragRectangle());
            graphics2D.setPaint(Color.GRAY);
            GraphHelper.draw(graphics2D, this.drag_cell_rect, 5);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        if (!(jComponent instanceof Grid)) {
            throw new IllegalArgumentException("The component c to paint must be a Grid!");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Grid grid = (Grid)jComponent;
        ReportPane reportPane = grid.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        ReportSettings reportSettings = ReportUtils.getReportSettings(templateReport);
        this.rowHeightList = ReportHelper.getRowHeightList(templateReport);
        this.columnWidthList = ReportHelper.getColumnWidthList(templateReport);
        this.verticalValue = grid.getVerticalValue();
        int n2 = grid.getVerticalExtent();
        this.horizontalValue = grid.getHorizontalValue();
        int n3 = grid.getHorizontalExtent();
        int n4 = grid.getVerticalBeginValue();
        n4 = this.verticalValue;
        grid.setVerticalBeinValue(n4);
        int n5 = grid.getHorizontalBeginValue();
        n5 = this.horizontalValue;
        grid.setHorizontalBeginValue(n5);
        this.gridSize = grid.getSize();
        this.verticalEndValue = this.verticalValue + n2 + 1;
        this.horizontalEndValue = this.horizontalValue + n3 + 1;
        double d = this.gridSize.getWidth();
        double d2 = this.gridSize.getHeight();
        if (!reportPane.isRowEndless()) {
            n = templateReport.getRowCount();
            this.verticalEndValue = Math.min(this.verticalEndValue, n);
            d2 = this.rowHeightList.getRangeValue(this.verticalValue, Math.max(0, n));
        }
        if (!reportPane.isColumnEndless()) {
            n = templateReport.getColumnCount();
            this.horizontalEndValue = Math.min(this.horizontalEndValue, n);
            d = this.columnWidthList.getRangeValue(this.horizontalValue, Math.max(0, n));
        }
        this.gridSize = grid.getSize();
        this.paintBackground(graphics2D, grid, templateReport, reportSettings);
        this.paintGridLine(graphics2D, grid, d, d2);
        this.paintCellElementList.clear();
        this.paintCellElementRectangleList.clear();
        this.paintCellElements(graphics2D, grid, templateReport);
        this.paintPaginateLines(graphics2D, grid);
        this.paintGridSelection(graphics2D, grid, templateReport);
        this.paintFloatElements(graphics2D, grid, templateReport);
        this.paintDragCellBorder(graphics2D, grid);
        grid.ajustEditorComponentBounds(reportPane);
    }

    public void caculateScrollVisibleBounds(Rectangle2D.Double double_, CellElement cellElement) {
        this.caculateScrollVisibleBounds(double_, cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
    }

    public void caculateScrollVisibleBounds(Rectangle2D.Double double_, Rectangle rectangle) {
        this.caculateScrollVisibleBounds(double_, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void caculateScrollVisibleBounds(Rectangle2D.Double double_, int n, int n2, int n3, int n4) {
        if (n > this.horizontalEndValue || n2 > this.verticalEndValue || n + n3 <= this.horizontalValue || n2 + n4 <= this.verticalValue) {
            double_.x = INVALID_INTEGER;
        } else {
            double_.x = this.columnWidthList.getRangeValue(this.horizontalValue, n);
            double_.y = this.rowHeightList.getRangeValue(this.verticalValue, n2);
            double_.width = this.columnWidthList.getRangeValue(n, n + n3);
            double_.height = this.rowHeightList.getRangeValue(n2, n2 + n4);
        }
    }

    public static boolean validate(Rectangle2D rectangle2D) {
        return rectangle2D != null && rectangle2D.getX() != (double)INVALID_INTEGER;
    }

    public void calculateForcedPagingOfCellElement(ReportPane reportPane, CellElement cellElement, double d, double d2) {
        double d3;
        double d4;
        if (cellElement == null) {
            return;
        }
        CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
        if (cellPageAttr == null) {
            return;
        }
        TemplateReport templateReport = reportPane.getEditingReport();
        DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
        DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(templateReport);
        int n = reportPane.getSize().width;
        int n2 = reportPane.getSize().height;
        if (cellPageAttr.isPageAfterColumn()) {
            d4 = (double)dynamicValueList.getRangeValueFromZero(cellElement.getColumn() + cellElement.getColumnSpan()) - d;
            this.paginateLineList.add(new Line2D.Double(d4, 0.0, d4, n2));
        }
        if (cellPageAttr.isPageBeforeColumn()) {
            d4 = (double)dynamicValueList.getRangeValueFromZero(cellElement.getColumn()) - d;
            this.paginateLineList.add(new Line2D.Double(d4, 0.0, d4, n2));
        }
        if (cellPageAttr.isPageAfterRow()) {
            d3 = (double)dynamicValueList2.getRangeValueFromZero(cellElement.getRow() + cellElement.getRowSpan()) - d2;
            this.paginateLineList.add(new Line2D.Double(0.0, d3, n, d3));
        }
        if (cellPageAttr.isPageBeforeRow()) {
            d3 = (double)dynamicValueList2.getRangeValueFromZero(cellElement.getRow()) - d2;
            this.paginateLineList.add(new Line2D.Double(0.0, d3, n, d3));
        }
    }
}

