/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.GraphHelper;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.ReportPaneEditState;
import com.fr.cell.core.layout.LayoutFactory;
import com.fr.cell.undo.UndoState;
import com.fr.report.AbstractFineBook;
import com.fr.report.TemplateReport;
import com.fr.report.TemplateWorkBook;
import com.fr.report.WorkBook;
import com.fr.report.WorkSheet;
import com.fr.report.core.SheetUtils;
import com.fr.util.Consts;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JWorkBook
extends ReportPane {
    private WorkBook book;
    private int selectedIndex;
    private List reportPaneEditStateList = new ArrayList();
    private int scrollIndex = -1;
    private JSplitPane splitpane;
    private TabPane tabPane;
    private JButton firstButton;
    private JButton leftButton;
    private JButton rightButton;
    private JButton lastButton;
    private ActionListener reportListItemListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = Integer.parseInt(string);
            JWorkBook.this.getGrid().stopEditing();
            JWorkBook.this.setSelectedIndex(n);
            JWorkBook.this.tabPane.repaint();
        }
    };

    public JWorkBook() {
        this(new WorkBook(new WorkSheet()));
    }

    public JWorkBook(WorkBook workBook) {
        this.setWorkBook(workBook, 0);
        this.undoRecord();
    }

    public TemplateWorkBook getTemplate() {
        return this.getWorkBook();
    }

    public WorkBook getWorkBook() {
        return this.book;
    }

    public void setWorkBook(WorkBook workBook) {
        this.setWorkBook(workBook, this.getSelectedIndex());
    }

    public void setWorkBook(WorkBook workBook, int n) {
        if (workBook == null) {
            return;
        }
        if (workBook.getReportCount() == 0) {
            workBook.addReport(new WorkSheet());
        }
        this.book = workBook;
        this.setSelectedIndex(n);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.getWorkBook().getReportCount()) {
            n = this.getWorkBook().getReportCount() - 1;
        }
        this.selectedIndex = n;
        this.setEditingReport(this.getWorkBook().getTemplateReport(n));
    }

    public void setEditingReport(TemplateReport templateReport) {
        if (templateReport == null) {
            return;
        }
        this.scrollIndex = 0;
        super.setEditingReport(templateReport);
    }

    protected JComponent horizontalBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(LayoutFactory.createBorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jPanel.add((Component)jToolBar, "West");
        jToolBar.setLayout(new GridLayout(1, 4, 0, 0));
        this.firstButton = new JButton(BaseUtils.readIcon("/com/fr/cell/images/tabscroll/first.png"));
        this.leftButton = new JButton(BaseUtils.readIcon("/com/fr/cell/images/tabscroll/left.png"));
        this.rightButton = new JButton(BaseUtils.readIcon("/com/fr/cell/images/tabscroll/right.png"));
        this.lastButton = new JButton(BaseUtils.readIcon("/com/fr/cell/images/tabscroll/last.png"));
        jToolBar.add(this.firstButton);
        jToolBar.add(this.leftButton);
        jToolBar.add(this.rightButton);
        jToolBar.add(this.lastButton);
        this.firstButton.addMouseListener(this.createMouseListener());
        this.leftButton.addMouseListener(this.createMouseListener());
        this.rightButton.addMouseListener(this.createMouseListener());
        this.lastButton.addMouseListener(this.createMouseListener());
        Dimension dimension = new Dimension(18, 18);
        this.firstButton.setPreferredSize(dimension);
        this.leftButton.setPreferredSize(dimension);
        this.rightButton.setPreferredSize(dimension);
        this.lastButton.setPreferredSize(dimension);
        this.tabPane = new TabPane();
        jPanel.add((Component)this.tabPane, "Center");
        jPanel.setPreferredSize(new Dimension(480, 18));
        this.splitpane = new JSplitPane(1, jPanel, this.horScrollBar);
        this.splitpane.setBorder(null);
        this.splitpane.setDividerSize(6);
        this.splitpane.setDividerLocation(this.splitpane.getPreferredSize().width * 3 / 4);
        return this.splitpane;
    }

    public void fireReportDataChanged() {
        if (this.isSupportDefaultParentCalculate()) {
            SheetUtils.calculateDefaultParent(this.getEditingReport());
        }
        this.fireReportDataChangeListener();
        this.repaint();
    }

    protected UndoState createUndoState() {
        if (this.getWorkBook() == null) {
            return null;
        }
        GridSelection gridSelection = null;
        try {
            gridSelection = (GridSelection)this.getGridSelection().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
        int n = this.getGrid().getVerticalValue();
        int n2 = this.getGrid().getHorizontalValue();
        return new WorkBookState(this, gridSelection, n, n2, this.isUndoCacheable());
    }

    private MouseListener createMouseListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Serializable serializable;
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    JWorkBook.this.getGrid().stopEditing();
                    serializable = JWorkBook.this.getWorkBook();
                    int n = ((AbstractFineBook)serializable).getReportCount();
                    if (n < 2) {
                        return;
                    }
                    Object object = mouseEvent.getSource();
                    if (object.equals(JWorkBook.this.firstButton)) {
                        JWorkBook.this.scrollIndex = 0;
                    } else if (object.equals(JWorkBook.this.leftButton)) {
                        if (JWorkBook.this.selectedIndex > 0) {
                            JWorkBook.this.scrollIndex = --JWorkBook.this.selectedIndex;
                        }
                    } else if (object.equals(JWorkBook.this.rightButton)) {
                        if (JWorkBook.this.selectedIndex < n - 1) {
                            JWorkBook.this.scrollIndex = ++JWorkBook.this.selectedIndex;
                        }
                    } else if (object.equals(JWorkBook.this.lastButton)) {
                        JWorkBook.this.scrollIndex = n - 1;
                    }
                    JWorkBook.this.setSelectedIndex(JWorkBook.this.scrollIndex);
                    JWorkBook.this.tabPane.repaint();
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    serializable = new JPopupMenu();
                    WorkBook workBook = JWorkBook.this.getWorkBook();
                    int n = workBook.getReportCount();
                    for (int i = 0; i < n; ++i) {
                        String string = workBook.getReportName(i);
                        JMenuItem jMenuItem = new JMenuItem(string);
                        ((JPopupMenu)serializable).add(jMenuItem);
                        jMenuItem.addActionListener(JWorkBook.this.reportListItemListener);
                        jMenuItem.setActionCommand("" + i);
                    }
                    Dimension dimension = ((JComponent)serializable).getPreferredSize();
                    ((JPopupMenu)serializable).show((Component)mouseEvent.getSource(), mouseEvent.getX() + 1, mouseEvent.getY() - 1 - dimension.height);
                }
            }
        };
        return mouseAdapter;
    }

    protected void changeBackUpTempalte(TemplateWorkBook templateWorkBook) {
    }

    public TemplateWorkBook getBackUpTempalte() {
        return null;
    }

    public void setBackUpTemplate(TemplateWorkBook templateWorkBook) {
    }

    private class TabPane
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        boolean isBlank;
        private int[] xyPressedCoordinate = new int[]{0, 0};
        private int[] xyReleasedCoordinate = new int[]{0, 0};
        private int[] widthArray;
        private List linearray = new ArrayList();
        private boolean isReleased = false;

        public TabPane() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.linearray.add(mouseEvent.getPoint());
            this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void paintComponent(Graphics graphics) {
            Object[] objectArray;
            int n;
            int n2;
            int n3;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontMetrics fontMetrics = GraphHelper.getFontMetrics(this.getFont());
            double d = 0.0;
            int n4 = fontMetrics.charWidth('M');
            int n5 = fontMetrics.getAscent();
            double d2 = this.getSize().getHeight() - 1.0;
            WorkBook workBook = JWorkBook.this.getWorkBook();
            this.widthArray = new int[workBook.getReportCount()];
            for (n3 = 0; n3 < workBook.getReportCount(); ++n3) {
                String string = workBook.getReportName(n3);
                this.widthArray[n3] = fontMetrics.stringWidth(string) + n4 * 2 - 1;
            }
            n3 = JWorkBook.this.getSelectedIndex();
            if (JWorkBook.this.scrollIndex >= 0 && JWorkBook.this.scrollIndex < workBook.getReportCount()) {
                int n6 = workBook.getReportCount();
                for (n2 = JWorkBook.this.scrollIndex; n2 < n6; ++n2) {
                    String string = workBook.getReportName(n2);
                    Color color = n2 == n3 ? UIManager.getColor("TabbedPane.highlight") : UIManager.getColor("TabbedPane.background");
                    n = fontMetrics.stringWidth(string) + n4 * 2 - 1;
                    int n7 = 6;
                    objectArray = new double[]{d, d, d + (double)n7, d + (double)n, d + (double)n};
                    double[] dArray = new double[]{0.0, d2 - (double)n7, d2, d2, 0.0};
                    graphics2D.setPaint(color);
                    GeneralPath generalPath = new GeneralPath(0, objectArray.length);
                    generalPath.moveTo((float)objectArray[0], (float)dArray[0]);
                    for (int i = 1; i < objectArray.length; ++i) {
                        generalPath.lineTo((float)objectArray[i], (float)dArray[i]);
                    }
                    generalPath.closePath();
                    graphics2D.fill(generalPath);
                    graphics2D.setPaint(UIManager.getColor("TabbedPane.darkShadow"));
                    if (n2 == JWorkBook.this.scrollIndex) {
                        graphics2D.draw(new Line2D.Double(objectArray[0], dArray[0], objectArray[1], dArray[1]));
                    }
                    graphics2D.draw(new Line2D.Double(objectArray[1], dArray[1], objectArray[2], dArray[2]));
                    graphics2D.draw(new Line2D.Double(objectArray[2], dArray[2], objectArray[3], dArray[3]));
                    graphics2D.draw(new Line2D.Double(objectArray[3], dArray[3], objectArray[4], dArray[4]));
                    if (n2 != n3) {
                        graphics2D.draw(new Line2D.Double(objectArray[4], dArray[4], objectArray[0], dArray[0]));
                    }
                    if (n2 != n3) {
                        graphics2D.setPaint(UIManager.getColor("TabbedPane.selected"));
                        double[] dArray2 = new double[]{d, d, d + (double)n7};
                        double[] dArray3 = new double[]{1.0, d2 - (double)n7 - 1.0, d2 - 1.0};
                        if (n2 == JWorkBook.this.scrollIndex) {
                            dArray2[0] = dArray2[0] + 1.0;
                            dArray2[1] = dArray2[1] + 1.0;
                        }
                        graphics2D.draw(new Line2D.Double(dArray2[0], dArray3[0], dArray2[1], dArray3[1]));
                        graphics2D.draw(new Line2D.Double(dArray2[1], dArray3[1], dArray2[2], dArray3[2]));
                    }
                    graphics2D.setPaint(this.getForeground());
                    graphics2D.drawString(string, (int)d + n4, n5);
                    d += (double)(n + 1);
                }
            }
            graphics2D.setPaint(UIManager.getColor("TabbedPane.darkShadow"));
            graphics2D.draw(new Line2D.Double(d, 0.0, this.getSize().getWidth(), 0.0));
            if (!this.linearray.isEmpty()) {
                graphics2D.setPaint(UIManager.getColor("TabbedPane.darkShadow"));
                Point point = (Point)this.linearray.get(this.linearray.size() - 1);
                n2 = this.getPressedXY()[0];
                int n8 = this.widthArray[n3];
                int n9 = 0;
                for (n = 0; n < n3; ++n) {
                    n9 += this.widthArray[n];
                }
                n = n2 - n9;
                int[] nArray = new int[]{(int)point.getX() - n, (int)point.getX() - n, (int)point.getX() + 5 - n, (int)point.getX() - n + n8, (int)point.getX() + n8 - n};
                objectArray = new int[]{0, (int)d2 * 2 / 3, (int)d2, (int)d2, 0};
                graphics2D.drawPolygon(nArray, (int[])objectArray, 5);
                graphics2D.setPaint(this.getForeground());
                graphics2D.drawString(workBook.getReportName(n3), (int)point.getX() - n + n4, n5);
            }
            if (this.isReleased) {
                this.linearray.clear();
            }
        }

        public int[] getPressedXY() {
            return this.xyPressedCoordinate;
        }

        public void setPressedXY(int n, int n2) {
            this.xyPressedCoordinate[0] = n;
            this.xyPressedCoordinate[1] = n2;
        }

        public int[] getReleasedXY() {
            return this.xyReleasedCoordinate;
        }

        public void setReleasedXY(int n, int n2) {
            this.xyReleasedCoordinate[0] = n;
            this.xyReleasedCoordinate[1] = n2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            WorkBook workBook = JWorkBook.this.getWorkBook();
            if (JWorkBook.this.scrollIndex < 0 || JWorkBook.this.scrollIndex >= workBook.getReportCount()) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.setPressedXY(n, n2);
            this.isBlank = true;
            FontMetrics fontMetrics = GraphHelper.getFontMetrics(this.getFont());
            int n3 = 0;
            int n4 = fontMetrics.charWidth('M');
            int n5 = workBook.getReportCount();
            if (JWorkBook.this.reportPaneEditStateList.size() < n5) {
                for (int i = n5 - JWorkBook.this.reportPaneEditStateList.size(); i >= 0; --i) {
                    JWorkBook.this.reportPaneEditStateList.add(new ReportPaneEditState());
                }
            }
            ReportPaneEditState reportPaneEditState = (ReportPaneEditState)JWorkBook.this.reportPaneEditStateList.get(JWorkBook.this.selectedIndex);
            reportPaneEditState.backupJWorkBook(JWorkBook.this);
            for (int i = JWorkBook.this.scrollIndex; i < n5; ++i) {
                object = workBook.getReportName(i);
                int n6 = fontMetrics.stringWidth((String)object) + n4 * 2;
                if (n >= n3 && n < n3 + n6) {
                    JWorkBook.this.getGrid().stopEditing();
                    JWorkBook.this.setSelectedIndex(i);
                    reportPaneEditState = (ReportPaneEditState)JWorkBook.this.reportPaneEditStateList.get(i);
                    reportPaneEditState.popupJWorkBook(JWorkBook.this);
                    reportPaneEditState.backupJWorkBook(JWorkBook.this);
                    this.isBlank = false;
                    JWorkBook.this.repaint(40L);
                    break;
                }
                n3 += n6;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                object = new JMenuItem(Inter.getLocText("Insert"));
                ((AbstractButton)object).setIcon(BaseUtils.readIcon("/com/fr/cell/images/control/add.png"));
                jPopupMenu.add((JMenuItem)object);
                ((AbstractButton)object).addActionListener(new ActionListener(this){
                    private final /* synthetic */ TabPane this$1;
                    {
                        this.this$1 = tabPane;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        WorkBook workBook = TabPane.access$900(this.this$1).getWorkBook();
                        int n = workBook.getReportCount();
                        WorkSheet workSheet = new WorkSheet();
                        ReportPaneEditState reportPaneEditState = (ReportPaneEditState)JWorkBook.access$800(TabPane.access$900(this.this$1)).get(TabPane.access$900(this.this$1).getSelectedIndex());
                        reportPaneEditState.backupJWorkBook(TabPane.access$900(this.this$1));
                        if (this.this$1.isBlank) {
                            workBook.addReport(n, (TemplateReport)workSheet);
                            TabPane.access$900(this.this$1).setSelectedIndex(n);
                            reportPaneEditState = new ReportPaneEditState();
                            JWorkBook.access$800(TabPane.access$900(this.this$1)).add(reportPaneEditState);
                            reportPaneEditState.popupJWorkBook(TabPane.access$900(this.this$1));
                            reportPaneEditState.backupJWorkBook(TabPane.access$900(this.this$1));
                        } else {
                            workBook.addReport(TabPane.access$900(this.this$1).getSelectedIndex(), (TemplateReport)workSheet);
                            JWorkBook.access$800(TabPane.access$900(this.this$1)).add(TabPane.access$900(this.this$1).getSelectedIndex(), reportPaneEditState);
                            reportPaneEditState.popupJWorkBook(TabPane.access$900(this.this$1));
                            reportPaneEditState.backupJWorkBook(TabPane.access$900(this.this$1));
                        }
                        TabPane.access$900(this.this$1).validate();
                        TabPane.access$900(this.this$1).repaint(100L);
                    }
                });
                JMenuItem jMenuItem = new JMenuItem(Inter.getLocText("Remove"));
                jMenuItem.setIcon(BaseUtils.readIcon("/com/fr/cell/images/control/remove.png"));
                jPopupMenu.add(jMenuItem);
                if (this.isBlank || workBook.getReportCount() <= 1) {
                    jMenuItem.setEnabled(false);
                }
                jMenuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TabPane this$1;
                    {
                        this.this$1 = tabPane;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        WorkBook workBook = TabPane.access$900(this.this$1).getWorkBook();
                        int n = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(TabPane.access$900(this.this$1)), Inter.getLocText("Des-Remove_WorkSheet"), Consts.APP_NAME, 2);
                        if (n == 0) {
                            int n2 = TabPane.access$900(this.this$1).getSelectedIndex();
                            workBook.removeReport(n2);
                            TabPane.access$900(this.this$1).setSelectedIndex(n2 > 0 ? n2 - 1 : 0);
                            TabPane.access$900(this.this$1).fireReportDataChanged();
                        }
                    }
                });
                JMenuItem jMenuItem2 = new JMenuItem(Inter.getLocText("Rename"));
                jMenuItem2.setIcon(BaseUtils.readIcon("/com/fr/cell/images/control/rename.png"));
                jPopupMenu.add(jMenuItem2);
                if (this.isBlank) {
                    jMenuItem2.setEnabled(false);
                }
                jMenuItem2.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TabPane this$1;
                    {
                        this.this$1 = tabPane;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        WorkBook workBook = TabPane.access$900(this.this$1).getWorkBook();
                        int n = TabPane.access$900(this.this$1).getSelectedIndex();
                        if (n < 0 || n >= workBook.getReportCount()) {
                            return;
                        }
                        String string = JOptionPane.showInputDialog(TabPane.access$900(this.this$1), Inter.getLocText("Rename") + ":", workBook.getReportName(n));
                        if (string != null) {
                            boolean bl = false;
                            for (int i = 0; i < workBook.getReportCount(); ++i) {
                                if (!string.equalsIgnoreCase(workBook.getReportName(i))) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                workBook.setReportName(n, string);
                                TabPane.access$900(this.this$1).repaint();
                            } else {
                                JOptionPane.showMessageDialog(TabPane.access$900(this.this$1), Inter.getLocText("Utils-The_Name_has_been_existed"));
                            }
                        }
                    }
                });
                GUICoreUtils.showPopupMenu(jPopupMenu, this, n - 1, n2 - 1);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            int n2;
            this.isReleased = true;
            this.setReleasedXY(mouseEvent.getX(), mouseEvent.getY());
            if (this.getPressedXY()[0] == this.getReleasedXY()[0] && this.getPressedXY()[1] == this.getReleasedXY()[1]) return;
            WorkBook workBook = JWorkBook.this.getWorkBook();
            ReportPaneEditState reportPaneEditState = (ReportPaneEditState)JWorkBook.this.reportPaneEditStateList.get(JWorkBook.this.getSelectedIndex());
            reportPaneEditState.backupJWorkBook(JWorkBook.this);
            int n3 = JWorkBook.this.getSelectedIndex();
            if (n2 > this.widthArray[n3] / 2) {
                int n4;
                if (JWorkBook.this.getSelectedIndex() >= workBook.getReportCount() - 1) return;
                for (n2 = this.getReleasedXY()[0] - this.getPressedXY()[0]; n2 > this.widthArray[n3] / 2; n2 -= this.widthArray[n4 + 1]) {
                    n4 = JWorkBook.this.getSelectedIndex();
                    workBook = this.exchangeWorkSheet(workBook, JWorkBook.this.getSelectedIndex(), JWorkBook.this.getSelectedIndex() + 1);
                    JWorkBook.this.setSelectedIndex(JWorkBook.this.getSelectedIndex() + 1);
                    if (n4 <= workBook.getReportCount() - 3) continue;
                    JWorkBook.this.setSelectedIndex(workBook.getReportCount() - 1);
                    return;
                }
                return;
            } else if (n > this.widthArray[n3] / 2) {
                int n5;
                if (JWorkBook.this.getSelectedIndex() <= 0) return;
                for (n = this.getPressedXY()[0] - this.getReleasedXY()[0]; n > this.widthArray[n3] / 2; n -= this.widthArray[n5 - 1]) {
                    n5 = JWorkBook.this.getSelectedIndex();
                    workBook = this.exchangeWorkSheet(workBook, JWorkBook.this.getSelectedIndex(), JWorkBook.this.getSelectedIndex() - 1);
                    JWorkBook.this.setSelectedIndex(JWorkBook.this.getSelectedIndex() - 1);
                    if (n5 >= 2) continue;
                    JWorkBook.this.setSelectedIndex(0);
                    return;
                }
                return;
            } else {
                JWorkBook.this.setSelectedIndex(n3);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private WorkBook exchangeWorkSheet(WorkBook workBook, int n, int n2) {
            WorkSheet workSheet = new WorkSheet();
            workSheet = (WorkSheet)workBook.getReport(n);
            String string = workBook.getReportName(n);
            WorkSheet workSheet2 = new WorkSheet();
            workSheet2 = (WorkSheet)workBook.getReport(n2);
            String string2 = workBook.getReportName(n2);
            workBook.addReport(n, string2, workSheet2);
            workBook.removeReport(n + 1);
            workBook.addReport(n2, string, workSheet);
            workBook.removeReport(n2 + 1);
            return workBook;
        }

        static /* synthetic */ JWorkBook access$900(TabPane tabPane) {
            return tabPane.JWorkBook.this;
        }
    }

    private class WorkBookState
    extends UndoState
    implements Serializable,
    Cloneable {
        private WorkBook book;
        private int selectedIndex;

        public WorkBookState(JWorkBook jWorkBook2, GridSelection gridSelection, int n, int n2, boolean bl) {
            super(jWorkBook2, gridSelection, n, n2, bl);
        }

        protected void evaluateReportTemplate() {
            try {
                this.book = (WorkBook)((JWorkBook)this.reportPane).getWorkBook().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                return;
            }
            this.selectedIndex = ((JWorkBook)this.reportPane).getSelectedIndex();
            if (this.isCacheable) {
                try {
                    this.cacheFile = new File(this.getCacheDirectory(), "Undo" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
                    int n = 0;
                    while (this.cacheFile.exists()) {
                        this.cacheFile = new File(this.getCacheDirectory(), "Undo" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n);
                        ++n;
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(this.cacheFile);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(this.book);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    this.cacheFile.deleteOnExit();
                    this.book = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public void applyState() {
            WorkBook workBook = this.getWorkBook();
            if (workBook == null) {
                return;
            }
            try {
                ((JWorkBook)this.reportPane).setWorkBook((WorkBook)workBook.clone(), this.selectedIndex);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
            super.applyState();
        }

        public WorkBook getWorkBook() {
            if (this.isCacheable && this.book == null) {
                if (this.cacheFile == null || !this.cacheFile.exists()) {
                    return null;
                }
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.cacheFile));
                    WorkBook workBook = (WorkBook)objectInputStream.readObject();
                    objectInputStream.close();
                    return workBook;
                }
                catch (Throwable throwable) {
                    FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
                }
            }
            return this.book;
        }
    }
}

