/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.Style;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.cell.Grid;
import com.fr.cell.GridColumn;
import com.fr.cell.GridCorner;
import com.fr.cell.GridRow;
import com.fr.cell.GridSelection;
import com.fr.cell.clipboard.CellElementsClip;
import com.fr.cell.clipboard.ElementsTransferable;
import com.fr.cell.clipboard.FloatElementsClip;
import com.fr.cell.core.DynamicScrollBar;
import com.fr.cell.core.GUIConstants;
import com.fr.cell.core.GridUtils;
import com.fr.cell.core.RGridLayout;
import com.fr.cell.event.GridSelectionChangeEvent;
import com.fr.cell.event.GridSelectionChangeListener;
import com.fr.cell.event.ReportDataChangeEvent;
import com.fr.cell.event.ReportDataChangeListener;
import com.fr.cell.undo.UndoState;
import com.fr.cell.undo.UndoStateEdit;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.FloatElement;
import com.fr.report.Report;
import com.fr.report.TemplateReport;
import com.fr.report.TemplateWorkBook;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.SheetUtils;
import com.fr.util.Utils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoManager;

public abstract class ReportPane
extends JComponent {
    private TemplateReport _curReport = null;
    private GridSelection gridSelelction = new GridSelection();
    private static final int Clear_All = 0;
    private static final int Clear_Formats = 1;
    private static final int Clear_Contents = 2;
    private UndoManager undoMananger;
    protected UndoState currentUndoState;
    private boolean supportUndo = true;
    private int undoLimit = 5;
    private boolean undoCacheable = false;
    private boolean supportDefaultParentCalculate = true;
    protected Grid grid;
    protected GridRow gridRow;
    protected GridColumn gridColumn;
    protected GridCorner gridCorner;
    protected JScrollBar verScrollBar;
    protected JScrollBar horScrollBar;
    private EventListenerList reportDataChangeListenerList = new EventListenerList();
    private EventListenerList gridSelectionChangeListenerList = new EventListenerList();
    private transient GridSelectionChangeEvent gridSelectionChangeEvent = null;
    private transient ReportDataChangeEvent reportDataChangeEvent = null;
    private boolean isFormatBrush;
    private boolean columnHeaderVisible = true;
    private boolean rowHeaderVisible = true;
    private boolean verticalScrollBarVisible = true;
    private boolean horizontalScrollBarVisible = true;
    private boolean rowEndless = true;
    private boolean columnEndless = true;
    static /* synthetic */ Class class$com$fr$cell$event$GridSelectionChangeListener;
    static /* synthetic */ Class class$com$fr$cell$event$ReportDataChangeListener;

    public ReportPane() {
        this.enableEvents(131072L);
        this.initComponents();
        this.setFocusTraversalKeysEnabled(false);
    }

    protected void initComponents() {
        this.setLayout(new RGridLayout());
        if (this.grid == null) {
            this.grid = new Grid();
        }
        if (this.gridColumn == null) {
            this.gridColumn = new GridColumn();
        }
        if (this.gridRow == null) {
            this.gridRow = new GridRow();
        }
        if (this.gridCorner == null) {
            this.gridCorner = new GridCorner();
        }
        this.grid.setReportPane(this);
        this.gridColumn.setReportPane(this);
        this.gridRow.setReportPane(this);
        this.gridCorner.setReportPane(this);
        this.verScrollBar = new DynamicScrollBar(1, this);
        this.horScrollBar = new DynamicScrollBar(0, this);
        this.add("GridCorner", this.gridCorner);
        this.add("GridColumn", this.gridColumn);
        this.add("GridRow", this.gridRow);
        this.add("Grid", this.grid);
        this.add("VerScrollBar", this.verScrollBar);
        this.add("HorScrollBar", this.horizontalBar());
        this.initInputActionMap();
        this.setMinimumSize(new Dimension(0, 0));
        this.initDefaultEditors();
    }

    protected JComponent horizontalBar() {
        return this.horScrollBar;
    }

    protected void initDefaultEditors() {
    }

    public abstract TemplateWorkBook getTemplate();

    public abstract TemplateWorkBook getBackUpTempalte();

    public abstract void setBackUpTemplate(TemplateWorkBook var1);

    public TemplateReport getEditingReport() {
        return this._curReport;
    }

    public void setEditingReport(TemplateReport templateReport) {
        TemplateReport templateReport2 = this._curReport;
        this._curReport = templateReport;
        if (this.grid != null) {
            this.grid.removeAll();
        }
        this.getGrid().setDrawingFloatElement(null);
        GridUtils.doSelectCell(this, 0, 0);
        this.firePropertyChange("report", templateReport2, this._curReport);
        this.validate();
        this.requestFocus();
    }

    public Grid getGrid() {
        return this.grid;
    }

    public GridColumn getGridColumn() {
        return this.gridColumn;
    }

    public GridRow getGridRow() {
        return this.gridRow;
    }

    public GridCorner getGridCorner() {
        return this.gridCorner;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.verScrollBar;
    }

    public void setVerticalScrollBar(JScrollBar jScrollBar) {
        this.verScrollBar = jScrollBar;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.horScrollBar;
    }

    public void setHorizontalScrollBar(JScrollBar jScrollBar) {
        this.horScrollBar = jScrollBar;
    }

    public GridSelection getGridSelection() {
        return this.gridSelelction;
    }

    public void setGridSelection(GridSelection gridSelection) {
        if (gridSelection == null) {
            return;
        }
        if (!ComparatorUtils.equals(this.gridSelelction, gridSelection)) {
            GridSelection gridSelection2 = this.gridSelelction;
            this.gridSelelction = gridSelection;
        }
        this.gridSelelction = gridSelection;
    }

    public int getUndoLimit() {
        return this.undoLimit;
    }

    public void setUndoLimit(int n) {
        this.undoLimit = n;
    }

    public boolean isSupportUndo() {
        return this.supportUndo;
    }

    public void setSupportUndo(boolean bl) {
        this.supportUndo = bl;
    }

    public boolean isSupportDefaultParentCalculate() {
        return this.supportDefaultParentCalculate;
    }

    public void setSupportDefaultParentCalculate(boolean bl) {
        this.supportDefaultParentCalculate = bl;
    }

    public boolean isUndoCacheable() {
        return this.undoCacheable;
    }

    public void setUndoCacheable(boolean bl) {
        this.undoCacheable = bl;
    }

    public boolean cut() {
        this.copy();
        return this.innerClear(0);
    }

    public void copy() {
        Object object;
        GridSelection gridSelection = this.getGridSelection();
        if (gridSelection.getType() == 0 && gridSelection.getCellRectangleCount() > 1) {
            JOptionPane.showMessageDialog(this, Inter.getLocText(""));
            return;
        }
        ElementsTransferable elementsTransferable = GridUtils.caculateElementsTransferable(this);
        Object object2 = elementsTransferable.getFirstObject();
        if (object2 != null && object2 instanceof CellElementsClip) {
            object = (CellElementsClip)object2;
            ((CellElementsClip)object).sortElementList();
            StringBuffer stringBuffer = new StringBuffer();
            int n = -1;
            int n2 = ((CellElementsClip)object).getCellElementCount();
            for (int i = 0; i < n2; ++i) {
                CellElement cellElement = ((CellElementsClip)object).getCellElement(i);
                if (n == -1) {
                    n = cellElement.getRow();
                }
                if (n < cellElement.getRow()) {
                    for (int j = n; j < cellElement.getRow(); ++j) {
                        stringBuffer.append('\n');
                    }
                    n = cellElement.getRow();
                }
                if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                    stringBuffer.append('\t');
                }
                stringBuffer.append(cellElement.getValue());
            }
            elementsTransferable.addObject(stringBuffer.toString());
        }
        object = FRCoreContext.getClipboard(this.getGrid());
        ((Clipboard)object).setContents(elementsTransferable, elementsTransferable);
    }

    public void formatBrush() {
        this.copy();
    }

    public boolean paste() {
        block30: {
            if (!this.isEditable()) {
                return false;
            }
            TemplateReport templateReport = this.getEditingReport();
            Clipboard clipboard = FRCoreContext.getClipboard(this.getGrid());
            Transferable transferable = clipboard.getContents(this);
            if (transferable == null) {
                return false;
            }
            GridSelection gridSelection = this.getGridSelection();
            try {
                Object object;
                Object object2;
                int n;
                int n2;
                Object object3;
                try {
                    object3 = ElementsTransferable.getElementNotStringTransderData(transferable);
                }
                catch (Exception exception) {
                    object3 = transferable.getTransferData(DataFlavor.stringFlavor);
                }
                if (object3 instanceof FloatElementsClip && gridSelection.getType() == 0) {
                    FloatElementsClip floatElementsClip = (FloatElementsClip)((FloatElementsClip)object3).clone();
                    Rectangle rectangle = gridSelection.getEditRectangle();
                    for (int i = 0; i < floatElementsClip.getFloatElementCount(); ++i) {
                        FloatElement floatElement = floatElementsClip.getFloatElement(i);
                        if (rectangle != null) {
                            floatElement.setColumn(rectangle.x + floatElement.getColumn());
                            floatElement.setRow(rectangle.y + floatElement.getRow());
                        }
                        while (this.isContainSameBoundFloatElement(this.getEditingReport(), floatElement)) {
                            floatElement.setTopDistance(floatElement.getTopDistance() + 5);
                            floatElement.setLeftDistance(floatElement.getLeftDistance() + 5);
                        }
                        gridSelection.addFloatName(floatElement.getName());
                        templateReport.addFloatElement(floatElement);
                    }
                    gridSelection.setType(1);
                    break block30;
                }
                Rectangle rectangle = gridSelection.getEditRectangle();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (object3 instanceof CellElementsClip && gridSelection.getType() == 0) {
                    CellElementsClip cellElementsClip = (CellElementsClip)object3;
                    n2 = gridSelection.getCellRectangleCount();
                    for (int i = 0; i < n2; ++i) {
                        Rectangle rectangle2 = gridSelection.getCellRectangle(i);
                        n = rectangle2.x;
                        int n3 = rectangle2.y;
                        int n4 = cellElementsClip.getColumnSpan();
                        int n5 = cellElementsClip.getRowSpan();
                        object2 = templateReport.intersect(n, n3, n4, n5);
                        while (object2.hasNext()) {
                            CellElement cellElement = (CellElement)object2.next();
                            templateReport.removeCellElement(cellElement);
                        }
                        int n6 = cellElementsClip.getCellElementCount();
                        for (int j = 0; j < n6; ++j) {
                            object = (CellElement)cellElementsClip.getCellElement(j).clone();
                            templateReport.addCellElement(object.deriveCellElement(n + object.getColumn(), n3 + object.getRow()), false);
                        }
                        Rectangle rectangle3 = new Rectangle(n, n3, n4, n5);
                        arrayList.add(rectangle3);
                    }
                } else if (object3 instanceof String) {
                    int n7 = gridSelection.getCellRectangleCount();
                    for (n2 = 0; n2 < n7; ++n2) {
                        Rectangle rectangle4 = gridSelection.getCellRectangle(n2);
                        int n8 = rectangle4.x;
                        n = rectangle4.y;
                        int n9 = Integer.MIN_VALUE;
                        int n10 = 0;
                        String[] stringArray = Utils.splitString((String)object3, '\n');
                        for (int i = 0; i < stringArray.length; ++i) {
                            String[] stringArray2 = Utils.splitString(stringArray[i], '\t');
                            for (int j = 0; j < stringArray2.length; ++j) {
                                object = stringArray2[j];
                                if (((String)object).startsWith("=")) {
                                    templateReport.setCellValue(n8 + j, n + i, new Formula((String)object));
                                    continue;
                                }
                                Number number = Utils.string2Number(stringArray2[j]);
                                if (number != null) {
                                    templateReport.setCellValue(n8 + j, n + i, number);
                                    continue;
                                }
                                String string = Utils.replaceAllString(stringArray2[j], ",", "");
                                number = Utils.string2Number(string);
                                if (number != null) {
                                    templateReport.setCellValue(n8 + j, n + i, Utils.string2Number(string));
                                    continue;
                                }
                                templateReport.setCellValue(n8 + j, n + i, stringArray2[j]);
                            }
                        }
                        object2 = new Rectangle(n8, n, n9, n10);
                        arrayList.add(object2);
                    }
                } else {
                    int n11 = gridSelection.getCellRectangleCount();
                    for (n2 = 0; n2 < n11; ++n2) {
                        Rectangle rectangle5 = gridSelection.getCellRectangle(n2);
                        int n12 = rectangle5.x;
                        n = rectangle5.y;
                        CellElement cellElement = templateReport.getCellElement(n12, n);
                        if (cellElement == null) {
                            cellElement = new DefaultCellElement(n12, n, object3);
                            templateReport.addCellElement(cellElement, false);
                        } else {
                            cellElement.setValue(object3);
                        }
                        Rectangle rectangle6 = new Rectangle(n12, n, 1, 1);
                        gridSelection.addCellRectangle(rectangle6);
                    }
                }
                gridSelection.clearCellRectangles();
                if (arrayList.size() > 0) {
                    gridSelection.clearAllCellRectangles();
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    gridSelection.addCellRectangle((Rectangle)arrayList.get(i));
                }
                CellElement cellElement = templateReport.getCellElement(rectangle.x, rectangle.y);
                if (cellElement != null) {
                    gridSelection.setEditBounds(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
                } else {
                    gridSelection.setEditBounds(rectangle.x, rectangle.y, 1, 1);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                return false;
            }
        }
        return true;
    }

    public boolean brushFormat() {
        block28: {
            if (!this.isEditable()) {
                return false;
            }
            TemplateReport templateReport = this.getEditingReport();
            Clipboard clipboard = FRCoreContext.getClipboard(this.getGrid());
            Transferable transferable = clipboard.getContents(this);
            if (transferable == null) {
                return false;
            }
            GridSelection gridSelection = this.getGridSelection();
            try {
                Cloneable cloneable;
                Object object;
                try {
                    object = ElementsTransferable.getElementNotStringTransderData(transferable);
                }
                catch (Exception exception) {
                    object = transferable.getTransferData(DataFlavor.stringFlavor);
                }
                if (object instanceof FloatElementsClip && gridSelection.getType() == 0) break block28;
                Rectangle rectangle = gridSelection.getEditRectangle();
                ArrayList arrayList = new ArrayList();
                if (object instanceof CellElementsClip && gridSelection.getType() == 0) {
                    cloneable = (CellElementsClip)object;
                    for (int i = 0; i < gridSelection.getCellRectangleCount(); ++i) {
                        int n;
                        int n2;
                        int n3;
                        Rectangle rectangle2 = gridSelection.getCellRectangle(i);
                        int n4 = rectangle2.x;
                        int n5 = rectangle2.y;
                        int n6 = 0;
                        int n7 = 0;
                        if ((int)rectangle2.getWidth() == 1 && (int)rectangle2.getHeight() == 1) {
                            this.getGridSelection().clearAllCellRectangles();
                            this.getGridSelection().addCellRectangle(new Rectangle(n4, n5, ((CellElementsClip)cloneable).getColumnSpan(), ((CellElementsClip)cloneable).getRowSpan()));
                            this.unMergeCell();
                            for (n3 = 0; n3 < ((CellElementsClip)cloneable).getColumnSpan(); ++n3) {
                                for (n2 = 0; n2 < ((CellElementsClip)cloneable).getRowSpan(); ++n2) {
                                    if (templateReport.getCellElement(n4 + n3, n5 + n2) == null) {
                                        templateReport.addCellElement(new DefaultCellElement(n4 + n3, n5 + n2), false);
                                    }
                                    templateReport.getCellElement(n4 + n3, n5 + n2).setStyle(Style.DEFAULT_STYLE);
                                }
                            }
                            for (n3 = 0; n3 < ((CellElementsClip)cloneable).getCellElementCount(); ++n3) {
                                n6 = n4 + ((CellElementsClip)cloneable).getCellElement(n3).getColumn();
                                n7 = n5 + ((CellElementsClip)cloneable).getCellElement(n3).getRow();
                                templateReport.getCellElement(n6, n7).setStyle(((CellElementsClip)cloneable).getCellElement(n3).getStyle());
                                if (((CellElementsClip)cloneable).getCellElement(n3).getColumnSpan() <= 1 && ((CellElementsClip)cloneable).getCellElement(n3).getRowSpan() <= 1) continue;
                                templateReport.merge(n7, n7 + ((CellElementsClip)cloneable).getCellElement(n3).getRowSpan() - 1, n6, n6 + ((CellElementsClip)cloneable).getCellElement(n3).getColumnSpan() - 1);
                            }
                            continue;
                        }
                        this.unMergeCell();
                        for (n3 = 0; n3 < (int)rectangle2.getWidth(); ++n3) {
                            for (n2 = 0; n2 < (int)rectangle2.getHeight(); ++n2) {
                                if (templateReport.getCellElement(n4 + n3, n5 + n2) == null) {
                                    templateReport.setCellValue(n4 + n3, n5 + n2, "");
                                }
                                templateReport.getCellElement(n4 + n3, n5 + n2).setStyle(Style.DEFAULT_STYLE);
                            }
                        }
                        n3 = 0;
                        n2 = 0;
                        n3 = 0;
                        while ((n3 + 1) * ((CellElementsClip)cloneable).getColumnSpan() <= (int)rectangle2.getWidth()) {
                            n2 = 0;
                            while ((n2 + 1) * ((CellElementsClip)cloneable).getRowSpan() <= (int)rectangle2.getHeight()) {
                                for (n = 0; n < ((CellElementsClip)cloneable).getCellElementCount(); ++n) {
                                    n6 = n4 + n3 * ((CellElementsClip)cloneable).getColumnSpan() + ((CellElementsClip)cloneable).getCellElement(n).getColumn();
                                    n7 = n5 + n2 * ((CellElementsClip)cloneable).getRowSpan() + ((CellElementsClip)cloneable).getCellElement(n).getRow();
                                    templateReport.getCellElement(n6, n7).setStyle(((CellElementsClip)cloneable).getCellElement(n).getStyle());
                                    if (((CellElementsClip)cloneable).getCellElement(n).getColumnSpan() <= 1 && ((CellElementsClip)cloneable).getCellElement(n).getRowSpan() <= 1) continue;
                                    templateReport.merge(n7, n7 + ((CellElementsClip)cloneable).getCellElement(n).getRowSpan() - 1, n6, n6 + ((CellElementsClip)cloneable).getCellElement(n).getColumnSpan() - 1);
                                }
                                ++n2;
                            }
                            for (n = 0; n < ((CellElementsClip)cloneable).getCellElementCount(); ++n) {
                                n6 = n4 + n3 * ((CellElementsClip)cloneable).getColumnSpan() + ((CellElementsClip)cloneable).getCellElement(n).getColumn();
                                n7 = n5 + n2 * ((CellElementsClip)cloneable).getRowSpan() + ((CellElementsClip)cloneable).getCellElement(n).getRow();
                                if (n6 >= n4 + (int)rectangle2.getWidth() || n7 >= n5 + (int)rectangle2.getHeight()) continue;
                                templateReport.getCellElement(n6, n7).setStyle(((CellElementsClip)cloneable).getCellElement(n).getStyle());
                                if (Math.min(((CellElementsClip)cloneable).getCellElement(n).getColumnSpan(), n4 + (int)rectangle2.getWidth() - n6) <= 1 && Math.min(((CellElementsClip)cloneable).getCellElement(n).getRowSpan(), n5 + (int)rectangle2.getHeight() - n7) <= 1) continue;
                                templateReport.merge(n7, n7 + Math.min(((CellElementsClip)cloneable).getCellElement(n).getRowSpan(), n5 + (int)rectangle2.getHeight() - n7) - 1, n6, n6 + Math.min(((CellElementsClip)cloneable).getCellElement(n).getColumnSpan(), n4 + (int)rectangle2.getWidth() - n6) - 1);
                            }
                            ++n3;
                        }
                        n2 = 0;
                        while ((n2 + 1) * ((CellElementsClip)cloneable).getRowSpan() <= (int)rectangle2.getHeight()) {
                            for (n = 0; n < ((CellElementsClip)cloneable).getCellElementCount(); ++n) {
                                n6 = n4 + n3 * ((CellElementsClip)cloneable).getColumnSpan() + ((CellElementsClip)cloneable).getCellElement(n).getColumn();
                                n7 = n5 + n2 * ((CellElementsClip)cloneable).getRowSpan() + ((CellElementsClip)cloneable).getCellElement(n).getRow();
                                if (n6 >= n4 + (int)rectangle2.getWidth() || n7 >= n5 + (int)rectangle2.getHeight()) continue;
                                templateReport.getCellElement(n6, n7).setStyle(((CellElementsClip)cloneable).getCellElement(n).getStyle());
                                if (Math.min(((CellElementsClip)cloneable).getCellElement(n).getColumnSpan(), n4 + (int)rectangle2.getWidth() - n6) <= 1 && Math.min(((CellElementsClip)cloneable).getCellElement(n).getRowSpan(), n5 + (int)rectangle2.getHeight() - n7) <= 1) continue;
                                templateReport.merge(n7, n7 + Math.min(((CellElementsClip)cloneable).getCellElement(n).getRowSpan(), n5 + (int)rectangle2.getHeight() - n7) - 1, n6, n6 + Math.min(((CellElementsClip)cloneable).getCellElement(n).getColumnSpan(), n4 + (int)rectangle2.getWidth() - n6) - 1);
                            }
                            ++n2;
                        }
                        for (n = 0; n < ((CellElementsClip)cloneable).getCellElementCount(); ++n) {
                            n6 = n4 + n3 * ((CellElementsClip)cloneable).getColumnSpan() + ((CellElementsClip)cloneable).getCellElement(n).getColumn();
                            n7 = n5 + n2 * ((CellElementsClip)cloneable).getRowSpan() + ((CellElementsClip)cloneable).getCellElement(n).getRow();
                            if (n6 >= n4 + (int)rectangle2.getWidth() || n7 >= n5 + (int)rectangle2.getHeight()) continue;
                            templateReport.getCellElement(n6, n7).setStyle(((CellElementsClip)cloneable).getCellElement(n).getStyle());
                            if (Math.min(((CellElementsClip)cloneable).getCellElement(n).getColumnSpan(), n4 + (int)rectangle2.getWidth() - n6) <= 1 && Math.min(((CellElementsClip)cloneable).getCellElement(n).getRowSpan(), n5 + (int)rectangle2.getHeight() - n7) <= 1) continue;
                            templateReport.merge(n7, n7 + Math.min(((CellElementsClip)cloneable).getCellElement(n).getRowSpan(), n5 + (int)rectangle2.getHeight() - n7) - 1, n6, n6 + Math.min(((CellElementsClip)cloneable).getCellElement(n).getColumnSpan(), n4 + (int)rectangle2.getWidth() - n6) - 1);
                        }
                    }
                } else if (object instanceof String) {
                    // empty if block
                }
                if ((cloneable = templateReport.getCellElement(rectangle.x, rectangle.y)) != null) {
                    gridSelection.setEditBounds(cloneable.getColumn(), cloneable.getRow(), cloneable.getColumnSpan(), cloneable.getRowSpan());
                } else {
                    gridSelection.setEditBounds(rectangle.x, rectangle.y, 1, 1);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                return false;
            }
        }
        if (this.isFormatBrush()) {
            this.setFormatBrush(false);
        }
        this.getGrid().setCursor(GUIConstants.CellDefaultCursor);
        this.repaint();
        return true;
    }

    public void ensureColumnRowVisible(int n, int n2) {
        int n3;
        Grid grid = this.getGrid();
        int n4 = grid.getVerticalValue() + grid.getVerticalExtent() + 1;
        int n5 = grid.getHorizontalValue() + grid.getHorizontalExtent() + 1;
        if (!this.isRowEndless()) {
            n3 = this.getEditingReport().getRowCount();
            n4 = Math.min(n4, n3);
        }
        if (!this.isColumnEndless()) {
            n3 = this.getEditingReport().getColumnCount();
            n5 = Math.min(n5, n3);
        }
        if (grid.getHorizontalValue() > n) {
            this.getHorizontalScrollBar().setValue(n);
        } else if (n5 <= n + 1) {
            this.getHorizontalScrollBar().setValue(n - grid.getHorizontalExtent() + 1);
        }
        if (grid.getVerticalValue() > n2) {
            this.getVerticalScrollBar().setValue(n2);
        } else if (n4 <= n2 + 1) {
            this.getVerticalScrollBar().setValue(n2 - grid.getVerticalExtent() + 1);
        }
    }

    private boolean isContainSameBoundFloatElement(Report report, FloatElement floatElement) {
        if (floatElement == null) {
            return false;
        }
        Iterator iterator = report.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement2 = (FloatElement)iterator.next();
            if (floatElement2.getColumn() != floatElement.getColumn() || floatElement2.getRow() != floatElement.getRow() || floatElement2.getTopDistance() != floatElement.getTopDistance() || floatElement2.getLeftDistance() != floatElement.getLeftDistance() || !ComparatorUtils.equals(floatElement2.getSize(), floatElement.getSize())) continue;
            return true;
        }
        return false;
    }

    public boolean clearAll() {
        return this.innerClear(0);
    }

    public boolean clearFormats() {
        return this.innerClear(1);
    }

    public boolean clearContents() {
        return this.innerClear(2);
    }

    public boolean canMergeCell() {
        GridSelection gridSelection = this.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            return false;
        }
        Rectangle rectangle = this.gridSelelction.getFirstCellRectangle();
        return rectangle.width > 1 || rectangle.height > 1;
    }

    public boolean mergeCell() {
        if (!this.canMergeCell()) {
            return false;
        }
        GridSelection gridSelection = this.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            return false;
        }
        Rectangle rectangle = gridSelection.getEditRectangle();
        int n2 = gridSelection.getCellRectangleCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            Rectangle rectangle2 = gridSelection.getCellRectangle(i);
            if (rectangle2.width == 1 && rectangle2.height == 1) {
                return false;
            }
            TemplateReport templateReport = this.getEditingReport();
            Iterator iterator = templateReport.intersect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            if (iterator.hasNext() && iterator.hasNext() && (n3 = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), Inter.getLocText("Des-Merger_Cell"), Inter.getLocText("Utils-Merge_Cell"), 2)) != 0) {
                return false;
            }
            templateReport.merge(rectangle2.y, rectangle2.y + rectangle2.height - 1, rectangle2.x, rectangle2.x + rectangle2.width - 1);
            if (!rectangle2.contains(rectangle)) continue;
            rectangle.setBounds(rectangle2);
        }
        return true;
    }

    protected void mergeCellElementList(Report report, List list) {
        CellElement cellElement;
        int n;
        if (list.size() <= 0) {
            return;
        }
        int n2 = list.size();
        int n3 = 0;
        int n4 = 0;
        CellElement cellElement2 = (CellElement)list.get(0);
        for (n = 0; n < n2; ++n) {
            cellElement = (CellElement)list.get(n);
            if (cellElement.getRow() + cellElement.getRowSpan() > n4) {
                n4 = cellElement.getRow() + cellElement.getRowSpan();
            }
            if (cellElement.getColumn() + cellElement.getColumnSpan() > n3) {
                n3 = cellElement.getColumn() + cellElement.getColumnSpan();
            }
            if (!(cellElement.getRow() < cellElement2.getRow() && cellElement.getColumn() < cellElement2.getColumn() || cellElement.getRow() == cellElement2.getRow() && cellElement.getColumn() < cellElement2.getColumn()) && (cellElement.getRow() >= cellElement2.getRow() || cellElement.getColumn() != cellElement2.getColumn())) continue;
            cellElement2 = cellElement;
        }
        for (n = 0; n < n2; ++n) {
            cellElement = (CellElement)list.get(n);
            report.removeCellElement(cellElement);
        }
        report.addCellElement(cellElement2.deriveCellElement(cellElement2.getColumn(), cellElement2.getRow(), n3 - cellElement2.getColumn(), n4 - cellElement2.getRow()));
    }

    public boolean canUnMergeCell() {
        GridSelection gridSelection = this.getGridSelection();
        if (gridSelection.getType() == 1) {
            return false;
        }
        TemplateReport templateReport = this.getEditingReport();
        for (int i = 0; i < gridSelection.getCellRectangleCount(); ++i) {
            Rectangle rectangle = gridSelection.getCellRectangle(i);
            Iterator iterator = templateReport.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            while (iterator.hasNext()) {
                CellElement cellElement = (CellElement)iterator.next();
                if (cellElement.getColumnSpan() <= 1 && cellElement.getRowSpan() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean unMergeCell() {
        if (!this.canUnMergeCell()) {
            return false;
        }
        TemplateReport templateReport = this.getEditingReport();
        GridSelection gridSelection = this.getGridSelection();
        for (int i = 0; i < gridSelection.getCellRectangleCount(); ++i) {
            Rectangle rectangle = gridSelection.getCellRectangle(i);
            Iterator iterator = templateReport.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            while (iterator.hasNext()) {
                CellElement cellElement = (CellElement)iterator.next();
                int n = cellElement.getColumnSpan();
                int n2 = cellElement.getRowSpan();
                this.getEditingReport().removeCellElement(cellElement);
                this.getEditingReport().addCellElement(cellElement.deriveCellElement(cellElement.getColumn(), cellElement.getRow(), 1, 1));
                for (int j = cellElement.getColumn(); j < cellElement.getColumn() + n; ++j) {
                    for (int k = cellElement.getRow(); k < cellElement.getRow() + n2; ++k) {
                        if (j == cellElement.getColumn() && k == cellElement.getRow()) continue;
                        this.getEditingReport().addCellElement(new DefaultCellElement(j, k), false);
                    }
                }
            }
        }
        Rectangle rectangle = gridSelection.getEditRectangle();
        rectangle.setBounds(rectangle.x, rectangle.y, 1, 1);
        return true;
    }

    public void fireGridSelectionChanged() {
        this.fireGridSelectionChangeListener();
        this.repaint(15L);
    }

    public void addGridSelectionChangeListener(GridSelectionChangeListener gridSelectionChangeListener) {
        this.gridSelectionChangeListenerList.add(class$com$fr$cell$event$GridSelectionChangeListener == null ? (class$com$fr$cell$event$GridSelectionChangeListener = ReportPane.class$("com.fr.cell.event.GridSelectionChangeListener")) : class$com$fr$cell$event$GridSelectionChangeListener, gridSelectionChangeListener);
    }

    public void removeGridSelectionChangeListener(GridSelectionChangeListener gridSelectionChangeListener) {
        this.gridSelectionChangeListenerList.remove(class$com$fr$cell$event$GridSelectionChangeListener == null ? (class$com$fr$cell$event$GridSelectionChangeListener = ReportPane.class$("com.fr.cell.event.GridSelectionChangeListener")) : class$com$fr$cell$event$GridSelectionChangeListener, gridSelectionChangeListener);
    }

    public void fireGridSelectionChangeListener() {
        Object[] objectArray = this.gridSelectionChangeListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$fr$cell$event$GridSelectionChangeListener == null ? ReportPane.class$("com.fr.cell.event.GridSelectionChangeListener") : class$com$fr$cell$event$GridSelectionChangeListener)) continue;
            if (this.gridSelectionChangeEvent == null) {
                this.gridSelectionChangeEvent = new GridSelectionChangeEvent(this);
            }
            ((GridSelectionChangeListener)objectArray[i + 1]).gridSelectionChanged(this.gridSelectionChangeEvent);
        }
    }

    public void fireReportDataChanged() {
        TemplateReport templateReport = this.getEditingReport();
        if (this.isSupportDefaultParentCalculate()) {
            SheetUtils.calculateDefaultParent(templateReport);
        }
        this.fireReportDataChangeListener();
        this.repaint(10L);
    }

    public void addReportDataChangeListener(ReportDataChangeListener reportDataChangeListener) {
        this.reportDataChangeListenerList.add(class$com$fr$cell$event$ReportDataChangeListener == null ? (class$com$fr$cell$event$ReportDataChangeListener = ReportPane.class$("com.fr.cell.event.ReportDataChangeListener")) : class$com$fr$cell$event$ReportDataChangeListener, reportDataChangeListener);
    }

    public void removeReportDataChangeListener(ReportDataChangeListener reportDataChangeListener) {
        this.reportDataChangeListenerList.remove(class$com$fr$cell$event$ReportDataChangeListener == null ? (class$com$fr$cell$event$ReportDataChangeListener = ReportPane.class$("com.fr.cell.event.ReportDataChangeListener")) : class$com$fr$cell$event$ReportDataChangeListener, reportDataChangeListener);
    }

    public void fireReportDataChangeListener() {
        Object[] objectArray = this.reportDataChangeListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$fr$cell$event$ReportDataChangeListener == null ? ReportPane.class$("com.fr.cell.event.ReportDataChangeListener") : class$com$fr$cell$event$ReportDataChangeListener)) continue;
            if (this.reportDataChangeEvent == null) {
                this.reportDataChangeEvent = new ReportDataChangeEvent(this);
            }
            ((ReportDataChangeListener)objectArray[i + 1]).reportDataChanged(this.reportDataChangeEvent);
        }
    }

    protected void initInputActionMap() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.clear();
        actionMap.clear();
        inputMap.put(KeyStroke.getKeyStroke(88, 2), "cut");
        actionMap.put("cut", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ReportPane.this.cut()) {
                    ReportPane.this.fireReportDataChanged();
                    ReportPane.this.undoRecord();
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(67, 2), "copy");
        actionMap.put("copy", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportPane.this.copy();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(86, 2), "paste");
        actionMap.put("paste", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ReportPane.this.paste()) {
                    ReportPane.this.fireReportDataChanged();
                    ReportPane.this.undoRecord();
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete_content");
        actionMap.put("delete_content", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ReportPane.this.clearContents()) {
                    ReportPane.this.fireReportDataChanged();
                    ReportPane.this.undoRecord();
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(127, 2), "delete_all");
        actionMap.put("delete_all", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ReportPane.this.clearAll()) {
                    ReportPane.this.fireReportDataChanged();
                    ReportPane.this.undoRecord();
                }
            }
        });
    }

    public boolean isColumnHeaderVisible() {
        return this.columnHeaderVisible;
    }

    public void setColumnHeaderVisible(boolean bl) {
        boolean bl2 = this.columnHeaderVisible;
        this.columnHeaderVisible = bl;
        this.firePropertyChange("columnHeaderVisible", bl2, this.columnHeaderVisible);
        this.resizeAndRepaint();
    }

    public boolean isRowHeaderVisible() {
        return this.rowHeaderVisible;
    }

    public void setRowHeaderVisible(boolean bl) {
        boolean bl2 = this.rowHeaderVisible;
        this.rowHeaderVisible = bl;
        this.firePropertyChange("rowHeaderVisible", bl2, this.rowHeaderVisible);
        this.resizeAndRepaint();
    }

    public boolean isVerticalScrollBarVisible() {
        return this.verticalScrollBarVisible;
    }

    public void setVerticalScrollBarVisible(boolean bl) {
        this.verticalScrollBarVisible = bl;
    }

    public boolean isHorizontalScrollBarVisible() {
        return this.horizontalScrollBarVisible;
    }

    public void setHorizontalScrollBarVisible(boolean bl) {
        this.horizontalScrollBarVisible = bl;
    }

    public boolean isEditable() {
        return this.grid.isEditable();
    }

    public void setEditable(boolean bl) {
        this.grid.setEditable(bl);
    }

    public boolean isColumnEndless() {
        return this.columnEndless;
    }

    public void setColumnEndless(boolean bl) {
        boolean bl2 = this.columnEndless;
        this.columnEndless = bl;
        this.firePropertyChange("columnEndless", bl2, this.columnEndless);
        this.resizeAndRepaint();
    }

    public boolean isRowEndless() {
        return this.rowEndless;
    }

    public void setRowEndless(boolean bl) {
        boolean bl2 = this.rowEndless;
        this.rowEndless = bl;
        this.firePropertyChange("rowEndless", bl2, this.rowEndless);
        this.resizeAndRepaint();
    }

    public boolean isFormatBrush() {
        return this.isFormatBrush;
    }

    public void setFormatBrush(boolean bl) {
        this.isFormatBrush = bl;
    }

    public void showWidgetWindow() {
    }

    public JPopupMenu createPopupMenu(MouseEvent mouseEvent) {
        return null;
    }

    public JPopupMenu createRowPopupMenu(MouseEvent mouseEvent, int n) {
        return null;
    }

    public JPopupMenu createColumnPopupMenu(MouseEvent mouseEvent, int n) {
        return null;
    }

    protected boolean innerClear(int n) {
        GridSelection gridSelection = this.getGridSelection();
        if (gridSelection.getType() == 1) {
            this.getGrid().stopEditing();
            this.getEditingReport().removeFloatElement(gridSelection.getLastFloatName());
            gridSelection.removeFloatName(gridSelection.getLastFloatName());
            Iterator iterator = this.getEditingReport().floatIterator();
            if (!iterator.hasNext()) {
                gridSelection.setType(0);
                gridSelection.setEditBounds(0, 0, 1, 1);
                gridSelection.setOnlyCellBounds(0, 0, 1, 1);
            } else {
                gridSelection.setType(1);
                if (gridSelection.getFloatNameCount() == 0) {
                    gridSelection.addFloatName(((FloatElement)iterator.next()).getName());
                }
            }
        } else {
            Object object;
            ArrayList<CellElement> arrayList = new ArrayList<CellElement>();
            for (int i = 0; i < gridSelection.getCellRectangleCount(); ++i) {
                Rectangle rectangle = gridSelection.getCellRectangle(i);
                object = this.getEditingReport().intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                while (object.hasNext()) {
                    CellElement cellElement = (CellElement)object.next();
                    CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
                    if (cellGUIAttr == null) {
                        cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
                    }
                    arrayList.add(cellElement);
                }
            }
            if (arrayList.size() == 0) {
                return false;
            }
            switch (n) {
                case 0: {
                    TemplateReport templateReport = this.getEditingReport();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object = arrayList.get(i);
                        if (!(object instanceof CellElement)) continue;
                        templateReport.removeCellElement((CellElement)object);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object = arrayList.get(i);
                        if (!(object instanceof CellElement)) continue;
                        ((CellElement)object).setStyle(null);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object = arrayList.get(i);
                        if (!(object instanceof CellElement)) continue;
                        ((CellElement)object).setValue(null);
                    }
                    break;
                }
            }
        }
        return true;
    }

    public void requestFocus() {
        this.getGrid().requestFocus();
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getID();
        switch (n) {
            case 507: {
                int n2 = mouseWheelEvent.getWheelRotation();
                this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getValue() + n2 * 3);
            }
        }
    }

    private UndoManager getUndoManager() {
        if (this.undoMananger == null) {
            this.undoMananger = new UndoManager();
            this.undoMananger.setLimit(this.getUndoLimit());
        }
        return this.undoMananger;
    }

    public boolean canUndo() {
        return this.getUndoManager().canUndo();
    }

    public boolean canRedo() {
        return this.getUndoManager().canRedo();
    }

    public void undo() {
        this.getUndoManager().undo();
    }

    public void redo() {
        this.getUndoManager().redo();
    }

    public void undoRecord() {
        UndoState undoState;
        if (this.supportUndo && (undoState = this.createUndoState()) != null) {
            this.getUndoManager().addEdit(new UndoStateEdit(this.currentUndoState, undoState));
            this.setUndoState(undoState);
        }
    }

    public void setUndoState(UndoState undoState) {
        this.currentUndoState = undoState;
    }

    protected UndoState createUndoState() {
        return null;
    }

    protected abstract void changeBackUpTempalte(TemplateWorkBook var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

