/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.comp;

import com.fr.cell.core.GUICoreUtils;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class ExpandMutableTreeNode
extends DefaultMutableTreeNode {
    private boolean isExpanded = false;

    public ExpandMutableTreeNode(Object object) {
        this(object, false);
    }

    public ExpandMutableTreeNode(Object object, boolean bl) {
        super(object);
        this.setExpanded(bl);
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean bl) {
        this.isExpanded = bl;
    }

    public void expandCurrentTreeNode(JTree jTree) {
        if (this.isExpanded) {
            jTree.expandPath(GUICoreUtils.getTreePath(this));
            this.setExpanded(true);
            this.expandSubTreeNodes(jTree);
        }
    }

    private void expandSubTreeNodes(JTree jTree) {
        if (!this.isExpanded()) {
            return;
        }
        jTree.expandPath(GUICoreUtils.getTreePath(this));
        this.setExpanded(true);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ExpandMutableTreeNode expandMutableTreeNode = (ExpandMutableTreeNode)this.getChildAt(i);
            if (!expandMutableTreeNode.isExpanded()) continue;
            jTree.expandPath(GUICoreUtils.getTreePath(expandMutableTreeNode));
            expandMutableTreeNode.setExpanded(true);
            expandMutableTreeNode.expandSubTreeNodes(jTree);
        }
    }
}

