/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.report.TemplateReport;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;

public class DynamicScrollBar
extends JScrollBar {
    private ReportPane reportPane;
    private boolean isSupportHide = true;

    public DynamicScrollBar(int n, ReportPane reportPane) {
        super(n);
        this.reportPane = reportPane;
        this.setMinimum(0);
        this.setUnitIncrement(1);
        this.setBlockIncrement(3);
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                this.ajustValues();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                this.ajustValues();
            }

            public void componentShown(ComponentEvent componentEvent) {
                this.ajustValues();
            }

            public void componentHidden(ComponentEvent componentEvent) {
                this.ajustValues();
            }

            private void ajustValues() {
                DynamicScrollBar.this.setValue(DynamicScrollBar.this.getValue());
            }
        });
    }

    public ReportPane getReportPane() {
        return this.reportPane;
    }

    public void setReportPane(ReportPane reportPane) {
        if (reportPane == null) {
            return;
        }
        this.reportPane = reportPane;
        if (this.orientation == 1) {
            this.setVerticalValue(this.reportPane.getGrid().getVerticalValue());
        } else {
            this.setHorizontalValue(this.reportPane.getGrid().getHorizontalValue());
        }
    }

    public int getVisibleAmount() {
        if (this.reportPane == null) {
            return 0;
        }
        if (this.orientation == 1) {
            return this.getVerticalExtent(this.getValue());
        }
        return this.getHorizontalExtent(this.getValue());
    }

    public void setValue(int n) {
        if (this.reportPane == null) {
            return;
        }
        if (this.orientation == 1) {
            this.setVerticalValue(n);
        } else {
            this.setHorizontalValue(n);
        }
    }

    private void setVerticalValue(int n) {
        BoundedRangeModel boundedRangeModel;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        block14: {
            n6 = this.getValue();
            TemplateReport templateReport = this.reportPane.getEditingReport();
            DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(templateReport);
            n5 = templateReport.getRowCount() - 1;
            if (n < 0) {
                n = 0;
            }
            if (n6 < n) {
                n4 = n - n6;
                n3 = 0;
                n2 = n6 + 1;
                while (true) {
                    if (dynamicValueList.get(n2) > 0 && ++n3 == n4) {
                        n = n2;
                        break block14;
                    }
                    ++n2;
                }
            }
            if (n6 > n) {
                n4 = n6 - n;
                n3 = 0;
                for (n2 = n6 - 1; n2 >= 0; --n2) {
                    if (dynamicValueList.get(n2) <= 0 || ++n3 != n4) continue;
                    n = n2;
                    break;
                }
            }
        }
        n4 = this.getVerticalExtent(n);
        if (!this.reportPane.isRowEndless()) {
            int n7;
            n3 = n5 + 1;
            n2 = n3;
            if (n > n2 - n4 && n > n6 && n6 >= n2 - (n7 = this.getVerticalExtent(n6))) {
                n = n6;
            }
        } else {
            n3 = Math.max(n5, n4) + 1;
            n3 = Math.max(n + n4, n3);
            GridSelection gridSelection = this.reportPane.getGridSelection();
            int n8 = gridSelection.getType();
            if (n8 == 0) {
                Rectangle rectangle = gridSelection.getFirstCellRectangle();
                n3 = Math.max(rectangle.y + rectangle.height + 1, n3);
            }
        }
        if (n != (boundedRangeModel = this.getModel()).getValue() || n4 != boundedRangeModel.getExtent() || n3 != boundedRangeModel.getMaximum()) {
            if (!this.reportPane.isRowEndless()) {
                boundedRangeModel.setRangeProperties(n, n4, 0, n3, false);
            } else {
                boundedRangeModel.setRangeProperties(n, n4, 0, n3, true);
            }
            this.reportPane.getGrid().setVerticalValue(n);
            this.reportPane.getGrid().setVerticalExtent(n4);
            this.reportPane.repaint(40L);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n6), new Integer(this.getValue()));
            }
        }
    }

    private int getVerticalExtent(int n) {
        TemplateReport templateReport = this.reportPane.getEditingReport();
        DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(templateReport);
        double d = this.reportPane.getGrid().getHeight();
        double d2 = 0.0;
        int n2 = n;
        int n3 = Integer.MAX_VALUE;
        for (int i = n2; i <= n3; ++i) {
            if (!((d2 += (double)dynamicValueList.get(i)) > d)) continue;
            n2 = i;
            int n4 = i;
            while (dynamicValueList.get(n4) == 0) {
                n2 = n4++;
            }
            break;
        }
        return n2 - n;
    }

    private void setHorizontalValue(int n) {
        BoundedRangeModel boundedRangeModel;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        block14: {
            n6 = this.getValue();
            TemplateReport templateReport = this.reportPane.getEditingReport();
            DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
            n5 = this.reportPane.getEditingReport().getColumnCount() - 1;
            if (n < 0) {
                n = 0;
            }
            if (n6 < n) {
                n4 = n - n6;
                n3 = 0;
                n2 = n6 + 1;
                while (true) {
                    if (dynamicValueList.get(n2) > 0 && ++n3 == n4) {
                        n = n2;
                        break block14;
                    }
                    ++n2;
                }
            }
            if (n6 > n) {
                n4 = n6 - n;
                n3 = 0;
                for (n2 = n6 - 1; n2 >= 0; --n2) {
                    if (dynamicValueList.get(n2) <= 0 || ++n3 != n4) continue;
                    n = n2;
                    break;
                }
            }
        }
        n4 = this.getHorizontalExtent(n);
        if (!this.reportPane.isColumnEndless()) {
            int n7;
            n3 = n5 + 1;
            n2 = n3;
            if (n > n2 - n4 && n > n6 && n6 >= n2 - (n7 = this.getHorizontalExtent(n6))) {
                n = n6;
            }
        } else {
            n3 = Math.max(n5, n4) + 1;
            n3 = Math.max(n + n4, n3);
            GridSelection gridSelection = this.reportPane.getGridSelection();
            int n8 = gridSelection.getType();
            if (n8 == 0) {
                Rectangle rectangle = gridSelection.getFirstCellRectangle();
                n3 = Math.max(rectangle.x + rectangle.width + 1, n3);
            }
        }
        if (n != (boundedRangeModel = this.getModel()).getValue() || n4 != boundedRangeModel.getExtent() || n3 != boundedRangeModel.getMaximum()) {
            if (!this.reportPane.isColumnEndless()) {
                boundedRangeModel.setRangeProperties(n, n4, 0, n3, false);
            } else {
                boundedRangeModel.setRangeProperties(n, n4, 0, n3, true);
            }
            this.reportPane.getGrid().setHorizontalValue(n);
            this.reportPane.getGrid().setHorizontalExtent(n4);
            this.reportPane.repaint(10L);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n6), new Integer(this.getValue()));
            }
        }
    }

    private int getHorizontalExtent(int n) {
        int n2;
        TemplateReport templateReport = this.reportPane.getEditingReport();
        DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
        double d = this.reportPane.getGrid().getWidth();
        double d2 = 0.0;
        int n3 = n;
        while (true) {
            if ((d2 += (double)dynamicValueList.get(n3)) > d) {
                n2 = n3;
                int n4 = n3;
                while (dynamicValueList.get(n4) == 0) {
                    n2 = n4++;
                }
                break;
            }
            ++n3;
        }
        return n2 - n;
    }

    public boolean isSupportHide() {
        return this.isSupportHide;
    }

    public void setSupportHide(boolean bl) {
        this.isSupportHide = bl;
    }

    public Dimension getPreferredSize() {
        if (this.isSupportHide && (this.getOrientation() == 0 ? this.reportPane != null && !this.reportPane.isHorizontalScrollBarVisible() : this.getOrientation() == 1 && this.reportPane != null && !this.reportPane.isVerticalScrollBarVisible())) {
            return new Dimension(0, 0);
        }
        return super.getPreferredSize();
    }
}

