/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.data.core.DataUtils;
import com.fr.data.util.function.DataFunction;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class FunctionComboBox
extends JComboBox {
    DefaultListCellRenderer functionCellRenderer = new DefaultListCellRenderer(){

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof DataFunction) {
                DataFunction dataFunction = (DataFunction)object;
                this.setText(DataUtils.getFunctionDisplayName(dataFunction));
            }
            return this;
        }
    };

    public FunctionComboBox(DataFunction[] dataFunctionArray) {
        this.setModel(new DefaultComboBoxModel<DataFunction>(dataFunctionArray));
        this.setRenderer(this.functionCellRenderer);
    }

    public DataFunction getFunction() {
        return (DataFunction)this.getSelectedItem();
    }

    public void setFunction(DataFunction dataFunction) {
        if (dataFunction == null) {
            return;
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            DataFunction dataFunction2 = (DataFunction)defaultComboBoxModel.getElementAt(i);
            if (dataFunction2 == null || !dataFunction.getClass().equals(dataFunction2.getClass())) continue;
            this.setSelectedIndex(i);
            break;
        }
    }
}

