/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.Nameable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.dav.LocalEnv;
import com.fr.base.file.DatasourceManager;
import com.fr.base.xml.XMLReadable;
import com.fr.cell.core.ListTableModel;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.report.TemplateWorkBook;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.util.Consts;
import com.fr.util.OperatingSystem;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GUICoreUtils {
    private GUICoreUtils() {
    }

    public static void setSelectedItem(JComboBox jComboBox, Object object) {
        jComboBox.setSelectedItem(object);
        if (jComboBox.getSelectedItem() != object) {
            jComboBox.getModel().setSelectedItem(object);
        }
    }

    public static TitledBorder createTitledBorder(String string, Color color) {
        TitledBorder titledBorder = new TitledBorder(string);
        if (color == null) {
            color = new Color(102, 153, 255);
        }
        titledBorder.setTitleColor(color);
        return titledBorder;
    }

    public static JComponent createToolBarPane(JComponent jComponent, boolean bl, LayoutManager layoutManager) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBackground(Color.darkGray);
        jToolBar.setLayout(layoutManager == null ? new BorderLayout() : layoutManager);
        jToolBar.setFloatable(bl);
        jToolBar.add(jComponent);
        return jToolBar;
    }

    public static void setWindowCenter(Window window, Window window2) {
        Point point = window.getLocation();
        Dimension dimension = window.getSize();
        Dimension dimension2 = window2.getSize();
        window2.setLocation((dimension.width - dimension2.width) / 2 + point.x, (dimension.height - dimension2.height) / 2 + point.y);
    }

    public static void setWindowFullScreen(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (OperatingSystem.isWindows()) {
            window.setLocation(0, 0);
            window.setSize(dimension.width, dimension.height - 28);
        } else {
            window.setLocation(5, 23);
            window.setSize(dimension.width, dimension.height - 56);
        }
    }

    public static void showPopupCloseMenu(JPopupMenu jPopupMenu, Component component) {
        if (jPopupMenu == null) {
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Window window = SwingUtilities.getWindowAncestor(component);
        int n = 0;
        int n2 = component.getLocation().x + window.getLocation().x + jPopupMenu.getPreferredSize().width;
        if (n2 > dimension.width) {
            n = dimension.width - n2;
        }
        jPopupMenu.show(component, n, component.getSize().height);
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        if (jPopupMenu == null) {
            return;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension = jPopupMenu.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        dimension2.setSize(dimension2.getSize().width, dimension2.height - 28);
        if (point.x + dimension.width > dimension2.width && dimension.width < dimension2.width) {
            n += dimension2.width - point.x - dimension.width;
        }
        if (point.y + dimension.height > dimension2.height && dimension.height < dimension2.height) {
            n2 -= dimension.height;
        }
        jPopupMenu.show(component, n, n2);
    }

    public static void setEnabled(JComponent jComponent, boolean bl) {
        Border border = jComponent.getBorder();
        if (border != null && border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            if (bl) {
                titledBorder.setTitleColor(UIManager.getColor("Label.foreground"));
            } else {
                titledBorder.setTitleColor(UIManager.getColor("Label.disabledForeground"));
            }
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (component instanceof JComponent) {
                GUICoreUtils.setEnabled((JComponent)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
        jComponent.setEnabled(bl);
    }

    public static Applet getAppletAncestor(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Applet)) continue;
            return (Applet)container;
        }
        return null;
    }

    public static JPanel createNamedPane(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(4, 4));
        jPanel.add((Component)new JLabel(string), "West");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    public static JPanel createVerticalNamedPane(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(4, 4));
        jPanel.add((Component)new JLabel(string), "North");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    public static JPanel createFlowPane(Component component, int n) {
        return GUICoreUtils.createFlowPane(new Component[]{component}, n);
    }

    public static JPanel createFlowPane(Component[] componentArray, int n) {
        return GUICoreUtils.createFlowPane(componentArray, n, 0);
    }

    public static JPanel createFlowPane(Component[] componentArray, int n, int n2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n, n2, 0));
        for (int i = 0; i < componentArray.length; ++i) {
            jPanel.add(componentArray[i]);
        }
        return jPanel;
    }

    public static JPanel createBorderPane(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent, string);
        return jPanel;
    }

    public static String[] getSelectedColumnNames(TemplateWorkBook templateWorkBook, DSColumn dSColumn) {
        XMLReadable xMLReadable;
        TableData tableData;
        TableData tableData2 = tableData = templateWorkBook == null ? null : templateWorkBook.getTableData(dSColumn.getDSName());
        if (tableData == null) {
            xMLReadable = FRContext.getDatasourceManager();
            tableData = ((DatasourceManager)xMLReadable).getTableData(dSColumn.getDSName());
        }
        if (tableData == null) {
            return new String[0];
        }
        xMLReadable = null;
        if (FRContext.getCurrentEnv() instanceof LocalEnv) {
            xMLReadable = tableData;
        } else {
            try {
                xMLReadable = FRContext.getCurrentEnv().previewTableData(tableData, Collections.EMPTY_MAP, 0);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (xMLReadable != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                for (int i = 0; i < xMLReadable.getColumnCount(); ++i) {
                    arrayList.add(xMLReadable.getColumnName(i));
                }
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    public static TreePath getTreePath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (treeNode != null) {
            arrayList.add(treeNode);
            while ((treeNode = treeNode.getParent()) != null) {
                arrayList.add(0, treeNode);
            }
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        if (objectArray.length <= 0) {
            return null;
        }
        return new TreePath(objectArray);
    }

    public static TreePath getTopTreePath(JTree jTree, TreePath[] treePathArray) {
        if (jTree == null || treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        TreePath treePath = null;
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < treePathArray.length; ++i) {
            int n2 = jTree.getRowForPath(treePathArray[i]);
            if (n2 >= n) continue;
            n = n2;
            treePath = treePathArray[i];
        }
        return treePath;
    }

    public static Color getTitleLineBorderColor() {
        Border border = UIManager.getBorder("TitledBorder.border");
        if (border instanceof LineBorder) {
            return ((LineBorder)border).getLineColor();
        }
        return Color.GRAY;
    }

    public static AbstractButton createMoveUpButton(JList jList) {
        JButton jButton = new JButton(BaseUtils.readIcon("/com/fr/design/images/control/up.png"));
        jButton.addActionListener(new MoveListActionListener(jList, true));
        jButton.setToolTipText(Inter.getLocText("Utils-Move_Up"));
        jButton.setPreferredSize(new Dimension(24, 24));
        return jButton;
    }

    public static AbstractButton createMoveDownButton(JList jList) {
        JButton jButton = new JButton(BaseUtils.readIcon("/com/fr/design/images/control/down.png"));
        jButton.addActionListener(new MoveListActionListener(jList, false));
        jButton.setToolTipText(Inter.getLocText("Utils-Move_Down"));
        jButton.setPreferredSize(new Dimension(24, 24));
        return jButton;
    }

    public static AbstractButton createMoveUpButton(JTable jTable) {
        JButton jButton = new JButton(BaseUtils.readIcon("/com/fr/design/images/control/up.png"));
        jButton.addActionListener(new MoveListJTableActionListener(jTable, true));
        jButton.setText(Inter.getLocText("Utils-Move_Up"));
        return jButton;
    }

    public static AbstractButton createMoveDownButton(JTable jTable) {
        JButton jButton = new JButton(BaseUtils.readIcon("/com/fr/design/images/control/down.png"));
        jButton.addActionListener(new MoveListJTableActionListener(jTable, false));
        jButton.setText(Inter.getLocText("Utils-Move_Down"));
        return jButton;
    }

    public static String popupInputNewName(Window window, List list) {
        String string;
        while (true) {
            if ((string = JOptionPane.showInputDialog(window, Inter.getLocText("Utils-Please_Input_a_New_Name") + ":", "")) == null) {
                return null;
            }
            if (string.trim().length() <= 0) {
                JOptionPane.showMessageDialog(window, Inter.getLocText("Utils-New_name_cannot_be_null") + ".", Consts.APP_NAME, 0);
                continue;
            }
            boolean bl = false;
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!ComparatorUtils.equals(string, list.get(i))) continue;
                    JOptionPane.showMessageDialog(window, "\"" + string + "\" " + Inter.getLocText("Utils-The_Name_has_been_existed") + ".", Consts.APP_NAME, 0);
                    bl = true;
                    break;
                }
            }
            if (!bl) break;
        }
        return string;
    }

    public static String popupRenameName(Window window, String string, List list) {
        String string2;
        while (true) {
            if ((string2 = JOptionPane.showInputDialog(window, Inter.getLocText("Rename") + ":", string)) == null) {
                return null;
            }
            if (string2.trim().length() <= 0) {
                JOptionPane.showMessageDialog(window, Inter.getLocText("Utils-New_name_cannot_be_null") + ".", Consts.APP_NAME, 0);
                continue;
            }
            boolean bl = false;
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!ComparatorUtils.equals(string2, list.get(i))) continue;
                    JOptionPane.showMessageDialog(window, "\"" + string2 + "\" " + Inter.getLocText("Utils-has_been_existed") + ".", Consts.APP_NAME, 0);
                    bl = true;
                    string2 = string;
                    break;
                }
            }
            if (!bl) break;
        }
        return string2;
    }

    public static boolean removeJListSelectedNodes(Window window, JList jList) {
        int n = jList.getSelectedIndex();
        if (n == -1) {
            return false;
        }
        int n2 = JOptionPane.showConfirmDialog(window, Inter.getLocText("Utils-Are_you_sure_to_remove_the_selected_item") + "?", Inter.getLocText("Remove"), 2, 3);
        if (n2 == 0) {
            int n3 = jList.getMinSelectionIndex();
            int[] nArray = jList.getSelectedIndices();
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)jList.getModel()).remove(nArray[i]);
            }
            if (jList.getModel().getSize() > 0) {
                if (n3 < jList.getModel().getSize()) {
                    jList.setSelectedValue(jList.getModel().getElementAt(n3), true);
                } else {
                    jList.setSelectedValue(jList.getModel().getElementAt(jList.getModel().getSize() - 1), true);
                }
            }
            return true;
        }
        return false;
    }

    public static JFormattedTextField getSpinnerTextField(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        System.err.println("Unexpected editor type: " + jSpinner.getEditor().getClass() + " isn't a descendant of DefaultEditor");
        return null;
    }

    public static void setColumnForSpinner(JSpinner jSpinner, int n) {
        JFormattedTextField jFormattedTextField = GUICoreUtils.getSpinnerTextField(jSpinner);
        if (jFormattedTextField != null) {
            jFormattedTextField.setColumns(n);
            jFormattedTextField.setHorizontalAlignment(2);
        }
    }

    public static void repaint(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.invalidate();
                component.validate();
                component.repaint();
            }
        });
    }

    static class MoveListJTableActionListener
    implements ActionListener {
        private JTable nameTable = null;
        private boolean isUp = true;

        public MoveListJTableActionListener(JTable jTable, boolean bl) {
            this.nameTable = jTable;
            this.isUp = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.nameTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            if (this.isUp) {
                TableModel tableModel;
                if (n > 0 && (tableModel = this.nameTable.getModel()) instanceof ListTableModel) {
                    ListTableModel listTableModel = (ListTableModel)tableModel;
                    List list = listTableModel.getList();
                    Object e = list.get(n - 1);
                    list.set(n - 1, list.get(n));
                    list.set(n, e);
                    listTableModel.fireTableDataChanged();
                    this.nameTable.setRowSelectionInterval(n - 1, n - 1);
                }
            } else {
                TableModel tableModel = this.nameTable.getModel();
                if (n < tableModel.getRowCount() - 1 && tableModel instanceof ListTableModel) {
                    ListTableModel listTableModel = (ListTableModel)tableModel;
                    List list = listTableModel.getList();
                    Object e = list.get(n + 1);
                    list.set(n + 1, list.get(n));
                    list.set(n, e);
                    listTableModel.fireTableDataChanged();
                    this.nameTable.setRowSelectionInterval(n + 1, n + 1);
                }
            }
        }
    }

    static class MoveListActionListener
    implements ActionListener {
        private JList nameObjectList = null;
        private boolean isUp = true;

        public MoveListActionListener(JList jList, boolean bl) {
            this.nameObjectList = jList;
            this.isUp = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.nameObjectList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            if (this.isUp) {
                if (n > 0) {
                    DefaultListModel defaultListModel = (DefaultListModel)this.nameObjectList.getModel();
                    Object e = defaultListModel.get(n - 1);
                    defaultListModel.set(n - 1, defaultListModel.get(n));
                    defaultListModel.set(n, e);
                    this.nameObjectList.setSelectedIndex(n - 1);
                    this.nameObjectList.ensureIndexIsVisible(n - 1);
                }
            } else {
                if (n == -1) {
                    return;
                }
                if (n < this.nameObjectList.getModel().getSize() - 1) {
                    DefaultListModel defaultListModel = (DefaultListModel)this.nameObjectList.getModel();
                    Object e = defaultListModel.get(n + 1);
                    defaultListModel.set(n + 1, defaultListModel.get(n));
                    defaultListModel.set(n, e);
                    this.nameObjectList.setSelectedIndex(n + 1);
                    this.nameObjectList.ensureIndexIsVisible(n + 1);
                }
            }
        }
    }

    static class RenameActionListener
    implements ActionListener {
        private JList nameList;

        public RenameActionListener(JList jList) {
            this.nameList = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            int n = this.nameList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(this.nameList);
            ArrayList<String> arrayList = new ArrayList<String>();
            DefaultListModel defaultListModel = (DefaultListModel)this.nameList.getModel();
            for (int i = 0; i < defaultListModel.size(); ++i) {
                object = (Nameable)defaultListModel.get(i);
                arrayList.add(object.getName());
            }
            Nameable nameable = (Nameable)this.nameList.getSelectedValue();
            object = GUICoreUtils.popupRenameName(window, nameable.getName(), arrayList);
            if (object != null) {
                nameable.setName((String)object);
                this.nameList.repaint();
            }
        }
    }
}

