/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.base.BaseUtils;
import com.fr.base.ColumnRow;
import com.fr.base.Inter;
import com.fr.base.core.list.IntList;
import com.fr.cell.GridColumn;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.GridUtils;
import com.fr.report.CellElement;
import com.fr.report.TemplateReport;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import com.fr.util.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class GridColumnMouseHandler
extends MouseInputAdapter {
    private GridColumn gridColumn;
    private int dragType = GridUtils.DRAG_NONE;
    private boolean isMulitColumnsSelectDragPermited = false;
    private int startMultiSelectIndex = 0;
    private int endMultiSelectIndex = 0;
    private boolean isDragPermited = false;
    private int dragColumnIndex = 0;
    private JToolTip columnTip = null;
    private JWindow tipWindow = null;

    public GridColumnMouseHandler(GridColumn gridColumn) {
        this.gridColumn = gridColumn;
    }

    public void setStartMultiSelectIndex(int n) {
        this.startMultiSelectIndex = n;
    }

    public void setEndMultiSelectIndex(int n) {
        this.endMultiSelectIndex = n;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.gridColumn.isEnabled()) {
            return;
        }
        ReportPane reportPane = this.gridColumn.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        reportPane.getGrid().stopEditing();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = mouseEvent.isShiftDown();
        boolean bl2 = mouseEvent.isControlDown();
        boolean bl3 = SwingUtilities.isRightMouseButton(mouseEvent);
        ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, n, n2);
        if (!reportPane.isColumnEndless()) {
            int n3 = templateReport.getColumnCount() - 1;
            if (columnRow.getColumn() > n3 + 1) {
                return;
            }
        }
        DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
        int n4 = reportPane.getGrid().getHorizontalValue();
        int n5 = reportPane.getGrid().getHorizontalExtent();
        int n6 = n4 + n5 + 1;
        int n7 = reportPane.getGrid().getHorizontalBeginValue();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n7; i <= n6; ++i) {
            double d3;
            if (i == 0) {
                i = n4;
            }
            if (this.isOnSeparatorLineIncludeZero(n, d3 = (d2 = (double)dynamicValueList.get(i)) <= 0.0 ? d + 1.0 : (d += d2) + d2, d2) || this.isOnNormalSeparatorLine(n, d3)) {
                this.dragType = GridUtils.DRAG_WIDTH;
                this.isDragPermited = true;
                this.dragColumnIndex = i;
                this.showToolTip(mouseEvent, this.createToolTipString(dynamicValueList.get(this.dragColumnIndex), dynamicValueList.getRangeValue(0, this.dragColumnIndex + 1)));
                break;
            }
            if (!((double)n > d) || !((double)n <= d3)) continue;
            this.dragType = GridUtils.DRAG_SELECT_COLUMNS;
            this.isMulitColumnsSelectDragPermited = true;
            this.startMultiSelectIndex = i;
            this.showToolTip(mouseEvent, this.createToolTipString(1));
            break;
        }
        if (bl3) {
            JPopupMenu jPopupMenu;
            GridSelection gridSelection = reportPane.getGridSelection();
            gridSelection.setType(0);
            IntList intList = GridUtils.getGridSelectionColumnIndex(gridSelection);
            if (columnRow.getColumn() < intList.get(0) || columnRow.getColumn() > intList.get(intList.size() - 1)) {
                this.doSelectColumn(columnRow.getColumn());
            }
            if ((jPopupMenu = reportPane.createColumnPopupMenu(mouseEvent, Math.max(this.dragColumnIndex, Math.min(this.startMultiSelectIndex, this.endMultiSelectIndex)))) != null) {
                GUICoreUtils.showPopupMenu(jPopupMenu, this.gridColumn, n + 1, n2 + 1);
            }
        } else if (this.dragType == GridUtils.DRAG_SELECT_COLUMNS) {
            GridSelection gridSelection = reportPane.getGridSelection();
            gridSelection.setType(0);
            if (bl) {
                Rectangle rectangle = null;
                rectangle = bl2 ? gridSelection.getLastCellRectangle() : gridSelection.getFirstCellRectangle();
                this.doShiftSelectColumn(reportPane, n, n2, rectangle);
            } else if (bl2) {
                this.doControlSelectColumn(reportPane, n, n2);
            } else {
                columnRow = GridUtils.getEventColumnRow(reportPane, n, n2);
                this.doSelectColumn(columnRow.getColumn());
            }
        }
        this.gridColumn.getReportPane().repaint();
    }

    private void doShiftSelectColumn(ReportPane reportPane, double d, double d2, Rectangle rectangle) {
        ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, d, d2);
        int n = columnRow.getColumn();
        int n2 = columnRow.getRow();
        GridSelection gridSelection = reportPane.getGridSelection();
        Rectangle rectangle2 = gridSelection.getEditRectangle();
        int n3 = rectangle2.x;
        if (columnRow.getColumn() >= rectangle2.x) {
            columnRow = ColumnRow.valueOf(columnRow.getColumn() + 1, columnRow.getRow());
        } else {
            ++n3;
        }
        int n4 = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getRow();
        Rectangle rectangle3 = new Rectangle(Math.min(n3, columnRow.getColumn()), 0, Math.max(rectangle2.width, Math.abs(n3 - columnRow.getColumn())), n4);
        rectangle.setBounds(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        reportPane.ensureColumnRowVisible(n, n2);
    }

    private void doControlSelectColumn(ReportPane reportPane, double d, double d2) {
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        gridSelection.setType(0);
        int n = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getRow();
        ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, d, d2);
        CellElement cellElement = templateReport.getCellElement(columnRow.getColumn(), 0);
        if (cellElement == null) {
            gridSelection.setEditBounds(columnRow.getColumn(), 0, 1, 1);
            gridSelection.addCellRectangle(new Rectangle(columnRow.getColumn(), 0, 1, n));
        } else {
            gridSelection.setEditBounds(cellElement.getColumn(), cellElement.getRow(), 1, cellElement.getRowSpan());
            gridSelection.addCellRectangle(new Rectangle(cellElement.getColumn(), 0, 1, n));
        }
        reportPane.setGridSelection(gridSelection);
        this.dealCellSelection(reportPane);
        reportPane.ensureColumnRowVisible(columnRow.getColumn(), columnRow.getRow());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.gridColumn.isEnabled()) {
            return;
        }
        ReportPane reportPane = this.gridColumn.getReportPane();
        reportPane.getGrid().stopEditing();
        this.isMulitColumnsSelectDragPermited = false;
        this.isDragPermited = false;
        this.hideToolTip();
        if (this.dragType == GridUtils.DRAG_WIDTH) {
            GridSelection gridSelection = reportPane.getGridSelection();
            int n = gridSelection.getType();
            if (n == 0) {
                boolean bl = true;
                int n2 = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getRow();
                for (int i = 0; i < gridSelection.getCellRectangleCount(); ++i) {
                    int n3 = gridSelection.getCellRectangle((int)i).height;
                    if (n3 >= n2) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    IntList intList = GridUtils.getGridSelectionColumnIndex(gridSelection);
                    DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(reportPane.getEditingReport());
                    int n4 = dynamicValueList.get(this.dragColumnIndex);
                    for (int i = 0; i < intList.size(); ++i) {
                        if (intList.get(i) != this.dragColumnIndex) continue;
                        for (int j = 0; j < intList.size(); ++j) {
                            dynamicValueList.set(intList.get(j), n4);
                        }
                    }
                }
            }
            reportPane.getVerticalScrollBar().setValue(reportPane.getVerticalScrollBar().getValue());
            reportPane.getHorizontalScrollBar().setValue(reportPane.getHorizontalScrollBar().getValue());
        }
        this.dragType = GridUtils.DRAG_NONE;
        this.dragColumnIndex = 0;
        reportPane.fireReportDataChanged();
        reportPane.undoRecord();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.gridColumn.isEnabled()) {
            return;
        }
        ReportPane reportPane = this.gridColumn.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        if (this.dragType == GridUtils.DRAG_NONE || SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        GridSelection gridSelection = reportPane.getGridSelection();
        reportPane.getGrid().stopEditing();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < 0) {
            n = 0;
        }
        if (this.dragType == GridUtils.DRAG_SELECT_COLUMNS) {
            if (!this.isMulitColumnsSelectDragPermited) {
                return;
            }
            int n3 = templateReport.getColumnCount() - 1;
            ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, n, n2);
            if (!reportPane.isColumnEndless() && columnRow.getColumn() > n3 + 1) {
                return;
            }
            this.endMultiSelectIndex = columnRow.getColumn();
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            int n4 = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getRow();
            if (this.endMultiSelectIndex > this.startMultiSelectIndex) {
                int n5 = this.endMultiSelectIndex - this.startMultiSelectIndex + 1;
                rectangle = new Rectangle(this.startMultiSelectIndex, 0, 1, 1);
                rectangle2 = new Rectangle(this.startMultiSelectIndex, 0, n5, n4);
            } else if (this.endMultiSelectIndex < this.startMultiSelectIndex) {
                int n6 = this.startMultiSelectIndex - this.endMultiSelectIndex + 1;
                rectangle = new Rectangle(this.startMultiSelectIndex, 0, 1, 1);
                rectangle2 = new Rectangle(this.endMultiSelectIndex, 0, n6, n4);
            } else {
                rectangle = new Rectangle(this.startMultiSelectIndex, 0, 1, 1);
                rectangle2 = new Rectangle(this.startMultiSelectIndex, 0, 1, n4);
            }
            gridSelection.setType(0);
            gridSelection.setEditBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            gridSelection.setOnlyCellBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            this.dealCellSelection(reportPane);
            reportPane.fireGridSelectionChanged();
            this.setToolTipText2(this.createToolTipString(Math.abs(this.startMultiSelectIndex - this.endMultiSelectIndex) + 1));
        } else if (this.dragType == GridUtils.DRAG_WIDTH) {
            if (!this.isDragPermited) {
                return;
            }
            DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
            int n7 = reportPane.getGrid().getHorizontalValue();
            int n8 = reportPane.getGrid().getHorizontalExtent();
            int n9 = n7 + n8 + 1;
            int n10 = reportPane.getGrid().getHorizontalBeginValue();
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            for (int i = n10; i <= n9; ++i) {
                if (i == 0) {
                    i = n7;
                }
                int n14 = (n13 = dynamicValueList.get(i)) <= 0 ? n12 + 1 : (n12 += n13) + n13;
                if (i == this.dragColumnIndex) {
                    n11 = n12;
                }
                if (n < n12 || n >= n14) continue;
                if (i >= this.dragColumnIndex) {
                    dynamicValueList.set(this.dragColumnIndex, n - n11);
                    break;
                }
                dynamicValueList.set(i, n - n12);
                for (int j = this.dragColumnIndex - 1; j > i; --j) {
                    dynamicValueList.set(j, 0);
                }
                break;
            }
            this.setToolTipText2(this.createToolTipString(dynamicValueList.get(this.dragColumnIndex), dynamicValueList.getRangeValue(0, this.dragColumnIndex + 1)));
        }
        this.gridColumn.getReportPane().repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.gridColumn.isEnabled()) {
            return;
        }
        ReportPane reportPane = this.gridColumn.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        this.gridColumn.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(BaseUtils.readImage("/com/fr/cell/images/cursor/cursor_hselect.gif"), new Point(16, 16), "hor_select"));
        int n = mouseEvent.getX();
        DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(templateReport);
        int n2 = reportPane.getGrid().getHorizontalValue();
        int n3 = reportPane.getGrid().getHorizontalExtent();
        int n4 = n2 + n3 + 1;
        int n5 = reportPane.getGrid().getHorizontalBeginValue();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n5; i < n4; ++i) {
            double d3;
            if (i == 0) {
                i = n2;
            }
            if (this.isOnSeparatorLineIncludeZero(n, d3 = (d2 = (double)dynamicValueList.get(i)) <= 0.0 ? d + 1.0 : (d += d2) + d2, d2)) {
                this.gridColumn.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(BaseUtils.readImage("/com/fr/cell/images/cursor/cursor_hsplit.gif"), new Point(16, 16), "ver_split"));
                break;
            }
            if (!this.isOnNormalSeparatorLine(n, d3)) continue;
            this.gridColumn.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(BaseUtils.readImage("/com/fr/cell/images/cursor/cursor_hmove.gif"), new Point(16, 16), "ver_move"));
            break;
        }
    }

    private boolean isOnSeparatorLineIncludeZero(double d, double d2, double d3) {
        return d3 == 0.0 && d >= d2 + 2.0 && d <= d2 + 5.0;
    }

    private boolean isOnNormalSeparatorLine(double d, double d2) {
        return d >= d2 - 2.0 && d <= d2 + 2.0;
    }

    private void showToolTip(MouseEvent mouseEvent, String string) {
        if (this.tipWindow == null) {
            this.tipWindow = new JWindow();
            this.columnTip = this.gridColumn.createToolTip();
            this.tipWindow.getContentPane().add((Component)this.columnTip, "Center");
        }
        this.columnTip.setTipText(string);
        Point point = new Point(mouseEvent.getX(), 0);
        SwingUtilities.convertPointToScreen(point, this.gridColumn);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.columnTip.getPreferredSize();
        int n = Math.max(0, Math.min(point.x - dimension2.width / 2, dimension.width - dimension2.width));
        int n2 = point.y - dimension2.height - 2;
        this.tipWindow.setLocation(n, n2);
        this.tipWindow.pack();
        this.tipWindow.setVisible(true);
    }

    private void hideToolTip() {
        if (this.tipWindow != null) {
            this.tipWindow.setVisible(false);
        }
    }

    private void setToolTipText2(String string) {
        if (this.columnTip == null) {
            return;
        }
        this.columnTip.setTipText(string);
        this.columnTip.setSize(this.columnTip.getPreferredSize());
        this.tipWindow.pack();
        this.tipWindow.repaint();
    }

    private String createToolTipString(double d, double d2) {
        return Inter.getLocText("Width") + ": " + Utils.doubleToString(d) + "/" + Utils.doubleToString(d2) + Inter.getLocText("px");
    }

    private String createToolTipString(int n) {
        return n + "C";
    }

    private void doSelectColumn(int n) {
        ReportPane reportPane = this.gridColumn.getReportPane();
        GridSelection gridSelection = reportPane.getGridSelection();
        gridSelection.setType(0);
        this.startMultiSelectIndex = this.endMultiSelectIndex = n;
        int n2 = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getRow();
        gridSelection.setEditBounds(n, 0, 1, 1);
        gridSelection.setOnlyCellBounds(n, 0, 1, n2);
        this.dealCellSelection(reportPane);
        reportPane.fireGridSelectionChanged();
    }

    private void dealCellSelection(ReportPane reportPane) {
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            return;
        }
        TemplateReport templateReport = reportPane.getEditingReport();
        Rectangle rectangle = gridSelection.getEditRectangle();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        CellElement cellElement = templateReport.getCellElement(n2, n3);
        while (cellElement != null && (cellElement.getRowSpan() != 1 || cellElement.getColumnSpan() != 1)) {
            cellElement = templateReport.getCellElement(n2, n3 += cellElement.getRowSpan());
        }
        rectangle.setBounds(n2, n3, n4, n5);
    }
}

