/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.base.ColumnRow;
import com.fr.cell.GridColumn;
import com.fr.cell.GridCorner;
import com.fr.cell.GridRow;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GUIConstants;
import com.fr.cell.core.GridColumnMouseHandler;
import com.fr.cell.core.GridRowMouseHandler;
import com.fr.cell.core.GridUtils;
import com.fr.report.CellElement;
import com.fr.report.TemplateReport;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class GridCornerMouseHandler
extends MouseInputAdapter {
    GridCorner gridCorner;

    public GridCornerMouseHandler(GridCorner gridCorner) {
        this.gridCorner = gridCorner;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.gridCorner.isEnabled()) {
            return;
        }
        ReportPane reportPane = this.gridCorner.getReportPane();
        this.doSelectAll();
        reportPane.getHorizontalScrollBar().setValue(reportPane.getHorizontalScrollBar().getValue());
        reportPane.getVerticalScrollBar().setValue(reportPane.getVerticalScrollBar().getValue());
    }

    private void doSelectAll() {
        ReportPane reportPane = this.gridCorner.getReportPane();
        ColumnRow columnRow = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane);
        GridSelection gridSelection = reportPane.getGridSelection();
        gridSelection.setType(0);
        gridSelection.setEditBounds(0, 0, 1, 1);
        gridSelection.setOnlyCellBounds(0, 0, columnRow.getColumn(), columnRow.getRow());
        this.dealCellSelection(reportPane);
        reportPane.fireGridSelectionChanged();
        GridColumn gridColumn = this.gridCorner.getReportPane().getGridColumn();
        GridColumnMouseHandler gridColumnMouseHandler = new GridColumnMouseHandler(gridColumn);
        gridColumnMouseHandler.setStartMultiSelectIndex(0);
        gridColumnMouseHandler.setEndMultiSelectIndex(columnRow.getColumn());
        gridColumn.addMouseListener(gridColumnMouseHandler);
        gridColumn.addMouseMotionListener(gridColumnMouseHandler);
        GridRow gridRow = this.gridCorner.getReportPane().getGridRow();
        GridRowMouseHandler gridRowMouseHandler = new GridRowMouseHandler(gridRow);
        gridRowMouseHandler.setStartMultiSelectIndex(0);
        gridRowMouseHandler.setEndMultiSelectIndex(columnRow.getRow());
        gridRow.addMouseListener(gridRowMouseHandler);
        gridRow.addMouseMotionListener(gridRowMouseHandler);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.gridCorner.isEnabled()) {
            return;
        }
        this.gridCorner.setCursor(GUIConstants.CellDefaultCursor);
    }

    private void dealCellSelection(ReportPane reportPane) {
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            return;
        }
        Rectangle rectangle = gridSelection.getEditRectangle();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        CellElement cellElement = templateReport.getCellElement(n2, n3);
        if (cellElement != null) {
            n4 = cellElement.getColumnSpan();
            n5 = cellElement.getRowSpan();
        }
        rectangle.width = n4;
        rectangle.height = n5;
    }
}

