/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.base.BaseUtils;
import com.fr.base.ColumnRow;
import com.fr.base.Inter;
import com.fr.base.core.list.IntList;
import com.fr.cell.GridRow;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.GridUtils;
import com.fr.report.CellElement;
import com.fr.report.TemplateReport;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import com.fr.util.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class GridRowMouseHandler
extends MouseInputAdapter {
    private GridRow gridRow;
    private int dragType = GridUtils.DRAG_NONE;
    private boolean isMultiRowsSelectDragPermited = false;
    private int startMultiSelectIndex = 0;
    private int endMultiSelectIndex = 0;
    private boolean isDragPermited = false;
    private int dragRowIndex = 0;
    private JToolTip rowTip = null;
    private JWindow tipWindow = null;

    public GridRowMouseHandler(GridRow gridRow) {
        this.gridRow = gridRow;
    }

    public void setStartMultiSelectIndex(int n) {
        this.startMultiSelectIndex = n;
    }

    public void setEndMultiSelectIndex(int n) {
        this.endMultiSelectIndex = n;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.gridRow.isEnabled()) {
            return;
        }
        ReportPane reportPane = this.gridRow.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        reportPane.getGrid().stopEditing();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = mouseEvent.isShiftDown();
        boolean bl2 = mouseEvent.isControlDown();
        boolean bl3 = SwingUtilities.isRightMouseButton(mouseEvent);
        int n3 = templateReport.getRowCount() - 1;
        ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, n, n2);
        if (!reportPane.isRowEndless() && columnRow.getRow() > n3 + 1) {
            return;
        }
        DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(templateReport);
        int n4 = reportPane.getGrid().getVerticalValue();
        int n5 = reportPane.getGrid().getVerticalExtent();
        int n6 = n4 + n5 + 1;
        int n7 = reportPane.getGrid().getVerticalBeginValue();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n7; i < n6; ++i) {
            double d3;
            if (i == 0) {
                i = n4;
            }
            if (this.isOnZeroSeparatorLine(n2, d3 = (d2 = (double)dynamicValueList.get(i)) <= 0.0 ? d + 1.0 : (d += d2) + d2, d2) || this.isOnNormalSeparatorLine(n2, d3)) {
                this.dragType = GridUtils.DRAG_HEIGHT;
                this.isDragPermited = true;
                this.dragRowIndex = i;
                this.showToolTip(mouseEvent, this.createToolTipString(dynamicValueList.get(this.dragRowIndex), dynamicValueList.getRangeValue(0, this.dragRowIndex + 1)));
                break;
            }
            if (!((double)n2 > d) || !((double)n2 <= d3)) continue;
            this.dragType = GridUtils.DRAG_SELECT_ROWS;
            this.isMultiRowsSelectDragPermited = true;
            this.startMultiSelectIndex = i;
            this.showToolTip(mouseEvent, this.createToolTipString(1));
            break;
        }
        if (bl3) {
            JPopupMenu jPopupMenu;
            GridSelection gridSelection = reportPane.getGridSelection();
            gridSelection.setType(0);
            IntList intList = GridUtils.getGridSelectionRowIndex(gridSelection);
            if (columnRow.getRow() < intList.get(0) || columnRow.getRow() > intList.get(intList.size() - 1)) {
                this.doSelectRow(columnRow.getRow());
            }
            if ((jPopupMenu = reportPane.createRowPopupMenu(mouseEvent, Math.max(this.dragRowIndex, Math.min(this.startMultiSelectIndex, this.endMultiSelectIndex)))) != null) {
                GUICoreUtils.showPopupMenu(jPopupMenu, this.gridRow, n + 1, n2 + 1);
            }
        } else if (this.dragType == GridUtils.DRAG_SELECT_ROWS) {
            GridSelection gridSelection = reportPane.getGridSelection();
            gridSelection.setType(0);
            if (bl) {
                Rectangle rectangle = null;
                rectangle = bl2 ? gridSelection.getLastCellRectangle() : gridSelection.getFirstCellRectangle();
                this.doShiftSelectRow(reportPane, n, n2, rectangle);
            } else if (bl2) {
                this.doControlSelectRow(reportPane, n, n2);
            } else {
                columnRow = GridUtils.getEventColumnRow(reportPane, n, n2);
                this.doSelectRow(columnRow.getRow());
            }
        }
        this.gridRow.getReportPane().repaint();
    }

    private void doShiftSelectRow(ReportPane reportPane, double d, double d2, Rectangle rectangle) {
        ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, d, d2);
        int n = columnRow.getColumn();
        int n2 = columnRow.getRow();
        GridSelection gridSelection = reportPane.getGridSelection();
        Rectangle rectangle2 = gridSelection.getEditRectangle();
        int n3 = rectangle2.y;
        if (columnRow.getRow() >= rectangle2.y) {
            columnRow = ColumnRow.valueOf(columnRow.getColumn(), columnRow.getRow() + 1);
        } else {
            ++n3;
        }
        int n4 = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getColumn();
        Rectangle rectangle3 = new Rectangle(0, Math.min(n3, columnRow.getRow()), n4, Math.max(rectangle2.height, Math.abs(n3 - columnRow.getRow())));
        rectangle.setBounds(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        reportPane.ensureColumnRowVisible(n, n2);
    }

    private void doControlSelectRow(ReportPane reportPane, double d, double d2) {
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        gridSelection.setType(0);
        int n = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getColumn();
        ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(reportPane, d, d2);
        CellElement cellElement = templateReport.getCellElement(columnRow.getColumn(), 0);
        if (cellElement == null) {
            gridSelection.setEditBounds(0, columnRow.getRow(), 1, 1);
            gridSelection.addCellRectangle(new Rectangle(0, columnRow.getRow(), n, 1));
        } else {
            gridSelection.setEditBounds(cellElement.getColumn(), cellElement.getRow(), 1, cellElement.getRowSpan());
            gridSelection.addCellRectangle(new Rectangle(0, cellElement.getRow(), n, 1));
        }
        reportPane.setGridSelection(gridSelection);
        this.dealCellSelection(reportPane);
        reportPane.ensureColumnRowVisible(columnRow.getColumn(), columnRow.getRow());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.gridRow.isEnabled()) {
            return;
        }
        ReportPane reportPane = this.gridRow.getReportPane();
        reportPane.getGrid().stopEditing();
        this.isMultiRowsSelectDragPermited = false;
        this.isDragPermited = false;
        this.hideToolTip();
        if (this.dragType == GridUtils.DRAG_HEIGHT) {
            GridSelection gridSelection = reportPane.getGridSelection();
            int n = gridSelection.getType();
            if (n == 0) {
                boolean bl = true;
                int n2 = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getColumn();
                for (int i = 0; i < gridSelection.getCellRectangleCount(); ++i) {
                    int n3 = gridSelection.getCellRectangle((int)i).width;
                    if (n3 >= n2) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    IntList intList = GridUtils.getGridSelectionRowIndex(gridSelection);
                    DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(reportPane.getEditingReport());
                    int n4 = dynamicValueList.get(this.dragRowIndex);
                    for (int i = 0; i < intList.size(); ++i) {
                        if (intList.get(i) != this.dragRowIndex) continue;
                        for (int j = 0; j < intList.size(); ++j) {
                            dynamicValueList.set(intList.get(j), n4);
                        }
                    }
                }
            }
            reportPane.getVerticalScrollBar().setValue(reportPane.getVerticalScrollBar().getValue());
            reportPane.getHorizontalScrollBar().setValue(reportPane.getHorizontalScrollBar().getValue());
        }
        this.dragType = GridUtils.DRAG_NONE;
        this.dragRowIndex = 0;
        reportPane.fireReportDataChanged();
        reportPane.undoRecord();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.gridRow.isEnabled()) {
            return;
        }
        ReportPane reportPane = this.gridRow.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        if (this.dragType == GridUtils.DRAG_NONE || SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        reportPane.getGrid().stopEditing();
        GridSelection gridSelection = reportPane.getGridSelection();
        gridSelection.setType(0);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.dragType == GridUtils.DRAG_SELECT_ROWS) {
            if (!this.isMultiRowsSelectDragPermited) {
                return;
            }
            int n3 = templateReport.getRowCount() - 1;
            ColumnRow columnRow = GridUtils.getAdjustEventColumnRow(this.gridRow.getReportPane(), n, n2);
            if (!reportPane.isRowEndless() && columnRow.getRow() > n3 + 1) {
                return;
            }
            this.endMultiSelectIndex = columnRow.getRow();
            int n4 = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getColumn();
            if (this.endMultiSelectIndex > this.startMultiSelectIndex) {
                int n5 = this.endMultiSelectIndex - this.startMultiSelectIndex + 1;
                gridSelection.setEditBounds(0, this.startMultiSelectIndex, 1, 1);
                gridSelection.setOnlyCellBounds(0, this.startMultiSelectIndex, n4, n5);
            } else if (this.endMultiSelectIndex < this.startMultiSelectIndex) {
                int n6 = this.startMultiSelectIndex - this.endMultiSelectIndex + 1;
                gridSelection.setEditBounds(0, this.startMultiSelectIndex, 1, 1);
                gridSelection.setOnlyCellBounds(0, this.endMultiSelectIndex, n4, n6);
            } else {
                gridSelection.setEditBounds(0, this.startMultiSelectIndex, 1, 1);
                gridSelection.setOnlyCellBounds(0, this.startMultiSelectIndex, n4, 1);
            }
            this.dealCellSelection(reportPane);
            this.setToolTipText2(this.createToolTipString(Math.abs(this.startMultiSelectIndex - this.endMultiSelectIndex) + 1));
            reportPane.fireGridSelectionChanged();
        } else {
            if (!this.isDragPermited) {
                return;
            }
            DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(templateReport);
            int n7 = reportPane.getGrid().getVerticalValue();
            int n8 = reportPane.getGrid().getVerticalExtent();
            int n9 = n7 + n8 + 1;
            int n10 = reportPane.getGrid().getVerticalBeginValue();
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            for (int i = n10; i < n9; ++i) {
                if (i == 0) {
                    i = n7;
                }
                int n14 = (n13 = dynamicValueList.get(i)) <= 0 ? n12 + 1 : (n12 += n13) + n13;
                if (i == this.dragRowIndex) {
                    n11 = n12;
                }
                if (n2 < n12 || n2 >= n14) continue;
                if (i >= this.dragRowIndex) {
                    dynamicValueList.set(this.dragRowIndex, n2 - n11);
                    break;
                }
                dynamicValueList.set(i, n2 - n12);
                for (int j = this.dragRowIndex - 1; j > i; --j) {
                    dynamicValueList.set(j, 0);
                }
                break;
            }
            this.setToolTipText2(this.createToolTipString(dynamicValueList.get(this.dragRowIndex), dynamicValueList.getRangeValue(0, this.dragRowIndex + 1)));
        }
        this.gridRow.getReportPane().repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.gridRow.isEnabled()) {
            return;
        }
        ReportPane reportPane = this.gridRow.getReportPane();
        TemplateReport templateReport = reportPane.getEditingReport();
        this.gridRow.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(BaseUtils.readImage("/com/fr/cell/images/cursor/cursor_vselect.gif"), new Point(16, 16), "ver_select"));
        double d = mouseEvent.getY();
        DynamicValueList dynamicValueList = ReportHelper.getRowHeightList(templateReport);
        int n = reportPane.getGrid().getVerticalValue();
        int n2 = reportPane.getGrid().getVerticalExtent();
        int n3 = n + n2 + 1;
        int n4 = reportPane.getGrid().getVerticalBeginValue();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = n4; i < n3; ++i) {
            double d4;
            if (i == 0) {
                i = n;
            }
            if (this.isOnZeroSeparatorLine(d, d4 = (d3 = (double)dynamicValueList.get(i)) <= 0.0 ? d2 + 1.0 : (d2 += d3) + d3, d3)) {
                this.gridRow.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(BaseUtils.readImage("/com/fr/cell/images/cursor/cursor_vsplit.gif"), new Point(16, 16), "ver_split"));
                break;
            }
            if (!this.isOnNormalSeparatorLine(d, d4)) continue;
            this.gridRow.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(BaseUtils.readImage("/com/fr/cell/images/cursor/cursor_vmove.gif"), new Point(16, 16), "ver_move"));
            break;
        }
    }

    private void doSelectRow(int n) {
        ReportPane reportPane = this.gridRow.getReportPane();
        GridSelection gridSelection = reportPane.getGridSelection();
        gridSelection.setType(0);
        this.startMultiSelectIndex = this.endMultiSelectIndex = n;
        int n2 = GridUtils.getAdjustLastColumnRowOfReportPane(reportPane).getColumn();
        gridSelection.setEditBounds(0, n, 1, 1);
        gridSelection.setOnlyCellBounds(0, n, n2, 1);
        this.dealCellSelection(reportPane);
        reportPane.fireGridSelectionChanged();
    }

    private boolean isOnZeroSeparatorLine(double d, double d2, double d3) {
        return d3 == 0.0 && d >= d2 + 2.0 && d <= d2 + 5.0;
    }

    private boolean isOnNormalSeparatorLine(double d, double d2) {
        return d >= d2 - 2.0 && d <= d2 + 2.0;
    }

    private void showToolTip(MouseEvent mouseEvent, String string) {
        if (this.tipWindow == null) {
            this.tipWindow = new JWindow();
            this.rowTip = this.gridRow.createToolTip();
            this.tipWindow.getContentPane().add((Component)this.rowTip, "Center");
        }
        this.rowTip.setTipText(string);
        Point point = new Point(0, mouseEvent.getY());
        SwingUtilities.convertPointToScreen(point, this.gridRow);
        Dimension dimension = this.rowTip.getPreferredSize();
        int n = point.x + this.gridRow.getSize().width + 2;
        int n2 = point.y - dimension.height / 2;
        this.tipWindow.setLocation(n, n2);
        this.tipWindow.pack();
        this.tipWindow.setVisible(true);
    }

    private void hideToolTip() {
        if (this.tipWindow != null) {
            this.tipWindow.setVisible(false);
        }
    }

    private void setToolTipText2(String string) {
        if (this.rowTip == null) {
            return;
        }
        this.rowTip.setTipText(string);
        this.rowTip.setSize(this.rowTip.getPreferredSize());
        this.tipWindow.pack();
        this.tipWindow.repaint();
    }

    private String createToolTipString(double d, double d2) {
        return Inter.getLocText("Height") + ": " + Utils.doubleToString(d) + "/" + Utils.doubleToString(d2) + Inter.getLocText("px");
    }

    private String createToolTipString(int n) {
        return n + "R";
    }

    private void dealCellSelection(ReportPane reportPane) {
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            return;
        }
        TemplateReport templateReport = reportPane.getEditingReport();
        Rectangle rectangle = gridSelection.getEditRectangle();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        CellElement cellElement = templateReport.getCellElement(n2, n3);
        while (cellElement != null && (cellElement.getRowSpan() != 1 || cellElement.getColumnSpan() != 1)) {
            cellElement = templateReport.getCellElement(n2 += cellElement.getColumnSpan(), n3);
        }
        rectangle.setBounds(n2, n3, n4, n5);
    }
}

