/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.core.list.IntList;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.clipboard.CellElementsClip;
import com.fr.cell.clipboard.ElementsTransferable;
import com.fr.cell.clipboard.FloatElementsClip;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.TemplateReport;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.logging.Level;

public class GridUtils {
    public static int DRAG_NONE = 0;
    public static int DRAG_CELLSELECTION = 1;
    public static int Drag_CellSelection_BottomRight_Corner = 2;
    public static int DRAG_WIDTH = 1;
    public static int DRAG_SELECT_COLUMNS = 2;
    public static int DRAG_HEIGHT = 3;
    public static int DRAG_SELECT_ROWS = 4;

    private GridUtils() {
    }

    public static Object[] getAboveFloatElementCursor(ReportPane reportPane, double d, double d2) {
        Object[] objectArray = null;
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        Iterator iterator = templateReport.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            double[] dArray = GridUtils.caculateFloatElementLocations(floatElement, ReportHelper.getColumnWidthList(templateReport), ReportHelper.getRowHeightList(templateReport), reportPane.getGrid().getVerticalValue(), reportPane.getGrid().getHorizontalValue());
            double d3 = dArray[0];
            double d4 = dArray[1];
            double d5 = dArray[2];
            double d6 = dArray[3];
            Rectangle2D.Double double_ = new Rectangle2D.Double(dArray[0], dArray[1], floatElement.getSize().getWidth(), floatElement.getSize().getHeight());
            if (!gridSelection.containFloatName(floatElement.getName())) {
                if (!double_.contains(d, d2)) continue;
                objectArray = new Object[]{floatElement, new Cursor(13)};
                continue;
            }
            Cursor cursor = null;
            if (gridSelection.getFloatNameCount() == 1) {
                Rectangle2D[] rectangle2DArray = new Rectangle2D[]{new Rectangle2D.Double(d3 - 3.0, d4 - 3.0, 6.0, 6.0), new Rectangle2D.Double((d3 + d5) / 2.0 - 3.0, d4 - 3.0, 6.0, 6.0), new Rectangle2D.Double(d5 - 3.0, d4 - 3.0, 6.0, 6.0), new Rectangle2D.Double(d5 - 3.0, (d4 + d6) / 2.0 - 3.0, 6.0, 6.0), new Rectangle2D.Double(d5 - 3.0, d6 - 3.0, 6.0, 6.0), new Rectangle2D.Double((d3 + d5) / 2.0 - 3.0, d6 - 3.0, 6.0, 6.0), new Rectangle2D.Double(d3 - 3.0, d6 - 3.0, 6.0, 6.0), new Rectangle2D.Double(d3 - 3.0, (d4 + d6) / 2.0 - 3.0, 6.0, 6.0)};
                int[] nArray = new int[]{6, 8, 7, 11, 5, 9, 4, 10};
                for (int i = 0; i < rectangle2DArray.length; ++i) {
                    if (!rectangle2DArray[i].contains(d, d2)) continue;
                    cursor = new Cursor(nArray[i]);
                    break;
                }
            }
            if (double_.contains(d, d2) && cursor == null) {
                objectArray = new Object[]{floatElement, new Cursor(13)};
            }
            if (cursor == null) continue;
            return new Object[]{floatElement, cursor};
        }
        return objectArray;
    }

    public static double[] caculateFloatElementLocations(FloatElement floatElement, DynamicValueList dynamicValueList, DynamicValueList dynamicValueList2, int n, int n2) {
        double d = dynamicValueList.getRangeValue(n2, floatElement.getColumn()) + floatElement.getLeftDistance();
        double d2 = dynamicValueList2.getRangeValue(n, floatElement.getRow()) + floatElement.getTopDistance();
        double d3 = d + floatElement.getSize().getWidth();
        double d4 = d2 + floatElement.getSize().getHeight();
        return new double[]{d, d2, d3, d4};
    }

    public static ColumnRow getEventColumnRow(ReportPane reportPane, double d, double d2) {
        int n;
        int n2;
        block10: {
            int n3;
            DynamicValueList dynamicValueList;
            block9: {
                TemplateReport templateReport = reportPane.getEditingReport();
                dynamicValueList = ReportHelper.getRowHeightList(templateReport);
                DynamicValueList dynamicValueList2 = ReportHelper.getColumnWidthList(templateReport);
                n3 = reportPane.getGrid().getVerticalValue();
                int n4 = reportPane.getGrid().getHorizontalValue();
                int n5 = reportPane.getGrid().getVerticalBeginValue();
                int n6 = reportPane.getGrid().getHorizontalBeginValue();
                double d3 = 0.0;
                n2 = 0;
                if (d < 0.0) {
                    n2 = n4;
                    while (!((d3 -= (double)dynamicValueList.get(n2)) < d)) {
                        --n2;
                    }
                } else {
                    boolean bl = false;
                    for (int i = n6; i < 0; ++i) {
                        if (!((d3 += (double)dynamicValueList2.get(i)) > d)) continue;
                        n2 = i;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        n2 = n4;
                        while (!((d3 += (double)dynamicValueList2.get(n2)) > d)) {
                            ++n2;
                        }
                    }
                }
                double d4 = 0.0;
                n = 0;
                if (!(d2 < 0.0)) break block9;
                n = n3;
                while (!((d4 -= (double)dynamicValueList.get(n)) < d2)) {
                    --n;
                }
                break block10;
            }
            boolean bl = false;
            for (int i = n5; i < 0; ++i) {
                if (!((d4 += (double)dynamicValueList.get(i)) > d2)) continue;
                n = i;
                bl = true;
                break;
            }
            if (bl) break block10;
            n = n3;
            while (!((d4 += (double)dynamicValueList.get(n)) > d2)) {
                ++n;
            }
        }
        return ColumnRow.valueOf(n2, n);
    }

    public static ColumnRow getAdjustEventColumnRow(ReportPane reportPane, double d, double d2) {
        ColumnRow columnRow = GridUtils.getEventColumnRow(reportPane, d, d2);
        int n = Math.max(columnRow.getColumn(), 0);
        int n2 = Math.max(columnRow.getRow(), 0);
        TemplateReport templateReport = reportPane.getEditingReport();
        if (!reportPane.isRowEndless() && columnRow.getRow() > templateReport.getRowCount() - 1) {
            n2 = templateReport.getRowCount() - 1;
        }
        if (!reportPane.isColumnEndless() && columnRow.getColumn() > templateReport.getColumnCount() - 1) {
            n = templateReport.getColumnCount() - 1;
        }
        return ColumnRow.valueOf(n, n2);
    }

    public static void doSelectCell(ReportPane reportPane, int n, int n2) {
        TemplateReport templateReport = reportPane.getEditingReport();
        if (!reportPane.isColumnEndless() && n > templateReport.getColumnCount() - 1) {
            n = 0;
            if (!reportPane.isRowEndless() && ++n2 > templateReport.getRowCount() - 1) {
                n2 = 0;
            }
        }
        if (!reportPane.isColumnEndless() && n < 0) {
            n = templateReport.getColumnCount() - 1;
            if (!reportPane.isRowEndless() && --n2 < 0) {
                n2 = templateReport.getRowCount() - 1;
            }
        }
        if (!reportPane.isRowEndless() && n2 > templateReport.getRowCount() - 1) {
            n2 = 0;
            if (!reportPane.isColumnEndless() && ++n > templateReport.getColumnCount() - 1) {
                n = 0;
            }
        }
        if (!reportPane.isRowEndless() && n2 < 0) {
            n2 = templateReport.getRowCount() - 1;
            if (!reportPane.isColumnEndless() && --n < 0) {
                n = templateReport.getColumnCount() - 1;
            }
        }
        GridSelection gridSelection = reportPane.getGridSelection();
        gridSelection.setType(0);
        CellElement cellElement = templateReport.getCellElement(n, n2);
        if (cellElement == null) {
            gridSelection.setEditBounds(n, n2, 1, 1);
            gridSelection.setOnlyCellBounds(n, n2, 1, 1);
        } else {
            gridSelection.setEditBounds(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            gridSelection.setOnlyCellBounds(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
        }
        reportPane.fireGridSelectionChanged();
    }

    public static ElementsTransferable caculateElementsTransferable(ReportPane reportPane) {
        ElementsTransferable elementsTransferable = new ElementsTransferable();
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            FloatElement floatElement;
            String string;
            int n2;
            FloatElementsClip floatElementsClip = new FloatElementsClip();
            int n3 = gridSelection.getFloatNameCount();
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            for (n2 = 0; n2 < n3; ++n2) {
                string = gridSelection.getFloatName(n2);
                floatElement = templateReport.getFloatElement(string);
                if (floatElement == null) continue;
                n4 = Math.min(n4, floatElement.getColumn());
                n5 = Math.min(floatElement.getRow(), n5);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                string = gridSelection.getFloatName(n2);
                floatElement = templateReport.getFloatElement(string);
                if (floatElement == null) continue;
                try {
                    FloatElement floatElement2 = (FloatElement)floatElement.clone();
                    floatElement2.setColumn(floatElement.getColumn() - n4);
                    floatElement2.setRow(floatElement.getRow() - n5);
                    floatElementsClip.addFloatElement(floatElement2);
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                    continue;
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            elementsTransferable.addObject(floatElementsClip);
        } else {
            Rectangle rectangle = gridSelection.getFirstCellRectangle();
            CellElementsClip cellElementsClip = new CellElementsClip(rectangle.width, rectangle.height);
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Iterator iterator = templateReport.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            while (iterator.hasNext()) {
                CellElement cellElement = (CellElement)iterator.next();
                Rectangle rectangle3 = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
                if (rectangle2.equals(rectangle3) || rectangle2.contains(rectangle3)) {
                    cellElementsClip.addCellElement(cellElement.deriveCellElement(cellElement.getColumn() - rectangle.x, cellElement.getRow() - rectangle.y));
                    continue;
                }
                if (!rectangle2.intersects(rectangle3)) continue;
            }
            elementsTransferable.addObject(cellElementsClip);
        }
        return elementsTransferable;
    }

    public static ColumnRow getAdjustLastColumnRowOfReportPane(ReportPane reportPane) {
        TemplateReport templateReport = reportPane.getEditingReport();
        return ColumnRow.valueOf(Math.max(1, templateReport.getColumnCount()), Math.max(1, templateReport.getRowCount()));
    }

    public static IntList getGridSelectionRowIndex(GridSelection gridSelection) {
        IntList intList = new IntList();
        for (int i = 0; i < gridSelection.getCellRectangleCount(); ++i) {
            Rectangle rectangle = gridSelection.getCellRectangle(i);
            for (int j = 0; j < rectangle.height; ++j) {
                int n = rectangle.y + j;
                if (intList.contain(n)) continue;
                intList.add(n);
            }
        }
        intList.sort();
        return intList;
    }

    public static IntList getGridSelectionColumnIndex(GridSelection gridSelection) {
        IntList intList = new IntList();
        for (int i = 0; i < gridSelection.getCellRectangleCount(); ++i) {
            Rectangle rectangle = gridSelection.getCellRectangle(i);
            for (int j = 0; j < rectangle.width; ++j) {
                int n = rectangle.x + j;
                if (intList.contain(n)) continue;
                intList.add(n);
            }
        }
        intList.sort();
        return intList;
    }
}

