/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.base.BaseUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.clipboard.CellElementsClip;
import com.fr.cell.clipboard.ElementsTransferable;
import com.fr.cell.core.GridUtils;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.Report;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.DSColumn;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IntelliElements {
    public static final int DIRECTION_UNDEF = -1;
    public static final int DIRECTION_UP_TO_DOWN = 0;
    public static final int DIRECTION_DOWN_TO_UP = 1;
    public static final int DIRECTION_LEFT_TO_RIGHT = 2;
    public static final int DIRECTION_RIGHT_TO_LEFT = 3;
    public static final int ACTION_SEQUENCING = 0;
    public static final int ACTION_REPLICATION = 1;
    public static final int FORMULA_NONE_PARA_SAME = -1;
    public static final int FORMULA_HOR_PARA_SAME = 0;
    public static final int FORMULA_VER_PARA_SAME = 1;
    private int direction = -1;
    private int action = 0;
    private boolean isStyleSupported = true;
    private ReportPane reportPane;
    private Report report;
    private Rectangle oldCellRectangle = null;
    private Rectangle editRectangle;
    private Rectangle dragCellRectangle = null;
    private boolean isNeedRepaint;
    private boolean isDataChanged;

    public static void iterating(ReportPane reportPane, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl, boolean bl2) {
        IntelliElements intelliElements = new IntelliElements(reportPane, rectangle, rectangle2, rectangle3, bl, bl2);
        intelliElements.setAction(0);
        intelliElements.setStyleSupported(true);
        intelliElements.doIntelliAction();
    }

    public IntelliElements(ReportPane reportPane, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl, boolean bl2) {
        this.reportPane = reportPane;
        this.report = reportPane.getEditingReport();
        this.oldCellRectangle = rectangle2;
        this.editRectangle = rectangle;
        this.dragCellRectangle = rectangle3;
        this.isNeedRepaint = bl;
        this.isDataChanged = bl2;
    }

    public void setAction(int n) {
        this.action = n;
    }

    public void setStyleSupported(boolean bl) {
        this.isStyleSupported = bl;
    }

    public void doIntelliAction() {
        int n;
        this.analyzeDirection();
        this.defineRules();
        if (this.action == 1) {
            this.doReplication();
            return;
        }
        if (this.direction == 0) {
            for (n = this.oldCellRectangle.x; n < this.oldCellRectangle.x + this.oldCellRectangle.width; ++n) {
                int n2;
                GridSelection gridSelection = this.reportPane.getGridSelection();
                gridSelection.getCellRectangle(0);
                int n3 = 0;
                int n4 = gridSelection.getCellRectangleCount();
                for (n2 = 0; n2 < n4; ++n2) {
                    n3 = gridSelection.getCellRectangle((int)n2).height;
                }
                if (n4 > 1) {
                    return;
                }
                n2 = this.oldCellRectangle.y + n3;
                int n5 = this.dragCellRectangle.y + this.dragCellRectangle.height;
                for (int i = n2; i < n5; ++i) {
                    DefaultCellElement defaultCellElement;
                    Serializable serializable;
                    CellElement cellElement = this.report.getCellElement(n, i - this.oldCellRectangle.height);
                    if (cellElement == null) {
                        cellElement = new DefaultCellElement();
                    }
                    if (cellElement.getColumnSpan() > 1 || cellElement.getRowSpan() > 1) {
                        System.out.println("column = " + n + ", row = " + i);
                    }
                    if (cellElement.getValue() instanceof DSColumn) {
                        serializable = (DSColumn)cellElement.getValue();
                        defaultCellElement = new DefaultCellElement(n, i);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        defaultCellElement.setCellExpandAttr(cellElement.getCellExpandAttr());
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    if (cellElement.getValue() instanceof Integer) {
                        serializable = (Integer)cellElement.getValue();
                        int n6 = (Integer)serializable + 1;
                        serializable = new Integer(n6);
                        DefaultCellElement defaultCellElement2 = new DefaultCellElement(n, i);
                        defaultCellElement2.setValue(serializable);
                        this.applyStyle(defaultCellElement2, cellElement);
                        this.report.addCellElement(defaultCellElement2);
                        continue;
                    }
                    if (cellElement.getValue() instanceof Double) {
                        serializable = (Double)cellElement.getValue();
                        double d = (Double)serializable + 1.0;
                        serializable = new Double(d);
                        DefaultCellElement defaultCellElement3 = new DefaultCellElement(n, i);
                        defaultCellElement3.setValue(serializable);
                        this.applyStyle(defaultCellElement3, cellElement);
                        this.report.addCellElement(defaultCellElement3);
                        continue;
                    }
                    if (cellElement.getValue() instanceof Formula) {
                        serializable = (Formula)cellElement.getValue();
                        serializable = this.generateSimpleFormula((Formula)serializable, 1, 0);
                        defaultCellElement = new DefaultCellElement(n, i);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    try {
                        serializable = (CellElement)cellElement.clone();
                        defaultCellElement = new DefaultCellElement(n, i);
                        defaultCellElement.setValue(serializable.getValue());
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        FRContext.getLogger().log(Level.INFO, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                    }
                }
            }
        } else if (this.direction == 1) {
            for (n = this.oldCellRectangle.x; n < this.oldCellRectangle.x + this.oldCellRectangle.width; ++n) {
            }
        } else if (this.direction == 2) {
            for (n = this.oldCellRectangle.y; n < this.oldCellRectangle.y + this.oldCellRectangle.height; ++n) {
                int n7;
                GridSelection gridSelection = this.reportPane.getGridSelection();
                gridSelection.getCellRectangle(0);
                int n8 = 0;
                int n9 = gridSelection.getCellRectangleCount();
                for (n7 = 0; n7 < n9; ++n7) {
                    n8 = gridSelection.getCellRectangle((int)n7).width;
                }
                if (n9 > 1) {
                    return;
                }
                n7 = this.oldCellRectangle.x + n8;
                int n10 = this.dragCellRectangle.x + this.dragCellRectangle.width;
                for (int i = n7; i < n10; ++i) {
                    DefaultCellElement defaultCellElement;
                    Serializable serializable;
                    CellElement cellElement = this.report.getCellElement(i - this.oldCellRectangle.width, n);
                    if (cellElement == null) {
                        cellElement = new DefaultCellElement();
                    }
                    if (cellElement.getValue() instanceof DSColumn) {
                        serializable = (DSColumn)cellElement.getValue();
                        defaultCellElement = new DefaultCellElement(i, n);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        defaultCellElement.setCellExpandAttr(cellElement.getCellExpandAttr());
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    if (cellElement.getValue() instanceof Integer) {
                        serializable = (Integer)cellElement.getValue();
                        defaultCellElement = new DefaultCellElement(i, n);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    if (cellElement.getValue() instanceof Double) {
                        serializable = (Double)cellElement.getValue();
                        defaultCellElement = new DefaultCellElement(i, n);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    if (cellElement.getValue() instanceof Formula) {
                        serializable = (Formula)cellElement.getValue();
                        serializable = this.generateSimpleFormula((Formula)serializable, 1, 2);
                        defaultCellElement = new DefaultCellElement(i, n);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    try {
                        serializable = (CellElement)cellElement.clone();
                        defaultCellElement = new DefaultCellElement(i, n);
                        defaultCellElement.setValue(serializable.getValue());
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                }
            }
        } else if (this.direction == 3) {
            for (n = this.oldCellRectangle.y; n < this.oldCellRectangle.y + this.oldCellRectangle.height; ++n) {
                GridSelection gridSelection = this.reportPane.getGridSelection();
                gridSelection.getCellRectangle(0);
                int n11 = gridSelection.getCellRectangleCount();
                if (n11 > 1) {
                    return;
                }
                int n12 = this.dragCellRectangle.x;
                int n13 = this.oldCellRectangle.x;
                for (int i = n12; i < n13; ++i) {
                    DefaultCellElement defaultCellElement;
                    Serializable serializable;
                    int n14 = i - n12;
                    CellElement cellElement = this.report.getCellElement(n13 + n14 % this.oldCellRectangle.width, n);
                    if (cellElement == null) {
                        cellElement = new DefaultCellElement();
                    }
                    if (cellElement.getValue() instanceof DSColumn) {
                        serializable = (DSColumn)cellElement.getValue();
                        defaultCellElement = new DefaultCellElement(i, n);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        defaultCellElement.setCellExpandAttr(cellElement.getCellExpandAttr());
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    if (cellElement.getValue() instanceof Integer) {
                        serializable = (Integer)cellElement.getValue();
                        defaultCellElement = new DefaultCellElement(i, n);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    if (cellElement.getValue() instanceof Double) {
                        serializable = (Double)cellElement.getValue();
                        defaultCellElement = new DefaultCellElement(i, n);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    if (cellElement.getValue() instanceof Formula) {
                        serializable = (Formula)cellElement.getValue();
                        defaultCellElement = new DefaultCellElement(i, n);
                        defaultCellElement.setValue(serializable);
                        this.applyStyle(defaultCellElement, cellElement);
                        this.report.addCellElement(defaultCellElement);
                        continue;
                    }
                    try {
                        serializable = (CellElement)cellElement.clone();
                        serializable = serializable.deriveCellElement(i, n);
                        this.report.addCellElement((CellElement)serializable);
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        FRContext.getLogger().log(Level.INFO, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                    }
                }
            }
        }
        GridSelection gridSelection = this.reportPane.getGridSelection();
        gridSelection.setType(0);
        gridSelection.setEditBounds(this.editRectangle.x, this.editRectangle.y, this.editRectangle.width, this.editRectangle.height);
        gridSelection.setEditBounds(this.dragCellRectangle.x, this.dragCellRectangle.y, this.dragCellRectangle.width, this.dragCellRectangle.height);
        this.isNeedRepaint = true;
        this.isDataChanged = true;
        this.reportPane.fireGridSelectionChanged();
        if (this.isDataChanged) {
            this.reportPane.repaint();
        }
    }

    private void doReplication() {
        if (this.direction == 0) {
            if (this.dragCellRectangle.height == this.oldCellRectangle.height) {
                this.isNeedRepaint = true;
            } else if (this.dragCellRectangle.height > this.oldCellRectangle.height) {
                ElementsTransferable elementsTransferable = GridUtils.caculateElementsTransferable(this.reportPane);
                CellElementsClip cellElementsClip = null;
                Object object = elementsTransferable.getFirstObject();
                if (object != null && object instanceof CellElementsClip) {
                    cellElementsClip = (CellElementsClip)object;
                }
                if (cellElementsClip != null) {
                    for (int i = this.oldCellRectangle.y + this.oldCellRectangle.height; i < this.dragCellRectangle.y + this.dragCellRectangle.height; i += this.oldCellRectangle.height) {
                        IntelliElements.pasteElementsCopyToReport(cellElementsClip, this.reportPane.getEditingReport(), this.oldCellRectangle.x, i, this.oldCellRectangle.x, i, this.oldCellRectangle.width, Math.min(this.oldCellRectangle.height, this.dragCellRectangle.y + this.dragCellRectangle.height - i));
                    }
                }
                GridSelection gridSelection = this.reportPane.getGridSelection();
                gridSelection.setType(0);
                gridSelection.setEditBounds(this.editRectangle.x, this.editRectangle.y, this.editRectangle.width, this.editRectangle.height);
                gridSelection.setEditBounds(this.dragCellRectangle.x, this.dragCellRectangle.y, this.dragCellRectangle.width, this.dragCellRectangle.height);
                this.isDataChanged = true;
            }
        } else if (this.direction == 1) {
            ElementsTransferable elementsTransferable = GridUtils.caculateElementsTransferable(this.reportPane);
            CellElementsClip cellElementsClip = null;
            Object object = elementsTransferable.getFirstObject();
            if (object != null && object instanceof CellElementsClip) {
                cellElementsClip = (CellElementsClip)object;
            }
            if (cellElementsClip != null) {
                int n = this.oldCellRectangle.y - this.oldCellRectangle.height;
                while (n + this.oldCellRectangle.height > this.dragCellRectangle.y) {
                    IntelliElements.pasteElementsCopyToReport(cellElementsClip, this.reportPane.getEditingReport(), this.oldCellRectangle.x, n, this.oldCellRectangle.x, Math.max(n, this.dragCellRectangle.y), this.oldCellRectangle.width, Math.min(this.oldCellRectangle.height, this.oldCellRectangle.height - (this.dragCellRectangle.y - n)));
                    n -= this.oldCellRectangle.height;
                }
            }
            GridSelection gridSelection = this.reportPane.getGridSelection();
            gridSelection.setType(0);
            gridSelection.setEditBounds(this.editRectangle.x, this.editRectangle.y, this.editRectangle.width, this.editRectangle.height);
            gridSelection.setEditBounds(this.dragCellRectangle.x, this.dragCellRectangle.y, this.dragCellRectangle.width, this.dragCellRectangle.height);
            this.isDataChanged = true;
        } else if (this.direction == 2) {
            if (this.dragCellRectangle.width == this.oldCellRectangle.width) {
                this.isNeedRepaint = true;
            } else if (this.dragCellRectangle.width > this.oldCellRectangle.width) {
                ElementsTransferable elementsTransferable = GridUtils.caculateElementsTransferable(this.reportPane);
                CellElementsClip cellElementsClip = null;
                Object object = elementsTransferable.getFirstObject();
                if (object != null && object instanceof CellElementsClip) {
                    cellElementsClip = (CellElementsClip)object;
                }
                if (cellElementsClip != null) {
                    for (int i = this.oldCellRectangle.x + this.oldCellRectangle.width; i < this.dragCellRectangle.x + this.dragCellRectangle.width; i += this.oldCellRectangle.width) {
                        IntelliElements.pasteElementsCopyToReport(cellElementsClip, this.reportPane.getEditingReport(), i, this.oldCellRectangle.y, i, this.oldCellRectangle.y, Math.min(this.oldCellRectangle.width, this.dragCellRectangle.x + this.dragCellRectangle.width - i), this.oldCellRectangle.height);
                    }
                }
                GridSelection gridSelection = this.reportPane.getGridSelection();
                gridSelection.setType(0);
                gridSelection.setEditBounds(this.editRectangle.x, this.editRectangle.y, this.editRectangle.width, this.editRectangle.height);
                gridSelection.setEditBounds(this.dragCellRectangle.x, this.dragCellRectangle.y, this.dragCellRectangle.width, this.dragCellRectangle.height);
                this.isDataChanged = true;
            }
        } else if (this.direction == 3) {
            ElementsTransferable elementsTransferable = GridUtils.caculateElementsTransferable(this.reportPane);
            CellElementsClip cellElementsClip = null;
            Object object = elementsTransferable.getFirstObject();
            if (object != null && object instanceof CellElementsClip) {
                cellElementsClip = (CellElementsClip)object;
            }
            if (cellElementsClip != null) {
                int n = this.oldCellRectangle.x - this.oldCellRectangle.width;
                while (n + this.oldCellRectangle.width > this.dragCellRectangle.x) {
                    IntelliElements.pasteElementsCopyToReport(cellElementsClip, this.reportPane.getEditingReport(), n, this.oldCellRectangle.y, Math.max(n, this.dragCellRectangle.x), this.oldCellRectangle.y, Math.min(this.oldCellRectangle.width, this.oldCellRectangle.width - (this.dragCellRectangle.x - n)), this.oldCellRectangle.height);
                    n -= this.oldCellRectangle.width;
                }
            }
            GridSelection gridSelection = this.reportPane.getGridSelection();
            gridSelection.setType(0);
            gridSelection.setEditBounds(this.editRectangle.x, this.editRectangle.y, this.editRectangle.width, this.editRectangle.height);
            gridSelection.setEditBounds(this.dragCellRectangle.x, this.dragCellRectangle.y, this.dragCellRectangle.width, this.dragCellRectangle.height);
            this.isDataChanged = true;
        }
        this.reportPane.fireGridSelectionChanged();
        if (this.isDataChanged) {
            this.reportPane.repaint();
        }
    }

    private void analyzeDirection() {
        if (this.dragCellRectangle.x == this.oldCellRectangle.x && this.dragCellRectangle.width == this.oldCellRectangle.width) {
            if (this.dragCellRectangle.y == this.oldCellRectangle.y) {
                this.direction = 0;
            } else if (this.dragCellRectangle.y < this.oldCellRectangle.y) {
                this.direction = 1;
            }
        } else if (this.dragCellRectangle.y == this.oldCellRectangle.y && this.dragCellRectangle.height == this.oldCellRectangle.height) {
            if (this.dragCellRectangle.x == this.oldCellRectangle.x) {
                this.direction = 2;
            } else if (this.dragCellRectangle.x < this.oldCellRectangle.x) {
                this.direction = 3;
            }
        }
    }

    private void defineRules() {
    }

    private Formula generateSimpleFormula(Formula formula, int n, int n2) {
        Formula formula2;
        try {
            formula2 = (Formula)formula.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            formula2 = new Formula();
            FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
        String string = formula.getContent();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "[a-z|A-Z]+[0-9]+";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        int n3 = 0;
        while (matcher.find()) {
            int n4 = matcher.start();
            int n5 = matcher.end();
            char c = string.charAt(n4 - 1);
            if (c == '$') continue;
            String string3 = string.substring(n4, n5);
            ColumnRow columnRow = BaseUtils.convertCellStringToColumnRow(string3);
            int n6 = columnRow.getColumn();
            int n7 = columnRow.getRow();
            int n8 = n6;
            int n9 = n7;
            if (n2 == 0) {
                n9 += n;
            } else if (n2 == 2) {
                n8 += n;
            } else if (n2 == 1) {
                if ((n9 -= n) < 0) {
                    n9 = 0;
                }
            } else if (n2 == 3 && (n8 -= n) < 0) {
                n8 = 0;
            }
            ColumnRow columnRow2 = ColumnRow.valueOf(n8, n9);
            String string4 = BaseUtils.convertColumnRowToCellString(columnRow2);
            stringBuffer.append(string.substring(n3, n4));
            stringBuffer.append(string4);
            n3 = n5;
        }
        stringBuffer.append(string.substring(n3, string.length()));
        formula2.setContent(stringBuffer.toString());
        return formula2;
    }

    private void applyStyle(CellElement cellElement, CellElement cellElement2) {
        if (this.isStyleSupported) {
            cellElement.setStyle(cellElement2.getStyle());
        }
    }

    public static void pasteElementsCopyToReport(CellElementsClip cellElementsClip, Report report, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = cellElementsClip.getCellElementCount();
        for (int i = 0; i < n7; ++i) {
            CellElement cellElement = cellElementsClip.getCellElement(i);
            if ((cellElement = cellElement.deriveCellElement(n + cellElement.getColumn(), n2 + cellElement.getRow())).getColumn() >= n3 + n5 || cellElement.getRow() >= n4 + n6 || cellElement.getColumn() < n3 || cellElement.getRow() < n4) continue;
            report.addCellElement(cellElement);
        }
    }
}

