/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.util.Utils;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JNumberField
extends JTextField
implements Serializable {
    public static final double ERROR_VALUE = Double.MAX_VALUE;
    private int maxIntegerLength = 24;
    private int maxDecimalLength = 16;
    private double minValue = -1.7976931348623157E308;
    private double maxValue = Double.MAX_VALUE;
    private boolean isContentChanged = false;

    public JNumberField() {
        this(32, 16);
    }

    public JNumberField(int n) {
        super(n);
    }

    public JNumberField(int n, int n2) {
        this(n, n2, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public JNumberField(int n, int n2, double d, double d2) {
        this.maxIntegerLength = n;
        this.maxDecimalLength = n2;
        this.minValue = d;
        this.maxValue = d2;
        this.setDocument(new NumberDocument());
    }

    public int getMaxIntegerLength() {
        return this.maxIntegerLength;
    }

    public void setMaxIntegerLength(int n) {
        this.maxIntegerLength = n;
    }

    public int getMaxDecimalLength() {
        return this.maxDecimalLength;
    }

    public void setMaxDecimalLength(int n) {
        this.maxDecimalLength = n;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public void setValue(double d) {
        this.setText(Utils.doubleToString(d));
    }

    public double getValue() throws NumberFormatException {
        try {
            if (this.getText().length() == 0) {
                return 0.0;
            }
            return Double.parseDouble(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return Double.MAX_VALUE;
        }
    }

    public String getTextValue() {
        return this.getText();
    }

    public void setInteger(boolean bl) {
        this.maxDecimalLength = bl ? 0 : 16;
    }

    public boolean isContentChanged() {
        return this.isContentChanged;
    }

    public Dimension getPreferredSize() {
        return new Dimension(60, 22);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("");
        jFrame.setSize(400, 320);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation((dimension.width - jFrame.getSize().width) / 2, (dimension.height - jFrame.getSize().height) / 2);
        jFrame.getContentPane().setLayout(new GridLayout(10, 2));
        jFrame.getContentPane().add(new JLabel("New JNumberField()"));
        jFrame.getContentPane().add(new JNumberField());
        jFrame.getContentPane().add(new JLabel("New JNumberField(2)"));
        jFrame.getContentPane().add(new JLabel("New JNumberField(8,2)"));
        jFrame.getContentPane().add(new JNumberField(8, 2));
        jFrame.getContentPane().add(new JLabel("New JNumberField(5,2,-10,100)"));
        jFrame.getContentPane().add(new JNumberField(5, 2, -10.0, 100.0));
        jFrame.setVisible(true);
    }

    class NumberDocument
    extends PlainDocument {
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            String string3 = this.getText(0, this.getLength());
            if (string.equals("F") || string.equals("f") || string.equals("D") || string.equals("d") || string3.trim().equals("0") && !string.substring(0, 1).equals(".") && n != 0 || string.equals(".") && JNumberField.this.maxDecimalLength == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String string4 = "";
            String string5 = string3.substring(0, n) + string + string3.substring(n, this.getLength());
            int n2 = (string5 = string5.replaceFirst("-", "")).indexOf(".");
            if (n2 > -1) {
                string2 = string5.substring(0, n2);
                string4 = string5.substring(n2 + 1);
            } else {
                string2 = string5;
            }
            if (string2.length() > JNumberField.this.maxIntegerLength || string4.length() > JNumberField.this.maxDecimalLength || string5.length() > 1 && string5.substring(0, 1).equals("0") && !string5.substring(1, 2).equals(".")) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                double d;
                if (!string5.equals("") && !string5.equals("-") && ((d = Double.parseDouble(string5)) < JNumberField.this.minValue || d > JNumberField.this.maxValue)) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            JNumberField.this.isContentChanged = true;
            super.insertString(n, string, attributeSet);
        }
    }
}

