/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.cell.core.GUICoreUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ModLineBorder
extends AbstractBorder {
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 8;
    private int modifiers = 0;
    private int thickness;
    private Color lineColor;

    public ModLineBorder(int n) {
        this(n, GUICoreUtils.getTitleLineBorderColor(), 1);
    }

    public ModLineBorder(int n, Color color) {
        this(n, color, 1);
    }

    public ModLineBorder(int n, Color color, int n2) {
        this.modifiers = n;
        this.lineColor = color;
        this.thickness = n2;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            if ((this.modifiers & 1) != 0) {
                graphics.drawLine(n + i, n2 + i, n + n3 - i - 1, n2 + i);
            }
            if ((this.modifiers & 2) != 0) {
                graphics.drawLine(n + i, n2 + i, n + i, n2 + n4 - i - 1);
            }
            if ((this.modifiers & 4) != 0) {
                graphics.drawLine(n + i, n2 + n4 - i - 1, n + n3 - i - 1, n2 + n4 - i - 1);
            }
            if ((this.modifiers & 8) == 0) continue;
            graphics.drawLine(n + n3 - i - 1, n2 + i, n + n3 - i - 1, n4 - i - i - 1);
        }
        graphics.setColor(color);
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(this.thickness, this.thickness, this.thickness, this.thickness));
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        if ((this.modifiers & 1) != 0 && (this.modifiers & 4) == 0) {
            insets.bottom = 0;
        }
        if ((this.modifiers & 2) != 0 && (this.modifiers & 8) == 0) {
            insets.right = 0;
        }
        if ((this.modifiers & 4) != 0 && (this.modifiers & 1) == 0) {
            insets.top = 0;
        }
        if ((this.modifiers & 8) != 0 && (this.modifiers & 2) == 0) {
            insets.left = 0;
        }
        return insets;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }
}

