/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core;

import com.fr.base.Inter;
import com.fr.cell.core.GUICoreUtils;
import com.fr.data.util.SortOrder;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class SortOrderComboBox
extends JComboBox {
    DefaultListCellRenderer sortOrderCellRenderer = new DefaultListCellRenderer(){

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof SortOrder) {
                SortOrder sortOrder = (SortOrder)object;
                if (sortOrder.getOrder() == 1) {
                    this.setText(Inter.getLocText("Sort-Ascending"));
                } else if (sortOrder.getOrder() == 2) {
                    this.setText(Inter.getLocText("Sort-Descending"));
                } else if (sortOrder.getOrder() == 0) {
                    this.setText(Inter.getLocText("Sort-Original"));
                }
            }
            return this;
        }
    };
    private static SortOrder[] SortOrderArray = new SortOrder[]{new SortOrder(1), new SortOrder(2), new SortOrder(0)};

    public SortOrderComboBox() {
        this(SortOrderArray);
    }

    public SortOrderComboBox(SortOrder[] sortOrderArray) {
        this.setModel(new DefaultComboBoxModel<SortOrder>(sortOrderArray));
        this.setRenderer(this.sortOrderCellRenderer);
    }

    public SortOrder getSortOrder() {
        return (SortOrder)this.getSelectedItem();
    }

    public void setSortOrder(SortOrder sortOrder) {
        GUICoreUtils.setSelectedItem(this, sortOrder);
    }
}

