/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core.date;

import com.fr.base.FRContext;
import com.fr.cell.core.ModLineBorder;
import com.fr.cell.core.date.JDayLabel;
import com.fr.cell.core.layout.LayoutFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class JCalendarPanel
extends JPanel {
    private static Border selectedBorder = new LineBorder(Color.black);
    private static Border unselectedBorder = new EmptyBorder(selectedBorder.getBorderInsets(new JLabel()));
    private Calendar calendar = null;
    private JLabel monthLabel = null;
    private JPanel days = null;
    private MouseListener dayBttListener = null;
    private boolean isSupportDateChangeListener = false;
    protected Color selectedBackground;
    protected Color selectedForeground;
    protected Color background;
    protected Color foreground;
    private Date selectedDate = null;
    final SimpleDateFormat monthFormat = new SimpleDateFormat("yyyy-MM");
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JCalendarPanel() {
        this(new Date());
    }

    public JCalendarPanel(Date date) {
        this.selectedDate = date;
        this.calendar = Calendar.getInstance();
        this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
        this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
        this.background = UIManager.getColor("ComboBox.background");
        this.foreground = UIManager.getColor("ComboBox.foreground");
        this.dayBttListener = this.createDayBttListener();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBackground(new Color(0, 0, 128));
        jPanel.setForeground(Color.white);
        jPanel.setPreferredSize(new Dimension(1, 25));
        JLabel jLabel = this.createSkipButton(1, -1);
        jLabel.setText("<<");
        jPanel.add(Box.createHorizontalStrut(12));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(12));
        jLabel = this.createSkipButton(2, -1);
        jLabel.setText("< ");
        jPanel.add(jLabel);
        this.monthLabel = new JLabel("", 0);
        this.monthLabel.setBackground(new Color(0, 0, 128));
        this.monthLabel.setForeground(Color.white);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.monthLabel);
        jPanel.add(Box.createHorizontalGlue());
        jLabel = this.createSkipButton(2, 1);
        jLabel.setText(" >");
        jPanel.add(jLabel);
        jLabel = this.createSkipButton(1, 1);
        jLabel.setText(">>");
        jPanel.add(Box.createHorizontalStrut(12));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(12));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 7));
        jPanel2.setBackground(this.background);
        jPanel2.setOpaque(true);
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(FRContext.getLocale());
        String[] stringArray = dateFormatSymbols.getShortWeekdays();
        for (int i = 1; i <= 7; ++i) {
            jLabel = new JLabel();
            jLabel.setHorizontalAlignment(0);
            jLabel.setForeground(this.foreground);
            jLabel.setText(stringArray[i]);
            jPanel2.add(jLabel);
        }
        this.days = new JPanel(new GridLayout(0, 7));
        this.days.setBorder(new ModLineBorder(5, Color.black));
        this.days.setBackground(this.background);
        this.days.setOpaque(true);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBackground(this.background);
        jPanel3.setOpaque(true);
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)this.days, "Center");
        JDayLabel jDayLabel = new JDayLabel(new Date(), false);
        jDayLabel.setForeground(this.foreground);
        jDayLabel.addMouseListener(this.dayBttListener);
        JPanel jPanel4 = new JPanel(LayoutFactory.createBorderLayout());
        jPanel4.setBackground(this.background);
        jPanel4.setForeground(this.foreground);
        jPanel4.add((Component)jDayLabel, "Center");
        this.setPreferredSize(new Dimension(280, 180));
        this.setForeground(this.foreground);
        this.setBackground(this.background);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(LayoutFactory.createBorderLayout());
        this.add("North", jPanel);
        this.add("Center", jPanel3);
        this.add("South", jPanel4);
        this.updateDays();
    }

    protected JLabel createSkipButton(int n, int n2) {
        JLabel jLabel = new JLabel();
        jLabel.setBorder(unselectedBorder);
        jLabel.setBackground(new Color(0, 0, 128));
        jLabel.setForeground(Color.white);
        jLabel.setRequestFocusEnabled(false);
        jLabel.addMouseListener(this.createSkipListener(n, n2));
        return jLabel;
    }

    protected MouseListener createSkipListener(final int n, final int n2) {
        return new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                JCalendarPanel.this.calendar.add(n, n2);
                JCalendarPanel.this.updateDays();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                JComponent jComponent = (JComponent)mouseEvent.getComponent();
                jComponent.setBorder(selectedBorder);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JComponent jComponent = (JComponent)mouseEvent.getComponent();
                jComponent.setBorder(unselectedBorder);
            }
        };
    }

    protected void updateDays() {
        this.monthLabel.setText(this.monthFormat.format(this.calendar.getTime()));
        this.days.removeAll();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.selectedDate);
        Calendar calendar2 = (Calendar)this.calendar.clone();
        calendar2.set(5, 1);
        int n = calendar2.get(7);
        calendar2.add(5, -n);
        boolean bl = false;
        for (int i = 0; i < 42; ++i) {
            calendar2.add(5, 1);
            JDayLabel jDayLabel = new JDayLabel(calendar2.getTime());
            jDayLabel.setForeground(this.foreground);
            jDayLabel.addMouseListener(this.dayBttListener);
            if ("1".equals(jDayLabel.getText())) {
                bl = !bl;
            }
            jDayLabel.setEnabled(bl);
            if (calendar2.get(1) == calendar.get(1) && calendar2.get(2) == calendar.get(2) && calendar2.get(5) == calendar.get(5)) {
                jDayLabel.setBorder(new LineBorder(this.selectedBackground, 1));
            }
            this.days.add(jDayLabel);
        }
        this.days.validate();
    }

    protected MouseListener createDayBttListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JDayLabel jDayLabel = (JDayLabel)mouseEvent.getComponent();
                if (JCalendarPanel.this.isEnabled()) {
                    jDayLabel.setOpaque(false);
                    jDayLabel.setBackground(JCalendarPanel.this.background);
                    jDayLabel.setForeground(JCalendarPanel.this.foreground);
                }
                JCalendarPanel.this.isSupportDateChangeListener = true;
                JCalendarPanel.this.setSelectedDate(jDayLabel.getDate());
                JCalendarPanel.this.isSupportDateChangeListener = false;
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (JCalendarPanel.this.isEnabled()) {
                    JComponent jComponent = (JComponent)mouseEvent.getComponent();
                    jComponent.setOpaque(true);
                    jComponent.setBackground(JCalendarPanel.this.selectedBackground);
                    jComponent.setForeground(JCalendarPanel.this.selectedForeground);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (JCalendarPanel.this.isEnabled()) {
                    JComponent jComponent = (JComponent)mouseEvent.getComponent();
                    jComponent.setOpaque(false);
                    jComponent.setBackground(JCalendarPanel.this.background);
                    jComponent.setForeground(JCalendarPanel.this.foreground);
                }
            }
        };
    }

    public void addDateChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JCalendarPanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeDateChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JCalendarPanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireDateChanged(ChangeEvent changeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? JCalendarPanel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public void setSelectedDate(Date date) {
        this.selectedDate = date;
        this.calendar.setTime(date);
        this.updateDays();
        if (this.isSupportDateChangeListener) {
            this.fireDateChanged(new ChangeEvent(date));
        }
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JCalendarPanel jCalendarPanel = new JCalendarPanel();
        final JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(120, 25));
        jCalendarPanel.addDateChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Date date = (Date)changeEvent.getSource();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                jTextField.setText(simpleDateFormat.format(date));
            }
        });
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(jTextField);
        jFrame.getContentPane().add(jCalendarPanel);
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

