/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core.date;

import java.awt.Toolkit;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class JDateDocument
extends PlainDocument {
    private JTextComponent textComponent;
    private SimpleDateFormat dateFormat;

    public JDateDocument(JTextComponent jTextComponent, SimpleDateFormat simpleDateFormat) throws UnsupportedOperationException {
        this(jTextComponent, simpleDateFormat, JDateDocument.getCurrentDate(simpleDateFormat));
    }

    public JDateDocument(JTextComponent jTextComponent, SimpleDateFormat simpleDateFormat, String string) throws UnsupportedOperationException {
        this.setDateFormat(simpleDateFormat);
        this.textComponent = jTextComponent;
        try {
            this.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new UnsupportedOperationException(badLocationException.getMessage());
        }
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        this.dateFormat = simpleDateFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public static String getCurrentDate(SimpleDateFormat simpleDateFormat) {
        return simpleDateFormat.format(new Date());
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string.length() == 1) {
            try {
                Integer.parseInt(string);
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int n2 = n;
            if (n == 4 || n == 7 || n == 10 || n == 13 || n == 16) {
                this.textComponent.setCaretPosition(++n2);
            }
            if (n == this.dateFormat.toPattern().length()) {
                return;
            }
            String string2 = this.textComponent.getText();
            boolean bl = this.isValidDate(string2 = string2.substring(0, n2) + string + string2.substring(n2 + 1));
            if (!bl) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.remove(n2, 1);
            super.insertString(n2, string, attributeSet);
        } else if (string.length() == 10 || string.length() == 19) {
            if (!this.isValidDate(string)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.remove(0, this.getLength());
            super.insertString(0, string, attributeSet);
        }
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (n == 4 || n == 7 || n == 10 || n == 13 || n == 16) {
            this.textComponent.setCaretPosition(n - 1);
        } else {
            this.textComponent.setCaretPosition(n);
        }
    }

    private boolean isValidDate(String string) {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.getDateFormat().toPattern().length();
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() != n7) {
            return false;
        }
        for (bl = false; bl < 10 != 0; bl += 1) {
            if (string.charAt(bl ? 1 : 0) <= '\u00ff') continue;
            return false;
        }
        try {
            n3 = Integer.parseInt(string.substring(0, 4));
            n2 = Integer.parseInt(string.substring(5, 7));
            n = Integer.parseInt(string.substring(8, 10));
        }
        catch (Exception exception) {
            return false;
        }
        int n8 = this.textComponent.getCaretPosition();
        bl = true;
        if (n2 > 12 || n2 < 1) {
            n2 = Math.min(12, Math.max(1, n2));
            bl = false;
        }
        if (n < 1) {
            n = 1;
            bl = false;
        }
        switch (n2) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (n <= 30) break;
                n = 30;
                bl = false;
                break;
            }
            case 2: {
                if (n3 % 4 == 0 && n3 % 100 != 0 || n3 % 400 == 0) {
                    if (n <= 29) break;
                    n = 29;
                    bl = false;
                    break;
                }
                if (n <= 28) break;
                n = 28;
                bl = false;
                break;
            }
            default: {
                if (n <= 31) break;
                n = 31;
                bl = false;
            }
        }
        if (n7 > 10) {
            try {
                n4 = Integer.parseInt(string.substring(11, 13));
                n5 = Integer.parseInt(string.substring(14, 16));
                n6 = Integer.parseInt(string.substring(17));
            }
            catch (Exception exception) {
                return false;
            }
            if (n4 > 23 || n4 < 0) {
                n4 = Math.min(23, Math.max(0, n4));
                bl = false;
            }
            if (n5 > 59 || n5 < 0) {
                n5 = Math.min(59, Math.max(0, n5));
                bl = false;
            }
            if (n6 > 59 || n6 < 0) {
                n6 = Math.min(59, Math.max(0, n6));
                bl = false;
            }
        }
        if (!bl) {
            this.textComponent.setText(this.toDateString(n3, n2, n, n4, n5, n6));
            this.textComponent.setCaretPosition(n8 + 1);
        }
        return bl;
    }

    private String toDateString(int n, int n2, int n3, int n4, int n5, int n6) {
        n2 = Math.max(1, Math.min(12, n2));
        n3 = Math.max(1, Math.min(31, n3));
        switch (n2) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n3 = Math.min(30, n3);
                break;
            }
            case 2: {
                n3 = n % 4 == 0 && n % 100 != 0 || n % 400 == 0 ? Math.min(29, n3) : Math.min(28, n3);
            }
        }
        n4 = Math.max(1, Math.min(24, n4));
        n5 = Math.max(1, Math.min(59, n5));
        n6 = Math.max(1, Math.min(59, n6));
        String string = this.getDateFormat().toPattern();
        String string2 = this.rPad0(4, "" + n);
        String string3 = this.rPad0(2, "" + n2);
        String string4 = this.rPad0(2, "" + n3);
        String string5 = string2 + string.substring(4, 5) + string3 + string.substring(7, 8) + string4;
        if (string.length() == 19) {
            string5 = string5 + string.substring(10, 11) + this.rPad0(2, "" + n4) + string.substring(13, 14) + this.rPad0(2, "" + n5) + string.substring(16, 17) + this.rPad0(2, "" + n6);
        }
        return string5;
    }

    private String rPad0(int n, String string) {
        if (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }
}

