/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core.date;

import com.fr.base.FRContext;
import com.fr.cell.core.date.JCalendarPanel;
import com.fr.cell.core.date.JDateDocument;
import com.fr.cell.core.date.SingleObjectComboBoxModel;
import com.fr.cell.core.layout.LayoutFactory;
import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Component;
import java.awt.Cursor;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class JDatePicker
extends JComboBox
implements Serializable {
    public static final int STYLE_CN_DATE = 0;
    public static final int STYLE_CN_DATE1 = 1;
    public static final int STYLE_CN_DATETIME = 2;
    public static final int STYLE_CN_DATETIME1 = 3;
    private int formatStyle = 2;
    private SimpleDateFormat dateFormat = null;
    private SingleObjectComboBoxModel model = new SingleObjectComboBoxModel();
    JDateDocument dateDocument = null;

    public JDatePicker() throws UnsupportedOperationException {
        this(3);
    }

    public JDatePicker(int n) throws UnsupportedOperationException {
        this(n, new Date());
    }

    public JDatePicker(int n, Date date) throws UnsupportedOperationException {
        this.setStyle(n);
        this.setEditable(true);
        this.setCursor(new Cursor(0));
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        jTextField.setHorizontalAlignment(0);
        this.dateDocument = new JDateDocument(jTextField, this.dateFormat);
        jTextField.setDocument(this.dateDocument);
        this.setModel(this.model);
        this.setSelectedItem(date == null ? new Date() : date);
    }

    public void setStyle(int n) throws UnsupportedOperationException {
        this.formatStyle = n;
        this.dateFormat = JDatePicker.getDateFormat(n);
        this.model.setDateFormat(this.dateFormat);
        if (this.dateDocument != null) {
            this.dateDocument.setDateFormat(this.dateFormat);
        }
    }

    private static SimpleDateFormat getDateFormat(int n) throws UnsupportedOperationException {
        switch (n) {
            case 0: {
                return new SimpleDateFormat("yyyy/MM/dd");
            }
            case 1: {
                return new SimpleDateFormat("yyyy-MM-dd");
            }
            case 2: {
                return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            }
            case 3: {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        }
        throw new UnsupportedOperationException("invalid formatStyle parameter!");
    }

    public int getStyle() {
        return this.formatStyle;
    }

    public Date getSelectedDate() throws ParseException {
        return this.dateFormat.parse(this.getSelectedItem().toString());
    }

    public void setSelectedDate(Date date) throws ParseException {
        this.setSelectedItem(this.dateFormat.format(date));
    }

    public void setSelectedItem(Object object) {
        this.model.setSelectedItem(object);
        super.setSelectedItem(object);
    }

    public void updateUI() {
        Object object = (ComboBoxUI)UIManager.getUI(this);
        object = object instanceof MetalComboBoxUI ? new MetalDateComboBoxUI() : (object instanceof MotifComboBoxUI ? new MotifDateComboBoxUI() : new WindowsDateComboBoxUI());
        this.setUI((ComboBoxUI)object);
    }

    class MotifDateComboBoxUI
    extends MotifComboBoxUI {
        MotifDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class WindowsDateComboBoxUI
    extends WindowsComboBoxUI {
        WindowsDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class MetalDateComboBoxUI
    extends MetalComboBoxUI {
        MetalDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class DatePopup
    extends BasicComboPopup
    implements ChangeListener {
        JCalendarPanel calendarPanel = null;

        public DatePopup(JComboBox jComboBox) {
            super(jComboBox);
            this.setLayout(LayoutFactory.createBorderLayout());
            this.calendarPanel = new JCalendarPanel();
            this.calendarPanel.addDateChangeListener(this);
            this.add((Component)this.calendarPanel, "Center");
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string.equals("visible")) {
                if (object.equals(Boolean.FALSE) && object2.equals(Boolean.TRUE)) {
                    try {
                        String string2 = this.comboBox.getSelectedItem().toString();
                        Date date = JDatePicker.this.dateFormat.parse(string2);
                        this.calendarPanel.setSelectedDate(date);
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                    }
                } else if (!object.equals(Boolean.TRUE) || object2.equals(Boolean.FALSE)) {
                    // empty if block
                }
            }
            super.firePropertyChange(string, object, object2);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Date date = (Date)changeEvent.getSource();
            String string = JDatePicker.this.dateFormat.format(date);
            if (this.comboBox.isEditable() && this.comboBox.getEditor() != null) {
                this.comboBox.configureEditor(this.comboBox.getEditor(), string);
            }
            this.comboBox.setSelectedItem(string);
            this.comboBox.setPopupVisible(false);
        }
    }
}

