/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core.date;

import com.fr.base.BaseUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JLabel;

public class JDayLabel
extends JLabel {
    private static Icon todayIcon = BaseUtils.readIcon("/com/fr/cell/core/date/today.gif");
    private Date date = null;
    private Icon currentIcon = null;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    final SimpleDateFormat dayFormat = new SimpleDateFormat("d");

    public JDayLabel(Date date) {
        this(date, true);
    }

    public JDayLabel(Date date, boolean bl) {
        this.setPreferredSize(new Dimension(40, 20));
        this.setToolTipText(this.dateFormat.format(date));
        this.date = date;
        if (bl) {
            this.setHorizontalAlignment(0);
            this.setText(this.dayFormat.format(date));
            Date date2 = new Date();
            if (this.dateFormat.format(date).equals(this.dateFormat.format(date2))) {
                this.currentIcon = todayIcon;
            }
        } else {
            this.setText("Today:" + this.dateFormat.format(new Date()));
            this.setIcon(todayIcon);
            this.setHorizontalAlignment(2);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.currentIcon != null && this.isEnabled()) {
            int n = (this.getWidth() - this.currentIcon.getIconWidth()) / 2;
            int n2 = (this.getHeight() - this.currentIcon.getIconHeight()) / 2;
            this.currentIcon.paintIcon(this, graphics, n, n2);
        }
    }
}

