/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.core.date;

import com.fr.base.FRContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class SingleObjectComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private SimpleDateFormat dateFormat;
    private String selectedDate = "";

    public SingleObjectComboBoxModel() {
    }

    public SingleObjectComboBoxModel(SimpleDateFormat simpleDateFormat) {
        this.setDateFormat(simpleDateFormat);
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        this.dateFormat = simpleDateFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setSelectedItem(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Date) {
            try {
                this.selectedDate = this.dateFormat.format((Date)object);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        } else {
            try {
                String string = object.toString().trim();
                if (string.length() != 10 && string.length() != 19) {
                    return;
                }
                String string2 = this.dateFormat.toPattern();
                if (string.length() == 10 && string2.length() == 19) {
                    string = string + this.selectedDate.substring(10);
                }
                this.dateFormat.parse(string);
                this.selectedDate = string;
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException("Invalid datetime: string [" + object + "], format is [" + this.dateFormat.toPattern() + "]. ");
            }
        }
        this.fireContentsChanged(this, -1, -1);
    }

    public Object getSelectedItem() {
        return this.selectedDate;
    }

    public Object getElementAt(int n) {
        return this.selectedDate;
    }

    public int getSize() {
        return 1;
    }
}

