/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.editor;

import com.fr.base.FRFont;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.cell.Grid;
import com.fr.cell.core.JNumberField;
import com.fr.cell.editor.AbstractCellEditor;
import com.fr.report.CellElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;

public class NumberCellEditor
extends AbstractCellEditor {
    private Grid grid;
    private JNumberField numberField;
    private Object oldValue = "";
    private KeyListener textKeyListener = new KeyListener(){

        public void keyTyped(KeyEvent keyEvent) {
            NumberCellEditor.this.adjustTextFieldSize();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                NumberCellEditor.this.numberField.setText("" + NumberCellEditor.this.oldValue);
                keyEvent.consume();
            } else if (n == 10 || n == 9 || n == 38 || n == 40) {
                NumberCellEditor.this.grid.requestFocus();
                NumberCellEditor.this.grid.dispatchEvent(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    };

    public NumberCellEditor() {
        this(new JNumberField());
    }

    public NumberCellEditor(JTextField jTextField) {
        this.numberField = jTextField instanceof JNumberField ? (JNumberField)jTextField : new JNumberField();
        this.numberField.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.numberField.addKeyListener(this.textKeyListener);
        this.numberField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                NumberCellEditor.this.stopCellEditing();
            }
        });
        this.numberField.setFocusTraversalKeysEnabled(false);
    }

    public int getMaxIntegerLength() {
        return this.numberField.getMaxIntegerLength();
    }

    public void setMaxIntegerLength(int n) {
        this.numberField.setMaxIntegerLength(n);
    }

    public int getMaxDecimalLength() {
        return this.numberField.getMaxDecimalLength();
    }

    public void setMaxDecimalLength(int n) {
        this.numberField.setMaxDecimalLength(n);
    }

    public Object getCellEditorValue() throws Exception {
        if (!this.numberField.isContentChanged()) {
            return this.oldValue;
        }
        double d = this.numberField.getValue();
        if (d == Double.MAX_VALUE) {
            String string = this.numberField.getTextValue();
            if (string != null && string.trim().length() == 0) {
                return string;
            }
            return this.oldValue;
        }
        return new Double(d);
    }

    public Component getCellEditorComponent(Grid grid, CellElement cellElement) {
        this.grid = grid;
        Object object = null;
        if (cellElement != null) {
            object = cellElement.getValue();
        }
        this.oldValue = object;
        if (object != null && object instanceof Number) {
            this.numberField.setValue(((Number)object).doubleValue());
        } else {
            this.numberField.setText("");
        }
        Style style = null;
        if (cellElement != null) {
            style = cellElement.getStyle();
        }
        this.adjustTextStyle(grid, style, object);
        return this.numberField;
    }

    void adjustTextStyle(Grid grid, Style style, Object object) {
        int n;
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        if ((n = style.getHorizontalAlignment()) == 2) {
            this.numberField.setHorizontalAlignment(2);
        } else if (n == 0) {
            this.numberField.setHorizontalAlignment(0);
        } else if (n == 4) {
            this.numberField.setHorizontalAlignment(4);
        } else {
            this.numberField.setHorizontalAlignment(2);
        }
        FRFont fRFont = style.getFRFont();
        this.numberField.setFont(new Font(fRFont.getFontName(), fRFont.getStyle(), fRFont.getSize()));
        this.numberField.setForeground(style.getFRFont().getForeground());
        if (style.getBackground() instanceof ColorBackground) {
            this.numberField.setBackground(((ColorBackground)style.getBackground()).getColor());
        } else {
            this.numberField.setBackground(Color.white);
        }
    }

    private void adjustTextFieldSize() {
        Dimension dimension = this.numberField.getSize();
        Dimension dimension2 = this.numberField.getPreferredSize();
        this.numberField.setSize((int)Math.max(dimension.getWidth(), dimension2.getWidth()), (int)dimension.getHeight());
    }
}

