/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.editor;

import com.fr.base.FRFont;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.cell.Grid;
import com.fr.cell.core.EditTextField;
import com.fr.cell.editor.AbstractFloatEditor;
import com.fr.report.FloatElement;
import com.fr.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;

public class TextFloatEditor
extends AbstractFloatEditor {
    private Grid grid;
    private FloatElement floatElement;
    protected EditTextField textField;
    protected String oldValue = "";
    private KeyListener textKeyListener = new KeyListener(){

        public void keyTyped(KeyEvent keyEvent) {
            TextFloatEditor.this.ajustTextFieldSize();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                TextFloatEditor.this.textField.setText(TextFloatEditor.this.oldValue);
                keyEvent.consume();
            } else if (n == 10 || n == 9) {
                TextFloatEditor.this.grid.requestFocus();
                TextFloatEditor.this.grid.dispatchEvent(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    };

    public Grid getGrid() {
        return this.grid;
    }

    public FloatElement getFloatElement() {
        return this.floatElement;
    }

    public TextFloatEditor() {
        this.textField = new EditTextField();
        this.textField.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.textField.addKeyListener(this.textKeyListener);
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TextFloatEditor.this.stopFloatEditing();
            }
        });
        this.textField.setFocusTraversalKeysEnabled(false);
    }

    public int getMaxLength() {
        return this.textField.getMaxLength();
    }

    public void setMaxLength(int n) {
        this.textField.setMaxLength(n);
    }

    public Object getFloatEditorValue() throws Exception {
        return this.textField.getText();
    }

    public Component getFloatEditorComponent(Grid grid, FloatElement floatElement) {
        this.grid = grid;
        this.floatElement = floatElement;
        Object object = floatElement.getValue();
        if (object == null) {
            object = "";
        }
        if (!(object instanceof String) && !(object instanceof Number)) {
            object = "";
        }
        this.oldValue = Utils.objectToString(object);
        this.textField.setText(this.oldValue);
        Style style = floatElement.getStyle();
        this.ajustTextStyle(grid, style, object);
        return this.textField;
    }

    protected void ajustTextStyle(Grid grid, Style style, Object object) {
        int n;
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        if ((n = style.getHorizontalAlignment()) == 2) {
            this.textField.setHorizontalAlignment(2);
        } else if (n == 0) {
            this.textField.setHorizontalAlignment(0);
        } else if (n == 4) {
            this.textField.setHorizontalAlignment(4);
        } else {
            this.textField.setHorizontalAlignment(2);
        }
        FRFont fRFont = style.getFRFont();
        this.textField.setFont(new Font(fRFont.getFontName(), fRFont.getStyle(), fRFont.getSize()));
        this.textField.setForeground(style.getFRFont().getForeground());
        if (style.getBackground() instanceof ColorBackground) {
            this.textField.setBackground(((ColorBackground)style.getBackground()).getColor());
        } else {
            this.textField.setBackground(Color.white);
        }
    }

    private void ajustTextFieldSize() {
        Dimension dimension = this.textField.getSize();
        Dimension dimension2 = this.textField.getPreferredSize();
        this.textField.setSize((int)Math.max(dimension.getWidth(), dimension2.getWidth()), (int)dimension.getHeight());
    }
}

