/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cell.undo;

import com.fr.base.FRContext;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.util.Utils;
import java.io.File;

public abstract class UndoState {
    protected ReportPane reportPane;
    protected GridSelection gridSelection;
    protected int verticalValue = 0;
    protected int horizontalValue = 0;
    protected boolean isCacheable = true;
    protected File cacheDirectory;
    protected File cacheFile;

    protected UndoState() {
    }

    protected UndoState(ReportPane reportPane, GridSelection gridSelection, int n, int n2, boolean bl) {
        this.reportPane = reportPane;
        this.isCacheable = bl;
        this.gridSelection = gridSelection;
        this.verticalValue = n;
        this.horizontalValue = n2;
        this.evaluateReportTemplate();
    }

    protected abstract void evaluateReportTemplate();

    protected File getCacheDirectory() {
        if (this.cacheDirectory == null) {
            this.cacheDirectory = FRContext.getCacheManager().getCacheDirectory();
            Utils.mkdirs(this.cacheDirectory);
            this.cacheDirectory.deleteOnExit();
        }
        return this.cacheDirectory;
    }

    public void applyState() {
        this.reportPane.setGridSelection(this.gridSelection);
        this.reportPane.getVerticalScrollBar().setValue(this.verticalValue);
        this.reportPane.getHorizontalScrollBar().setValue(this.horizontalValue);
        this.reportPane.setUndoState(this);
        this.reportPane.repaint();
    }
}

