/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ChartFactory;
import com.fr.chart.ChartModule;
import com.fr.chart.Title;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.ChartGlyph;
import com.fr.chart.core.glyph.LegendGlyph;
import com.fr.chart.core.glyph.PlotGlyph;
import com.fr.chart.legend.Legend;
import com.fr.chart.plot.CustomPlot;
import com.fr.chart.plot.MeterPlot;
import com.fr.chart.plot.Plot;
import com.fr.chart.plot.RangePlot;
import com.fr.data.ChartData;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.js.NameJavaScriptGroup;

public class Chart
extends ChartModule {
    private static final long serialVersionUID = -2818043793300636874L;
    public static final String XML_TAG = "Chart";
    private Title title;
    private Plot plot;
    private boolean isJSDraw = true;

    public Chart() {
        this(null);
    }

    public Chart(Plot plot) {
        this.plot = plot;
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    public void setJSDraw(boolean bl) {
        this.isJSDraw = bl;
    }

    public boolean isJSDraw() {
        return this.isJSDraw;
    }

    public ChartGlyph createGlyph(ChartData chartData) {
        ChartGlyph chartGlyph = new ChartGlyph();
        chartGlyph.setInfo(this.getInfo());
        chartGlyph.setJSDraw(this.isJSDraw());
        if (this.title != null) {
            chartGlyph.setTitleGlyph(this.title.createGlyph());
        }
        PlotGlyph plotGlyph = this.plot.createPlotGlyph(chartData);
        chartGlyph.setPlotGlyph(plotGlyph);
        LegendGlyph legendGlyph = this.plot.createLegendGlyph(plotGlyph);
        chartGlyph.setLegendGlyph(legendGlyph);
        return chartGlyph;
    }

    public void switchPlot(Plot plot) {
        Plot plot2 = this.getPlot();
        if (plot2 != null) {
            if (plot instanceof RangePlot || plot instanceof MeterPlot) {
                plot.setLegend(null);
            } else if (plot2 instanceof RangePlot || plot2 instanceof MeterPlot) {
                plot.setLegend(new Legend());
            } else {
                plot.setLegend(plot2.getLegend());
            }
            plot.setInfo(plot2.getInfo());
            plot.getSeriesCollection().getSeriesAttrMap().clear();
            if (plot instanceof CustomPlot) {
                ChartFactory.createSeriesMap4CustomPlot(plot);
            }
        }
        this.setPlot(plot);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Title")) {
                this.title = new Title();
                xMLableReader.readXMLObject(this.title);
            } else if (string2.equals("Plot")) {
                this.plot = (Plot)ReportXMLUtils.readXMLable(xMLableReader);
            } else if ("NameJavaScriptGroup".equals(string2) || "NameHyperlinks".equals(string2) || "HyperlinkMap".equals(string2)) {
                this.plot.setHotHyperLink((NameJavaScriptGroup)xMLableReader.readXMLObject(new NameJavaScriptGroup()));
            } else if (string2.equals("ChartAttr") && (string = xMLableReader.getAttr("isJSDraw")) != null) {
                this.setJSDraw(Boolean.valueOf(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ChartAttr").attr("isJSDraw", this.isJSDraw).end();
        if (this.title != null) {
            this.title.writeXML(xMLPrintWriter);
        }
        if (this.plot != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.plot, "Plot");
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Chart chart = (Chart)super.clone();
        if (this.title != null) {
            chart.title = (Title)this.title.clone();
        }
        if (this.plot != null) {
            chart.plot = (Plot)this.plot.clone();
        }
        return chart;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Chart)) {
            return false;
        }
        Chart chart = (Chart)object;
        if (!super.equals(chart)) {
            return false;
        }
        if (!Equals.equals(chart.getPlot(), this.getPlot())) {
            return false;
        }
        if (!Equals.equals(chart.getTitle(), this.getTitle())) {
            return false;
        }
        return chart.isJSDraw == this.isJSDraw;
    }
}

