/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart;

import com.fr.base.Style;
import com.fr.base.core.GraphHelper;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.Chart;
import com.fr.chart.ChartLayout;
import com.fr.chart.ChartPainter;
import com.fr.chart.base.equals.Equals;
import com.fr.chart.core.glyph.ChartGlyph;
import com.fr.data.ChartData;
import com.fr.data.ChartDataModel;
import com.fr.data.core.define.FilterDefinition;
import com.fr.dialog.NameObject;
import com.fr.report.io.xml.ReportXMLUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ChartCollection
extends ChartLayout {
    private static final long serialVersionUID = 1265398996017104404L;
    public static final String XML_TAG = "CC";
    private List nameObjectList = new ArrayList();
    private FilterDefinition filterDefinition;

    public void addChart(Chart chart) {
        this.addNamedChart("Default", chart);
    }

    public void addNamedChart(String string, Chart chart) {
        this.nameObjectList.add(new NameObject(string, chart));
    }

    public int getChartSize() {
        return this.nameObjectList.size();
    }

    public String getChartName(int n) {
        return ((NameObject)this.nameObjectList.get(n)).getName();
    }

    public Chart getChart(int n) {
        return (Chart)((NameObject)this.nameObjectList.get(n)).getObject();
    }

    public void removeAllCharts() {
        this.nameObjectList.clear();
    }

    public void setFilterDefinition(FilterDefinition filterDefinition) {
        this.filterDefinition = filterDefinition;
    }

    public FilterDefinition getFilterDefinition() {
        return this.filterDefinition;
    }

    public Chart getSelectedChart() {
        int n = Math.max(0, this.getSelectedIndex());
        return n >= 0 && n < this.getChartSize() ? this.getChart(n) : null;
    }

    public ChartPainter createChartPainter(ChartData chartData) {
        ChartPainter chartPainter = new ChartPainter();
        int n = this.getChartSize();
        for (int i = 0; i < n; ++i) {
            chartPainter.addNamedGlyph(this.getChartName(i), this.getChart(i).createGlyph(chartData));
        }
        chartPainter.setSelectedIndex(this.getSelectedIndex());
        chartPainter.setColumns(this.getColumns());
        return chartPainter;
    }

    public void paint(Graphics graphics, int n, int n2, Style style) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getSelectedChart() == null) {
            return;
        }
        ChartData chartData = ChartDataModel.getChartData(this.getSelectedChart().getPlot());
        ChartGlyph chartGlyph = this.getSelectedChart().createGlyph(chartData);
        Image image = chartGlyph.toImage(n, n2);
        if (chartGlyph.isRoundBorder()) {
            chartGlyph.setBounds(new RoundRectangle2D.Double(0.0, 0.0, n, n2, 10.0, 10.0));
        } else {
            chartGlyph.setBounds(new Rectangle2D.Double(0.0, 0.0, n, n2));
        }
        chartGlyph.draw(graphics2D);
        GraphHelper.paintImage(graphics2D, n, n2, image, Style.getInstance(), 1, n, n2);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.removeAllCharts();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Chart".equals(string)) {
                Chart chart = new Chart();
                this.addNamedChart(xMLableReader.getAttr("name"), chart);
                xMLableReader.readXMLObject(chart);
            } else if (string.endsWith("Definition")) {
                this.filterDefinition = ReportXMLUtils.readDefinition(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        int n = this.getChartSize();
        for (int i = 0; i < n; ++i) {
            xMLPrintWriter.startTAG("Chart").attr("name", this.getChartName(i));
            this.getChart(i).writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.filterDefinition != null) {
            this.filterDefinition.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ChartCollection chartCollection = (ChartCollection)super.clone();
        chartCollection.nameObjectList = new ArrayList(this.getChartSize());
        int n = this.getChartSize();
        for (int i = 0; i < n; ++i) {
            chartCollection.addNamedChart(this.getChartName(i), (Chart)this.getChart(i).clone());
        }
        if (this.filterDefinition != null) {
            chartCollection.filterDefinition = (FilterDefinition)this.filterDefinition.clone();
        }
        return chartCollection;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChartCollection)) {
            return false;
        }
        ChartCollection chartCollection = (ChartCollection)object;
        if (!super.equals(chartCollection)) {
            return false;
        }
        if (!Equals.equals(chartCollection.filterDefinition, this.filterDefinition)) {
            return false;
        }
        if (chartCollection.nameObjectList.size() != this.nameObjectList.size()) {
            return false;
        }
        for (int i = 0; i < chartCollection.getChartSize(); ++i) {
            if (!Equals.equals(chartCollection.getChart(i), this.getChart(i))) {
                return false;
            }
            if (Equals.equals(chartCollection.getChartName(i), this.getChartName(i))) continue;
            return false;
        }
        return true;
    }
}

