/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart;

import com.fr.base.Inter;
import com.fr.chart.Chart;
import com.fr.chart.axis.SeriesAttrAlpha;
import com.fr.chart.axis.SeriesAttrLine;
import com.fr.chart.core.ChartCoreConstants;
import com.fr.chart.legend.Legend;
import com.fr.chart.plot.Area3DPlot;
import com.fr.chart.plot.AreaPlot;
import com.fr.chart.plot.Bar2DPlot;
import com.fr.chart.plot.Bar3DPlot;
import com.fr.chart.plot.CustomAttr;
import com.fr.chart.plot.CustomPlot;
import com.fr.chart.plot.GanttPlot;
import com.fr.chart.plot.Line3DPlot;
import com.fr.chart.plot.LinePlot;
import com.fr.chart.plot.MeterPlot;
import com.fr.chart.plot.Pie3DPlot;
import com.fr.chart.plot.PiePlot;
import com.fr.chart.plot.Plot;
import com.fr.chart.plot.RadarPlot;
import com.fr.chart.plot.RangePlot;
import com.fr.chart.plot.SeriesAttr;
import com.fr.chart.plot.SeriesCollection;
import com.fr.chart.plot.StockPlot;
import com.fr.chart.plot.XYScatterPlot;
import java.awt.Color;
import java.text.DecimalFormat;

public abstract class ChartFactory {
    public static String[] allChartNames = new String[]{Inter.getLocText("ChartF-Column"), Inter.getLocText("ChartF-Line"), Inter.getLocText("ChartF-Bar"), Inter.getLocText("ChartF-Pie"), Inter.getLocText("ChartF-Area"), Inter.getLocText("ChartF-XYScatter"), Inter.getLocText("ChartF-Radar"), Inter.getLocText("ChartF-Stock"), Inter.getLocText("ChartF-Meter"), Inter.getLocText("ChartF-Range_Chart"), Inter.getLocText("ChartF-Comb_Chart"), Inter.getLocText("ChartF-Gantt")};
    public static Chart[][] allChartTypes = new Chart[][]{{ChartFactory.createBar2DChart(false, false, false), ChartFactory.createBar2DChart(false, true, false), ChartFactory.createBar2DChart(false, true, true), ChartFactory.createBar3DChart(false, false, false, false), ChartFactory.createBar3DChart(false, false, false, true), ChartFactory.createBar3DChart(false, true, false, false), ChartFactory.createBar3DChart(false, true, true, false)}, {ChartFactory.createLineChart(false, false, false), ChartFactory.createLineChart(true, false, false), ChartFactory.createLineChart(true, false, true), ChartFactory.createLineChart(false, true, false), ChartFactory.createLineChart(true, true, false), ChartFactory.createLineChart(true, true, true), ChartFactory.createLine3DChart()}, {ChartFactory.createBar2DChart(true, false, false), ChartFactory.createBar2DChart(true, true, false), ChartFactory.createBar2DChart(true, true, true), ChartFactory.createBar3DChart(true, false, false, false), ChartFactory.createBar3DChart(true, false, false, true), ChartFactory.createBar3DChart(true, true, false, false), ChartFactory.createBar3DChart(true, true, true, false)}, {ChartFactory.createPieChart(0), ChartFactory.createPieChart(6), ChartFactory.createPie3DChart(0), ChartFactory.createPie3DChart(15)}, {ChartFactory.createAreaChart(false, false), ChartFactory.createAreaChart(true, false), ChartFactory.createAreaChart(true, true), ChartFactory.createArea3DChart(false, false), ChartFactory.createArea3DChart(true, false), ChartFactory.createArea3DChart(true, true)}, {ChartFactory.createXYScatterChart(true, false), ChartFactory.createXYScatterChart(true, true), ChartFactory.createXYScatterChart(false, true)}, {ChartFactory.createRadarChart(true, false, false), ChartFactory.createRadarChart(true, true, false), ChartFactory.createRadarChart(true, false, true), ChartFactory.createRadarChart(true, true, true)}, {ChartFactory.createStockChart(0), ChartFactory.createStockChart(1), ChartFactory.createStockChart(2), ChartFactory.createStockChart(3)}, {ChartFactory.createMeterChart()}, {ChartFactory.createRangeChart()}, {ChartFactory.createCustomChart()}, {ChartFactory.createGanttChart()}};

    private static void setLegendRoundBorder(Plot plot) {
        Legend legend = plot.getLegend();
        if (legend != null) {
            legend.setRoundBorder(true);
            legend.setBorderStyle(1);
            legend.setBorderColor(Color.GRAY);
        }
    }

    public static Chart createBar2DChart(boolean bl, boolean bl2, boolean bl3) {
        Bar2DPlot bar2DPlot = new Bar2DPlot();
        bar2DPlot.setIsHorizontal(bl);
        bar2DPlot.setIsStacked(bl2);
        if (bl2) {
            bar2DPlot.setSeriesOverlapPercent(1.0);
        }
        if (bl3) {
            bar2DPlot.getValueAxis().setPercentage(bl3);
            bar2DPlot.getValueAxis().setFormat(new DecimalFormat("0%"));
        } else {
            bar2DPlot.getValueAxis().setFormat(new DecimalFormat("0"));
        }
        bar2DPlot.getValueAxis().setAxisShow(false);
        ChartFactory.setLegendRoundBorder(bar2DPlot);
        return new Chart(bar2DPlot);
    }

    public static Chart createBar3DChart(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Bar3DPlot bar3DPlot = new Bar3DPlot();
        bar3DPlot.setIsHorizontal(bl);
        bar3DPlot.setIsStacked(bl2);
        bar3DPlot.setHorizontalDrawBar(bl4);
        if (bl4) {
            bar3DPlot.setSeriesOverlapPercent(-0.5);
        } else {
            bar3DPlot.setSeriesOverlapPercent(1.0);
        }
        if (bl3) {
            bar3DPlot.getValueAxis().setPercentage(true);
            bar3DPlot.getValueAxis().setFormat(new DecimalFormat("0%"));
        } else {
            bar3DPlot.getValueAxis().setFormat(new DecimalFormat("0"));
        }
        ChartFactory.setLegendRoundBorder(bar3DPlot);
        return new Chart(bar3DPlot);
    }

    public static Chart createPieChart(int n) {
        PiePlot piePlot = new PiePlot();
        piePlot.setSeparatePercent(n);
        ChartFactory.setLegendRoundBorder(piePlot);
        return new Chart(piePlot);
    }

    public static Chart createPie3DChart(int n) {
        Pie3DPlot pie3DPlot = new Pie3DPlot();
        pie3DPlot.setSeparatePercent(n);
        ChartFactory.setLegendRoundBorder(pie3DPlot);
        return new Chart(pie3DPlot);
    }

    public static Chart createLineChart(boolean bl, boolean bl2, boolean bl3) {
        LinePlot linePlot = new LinePlot();
        linePlot.setIsStacked(bl);
        linePlot.setIsShowMarker(bl2);
        if (bl3) {
            linePlot.getValueAxis().setPercentage(true);
            linePlot.getValueAxis().setFormat(new DecimalFormat("0%"));
        } else {
            linePlot.getValueAxis().setFormat(new DecimalFormat("0"));
        }
        linePlot.getValueAxis().setAxisShow(false);
        ChartFactory.setLegendRoundBorder(linePlot);
        return new Chart(linePlot);
    }

    public static Chart createLine3DChart() {
        Line3DPlot line3DPlot = new Line3DPlot();
        line3DPlot.getValueAxis().setFormat(new DecimalFormat("0"));
        ChartFactory.setLegendRoundBorder(line3DPlot);
        return new Chart(line3DPlot);
    }

    public static Chart createCustomChart() {
        CustomPlot customPlot = new CustomPlot();
        customPlot.getValueAxis().setFormat(new DecimalFormat("0"));
        ChartFactory.createSeriesMap4CustomPlot(customPlot);
        ChartFactory.setLegendRoundBorder(customPlot);
        return new Chart(customPlot);
    }

    public static Chart createAreaChart(boolean bl, boolean bl2) {
        AreaPlot areaPlot = new AreaPlot();
        areaPlot.setIsStacked(bl);
        if (bl2) {
            areaPlot.getValueAxis().setPercentage(true);
            areaPlot.getValueAxis().setFormat(new DecimalFormat("0%"));
        } else {
            areaPlot.getValueAxis().setFormat(new DecimalFormat("0"));
        }
        areaPlot.getValueAxis().setAxisShow(false);
        ChartFactory.setLegendRoundBorder(areaPlot);
        return new Chart(areaPlot);
    }

    public static Chart createArea3DChart(boolean bl, boolean bl2) {
        Area3DPlot area3DPlot = new Area3DPlot();
        area3DPlot.setIsStacked(bl);
        if (bl2) {
            area3DPlot.getValueAxis().setPercentage(true);
            area3DPlot.getValueAxis().setFormat(new DecimalFormat("0%"));
        } else {
            area3DPlot.getValueAxis().setFormat(new DecimalFormat("0"));
        }
        ChartFactory.setLegendRoundBorder(area3DPlot);
        return new Chart(area3DPlot);
    }

    public static Chart createMeterChart() {
        MeterPlot meterPlot = new MeterPlot();
        return new Chart(meterPlot);
    }

    public static Chart createRangeChart() {
        RangePlot rangePlot = new RangePlot();
        rangePlot.getValueAxis().setFormat(new DecimalFormat("0"));
        return new Chart(rangePlot);
    }

    public static Chart createGanttChart() {
        GanttPlot ganttPlot = new GanttPlot();
        ChartFactory.setLegendRoundBorder(ganttPlot);
        return new Chart(ganttPlot);
    }

    public static Chart createXYScatterChart(boolean bl, boolean bl2) {
        XYScatterPlot xYScatterPlot = new XYScatterPlot();
        xYScatterPlot.setShowMarker(bl);
        xYScatterPlot.setShowLine(bl2);
        xYScatterPlot.getXAxis().setFormat(new DecimalFormat("0"));
        xYScatterPlot.getYAxis().setFormat(new DecimalFormat("0"));
        ChartFactory.setLegendRoundBorder(xYScatterPlot);
        return new Chart(xYScatterPlot);
    }

    public static Chart createRadarChart(boolean bl, boolean bl2, boolean bl3) {
        RadarPlot radarPlot = new RadarPlot();
        radarPlot.setShowLine(bl);
        radarPlot.setShowMarker(bl2);
        radarPlot.setIsFilled(bl3);
        radarPlot.getSeriesCollection().getDefaultSeriesAttr().addCondition(new SeriesAttrAlpha(0.6f));
        SeriesAttr seriesAttr = new SeriesAttr();
        seriesAttr.addCondition(new SeriesAttrLine(ChartCoreConstants.CHART_COLOR_ARRAY[0], 2));
        radarPlot.getSeriesCollection().putSeriesAttr(0, seriesAttr);
        ChartFactory.setLegendRoundBorder(radarPlot);
        return new Chart(radarPlot);
    }

    public static Chart createStockChart(int n) {
        StockPlot stockPlot = new StockPlot(n);
        stockPlot.getPriceAxis().setFormat(new DecimalFormat("0"));
        stockPlot.getVolumeAxis().setFormat(new DecimalFormat("0"));
        ChartFactory.setLegendRoundBorder(stockPlot);
        return new Chart(stockPlot);
    }

    public static void createSeriesMap4CustomPlot(Plot plot) {
        SeriesCollection seriesCollection = plot.getSeriesCollection();
        seriesCollection.setDefaultSeriesAttr(new CustomAttr());
        CustomAttr customAttr = new CustomAttr(1);
        CustomAttr customAttr2 = new CustomAttr(2);
        seriesCollection.putSeriesAttr(0, customAttr);
        seriesCollection.putSeriesAttr(1, customAttr2);
    }
}

