/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart;

import com.fr.base.StringUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.painter.AbstractPainter;
import com.fr.util.Utils;

public abstract class ChartLayout
extends AbstractPainter {
    private static final long serialVersionUID = -3903716633428879679L;
    protected int selectedIndex;
    protected int columns;

    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public int getColumns() {
        return this.columns;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "LayoutAttr".equals(xMLableReader.getTagName())) {
            String string = xMLableReader.getAttr("selectedIndex");
            if (StringUtils.isNotBlank(string)) {
                this.setSelectedIndex(Utils.string2Number(string).intValue());
            }
            if (StringUtils.isNotBlank(string = xMLableReader.getAttr("columns"))) {
                this.setColumns(Utils.string2Number(string).intValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("LayoutAttr").attr("selectedIndex", this.selectedIndex).attr("columns", this.columns).end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChartLayout)) {
            return false;
        }
        ChartLayout chartLayout = (ChartLayout)object;
        if (chartLayout.columns != this.columns) {
            return false;
        }
        return chartLayout.selectedIndex == this.selectedIndex;
    }
}

